/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.internal;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.sql.DataSource;

public class DriverDataSource
implements DataSource,
Referenceable,
ObjectFactory {
    private String classname;
    private String url;
    private String user;
    private String password;
    private int loginTimeout;
    private PrintWriter logWriter;

    public DriverDataSource() {
    }

    public DriverDataSource(String classname, String url, String user, String password) {
        this.classname = classname;
        this.url = url;
        this.user = user;
        this.password = password;
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.password);
    }

    public Connection getConnection(String user, String password) throws SQLException {
        try {
            Class.forName(this.classname);
            return DriverManager.getConnection(this.url, user, password);
        }
        catch (ClassNotFoundException ex) {
            throw new SQLException("driver class '" + this.classname + "' not found");
        }
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.logWriter = out;
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout = seconds;
    }

    public Reference getReference() throws NamingException {
        Reference ref = new Reference(this.getClass().getName(), this.getClass().getName(), null);
        ref.add(new StringRefAddr("classname", this.classname));
        ref.add(new StringRefAddr("url", this.url));
        ref.add(new StringRefAddr("user", this.user));
        ref.add(new StringRefAddr("password", this.password));
        return ref;
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        Reference ref = (Reference)obj;
        this.classname = (String)ref.get("classname").getContent();
        this.url = (String)ref.get("url").getContent();
        this.user = (String)ref.get("user").getContent();
        this.password = (String)ref.get("password").getContent();
        return this;
    }
}

