/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.internal;

import com.sap.sql.jdbc.DatabaseVendor;
import com.sap.sql.jdbc.internal.DriverDataSource;
import com.sap.sql.jdbc.internal.SAPContext;
import com.sap.sql.jdbc.internal.SAPDataSource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.naming.Reference;
import javax.sql.DataSource;

public class DataSourceManager {
    private String source;
    private String destination;
    private SortedMap drivers = new TreeMap();
    private SortedMap systems = new TreeMap();
    private SortedMap testSystems = new TreeMap();
    private SAPContext context;

    public DataSourceManager() {
    }

    public DataSourceManager(String sourceFilename, String destPath) throws Exception {
        this.source = sourceFilename;
        this.destination = destPath;
        this.loadSystemInfo();
        this.context = new SAPContext(new File(this.destination));
    }

    public String getDestination() {
        return this.destination;
    }

    public String getSource() {
        return this.source;
    }

    public void setDestination(String destPath) {
        this.destination = destPath;
        this.context = new SAPContext(new File(this.destination));
    }

    public void setSource(String sourceFilename) throws Exception {
        this.source = sourceFilename;
        this.loadSystemInfo();
    }

    public String[] getVendors() throws Exception {
        return DatabaseVendor.getVendorNames();
    }

    public Map getDrivers() {
        String[] vendors = DatabaseVendor.getVendorNames();
        TreeMap<String, String> map = new TreeMap<String, String>();
        int i = 0;
        while (i < vendors.length) {
            String driver = (String)this.drivers.get(vendors[i]);
            if (driver == null) {
                driver = "";
            }
            map.put(vendors[i], driver);
            ++i;
        }
        return map;
    }

    public synchronized void changeDriver(Map map) throws Exception {
        this.drivers.putAll(map);
        this.storeSystemInfo();
    }

    public Iterator getSystems() {
        return this.systems.keySet().iterator();
    }

    public String getSystemVendor(String systemName) throws Exception {
        Map prop = this.getSystemProperties(systemName, "driver");
        return (String)prop.get("Vendor");
    }

    public Map getSystemDriver(Map map) throws Exception {
        String systemName = (String)map.get("System");
        TreeMap prop = new TreeMap();
        Map sysProp = this.getSystemProperties(systemName, "driver");
        if (sysProp != null) {
            prop.putAll(sysProp);
            prop.remove("Vendor");
        }
        return prop;
    }

    public Map getSystemDriverProperties(Map map) throws Exception {
        String systemName = (String)map.get("System");
        String systemVendor = (String)map.get("Vendor");
        if (this.systems.get(systemName) != null) {
            throw new Exception("System " + systemName + " already existing!");
        }
        String classname = (String)this.drivers.get(systemVendor);
        if (classname == null) {
            classname = "";
        }
        TreeMap<String, String> prop = new TreeMap<String, String>();
        prop.put("Classname", classname);
        prop.put("Url", "");
        prop.put("User", "");
        prop.put("Password", "");
        return prop;
    }

    public synchronized void changeSystemDriver(Map map) throws Exception {
        String systemName = (String)map.get("System");
        map.remove("System");
        TreeMap<String, Map> driverMap = (TreeMap<String, Map>)this.systems.get(systemName);
        if (driverMap == null) {
            driverMap = new TreeMap<String, Map>();
            this.systems.put(systemName, driverMap);
        }
        driverMap.put("driver", map);
        this.storeSystemInfo();
        this.bindSystem(systemName);
    }

    public synchronized void deleteSystemDriver(String systemName) throws Exception {
        this.systems.remove(systemName);
        this.storeSystemInfo();
        this.unbindSystem(systemName);
    }

    public Map getTestSystems() throws Exception {
        String[] vendors = DatabaseVendor.getVendorNames();
        TreeMap<String, String> map = new TreeMap<String, String>();
        int i = 0;
        while (i < vendors.length) {
            String testSystem = (String)this.testSystems.get(vendors[i]);
            if (testSystem == null) {
                testSystem = "";
            }
            map.put(vendors[i], testSystem);
            ++i;
        }
        return map;
    }

    public synchronized void changeTestSystem(Map map) throws Exception {
        this.testSystems.putAll(map);
        this.storeSystemInfo();
        this.bindTestSystems();
    }

    public synchronized void bindAllSystems() throws Exception {
        Iterator iter = this.systems.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            this.bindSystem(name);
        }
    }

    public synchronized void bindSystem(String systemName) throws Exception {
        DataSource nds;
        Map prop = this.getSystemProperties(systemName, "datasource");
        if (prop != null) {
            nds = this.initDataSource(prop);
        } else {
            prop = this.getSystemProperties(systemName, "driver");
            nds = this.initDriver(prop);
        }
        SAPDataSource ds = new SAPDataSource(nds, 1);
        Reference reference = ds.getReference();
        this.context.bind("jdbc/native/" + systemName, reference);
        this.context.bind("jdbc/vendorsql/" + systemName, reference);
        ds = new SAPDataSource(nds, 2);
        reference = ds.getReference();
        this.context.bind("jdbc/direct/" + systemName, reference);
        this.context.bind("jdbc/nativesql/" + systemName, reference);
        ds = new SAPDataSource(nds, 3);
        reference = ds.getReference();
        this.context.bind("jdbc/common/" + systemName, reference);
        this.context.bind("jdbc/opensql/" + systemName, reference);
    }

    public synchronized void bindTestSystems() throws Exception {
        this.context.bind("test/systems", this.testSystems);
    }

    public synchronized void refreshBindings() throws Exception {
        String[] types = this.context.list("jdbc");
        int i = 0;
        while (i < types.length) {
            String[] systemNames = this.context.list("jdbc/" + types[i]);
            int j = 0;
            while (j < systemNames.length) {
                this.context.unbind("jdbc/" + types[i] + "/" + systemNames[j]);
                ++j;
            }
            ++i;
        }
        this.context.unbind("test/systems");
        this.bindAllSystems();
        this.bindTestSystems();
    }

    private synchronized void unbindSystem(String systemName) throws Exception {
        this.context.unbind("jdbc/native/" + systemName);
        this.context.unbind("jdbc/vendorsql/" + systemName);
        this.context.unbind("jdbc/direct/" + systemName);
        this.context.unbind("jdbc/nativesql/" + systemName);
        this.context.unbind("jdbc/common/" + systemName);
        this.context.unbind("jdbc/opensql/" + systemName);
    }

    private Map getSystemProperties(String systemName, String driverType) throws Exception {
        Map driverMap = (Map)this.systems.get(systemName);
        if (driverMap == null) {
            throw new Exception("no info for system " + systemName + " available!");
        }
        return (Map)driverMap.get(driverType);
    }

    private DataSource initDataSource(Map prop) {
        return null;
    }

    private DataSource initDriver(Map prop) {
        String classname = (String)prop.get("Classname");
        String url = (String)prop.get("Url");
        String user = (String)prop.get("User");
        String password = (String)prop.get("Password");
        return new DriverDataSource(classname, url, user, password);
    }

    /*
     * WARNING - void declaration
     */
    private void loadSystemInfo() throws Exception {
        String prop;
        String name;
        String line;
        String lastName = "";
        String lastType = "";
        TreeMap driverMap = null;
        TreeMap<String, String> propMap = null;
        TreeSet<String> buffer = new TreeSet<String>();
        BufferedReader in = new BufferedReader(new FileReader(this.source));
        while ((line = in.readLine()) != null) {
            void var1_7;
            line = var1_7.trim();
            if (line.length() <= 0) continue;
            buffer.add(line);
        }
        in.close();
        Iterator iter = buffer.iterator();
        if (!iter.hasNext()) {
            return;
        }
        line = (String)iter.next();
        while (line.startsWith("driver.")) {
            int index = line.indexOf("=", 7);
            name = line.substring(7, index);
            prop = line.substring(index + 1);
            this.drivers.put(name, prop);
            if (!iter.hasNext()) break;
            line = (String)iter.next();
        }
        while (line.startsWith("system.")) {
            StringTokenizer token = new StringTokenizer(line, ".");
            token.nextToken();
            String systemName = token.nextToken();
            String driverType = token.nextToken();
            String propKey = token.nextToken(".=");
            String propValue = token.nextToken("").substring(1);
            if (!systemName.equals(lastName)) {
                lastName = systemName;
                lastType = "";
                driverMap = new TreeMap();
                this.systems.put(systemName, driverMap);
            }
            if (!driverType.equals(lastType)) {
                lastType = driverType;
                propMap = new TreeMap<String, String>();
                driverMap.put(driverType, propMap);
            }
            propMap.put(propKey, propValue);
            if (!iter.hasNext()) break;
            line = (String)iter.next();
        }
        while (line.startsWith("testsystem.")) {
            int index = line.indexOf("=", 11);
            name = line.substring(11, index);
            prop = line.substring(index + 1);
            this.testSystems.put(name, prop);
            if (!iter.hasNext()) break;
            line = (String)iter.next();
        }
    }

    private void storeSystemInfo() throws Exception {
        Map.Entry entry;
        PrintWriter out = new PrintWriter(new FileWriter(this.source));
        Iterator iter = this.drivers.entrySet().iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            out.println("driver." + (String)entry.getKey() + "=" + (String)entry.getValue());
        }
        iter = this.testSystems.entrySet().iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            out.println("testsystem." + (String)entry.getKey() + "=" + (String)entry.getValue());
        }
        iter = this.systems.keySet().iterator();
        while (iter.hasNext()) {
            String systemName = (String)((Object)iter.next());
            Map driverMap = (Map)this.systems.get(systemName);
            Iterator driverIter = driverMap.keySet().iterator();
            while (driverIter.hasNext()) {
                String driverType = (String)driverIter.next();
                Map propMap = (Map)driverMap.get(driverType);
                Iterator propIter = propMap.entrySet().iterator();
                while (propIter.hasNext()) {
                    Map.Entry prop = propIter.next();
                    StringBuffer buffer = new StringBuffer("system.");
                    buffer.append(systemName).append(".").append(driverType).append(".").append((String)prop.getKey()).append("=").append((String)prop.getValue());
                    out.println(buffer.toString());
                }
            }
        }
        out.close();
    }
}

