/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.db6;

import com.sap.sql.jdbc.basic.SQLExceptionAnalyzer;
import java.sql.Connection;
import java.sql.SQLException;

public class Db6SQLExceptionAnalyzer
extends SQLExceptionAnalyzer {
    public Db6SQLExceptionAnalyzer(Connection con) {
        super(con);
    }

    public int getCategory(SQLException exception) {
        int category = 0;
        SQLException sqlex = exception;
        int exLevel = 0;
        while (sqlex != null) {
            int dbcode = sqlex.getErrorCode();
            if (dbcode == -727 && exLevel > 0) {
                dbcode = 0;
            }
            switch (dbcode) {
                case -911: {
                    if (category >= 6) break;
                    category = 6;
                    break;
                }
                case -803: {
                    if (category >= 1) break;
                    category = 1;
                    break;
                }
                case -206: {
                    if (category >= 3) break;
                    category = 3;
                    break;
                }
                case -2306: 
                case -204: {
                    if (category >= 4) break;
                    category = 4;
                    break;
                }
                case -601: {
                    if (category >= 5) break;
                    category = 5;
                    break;
                }
                case -30081: 
                case -30080: 
                case -1224: 
                case -1035: 
                case -1034: 
                case -1032: 
                case -1024: 
                case -1023: 
                case -1015: 
                case -903: 
                case -900: {
                    if (category >= 9) break;
                    category = 9;
                    break;
                }
                case -1225: 
                case -1036: 
                case -1007: 
                case -996: 
                case -975: 
                case -968: 
                case -964: 
                case -659: 
                case -293: 
                case -292: 
                case -289: {
                    if (category >= 8) break;
                    category = 8;
                    break;
                }
                case -802: {
                    if (category >= 2) break;
                    category = 2;
                    break;
                }
                case -99999: {
                    if (sqlex.getMessage().startsWith("Invalid data conversion:Requested conversion would result in a loss of precision")) {
                        if (category >= 2) break;
                        category = 2;
                        break;
                    }
                    if (category >= 7) break;
                    category = 7;
                    break;
                }
                default: {
                    if (dbcode >= 0 || category >= 7) break;
                    category = 7;
                }
            }
            ++exLevel;
            sqlex = sqlex.getNextException();
        }
        return category;
    }
}

