/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.db4;

import com.sap.sql.jdbc.basic.BasicJdbcObjectFactory;
import com.sap.sql.jdbc.db4.Db4PreparedStatement;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public class Db4TbxPreparedStatement
extends Db4PreparedStatement {
    public Db4TbxPreparedStatement(BasicJdbcObjectFactory factory, Connection conn, PreparedStatement ps, String sql) {
        super(factory, conn, ps, sql);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int[] executeBatch() throws SQLException {
        int[] updateCounts = null;
        boolean autoCommitWasTrue = this.dConn.getAutoCommit();
        try {
            try {
                if (autoCommitWasTrue) {
                    this.dConn.setAutoCommit(false);
                }
                updateCounts = this.tryExecuteBatch();
            }
            catch (SQLException e) {
                if (e.getErrorCode() != -428) throw e;
                super.clearBatch();
                updateCounts = new int[]{};
                BatchUpdateException bE = new BatchUpdateException("Db4TbxPreparedStatement: Internal error (failed to turn off auto commit.)", "SAP_DB4_NO_ERROR_CATEGORY", -99998, updateCounts);
                bE.setNextException(e);
                throw bE;
            }
            Object var6_3 = null;
            if (!autoCommitWasTrue) return updateCounts;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            if (!autoCommitWasTrue) throw throwable;
            this.dConn.commit();
            this.dConn.setAutoCommit(true);
            throw throwable;
        }
        this.dConn.commit();
        this.dConn.setAutoCommit(true);
        return updateCounts;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int[] tryExecuteBatch() throws SQLException {
        Statement svpStmt;
        int[] updateCounts;
        block15: {
            String SET_SAVEPOINT = "SAVEPOINT BEFORE_BATCH ON ROLLBACK RETAIN CURSORS";
            String RELEASE_SAVEPOINT = "RELEASE SAVEPOINT BEFORE_BATCH";
            String ROLLBACK_TO_SAVEPOINT = "ROLLBACK TO SAVEPOINT BEFORE_BATCH";
            updateCounts = null;
            svpStmt = null;
            boolean savepointSet = false;
            try {
                try {
                    svpStmt = this.dConn.createStatement();
                    svpStmt.executeUpdate("SAVEPOINT BEFORE_BATCH ON ROLLBACK RETAIN CURSORS");
                    savepointSet = true;
                    updateCounts = super.executeBatch();
                }
                catch (SQLException e) {
                    if (!savepointSet) {
                        SQLException sqlEx = new SQLException("Db4TbxPreparedStatement: Failed to prepare batch execution.", "SAP_DB4_NO_ERROR_CATEGORY", -99998);
                        sqlEx.setNextException(e);
                        throw sqlEx;
                    }
                    try {
                        svpStmt.executeUpdate("ROLLBACK TO SAVEPOINT BEFORE_BATCH");
                        savepointSet = false;
                    }
                    catch (SQLException svpE) {
                        SQLException sqlEx = new SQLException("Db4TbxPreparedStatement: Failed to roll back to begin of batch execution.", "SAP_DB4_NO_ERROR_CATEGORY", -99998);
                        sqlEx.setNextException(svpE);
                        throw sqlEx;
                    }
                    updateCounts = new int[]{};
                    BatchUpdateException bE = new BatchUpdateException("Db4TbxPreparedStatement: Failed to do batch update.", "SAP_DB4_NO_ERROR_CATEGORY", -99998, updateCounts);
                    bE.setNextException(e);
                    throw bE;
                }
                Object var11_7 = null;
                if (!savepointSet) break block15;
            }
            catch (Throwable throwable) {
                Object var11_8 = null;
                if (savepointSet) {
                    try {
                        svpStmt.executeUpdate("RELEASE SAVEPOINT BEFORE_BATCH");
                    }
                    catch (SQLException e) {
                        SQLException sqlEx = new SQLException("Db4TbxPreparedStatement: Failed to relase savepoint indicating begin of batch execution.", "SAP_DB4_NO_ERROR_CATEGORY", -99998);
                        sqlEx.setNextException(e);
                        throw sqlEx;
                    }
                }
                try {
                    svpStmt.close();
                    throw throwable;
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (SQLException e) {
                SQLException sqlEx = new SQLException("Db4TbxPreparedStatement: Failed to relase savepoint indicating begin of batch execution.", "SAP_DB4_NO_ERROR_CATEGORY", -99998);
                sqlEx.setNextException(e);
                throw sqlEx;
            }
            svpStmt.executeUpdate("RELEASE SAVEPOINT BEFORE_BATCH");
        }
        try {}
        catch (Exception e) {}
        svpStmt.close();
        return updateCounts;
    }
}

