/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.db4;

import com.sap.sql.jdbc.basic.SQLExceptionAnalyzer;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class Db4SQLExceptionAnalyzer
extends SQLExceptionAnalyzer {
    public static final int SAP_DB4_SQL_ERROR_CODE = -99998;
    public static final String SAP_DB4_NUMERIC_OVERFLOW = "SAP_DB4_NUMERIC_OVERFLOW";
    public static final String SAP_DB4_NO_ERROR_CATEGORY = "SAP_DB4_NO_ERROR_CATEGORY";
    public static final String SAP_DB4_DB_ADMINISTRATOR_REQUIRED = "SAP_DB4_DB_ADMINISTRATOR_REQUIRED";

    public Db4SQLExceptionAnalyzer(Connection con) {
        super(con);
    }

    public int getCategory(SQLException exception) {
        int category = 0;
        int newCategory = 0;
        while (exception != null) {
            int errorCode = exception.getErrorCode();
            String sqlState = exception.getSQLState();
            if (errorCode == -99998) {
                if (sqlState != null) {
                    if (sqlState.equals(SAP_DB4_NUMERIC_OVERFLOW)) {
                        newCategory = 2;
                    } else if (sqlState.equals(SAP_DB4_NO_ERROR_CATEGORY)) {
                        newCategory = 7;
                    } else if (sqlState.equals(SAP_DB4_DB_ADMINISTRATOR_REQUIRED)) {
                        newCategory = 8;
                    }
                }
            } else if (errorCode > 0) {
                switch (errorCode) {
                    case 204: {
                        newCategory = 4;
                        break;
                    }
                    case 7905: {
                        newCategory = 8;
                        break;
                    }
                    default: {
                        newCategory = 0;
                        break;
                    }
                }
            } else {
                switch (errorCode) {
                    case -803: 
                    case -603: {
                        newCategory = 1;
                        break;
                    }
                    case -206: 
                    case -205: {
                        newCategory = 3;
                        break;
                    }
                    case -204: {
                        newCategory = 4;
                        break;
                    }
                    case -601: 
                    case -541: 
                    case -454: {
                        newCategory = 5;
                        break;
                    }
                    case -913: {
                        newCategory = 6;
                        break;
                    }
                    case -30060: 
                    case -30041: 
                    case -30040: 
                    case -9012: 
                    case -9006: 
                    case -8010: 
                    case -7934: 
                    case -4301: 
                    case -4300: 
                    case -950: 
                    case -904: 
                    case -901: 
                    case -357: 
                    case -250: {
                        newCategory = 8;
                        break;
                    }
                    case -99999: {
                        newCategory = !this.connectionAlive() ? 9 : 7;
                        break;
                    }
                    case -30089: 
                    case -30082: 
                    case -30080: 
                    case -900: 
                    case -843: 
                    case -251: 
                    case -188: 
                    case -113: {
                        newCategory = 9;
                        break;
                    }
                    default: {
                        newCategory = 7;
                    }
                }
            }
            category = newCategory > category ? newCategory : category;
            exception = exception.getNextException();
        }
        return category;
    }

    /*
     * Loose catch block
     */
    private boolean connectionAlive() {
        boolean isAlive;
        block11: {
            isAlive = false;
            Statement stmt = null;
            String chkObj = "CHKOBJ OBJ(QSYS/QSYS) OBJTYPE(*LIB) AUT(*NONE)";
            String exec = "CALL QSYS.QCMDEXC('" + chkObj + "', " + "00000000" + new Integer(chkObj.length()).toString() + ".00000)";
            stmt = this.con.createStatement();
            stmt.executeUpdate(exec);
            isAlive = true;
            Object var7_5 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                break block11;
            }
            catch (SQLException e2) {}
            break block11;
            {
                catch (SQLException e) {
                    isAlive = false;
                    Object var7_6 = null;
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                        break block11;
                    }
                    catch (SQLException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return isAlive;
    }
}

