/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.db4;

import com.sap.sql.jdbc.basic.BasicDbPortingServices;
import com.sap.sql.jdbc.basic.DbPortingFactory;
import com.sap.sql.jdbc.basic.SQLExceptionAnalyzer;
import com.sap.sql.jdbc.db4.Db4NtvConnection;
import com.sap.sql.jdbc.db4.Db4NtvPortingServices;
import com.sap.sql.jdbc.db4.Db4NtvSQLExceptionAnalyzer;
import com.sap.sql.jdbc.db4.Db4TbxConnection;
import com.sap.sql.jdbc.db4.Db4TbxPortingServices;
import com.sap.sql.jdbc.db4.Db4TbxSQLExceptionAnalyzer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.StringTokenizer;

public class Db4PortingFactory
implements DbPortingFactory {
    private final String DB4_DRIVER_PKG_TOOLBOX = "com.ibm.as400.access";
    private final String DB4_DRIVER_PKG_NATIVE = "com.ibm.db2.jdbc.app";
    private static final int[] MIN_VERSION_TOOLBOX = new int[]{5, 3, 0, 0};
    private static final int[] MIN_VERSION_PATCH = new int[]{4, 0};

    public boolean isJdbcDriverSupported(Connection connection) throws SQLException {
        boolean supported = false;
        Package pkg = connection.getClass().getPackage();
        if (pkg.getName().trim().equals("com.ibm.as400.access")) {
            supported = true;
        } else if (pkg.getName().trim().equals("com.ibm.db2.jdbc.app")) {
            supported = true;
        }
        return supported;
    }

    public Connection createPortedConnection(Connection connection) throws SQLException {
        Package pkg = connection.getClass().getPackage();
        if (pkg.getName().trim().equals("com.ibm.as400.access")) {
            return new Db4TbxConnection(connection);
        }
        if (pkg.getName().trim().equals("com.ibm.db2.jdbc.app")) {
            return new Db4NtvConnection(connection);
        }
        throw new SQLException("Db4PortingFactory: JDBC driver not supported (" + pkg.getName() + ").", "SAP_DB4_DB_ADMINISTRATOR_REQUIRED", -99998);
    }

    public BasicDbPortingServices createDbPortingServices(Connection connection) throws SQLException {
        Package pkg = connection.getClass().getPackage();
        if (pkg.getName().trim().equals("com.ibm.as400.access")) {
            return new Db4TbxPortingServices(connection);
        }
        if (pkg.getName().trim().equals("com.ibm.db2.jdbc.app")) {
            return new Db4NtvPortingServices(connection);
        }
        throw new SQLException("Db4PortingFactory: JDBC driver not supported (" + pkg.getName() + ").", "SAP_DB4_DB_ADMINISTRATOR_REQUIRED", -99998);
    }

    public SQLExceptionAnalyzer createSQLExceptionAnalyzer(Connection connection) throws SQLException {
        Package pkg = connection.getClass().getPackage();
        if (pkg.getName().trim().equals("com.ibm.as400.access")) {
            return new Db4TbxSQLExceptionAnalyzer(connection);
        }
        if (pkg.getName().trim().equals("com.ibm.db2.jdbc.app")) {
            return new Db4NtvSQLExceptionAnalyzer(connection);
        }
        throw new SQLException("Db4PortingFactory: JDBC driver not supported (" + pkg.getName() + ").", "SAP_DB4_DB_ADMINISTRATOR_REQUIRED", -99998);
    }

    private boolean checkToolboxVersion(Package pkg) throws SQLException {
        int length = MIN_VERSION_TOOLBOX.length;
        boolean isOk = true;
        boolean decided = false;
        int[] driverSpecVersion = new int[length];
        try {
            int index;
            int majorImplVersion;
            String implVersion = pkg.getImplementationVersion();
            if (implVersion.startsWith("JTO") && (majorImplVersion = new Integer(implVersion.substring(index = implVersion.indexOf(".") - 1, index + 1)).intValue()) >= MIN_VERSION_PATCH[0]) {
                decided = true;
                isOk = true;
            }
            StringTokenizer specTokenizer = new StringTokenizer(pkg.getSpecificationVersion(), ".");
            int i = 0;
            while (!decided && i < length) {
                String next = specTokenizer.nextToken();
                driverSpecVersion[i] = new Integer(next);
                if (driverSpecVersion[i] != MIN_VERSION_TOOLBOX[i]) {
                    decided = true;
                    if (driverSpecVersion[i] < MIN_VERSION_TOOLBOX[i]) {
                        isOk = false;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new SQLException("Db4PortingFactory: Internal error. Failed to check Toolbox JDBC Driver level(level: " + pkg.getSpecificationVersion() + ", " + pkg.getImplementationVersion() + ")", "SAP_DB4_NO_ERROR_CATEGORY", -99998);
        }
        return isOk;
    }
}

