/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.db2;

import com.sap.sql.jdbc.basic.BasicDbPortingServices;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;

public class Db2PortingServices
extends BasicDbPortingServices {
    private PreparedStatement utcTimeStmt = null;

    public Db2PortingServices(Connection con) {
        super(con);
    }

    public String getConnectionID() throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        String conid = null;
        stmt = this.connection.createStatement();
        rs = stmt.executeQuery("select rtrim(char(current sqlid)) concat '_' concat rtrim(char(current server))  concat  coalesce (z.ipaddr,'') from sysibm.sysdummy1 left outer join (select '_' concat rtrim(char(b.ipaddr)) as ipaddr from sysibm.locations a,  sysibm.ipnames b where a.location =  char(current server) and a.linkname = b.linkname ) as z on 1 = 1 ");
        rs.next();
        conid = rs.getString(1);
        rs.close();
        return conid;
    }

    public Timestamp getUTCTimestamp() throws SQLException {
        ResultSet rs;
        if (this.utcTimeStmt == null) {
            this.utcTimeStmt = this.connection.prepareStatement("SELECT CURRENT TIMESTAMP - CURRENT TIMEZONE FROM SYSIBM.SYSTABLES");
        }
        if (!(rs = this.utcTimeStmt.executeQuery()).next()) {
            throw new SQLException("Failed to get UTC timestamp on DB server");
        }
        Timestamp ts = rs.getTimestamp(1, this.utcCalendar);
        rs.close();
        return ts;
    }

    public String getDatabaseProductName() throws SQLException {
        return this.connection.getMetaData().getDatabaseProductName();
    }

    public String getDatabaseProductVersion() throws SQLException {
        return this.connection.getMetaData().getDatabaseProductVersion();
    }

    public String getUserName() throws SQLException {
        return this.connection.getMetaData().getUserName();
    }

    public String getSchemaName() throws SQLException {
        Statement stmt = null;
        String schemaName = null;
        stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT CURRENT SQLID FROM SYSIBM.SYSDUMMY1");
        if (rs.next()) {
            schemaName = rs.getString(1);
        }
        rs.close();
        stmt.close();
        return schemaName;
    }

    public String getDatabaseName() throws SQLException {
        Statement stmt = null;
        String dbName = null;
        stmt = this.connection.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT CURRENT SERVER FROM SYSIBM.SYSDUMMY1");
        if (rs.next()) {
            dbName = rs.getString(1);
        }
        rs.close();
        stmt.close();
        return dbName;
    }

    public String getDatabaseHost() throws SQLException {
        String dbHost = null;
        String url = this.connection.getMetaData().getURL();
        if (url != null && url.startsWith("jdbc:db2://")) {
            dbHost = url.substring(11, url.substring(11).indexOf(58) + 11);
        }
        return dbHost;
    }

    public int getVendorID() {
        return 2;
    }

    public Boolean isDatabaseKernel64Bit() throws SQLException {
        DatabaseMetaData md = this.connection.getMetaData();
        String db_vers = md.getDatabaseProductVersion();
        if (0 == db_vers.compareTo("DSN07011")) {
            return new Boolean(false);
        }
        if (0 == db_vers.compareTo("DSN08015")) {
            return new Boolean(true);
        }
        return null;
    }

    public boolean selectAllocatesResources(int transactionIsolationLevel) {
        return true;
    }
}

