/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.common;

import java.io.IOException;
import java.io.Reader;

final class CommonSecureLengthReader
extends Reader {
    private final int expectedLength;
    private final Reader wrappedReader;
    private int charactersRead;

    CommonSecureLengthReader(Reader aReader, int aLength) {
        this.wrappedReader = aReader;
        this.expectedLength = aLength;
        this.charactersRead = 0;
    }

    public void close() throws IOException {
        this.wrappedReader.close();
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int readThisCall = this.wrappedReader.read(cbuf, off, len);
        if (readThisCall >= 0) {
            this.charactersRead += readThisCall;
            if (this.charactersRead > this.expectedLength) {
                throw new IOException("stream exeeds expected length");
            }
        } else if (this.charactersRead < this.expectedLength) {
            throw new IOException("unexpected end of stream");
        }
        return readThisCall;
    }

    public boolean ready() throws IOException {
        return this.wrappedReader.ready();
    }
}

