/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.common;

import com.sap.sql.tree.GeneralSelectStatement;
import com.sap.sql.tree.ResultDescriptor;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;

public class CommonResultSetMetaData
implements ResultSetMetaData {
    private ResultDescriptor[] columns;
    private HashMap columnMap;

    CommonResultSetMetaData(GeneralSelectStatement selectTree) {
        this.columns = selectTree.getResultSetColumns();
        this.columnMap = selectTree.getColumnMap();
        if (null == this.columns) {
            throw new IllegalArgumentException("null == columns");
        }
        if (null == this.columnMap) {
            throw new IllegalArgumentException("null == columnMap");
        }
    }

    public int getColumnCount() throws SQLException {
        return this.columns.length;
    }

    public boolean isAutoIncrement(int column) throws SQLException {
        CommonResultSetMetaData.throwUnsupported("isAutoIncrement()");
        return false;
    }

    public boolean isCaseSensitive(int column) throws SQLException {
        CommonResultSetMetaData.throwUnsupported("isCaseSensitive(int)");
        return true;
    }

    public boolean isSearchable(int column) throws SQLException {
        CommonResultSetMetaData.throwUnsupported("isSearchable()");
        return false;
    }

    public boolean isCurrency(int column) throws SQLException {
        CommonResultSetMetaData.throwUnsupported("isCurrency()");
        return false;
    }

    public int isNullable(int column) throws SQLException {
        ResultDescriptor col = this.getColumn(column);
        if (col.isNullable()) {
            return 1;
        }
        return 0;
    }

    public boolean isSigned(int column) throws SQLException {
        CommonResultSetMetaData.throwUnsupported("isSigned()");
        return false;
    }

    public int getColumnDisplaySize(int column) throws SQLException {
        CommonResultSetMetaData.throwUnsupported("getColumnDisplaySize()");
        return 0;
    }

    public String getColumnLabel(int column) throws SQLException {
        CommonResultSetMetaData.throwUnsupported("getColumnLabel()");
        return null;
    }

    public String getColumnName(int column) throws SQLException {
        ResultDescriptor col = this.getColumn(column);
        return col.getName();
    }

    public String getSchemaName(int column) throws SQLException {
        ResultDescriptor col = this.getColumn(column);
        return col.getSchemaName();
    }

    public int getPrecision(int column) throws SQLException {
        ResultDescriptor col = this.getColumn(column);
        if (col.isNumeric || col.isBinary || col.isCharacterLike) {
            return (int)col.getSize();
        }
        throw new SQLException("Method getPrecision not applicable for JDBC-Type \"" + col.getTypeName());
    }

    public int getScale(int column) throws SQLException {
        ResultDescriptor col = this.getColumn(column);
        if (col.isNumeric) {
            return col.getDecimals();
        }
        throw new SQLException("Method getScale not applicable for JDBC-Type \"" + col.getTypeName());
    }

    public String getTableName(int column) throws SQLException {
        ResultDescriptor col = this.getColumn(column);
        return col.getTableName();
    }

    public String getCatalogName(int column) throws SQLException {
        CommonResultSetMetaData.throwUnsupported("getCatalogName()");
        return null;
    }

    public int getColumnType(int column) throws SQLException {
        ResultDescriptor col = this.getColumn(column);
        return col.getJdbcType();
    }

    public String getColumnTypeName(int column) throws SQLException {
        ResultDescriptor col = this.getColumn(column);
        return col.getTypeName();
    }

    public boolean isReadOnly(int column) throws SQLException {
        CommonResultSetMetaData.throwUnsupported("isReadOnly()");
        return false;
    }

    public boolean isWritable(int column) throws SQLException {
        CommonResultSetMetaData.throwUnsupported("isWritable()");
        return !this.isReadOnly(column);
    }

    public boolean isDefinitelyWritable(int column) throws SQLException {
        CommonResultSetMetaData.throwUnsupported("isDefinitelyWritable()");
        return false;
    }

    public String getColumnClassName(int column) throws SQLException {
        CommonResultSetMetaData.throwUnsupported("getColumnClassName()");
        return null;
    }

    HashMap getColumnMap() {
        return this.columnMap;
    }

    private static void throwUnsupported(String method) {
        throw new UnsupportedOperationException("Method " + method + " not supported by Common JDBC");
    }

    ResultDescriptor getColumn(int i) throws SQLException {
        return this.columns[i - 1];
    }
}

