/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.common;

import com.sap.exception.standard.SAPIllegalArgumentException;
import com.sap.sql.DuplicateKeyException;
import com.sap.sql.jdbc.ExtendedConnection;
import com.sap.sql.jdbc.ExtendedPreparedStatement;
import com.sap.sql.jdbc.ExtendedPreparedStatementAdapter;
import com.sap.sql.jdbc.ExtendedStatement;
import com.sap.sql.jdbc.common.AbstractCommonStatement;
import com.sap.sql.jdbc.common.CommonBlob;
import com.sap.sql.jdbc.common.CommonClob;
import com.sap.sql.jdbc.common.CommonConnectionContext;
import com.sap.sql.jdbc.common.CommonResultSetMetaData;
import com.sap.sql.jdbc.common.CommonSecureLengthInputStream;
import com.sap.sql.jdbc.common.CommonSecureLengthReader;
import com.sap.sql.jdbc.common.UTCCalendar;
import com.sap.sql.log.Syslog;
import com.sap.sql.tablebuffer.BufferCommonStatement;
import com.sap.sql.tabstat.TableStatistics;
import com.sap.sql.trace.TraceContext;
import com.sap.sql.tree.DeleteStatement;
import com.sap.sql.tree.GeneralSelectStatement;
import com.sap.sql.tree.InsertStatement;
import com.sap.sql.tree.ResultDescriptor;
import com.sap.sql.tree.SQLStatement;
import com.sap.sql.tree.UpdateStatement;
import com.sap.tc.logging.Location;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class CommonPreparedStatement
extends AbstractCommonStatement
implements PreparedStatement,
BufferCommonStatement {
    private static final Location TRACE = Location.getLocation((Class)(class$com$sap$sql$jdbc$common$CommonPreparedStatement == null ? (class$com$sap$sql$jdbc$common$CommonPreparedStatement = CommonPreparedStatement.class$("com.sap.sql.jdbc.common.CommonPreparedStatement")) : class$com$sap$sql$jdbc$common$CommonPreparedStatement));
    private static final float MAX_POSITIVE_FLOAT_VALUE = 3.402E38f;
    private static final float MIN_NEGATIVE_FLOAT_VALUE = -3.402E38f;
    private static final float MIN_POSITIVE_FLOAT_VALUE = 1.175E-37f;
    private static final float MAX_NEGATIVE_FLOAT_VALUE = -1.175E-37f;
    private static final double MAX_POSITIVE_DOUBLE_VALUE = 9.9E62;
    private static final double MIN_NEGATIVE_DOUBLE_VALUE = -9.9E62;
    private static final double MIN_POSITIVE_DOUBLE_VALUE = 1.0E-64;
    private static final double MAX_NEGATIVE_DOUBLE_VALUE = -1.0E-64;
    protected ExtendedPreparedStatement wrappedPrepStmt;
    protected TraceContext traceContext;
    private CommonResultSetMetaData metaData = null;
    private ResultDescriptor[] hostVars;
    private Calendar localCalendar = null;
    private int prepareTimeTransactionIsolation;
    private boolean batch = false;
    static /* synthetic */ Class class$com$sap$sql$jdbc$common$CommonPreparedStatement;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$io$Reader;
    static /* synthetic */ Class class$java$sql$Blob;
    static /* synthetic */ Class class$java$sql$Clob;

    CommonPreparedStatement(CommonConnectionContext connectionContext, String sql, TraceContext traceContext) throws SQLException {
        super(connectionContext);
        SQLStatement tree = connectionContext.getStatementAnalyzer().preprepareStatement(sql, connectionContext.getCatalogReader());
        this.initStatement(tree);
    }

    CommonPreparedStatement(CommonConnectionContext connectionContext, SQLStatement tree) throws SQLException {
        super(connectionContext);
        if (tree.getHostVariablesList() == null) {
            tree = connectionContext.getStatementAnalyzer().checkSemantics(tree, connectionContext.getCatalogReader());
        }
        this.initStatement(tree);
    }

    CommonPreparedStatement(CommonConnectionContext connectionContext) throws SQLException {
        super(connectionContext);
    }

    public final ResultSet executeQuery() throws SQLException {
        String methodName = "executeQuery()";
        if (TRACE.bePath()) {
            TRACE.entering("executeQuery()");
        }
        try {
            this.validate();
            this.validateBatch("executeQuery()");
            if (this.commonConnection.getTransactionIsolation() != this.prepareTimeTransactionIsolation) {
                throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.jdbc.common_1136", new Object[]{new Integer(this.prepareTimeTransactionIsolation), new Integer(this.commonConnection.getTransactionIsolation())});
            }
            this.updateCount = -1;
            this.closeResultSet();
            switch (this.stmtTree.getStatementType()) {
                case 2: {
                    break;
                }
                case 32: {
                    if (!this.connectionContext.getConnection().getAutoCommit()) break;
                    throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.jdbc.common_1102", null);
                }
                default: {
                    throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.jdbc.common_1103", new Object[]{this.stmtTree.getStatementTypeName(), "executeQuery()"});
                }
            }
            if (this.wrappedBufStmt != null) {
                this.commonConnection.setActiveTransactionStateMin();
            } else {
                this.commonConnection.setActiveTransactionState(this.stmtTree.getStatementType(), -1);
            }
            if (TableStatistics.isSwitchedOn()) {
                this.gatherTableStatistics(this.stmtTree, 1L);
            }
            ResultSet basicResultSet = this.wrappedPrepStmt.executeQuery(this.traceContext);
            this.wrappedPrepStmt.prepareResultSet(((GeneralSelectStatement)this.stmtTree).getResultSetColumns());
            this.resultSet = this.createResultSet(this, basicResultSet, this.metaData, this.pedanticTypeChecking, this.stmtTree);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (TRACE.bePath()) {
                TRACE.exiting((Object)this.resultSet);
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting((Object)this.resultSet);
        }
        return this.resultSet;
    }

    public final ResultSet executeQuery(String sql) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "executeQuery(String)");
    }

    public final ResultSet executeQuery(SQLStatement tree, String source, int line, long timestamp) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "executeQuery(SQLStatement, String, int, long)");
    }

    public final int executeUpdate() throws SQLException {
        String methodName = "executeUpdate()";
        if (TRACE.bePath()) {
            TRACE.entering("executeUpdate()");
        }
        try {
            this.validate();
            this.validateBatch("executeUpdate()");
            this.updateCount = -1;
            this.closeResultSet();
            switch (this.stmtTree.getStatementType()) {
                case 4: 
                case 8: 
                case 16: {
                    break;
                }
                default: {
                    throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.jdbc.common_1103", new Object[]{this.stmtTree.getStatementTypeName(), "executeUpdate()"});
                }
            }
            this.commonConnection.setActiveTransactionState(this.stmtTree.getStatementType(), -1);
            if (TableStatistics.isSwitchedOn()) {
                this.gatherTableStatistics(this.stmtTree, 1L);
            }
            try {
                this.updateCount = this.wrappedPrepStmt.executeUpdate(this.traceContext);
            }
            catch (SQLException sqlEx) {
                throw this.isDuplicateKeyException(sqlEx) ? new DuplicateKeyException(sqlEx) : sqlEx;
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (TRACE.bePath()) {
                TRACE.exiting((Object)new Integer(this.updateCount));
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting((Object)new Integer(this.updateCount));
        }
        return this.updateCount;
    }

    public final int executeUpdate(String sql) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "executeUpdate(String)");
    }

    public final int executeUpdate(SQLStatement tree, String source, int line, long timestamp) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "executeUpdate(SQLStatement, String, int, long)");
    }

    public final void setNull(int index, int type) throws SQLException {
        this.validate();
        ResultDescriptor hostVar = this.hostVars[index - 1];
        if (this.pedanticTypeChecking && !hostVar.isNullable()) {
            switch (this.stmtTree.getStatementType()) {
                case 4: 
                case 8: {
                    throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.jdbc.common_1104", new Object[]{new Integer(index), hostVar.getName(), hostVar.getTableName(), this.getStatementString()});
                }
            }
            throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.jdbc.common_1127", new Object[]{new Integer(index), this.getStatementString()});
        }
        this.wrappedPrepStmt.setNull(index, hostVar.getJdbcType());
    }

    public final void setBoolean(int index, boolean x) throws SQLException {
        this.validate();
        this.checkHostvarType(index, Boolean.TYPE);
        this.wrappedPrepStmt.setBoolean(index, x);
    }

    public final void setByte(int index, byte x) throws SQLException {
        this.validate();
        this.checkHostvarType(index, Byte.TYPE);
        this.wrappedPrepStmt.setByte(index, x);
    }

    public final void setShort(int index, short x) throws SQLException {
        this.validate();
        this.checkHostvarType(index, Short.TYPE);
        this.wrappedPrepStmt.setShort(index, x);
    }

    public final void setInt(int index, int x) throws SQLException {
        this.validate();
        this.checkHostvarType(index, Integer.TYPE);
        this.wrappedPrepStmt.setInt(index, x);
    }

    public final void setLong(int index, long x) throws SQLException {
        this.validate();
        this.checkHostvarType(index, Long.TYPE);
        this.wrappedPrepStmt.setLong(index, x);
    }

    public final void setFloat(int index, float x) throws SQLException {
        this.validate();
        this.checkHostvarType(index, Float.TYPE);
        if (Float.isInfinite(x) || Float.isNaN(x)) {
            throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.jdbc.common_1130", new Object[]{new Integer(index), Float.toString(x)});
        }
        if (x > 0.0f && (x < 1.175E-37f || x > 3.402E38f) || x < 0.0f && (x > -1.175E-37f || x < -3.402E38f)) {
            throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.jdbc.common_1132", new Object[]{new Integer(index), Float.toString(x), Float.toString(1.175E-37f), Float.toString(3.402E38f)});
        }
        this.wrappedPrepStmt.setFloat(index, x);
    }

    public final void setDouble(int index, double x) throws SQLException {
        this.validate();
        this.checkHostvarType(index, Double.TYPE);
        if (Double.isInfinite(x) || Double.isNaN(x)) {
            throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.jdbc.common_1131", new Object[]{new Integer(index), Double.toString(x), Double.toString(1.0E-64), Double.toString(9.9E62)});
        }
        if (x > 0.0 && (x < 1.0E-64 || x > 9.9E62) || x < 0.0 && (x > -1.0E-64 || x < -9.9E62)) {
            throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.jdbc.common_1133", new Object[]{new Integer(index), Double.toString(x)});
        }
        this.wrappedPrepStmt.setDouble(index, x);
    }

    public final void setBigDecimal(int index, BigDecimal x) throws SQLException {
        this.validate();
        this.checkHostvarType(index, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = CommonPreparedStatement.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
        if (x == null) {
            this.setNull(index, 3);
        } else {
            this.wrappedPrepStmt.setBigDecimal(index, x);
        }
    }

    public final void setString(int index, String x) throws SQLException {
        this.validate();
        if (x == null) {
            this.setNull(index, 12);
        } else {
            int length = x.length();
            ResultDescriptor hostVar = this.checkHostvarType(index, class$java$lang$String == null ? (class$java$lang$String = CommonPreparedStatement.class$("java.lang.String")) : class$java$lang$String, length);
            int jdbcType = hostVar.getJdbcType();
            if (length == 0 && jdbcType != 1) {
                throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.jdbc.common_1105", new Object[]{new Integer(index)});
            }
            if (length > 1 && x.charAt(length - 1) == ' ' && (jdbcType == 12 || jdbcType == -1)) {
                throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.jdbc.common_1106", new Object[]{new Integer(index)});
            }
            if (jdbcType == 2005) {
                this.wrappedPrepStmt.setCharacterStream(index, (Reader)new StringReader(x), length);
            } else {
                this.wrappedPrepStmt.setString(index, x);
            }
        }
    }

    public final void setBytes(int index, byte[] x) throws SQLException {
        this.validate();
        if (x == null) {
            this.setNull(index, -3);
        } else {
            ResultDescriptor hostVar = this.checkHostvarType(index, array$B == null ? (array$B = CommonPreparedStatement.class$("[B")) : array$B);
            int jdbcType = hostVar.getJdbcType();
            if (x.length == 0) {
                throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.jdbc.common_1108", new Object[]{new Integer(index)});
            }
            if (jdbcType == -2 && (long)x.length != hostVar.getSize()) {
                throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.jdbc.common_1107", new Object[]{new Integer(index), new Integer(x.length), new Integer((int)hostVar.getSize())});
            }
            if (hostVar.getJdbcType() == 2004) {
                this.wrappedPrepStmt.setBinaryStream(index, (InputStream)new ByteArrayInputStream(x), x.length);
            } else {
                this.wrappedPrepStmt.setBytes(index, x);
            }
        }
    }

    public final void setDate(int index, Date x) throws SQLException {
        this.validate();
        if (x == null) {
            this.setNull(index, 91);
        } else {
            this.checkHostvarType(index, class$java$sql$Date == null ? (class$java$sql$Date = CommonPreparedStatement.class$("java.sql.Date")) : class$java$sql$Date);
            if (!this.isValid(x)) {
                throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.jdbc.common_1109", new Object[]{new Integer(index), x.getClass().getName(), x});
            }
            this.wrappedPrepStmt.setDate(index, x);
        }
    }

    public final void setDate(int index, Date x, Calendar cal) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "setDate(int, java.sql.Date, Calendar)");
    }

    public final void setTime(int index, Time x) throws SQLException {
        this.validate();
        if (x == null) {
            this.setNull(index, 92);
        } else {
            this.checkHostvarType(index, class$java$sql$Time == null ? (class$java$sql$Time = CommonPreparedStatement.class$("java.sql.Time")) : class$java$sql$Time);
            if (!this.isValid(x)) {
                throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.jdbc.common_1109", new Object[]{new Integer(index), x.getClass().getName(), x});
            }
            this.wrappedPrepStmt.setTime(index, x);
        }
    }

    public final void setTime(int index, Time x, Calendar cal) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "setTime(int, java.sql.Time, Calendar)");
    }

    public final void setTimestamp(int index, Timestamp x) throws SQLException {
        this.validate();
        if (x == null) {
            this.setNull(index, 93);
        } else {
            this.checkHostvarType(index, class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = CommonPreparedStatement.class$("java.sql.Timestamp")) : class$java$sql$Timestamp);
            this.wrappedPrepStmt.setTimestamp(index, x, UTCCalendar.getInstance());
        }
    }

    public final void setTimestamp(int index, Timestamp x, Calendar cal) throws SQLException {
        this.setTimestamp(index, x);
    }

    public final void setAsciiStream(int index, InputStream x, int length) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "setAsciiStream(int, InputStream, int)");
    }

    public final void setUnicodeStream(int index, InputStream x, int length) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "setUnicodeStream(int, InputStream, int)");
    }

    public final void setBinaryStream(int index, InputStream x, int length) throws SQLException {
        this.validate();
        if (x == null) {
            this.setNull(index, -2);
        } else {
            ResultDescriptor hostVar = this.checkHostvarType(index, class$java$io$InputStream == null ? (class$java$io$InputStream = CommonPreparedStatement.class$("java.io.InputStream")) : class$java$io$InputStream);
            if (length < 0) {
                throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql_0015", new Object[]{"length", new Integer(length)});
            }
            if (length == 0) {
                throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.jdbc.common_1113", new Object[]{new Integer(index), x.getClass().getName(), new Long(length)});
            }
            if (hostVar.getJdbcType() == 2004) {
                this.wrappedPrepStmt.setBinaryStream(index, (InputStream)new CommonSecureLengthInputStream(x, length), length);
            } else {
                int realLength2;
                byte[] content = new byte[length];
                try {
                    realLength2 = x.read(content);
                }
                catch (IOException e) {
                    boolean realLength2 = false;
                    throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.jdbc.common_1110", new Object[]{new Integer(index), x.getClass().getName(), e.getMessage()}, (Throwable)e);
                }
                if (realLength2 != length) {
                    throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.jdbc.common_1111", new Object[]{new Integer(index), x.getClass().getName(), new Integer(realLength2), new Integer(length)});
                }
                if (hostVar.getJdbcType() == -2 && (long)length != hostVar.getSize()) {
                    throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.jdbc.common_1107", new Object[]{new Integer(index), new Integer(length), new Integer((int)hostVar.getSize())});
                }
                this.wrappedPrepStmt.setBytes(index, content);
            }
        }
    }

    public final void clearParameters() throws SQLException {
        this.validate();
        this.wrappedPrepStmt.clearParameters();
    }

    public final void setObject(int index, Object x, int type, int scale) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "setObject(int, Object, int, int)");
    }

    public final void setObject(int index, Object x, int type) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "setObject(int, Object, int)");
    }

    public final void setObject(int index, Object x) throws SQLException {
        this.validate();
        ResultDescriptor hostVar = this.hostVars[index - 1];
        if (x == null) {
            this.setNull(index, hostVar.getJdbcType());
        } else {
            Class<?> javaClass = x.getClass();
            if (!hostVar.isSetableFrom(javaClass, this.pedanticTypeChecking)) {
                throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.jdbc.common_1112", new Object[]{new Integer(index), hostVar.getJdbcTypeName(), javaClass.getName()});
            }
            switch (hostVar.getJdbcType()) {
                case 93: {
                    this.setTimestamp(index, (Timestamp)x);
                    break;
                }
                default: {
                    this.wrappedPrepStmt.setObject(index, x, hostVar.getJdbcType());
                }
            }
        }
    }

    public final boolean execute() throws SQLException {
        this.validate();
        this.validateBatch("execute()");
        if (this.stmtTree instanceof GeneralSelectStatement) {
            this.executeQuery();
            return true;
        }
        this.executeUpdate();
        return false;
    }

    public final boolean execute(String sql) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "execute(String)");
    }

    public final boolean execute(SQLStatement tree, String source, int line, long timestamp) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "execute(SQLStatement, String, int, long)");
    }

    public final void addBatch() throws SQLException {
        this.validate();
        this.wrappedPrepStmt.addBatch();
        this.batch = true;
    }

    public final void setCharacterStream(int index, Reader x, int length) throws SQLException {
        this.validate();
        if (x != null) {
            ResultDescriptor hostVar = this.checkHostvarType(index, class$java$io$Reader == null ? (class$java$io$Reader = CommonPreparedStatement.class$("java.io.Reader")) : class$java$io$Reader, length);
            if (length < 0) {
                throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql_0015", new Object[]{"length", new Integer(length)});
            }
            if (length == 0 && hostVar.getJdbcType() != 1) {
                throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.jdbc.common_1113", new Object[]{new Integer(index), x.getClass().getName(), new Long(length)});
            }
            if (hostVar.getJdbcType() == 2005) {
                this.wrappedPrepStmt.setCharacterStream(index, (Reader)new CommonSecureLengthReader(x, length), length);
            } else {
                int realLength2;
                char[] content = new char[length];
                try {
                    realLength2 = x.read(content);
                }
                catch (IOException e) {
                    boolean realLength2 = false;
                    throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.jdbc.common_1110", new Object[]{new Integer(index), "java.io.Reader", e.getMessage()}, (Throwable)e);
                }
                if (realLength2 != length) {
                    throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.jdbc.common_1111", new Object[]{new Integer(index), x.getClass().getName(), new Integer(realLength2), new Integer(length)});
                }
                this.wrappedPrepStmt.setString(index, new String(content));
            }
        } else {
            this.setNull(index, 12);
        }
    }

    public final void setRef(int index, Ref x) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "setRef(int, Ref)");
    }

    public final void setBlob(int index, Blob blob) throws SQLException {
        this.validate();
        this.checkHostvarType(index, class$java$sql$Blob == null ? (class$java$sql$Blob = CommonPreparedStatement.class$("java.sql.Blob")) : class$java$sql$Blob);
        if (null == blob) {
            this.setNull(index, 2004);
            return;
        }
        if (!(blob instanceof CommonBlob)) {
            throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql_0016", new Object[]{"blob", "CommonBlob", blob.getClass().getName()});
        }
        long length = blob.length();
        if (length <= 0L || length > Integer.MAX_VALUE) {
            throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.jdbc.common_1113", new Object[]{new Integer(index), "BLOB", new Long(length)});
        }
        CommonBlob commonBlob = (CommonBlob)blob;
        if (!commonBlob.checkAccess(this.connectionContext.getConnection())) {
            throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.jdbc.common_1114", new Object[]{new Integer(index), "BLOB"});
        }
        this.wrappedPrepStmt.setBinaryStream(index, (InputStream)new CommonSecureLengthInputStream(blob.getBinaryStream(), (int)length), (int)length);
    }

    public final void setClob(int index, Clob clob) throws SQLException {
        this.validate();
        this.checkHostvarType(index, class$java$sql$Clob == null ? (class$java$sql$Clob = CommonPreparedStatement.class$("java.sql.Clob")) : class$java$sql$Clob);
        if (null == clob) {
            this.setNull(index, 2005);
            return;
        }
        if (!(clob instanceof CommonClob)) {
            throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql_0016", new Object[]{"clob", "CommonClob", clob.getClass().getName()});
        }
        long length = clob.length();
        if (length <= 0L || length > Integer.MAX_VALUE) {
            throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.jdbc.common_1113", new Object[]{new Integer(index), "CLOB", new Long(length)});
        }
        CommonClob commonClob = (CommonClob)clob;
        if (!commonClob.checkAccess(this.connectionContext.getConnection())) {
            throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.jdbc.common_1114", new Object[]{new Integer(index), "CLOB"});
        }
        this.wrappedPrepStmt.setCharacterStream(index, (Reader)new CommonSecureLengthReader(clob.getCharacterStream(), (int)length), (int)length);
    }

    public final void setArray(int index, Array x) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "setArray(int, Array)");
    }

    public final ResultSetMetaData getMetaData() throws SQLException {
        this.validate();
        return this.metaData;
    }

    public final void setNull(int index, int type, String name) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "setNull(int, int, String)");
    }

    public final void addBatch(String sql) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "addBatch(String)");
    }

    public final void clearBatch() throws SQLException {
        this.validate();
        this.batch = false;
        this.wrappedPrepStmt.clearBatch();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int[] executeBatch() throws SQLException {
        int[] nArray;
        String methodName = "executeBatch()";
        if (TRACE.bePath()) {
            TRACE.entering("executeBatch()");
        }
        try {
            this.validate();
            switch (this.stmtTree.getStatementType()) {
                case 4: 
                case 8: 
                case 16: {
                    break;
                }
                default: {
                    throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.jdbc.common_1103", new Object[]{this.stmtTree.getStatementTypeName(), "executeBatch()"});
                }
            }
            this.commonConnection.setActiveTransactionState(this.stmtTree.getStatementType(), -1);
            nArray = this.wrappedPrepStmt.executeBatch(this.traceContext);
            Object var4_3 = null;
            this.batch = false;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.batch = false;
            if (!TRACE.bePath()) throw throwable;
            TRACE.exiting();
            throw throwable;
        }
        if (!TRACE.bePath()) return nArray;
        TRACE.exiting();
        return nArray;
    }

    public final ExtendedStatement getDbStmt(int stmtType) throws SQLException {
        if (this.wrappedDbStmt == null) {
            Connection wc = this.connectionContext.getWrappedConnection();
            this.wrappedDbStmt = wc instanceof ExtendedConnection ? (ExtendedStatement)((Object)((ExtendedConnection)wc).prepareStatement(this.getStatementString(), this.traceContext)) : new ExtendedPreparedStatementAdapter(wc.prepareStatement(this.getStatementString()));
            this.initStmt(this.wrappedDbStmt);
        }
        if (stmtType >= 0) {
            this.commonConnection.setActiveTransactionState(stmtType, -1);
        }
        return this.wrappedDbStmt;
    }

    public final ExtendedPreparedStatement getDbPrepStmt() throws SQLException {
        return (ExtendedPreparedStatement)this.getDbStmt(this.stmtTree.getStatementType());
    }

    final void setURL(int parameterIndex, URL x) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "setURL()");
    }

    protected final void initStatement(SQLStatement aStmtTree) throws SQLException {
        this.setStatement(aStmtTree);
        this.prepareTimeTransactionIsolation = this.commonConnection.getTransactionIsolation();
        this.hostVars = this.stmtTree.getHostVariablesList();
        this.traceContext = this.stmtTree.getTraceContext();
        if (this.hostVars == null) {
            throw new SAPIllegalArgumentException("com.sap.exception.standard_0001", new Object[]{"aStmtTree.getHostVariablesList()"});
        }
        if (this.stmtTree instanceof GeneralSelectStatement) {
            this.metaData = this.createMetaData((GeneralSelectStatement)this.stmtTree);
        } else if (!(this.stmtTree instanceof DeleteStatement || this.stmtTree instanceof InsertStatement || this.stmtTree instanceof UpdateStatement)) {
            throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.jdbc.common_1121", new Object[]{this.stmtTree.getStatementTypeName()});
        }
        this.wrappedPrepStmt = this.bufferManager.checkPreparedStatement(this.connectionContext, this.stmtTree, this);
        if (this.wrappedPrepStmt != null) {
            this.wrappedBufStmt = this.wrappedPrepStmt;
            this.initStmt(this.wrappedBufStmt);
        } else {
            this.wrappedPrepStmt = this.getDbPrepStmt();
        }
    }

    protected final void invalidate() {
        this.hostVars = null;
        this.localCalendar = null;
        this.metaData = null;
        this.traceContext = null;
        this.wrappedPrepStmt = null;
    }

    private final ResultDescriptor checkHostvarType(int columnIndex, Class javaClass, long length) throws SQLException {
        ResultDescriptor hostVar = this.hostVars[columnIndex - 1];
        if (!hostVar.isSetableFrom(javaClass, this.pedanticTypeChecking)) {
            throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.jdbc.common_1112", new Object[]{new Integer(columnIndex), hostVar.getJdbcTypeName(), javaClass.getName()});
        }
        if (length > 0L && hostVar.getSize() > 0L && length > hostVar.getSize()) {
            throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.jdbc.common_1115", new Object[]{new Integer(columnIndex), hostVar.getJdbcTypeName(), new Long(hostVar.getSize()), javaClass.getName(), new Long(length)});
        }
        return hostVar;
    }

    private ResultDescriptor checkHostvarType(int columnIndex, Class javaClass) throws SQLException {
        return this.checkHostvarType(columnIndex, javaClass, 0L);
    }

    private boolean isValid(Date date, Calendar calendar) throws IllegalArgumentException {
        if (date == null) {
            throw new SAPIllegalArgumentException("com.sap.exception.standard_0001", new Object[]{"date"});
        }
        calendar.setTime(date);
        return calendar.get(11) == 0 && calendar.get(12) == 0 && calendar.get(13) == 0 && calendar.get(14) == 0;
    }

    private boolean isValid(Date date) throws IllegalArgumentException {
        if (this.localCalendar == null) {
            this.localCalendar = Calendar.getInstance();
        }
        return this.isValid(date, this.localCalendar);
    }

    private boolean isValid(Time time, Calendar calendar) throws IllegalArgumentException {
        if (time == null) {
            throw new SAPIllegalArgumentException("com.sap.exception.standard_0001", new Object[]{"time"});
        }
        calendar.setTime(time);
        return calendar.get(1) == 1970 && calendar.get(6) == 1;
    }

    private boolean isValid(Time time) throws IllegalArgumentException {
        if (this.localCalendar == null) {
            this.localCalendar = Calendar.getInstance();
        }
        return this.isValid(time, this.localCalendar);
    }

    private void validateBatch(String methodName) throws SQLException {
        if (this.batch) {
            throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.jdbc.common_1143", new Object[]{methodName});
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

