/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.common;

import com.sap.exception.standard.SAPIllegalArgumentException;
import com.sap.sql.catalog.CatalogReader;
import com.sap.sql.jdbc.ConnectionContext;
import com.sap.sql.jdbc.common.AbstractCommonStatement;
import com.sap.sql.jdbc.common.CommonConnection;
import com.sap.sql.jdbc.common.CommonConnectionContext;
import com.sap.sql.jdbc.common.CommonConnectionWrapper;
import com.sap.sql.jdbc.common.CommonContextFactory;
import com.sap.sql.jdbc.common.CommonDatabaseMetaData;
import com.sap.sql.jdbc.common.CommonPooledConnection;
import com.sap.sql.jdbc.common.CommonPreparedStatement;
import com.sap.sql.jdbc.common.CommonStatementImpl;
import com.sap.sql.log.Syslog;
import com.sap.sql.sync.SyncWriter;
import com.sap.sql.tablebuffer.BufferManager;
import com.sap.sql.trace.SQLTraceContext;
import com.sap.sql.tree.SQLStatement;
import com.sap.tc.logging.Location;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class CommonConnectionImpl
implements CommonConnection,
CommonConnectionWrapper {
    static final int DEFAULT_TRANSACTION_ISOLATION = 1;
    private static final Location TRACE = Location.getLocation((Class)(class$com$sap$sql$jdbc$common$CommonConnectionImpl == null ? (class$com$sap$sql$jdbc$common$CommonConnectionImpl = CommonConnectionImpl.class$("com.sap.sql.jdbc.common.CommonConnectionImpl")) : class$com$sap$sql$jdbc$common$CommonConnectionImpl));
    private static final int TRANSACTION_STATE_NONE = 0;
    private static final int TRANSACTION_STATE_INITIALIZED = 1;
    private static final int TRANSACTION_STATE_ACTIVE_SELECTS = 2;
    private static final int TRANSACTION_STATE_ACTIVE_RESOURCES = 3;
    private static final int TRANSACTION_STATE_ACTIVE_MODIFICATIONS = 4;
    private static final int DEFERRED_ACTION_NONE = 0;
    private static final int DEFERRED_ACTION_SET_AUTOCOMMIT = 1;
    private static final int DEFERRED_ACTION_SET_ISOLATIONLEVEL = 2;
    protected CommonConnectionContext connectionContext = null;
    private CommonPooledConnection pooledConnection = null;
    private Connection nativeConnection;
    private BufferManager bufferManager;
    private SyncWriter syncWriter;
    private boolean basicSupportsUncommitedRead;
    private HashSet openStatements = new HashSet();
    private boolean isClosed = false;
    private int transactionState = 0;
    private int deferredAction = 0;
    private boolean autoCommit;
    private int isolationLevel;
    private boolean tooManyStatements = false;
    static /* synthetic */ Class class$com$sap$sql$jdbc$common$CommonConnectionImpl;

    CommonConnectionImpl(CommonConnectionContext connectionContext) throws SQLException {
        this(null, connectionContext);
    }

    CommonConnectionImpl(CommonPooledConnection pooledConnection, CommonConnectionContext connectionContext) throws SQLException {
        this.pooledConnection = pooledConnection;
        this.connectionContext = connectionContext;
        this.nativeConnection = connectionContext.getWrappedConnection();
        this.bufferManager = connectionContext.getBufferManager();
        this.syncWriter = connectionContext.getSyncWriter();
        this.basicSupportsUncommitedRead = pooledConnection != null ? pooledConnection.supportsUncommitedRead() : this.nativeConnection.getMetaData().supportsTransactionIsolationLevel(1);
        this.setTransactionIsolation(1);
        this.setAutoCommit(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Statement createStatement() throws SQLException {
        CommonStatementImpl commonStatementImpl;
        if (TRACE.bePath()) {
            TRACE.entering("createStatement()");
        }
        try {
            this.validate();
            CommonStatementImpl stmt = new CommonStatementImpl(this.connectionContext);
            this.openStatements.add(stmt);
            this.checkStatementNumber();
            commonStatementImpl = stmt;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!TRACE.bePath()) throw throwable;
            TRACE.exiting();
            throw throwable;
        }
        if (!TRACE.bePath()) return commonStatementImpl;
        TRACE.exiting();
        return commonStatementImpl;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        CommonPreparedStatement ps = null;
        if (TRACE.bePath()) {
            TRACE.entering("prepareStatement(String)", new Object[]{sql});
        }
        try {
            this.validate();
            if (null == sql) {
                throw new SAPIllegalArgumentException("com.sap.exception.standard_0001", new Object[]{"sql"});
            }
            ps = new CommonPreparedStatement(this.connectionContext, sql, new SQLTraceContext());
            this.openStatements.add(ps);
            this.checkStatementNumber();
            Object var4_3 = null;
            this.setActiveTransactionStateMin();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.setActiveTransactionStateMin();
            if (TRACE.bePath()) {
                TRACE.exiting(ps);
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting((Object)ps);
        }
        return ps;
    }

    public PreparedStatement prepareStatement(SQLStatement tree) throws SQLException {
        CommonPreparedStatement ps = null;
        if (TRACE.bePath()) {
            TRACE.entering("prepareStatement(SQLStatement)");
        }
        try {
            this.validate();
            ps = new CommonPreparedStatement(this.connectionContext, tree);
            this.openStatements.add(ps);
            this.checkStatementNumber();
            Object var4_3 = null;
            this.setActiveTransactionStateMin();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.setActiveTransactionStateMin();
            if (TRACE.bePath()) {
                TRACE.exiting((Object)ps);
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting((Object)ps);
        }
        return ps;
    }

    public PreparedStatement prepareStatement(SQLStatement tree, String source, int line, long timestamp) throws SQLException {
        CommonPreparedStatement ps = null;
        if (TRACE.bePath()) {
            TRACE.entering("prepareStatement(SQLStatement, String, int, long)");
        }
        try {
            this.validate();
            tree.setTraceContext(new SQLTraceContext(timestamp, source, line));
            ps = new CommonPreparedStatement(this.connectionContext, tree);
            this.openStatements.add(ps);
            this.checkStatementNumber();
            Object var8_6 = null;
            this.setActiveTransactionStateMin();
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.setActiveTransactionStateMin();
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
        return ps;
    }

    public PreparedStatement prepareStatement(String sql, String source, int line, long timestamp) throws SQLException {
        CommonPreparedStatement ps = null;
        if (TRACE.bePath()) {
            TRACE.entering("prepareStatement(String, String, int, long)");
        }
        try {
            this.validate();
            ps = new CommonPreparedStatement(this.connectionContext, sql, new SQLTraceContext(timestamp, source, line));
            this.openStatements.add(ps);
            this.checkStatementNumber();
            Object var8_6 = null;
            this.setActiveTransactionStateMin();
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.setActiveTransactionStateMin();
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
        return ps;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clearWarnings() throws SQLException {
        block5: {
            block4: {
                if (TRACE.bePath()) {
                    TRACE.entering("clearWarnings()");
                }
                try {
                    if (this.isClosed) {
                        Object var2_1 = null;
                        break block4;
                    }
                    this.nativeConnection.clearWarnings();
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    if (!TRACE.bePath()) throw throwable;
                    TRACE.exiting();
                    throw throwable;
                }
            }
            if (!TRACE.bePath()) return;
            TRACE.exiting();
            return;
        }
        Object var2_2 = null;
        if (!TRACE.bePath()) return;
        TRACE.exiting();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws SQLException {
        boolean release;
        block19: {
            block17: {
                block18: {
                    release = false;
                    if (TRACE.bePath()) {
                        TRACE.entering("close()");
                    }
                    try {
                        if (this.isClosed) {
                            Object var5_2 = null;
                            if (this.isClosed || this.connectionContext.getState() != 0) break block17;
                            break block18;
                        }
                        if (!this.connectionContext.getAutoCommit()) {
                            try {
                                switch (this.transactionState) {
                                    case 4: {
                                        this.rollback();
                                        break;
                                    }
                                    case 3: {
                                        this.commit();
                                        break;
                                    }
                                }
                            }
                            catch (SQLException ex) {
                                Syslog.logSQLException(this, ex);
                            }
                        }
                        Iterator iter = this.openStatements.iterator();
                        while (true) {
                            if (!iter.hasNext()) {
                                if (this.pooledConnection == null) break;
                                this.pooledConnection.connectionClosed();
                                this.pooledConnection = null;
                                break block19;
                            }
                            try {
                                ((AbstractCommonStatement)iter.next()).close(false);
                            }
                            catch (SQLException ex) {
                                Syslog.logSQLException(this, ex);
                            }
                        }
                        release = true;
                        this.nativeConnection.close();
                        break block19;
                    }
                    catch (Throwable throwable) {
                        Object var5_4 = null;
                        if (!this.isClosed && this.connectionContext.getState() == 0) {
                            CommonContextFactory.closeCommonConnectionContext(this.connectionContext, release);
                            this.openStatements.clear();
                            this.bufferManager = null;
                            this.connectionContext = null;
                            this.nativeConnection = null;
                            this.openStatements = null;
                            this.syncWriter = null;
                        }
                        this.isClosed = true;
                        if (!TRACE.bePath()) throw throwable;
                        TRACE.exiting();
                        throw throwable;
                    }
                }
                CommonContextFactory.closeCommonConnectionContext(this.connectionContext, release);
                this.openStatements.clear();
                this.bufferManager = null;
                this.connectionContext = null;
                this.nativeConnection = null;
                this.openStatements = null;
                this.syncWriter = null;
            }
            this.isClosed = true;
            if (!TRACE.bePath()) return;
            TRACE.exiting();
            return;
        }
        Object var5_3 = null;
        if (!this.isClosed && this.connectionContext.getState() == 0) {
            CommonContextFactory.closeCommonConnectionContext(this.connectionContext, release);
            this.openStatements.clear();
            this.bufferManager = null;
            this.connectionContext = null;
            this.nativeConnection = null;
            this.openStatements = null;
            this.syncWriter = null;
        }
        this.isClosed = true;
        if (!TRACE.bePath()) return;
        TRACE.exiting();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commit() throws SQLException {
        block13: {
            block12: {
                if (TRACE.bePath()) {
                    TRACE.entering("commit()");
                }
                try {
                    this.validate();
                    if (this.connectionContext.getAutoCommit()) {
                        throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.jdbc.common_1134", new Object[]{"commit()"});
                    }
                    if (this.transactionState <= 2) {
                        Object var4_1 = null;
                        this.closeResultSets();
                        this.transactionState = 0;
                        break block12;
                    }
                    if (this.syncWriter != null) {
                        try {
                            this.syncWriter.flushRequests();
                        }
                        catch (SQLException syncEx) {
                            this.bufferManager.rollback();
                            try {
                                this.nativeConnection.rollback();
                                throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.sync_1025", null, (Throwable)syncEx);
                            }
                            catch (SQLException sqlEx) {
                                Syslog.logSQLException(this, sqlEx, this.connectionContext.getConnectionID(), "rollback");
                            }
                            throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.sync_1025", null, (Throwable)syncEx);
                        }
                    }
                    try {
                        this.nativeConnection.commit();
                    }
                    catch (SQLException ex) {
                        this.bufferManager.rollback();
                        throw ex;
                    }
                    this.bufferManager.commit();
                    break block13;
                }
                catch (Throwable throwable) {
                    Object var4_3 = null;
                    this.closeResultSets();
                    this.transactionState = 0;
                    if (!TRACE.bePath()) throw throwable;
                    TRACE.exiting();
                    throw throwable;
                }
            }
            if (!TRACE.bePath()) return;
            TRACE.exiting();
            return;
        }
        Object var4_2 = null;
        this.closeResultSets();
        this.transactionState = 0;
        if (!TRACE.bePath()) return;
        TRACE.exiting();
    }

    public boolean getAutoCommit() throws SQLException {
        this.validateDeferredAction();
        return (this.deferredAction & 1) > 0 ? this.autoCommit : this.connectionContext.getAutoCommit();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.validate();
        return this.nativeConnection.getWarnings();
    }

    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rollback() throws SQLException {
        block9: {
            block8: {
                if (TRACE.bePath()) {
                    TRACE.entering("rollback()");
                }
                try {
                    this.validate();
                    if (this.connectionContext.getAutoCommit()) {
                        throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.jdbc.common_1134", new Object[]{"rollback()"});
                    }
                    if (this.transactionState <= 2) {
                        Object var2_1 = null;
                        this.closeResultSets();
                        this.transactionState = 0;
                        break block8;
                    }
                    if (this.syncWriter != null) {
                        this.syncWriter.undoRequests();
                    }
                    this.bufferManager.rollback();
                    if (this.transactionState == 4) {
                        this.nativeConnection.rollback();
                        break block9;
                    } else {
                        this.nativeConnection.commit();
                    }
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    this.closeResultSets();
                    this.transactionState = 0;
                    if (!TRACE.bePath()) throw throwable;
                    TRACE.exiting();
                    throw throwable;
                }
            }
            if (!TRACE.bePath()) return;
            TRACE.exiting();
            return;
        }
        Object var2_2 = null;
        this.closeResultSets();
        this.transactionState = 0;
        if (!TRACE.bePath()) return;
        TRACE.exiting();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setAutoCommit(boolean enableAutoCommit) throws SQLException {
        block8: {
            block7: {
                block6: {
                    if (TRACE.bePath()) {
                        TRACE.entering("setAutoCommit(boolean)", new Object[]{new Boolean(enableAutoCommit)});
                    }
                    try {
                        this.validateDeferredAction();
                        if (this.transactionState == 0) {
                            this.autoCommit = enableAutoCommit;
                            this.deferredAction |= 1;
                            Object var3_2 = null;
                            break block6;
                        }
                        if (enableAutoCommit == this.connectionContext.getAutoCommit()) {
                            break block7;
                        }
                        if (this.transactionState > 2 && enableAutoCommit) {
                            this.commit();
                        }
                        this.nativeConnection.setAutoCommit(enableAutoCommit);
                        this.connectionContext.setAutoCommit(enableAutoCommit);
                        break block8;
                    }
                    catch (Throwable throwable) {
                        Object var3_5 = null;
                        if (!TRACE.bePath()) throw throwable;
                        TRACE.exiting();
                        throw throwable;
                    }
                }
                if (!TRACE.bePath()) return;
                TRACE.exiting();
                return;
            }
            Object var3_3 = null;
            if (!TRACE.bePath()) return;
            TRACE.exiting();
            return;
        }
        Object var3_4 = null;
        if (!TRACE.bePath()) return;
        TRACE.exiting();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setTransactionIsolation(int level) throws SQLException {
        block10: {
            block9: {
                block8: {
                    if (TRACE.bePath()) {
                        TRACE.entering("setTransactionIsolation(int)", new Object[]{new Integer(level)});
                    }
                    try {
                        this.validateDeferredAction();
                        if (level != 1 && level != 2) {
                            throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.jdbc.common_1128", new Object[]{new Integer(level), new Integer(1), new Integer(2)});
                        }
                        if (this.transactionState == 0) {
                            this.isolationLevel = level;
                            this.deferredAction |= 2;
                            Object var3_2 = null;
                            break block8;
                        }
                        if (this.transactionState >= 2) {
                            throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.jdbc.common_1129", null);
                        }
                        if (level == this.connectionContext.getTransactionIsolation()) {
                            break block9;
                        }
                        if (level == 2 || this.basicSupportsUncommitedRead) {
                            this.nativeConnection.setTransactionIsolation(level);
                        }
                        this.connectionContext.setTransactionIsolation(level);
                        break block10;
                    }
                    catch (Throwable throwable) {
                        Object var3_5 = null;
                        if (!TRACE.bePath()) throw throwable;
                        TRACE.exiting();
                        throw throwable;
                    }
                }
                if (!TRACE.bePath()) return;
                TRACE.exiting();
                return;
            }
            Object var3_3 = null;
            if (!TRACE.bePath()) return;
            TRACE.exiting();
            return;
        }
        Object var3_4 = null;
        if (!TRACE.bePath()) return;
        TRACE.exiting();
    }

    public int getTransactionIsolation() throws SQLException {
        this.validateDeferredAction();
        return (this.deferredAction & 2) > 0 ? this.isolationLevel : this.connectionContext.getTransactionIsolation();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.validate();
        return new CommonDatabaseMetaData(this);
    }

    public String nativeSQL(String query) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "nativeSQL");
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "setReadOnly");
    }

    public boolean isReadOnly() throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "isReadOnly");
    }

    public void setCatalog(String catalog) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "setCatalog");
    }

    public String getCatalog() throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "getCatalog");
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "createStatement");
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "createStatement");
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "prepareCall");
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "prepareCall");
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "prepareCall");
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "prepareStatement");
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "prepareStatement");
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "prepareStatement");
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "prepareStatement");
    }

    public PreparedStatement prepareStatement(String sql, String[] ColumnNames) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "prepareStatement");
    }

    public int getHoldability() throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "getHoldability");
    }

    public void setHoldability() throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "setHoldability");
    }

    public void setSavepoint() throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "setSavepoint");
    }

    public void setSavepoint(String name) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "setSavepoint");
    }

    public Map getTypeMap() throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "getTypeMap");
    }

    public void setTypeMap(Map map) throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "setTypeMap");
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public CommonConnectionContext getCommonConnectionContext() {
        return this.connectionContext;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Statement createDirectStatement() throws SQLException {
        Statement statement;
        if (TRACE.bePath()) {
            TRACE.entering("createDirectStatement()");
        }
        try {
            this.validate();
            this.setActiveTransactionStateMax();
            statement = this.nativeConnection.createStatement();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!TRACE.bePath()) throw throwable;
            TRACE.exiting();
            throw throwable;
        }
        if (!TRACE.bePath()) return statement;
        TRACE.exiting();
        return statement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Statement createDirectStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        Statement statement;
        if (TRACE.bePath()) {
            TRACE.entering("createDirectStatement(int, int)", new Object[]{new Integer(resultSetType), new Integer(resultSetConcurrency)});
        }
        try {
            this.validate();
            this.setActiveTransactionStateMax();
            statement = this.nativeConnection.createStatement(resultSetType, resultSetConcurrency);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!TRACE.bePath()) throw throwable;
            TRACE.exiting();
            throw throwable;
        }
        if (!TRACE.bePath()) return statement;
        TRACE.exiting();
        return statement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PreparedStatement prepareDirectStatement(String sql) throws SQLException {
        PreparedStatement preparedStatement;
        if (TRACE.bePath()) {
            TRACE.entering("prepareDirectStatement(String)", new Object[]{sql});
        }
        try {
            this.validate();
            this.setActiveTransactionStateMax();
            preparedStatement = this.nativeConnection.prepareStatement(sql);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!TRACE.bePath()) throw throwable;
            TRACE.exiting();
            throw throwable;
        }
        if (!TRACE.bePath()) return preparedStatement;
        TRACE.exiting();
        return preparedStatement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PreparedStatement prepareDirectStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement preparedStatement;
        if (TRACE.bePath()) {
            TRACE.entering("prepareDirectStatement(String, int, int)", new Object[]{sql, new Integer(resultSetType), new Integer(resultSetConcurrency)});
        }
        try {
            this.validate();
            this.setActiveTransactionStateMax();
            preparedStatement = this.nativeConnection.prepareStatement(sql, resultSetType, resultSetConcurrency);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (!TRACE.bePath()) throw throwable;
            TRACE.exiting();
            throw throwable;
        }
        if (!TRACE.bePath()) return preparedStatement;
        TRACE.exiting();
        return preparedStatement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CallableStatement prepareDirectCall(String sql) throws SQLException {
        CallableStatement callableStatement;
        if (TRACE.bePath()) {
            TRACE.entering("prepareDirectCall(String)", new Object[]{sql});
        }
        try {
            this.validate();
            this.setActiveTransactionStateMax();
            callableStatement = this.nativeConnection.prepareCall(sql);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!TRACE.bePath()) throw throwable;
            TRACE.exiting();
            throw throwable;
        }
        if (!TRACE.bePath()) return callableStatement;
        TRACE.exiting();
        return callableStatement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CallableStatement prepareDirectCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        CallableStatement callableStatement;
        if (TRACE.bePath()) {
            TRACE.entering("prepareDirectCall(String, int, int)", new Object[]{sql, new Integer(resultSetType), new Integer(resultSetConcurrency)});
        }
        try {
            this.validate();
            this.setActiveTransactionStateMax();
            callableStatement = this.nativeConnection.prepareCall(sql, resultSetType, resultSetConcurrency);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (!TRACE.bePath()) throw throwable;
            TRACE.exiting();
            throw throwable;
        }
        if (!TRACE.bePath()) return callableStatement;
        TRACE.exiting();
        return callableStatement;
    }

    public SQLStatement preprepareStatement(String sql) throws SQLException {
        throw new UnsupportedOperationException("deprecated!");
    }

    public SQLStatement preprepareStatement(String sql, String source, int line, long generationTimeMillis) throws SQLException {
        throw new UnsupportedOperationException("deprecated!");
    }

    public SQLStatement preprepareStatement(SQLStatement tree) throws SQLException {
        throw new UnsupportedOperationException("deprecated!");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DatabaseMetaData getDirectMetaData() throws SQLException {
        DatabaseMetaData databaseMetaData;
        if (TRACE.bePath()) {
            TRACE.entering("getDirectMetaData()");
        }
        try {
            this.validate();
            this.setActiveTransactionStateMax();
            databaseMetaData = this.nativeConnection.getMetaData();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!TRACE.bePath()) throw throwable;
            TRACE.exiting();
            throw throwable;
        }
        if (!TRACE.bePath()) return databaseMetaData;
        TRACE.exiting();
        return databaseMetaData;
    }

    public CatalogReader getCatalogReader() throws SQLException {
        this.validate();
        return this.connectionContext.getCatalogReader();
    }

    public Object getServiceContext() throws SQLException {
        this.validate();
        return this.connectionContext;
    }

    public Object getSqljConnectionContext(SQLStatement stmt) {
        throw new UnsupportedOperationException("deprecated!");
    }

    public void setActiveTransactionStateMax() {
        this.transactionState = 4;
    }

    public void setActiveTransactionStateMin() {
        if (this.transactionState < 2) {
            this.transactionState = 2;
        }
    }

    public void setActiveTransactionState(int statementType, int transactionIsolation) {
        int state = 0;
        switch (statementType) {
            case 4: 
            case 8: 
            case 16: {
                state = 4;
                break;
            }
            case 32: {
                state = 3;
                break;
            }
            case 2: {
                int isolation = transactionIsolation > 0 ? transactionIsolation : this.connectionContext.getTransactionIsolation();
                int n = state = this.connectionContext.getDbPortingServices().selectAllocatesResources(isolation) ? 3 : 2;
            }
        }
        if (state > this.transactionState) {
            this.transactionState = state;
        }
    }

    void statementClosed(Statement statement) {
        this.openStatements.remove(statement);
    }

    void closeResultSets() {
        Iterator iter = this.openStatements.iterator();
        while (iter.hasNext()) {
            try {
                ((AbstractCommonStatement)iter.next()).closeResultSet();
            }
            catch (SQLException ex) {
                Syslog.logSQLException(this, ex);
            }
        }
    }

    private void validate() throws SQLException {
        if (this.isClosed) {
            throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql_0004", new Object[]{this});
        }
        if (this.transactionState == 0) {
            this.transactionState = 1;
            if ((this.deferredAction & 1) > 0) {
                this.setAutoCommit(this.autoCommit);
            }
            if ((this.deferredAction & 2) > 0) {
                this.setTransactionIsolation(this.isolationLevel);
            }
            this.deferredAction = 0;
        }
    }

    private void validateDeferredAction() throws SQLException {
        if (this.isClosed) {
            throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql_0004", new Object[]{this});
        }
    }

    private void checkStatementNumber() {
        if (this.openStatements.size() == 100 && !this.tooManyStatements) {
            Syslog.logError(this, "com.sap.sql.jdbc.common_1144", null);
            int i = 0;
            Iterator iter = this.openStatements.iterator();
            while (iter.hasNext()) {
                AbstractCommonStatement stmt = (AbstractCommonStatement)iter.next();
                String stmtType = stmt instanceof PreparedStatement ? "PreparedStatement" : "Statement";
                String stmtString = stmt.getStatementString();
                if (stmtString == null) {
                    stmtString = "NULL";
                }
                Syslog.logError(this, "com.sap.sql.jdbc.common_1145", new Object[]{new Integer(++i), stmtType, stmtString});
            }
            this.tooManyStatements = true;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

