/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.basic;

import com.sap.sql.jdbc.basic.BasicJdbcObjectFactory;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class BasicStatement
implements Statement {
    protected Connection dConn;
    protected Statement stmt;
    protected String sql;
    protected BasicJdbcObjectFactory factory;
    protected ResultSet result;
    protected int updateCount;

    public BasicStatement(BasicJdbcObjectFactory aFactory, Connection dConn, Statement stmt) {
        this.stmt = stmt;
        this.dConn = dConn;
        this.factory = aFactory;
        this.result = null;
        this.updateCount = -1;
    }

    public int executeUpdate(String sql) throws SQLException {
        this.result = null;
        this.updateCount = this.stmt.executeUpdate(sql);
        return this.updateCount;
    }

    public void close() throws SQLException {
        this.stmt.close();
    }

    public int getMaxFieldSize() throws SQLException {
        return this.stmt.getMaxFieldSize();
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.stmt.setMaxFieldSize(max);
    }

    public int getMaxRows() throws SQLException {
        return this.stmt.getMaxRows();
    }

    public void setMaxRows(int max) throws SQLException {
        this.stmt.setMaxRows(max);
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.stmt.setEscapeProcessing(enable);
    }

    public int getQueryTimeout() throws SQLException {
        return this.stmt.getQueryTimeout();
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.stmt.setQueryTimeout(seconds);
    }

    public void cancel() throws SQLException {
        this.stmt.cancel();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.stmt.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.stmt.clearWarnings();
    }

    public void setCursorName(String name) throws SQLException {
        this.stmt.setCursorName(name);
    }

    public boolean execute(String sql) throws SQLException {
        this.updateCount = -1;
        this.result = null;
        if (this.stmt.execute(sql)) {
            this.result = this.factory.createResultSet(this, this.stmt.getResultSet());
            return true;
        }
        this.updateCount = this.stmt.getUpdateCount();
        return false;
    }

    public int getUpdateCount() throws SQLException {
        return this.updateCount;
    }

    public boolean getMoreResults() throws SQLException {
        this.updateCount = -1;
        this.result = null;
        if (this.stmt.getMoreResults()) {
            this.result = this.factory.createResultSet(this, this.stmt.getResultSet());
            return true;
        }
        this.updateCount = this.stmt.getUpdateCount();
        return false;
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.stmt.setFetchDirection(direction);
    }

    public int getFetchDirection() throws SQLException {
        return this.stmt.getFetchDirection();
    }

    public void setFetchSize(int rows) throws SQLException {
        this.stmt.setFetchSize(rows);
    }

    public int getFetchSize() throws SQLException {
        return this.stmt.getFetchSize();
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.stmt.getResultSetConcurrency();
    }

    public int getResultSetType() throws SQLException {
        return this.stmt.getResultSetType();
    }

    public void addBatch(String sql) throws SQLException {
        this.stmt.addBatch(sql);
    }

    public void clearBatch() throws SQLException {
        this.stmt.clearBatch();
    }

    public int[] executeBatch() throws SQLException {
        return this.stmt.executeBatch();
    }

    public Connection getConnection() throws SQLException {
        return this.dConn;
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        this.updateCount = -1;
        this.result = this.factory.createResultSet(this, this.stmt.executeQuery(sql));
        return this.result;
    }

    public ResultSet getResultSet() throws SQLException {
        return this.result;
    }
}

