/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.basic;

import com.sap.sql.jdbc.basic.BasicJdbcObjectFactory;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class BasicResultSet
implements ResultSet {
    protected Statement mystatement;
    protected ResultSet resultSet;
    protected BasicJdbcObjectFactory factory;

    public BasicResultSet(BasicJdbcObjectFactory aFactory, Statement statement, ResultSet resultSet) throws SQLException {
        this.mystatement = statement;
        this.factory = aFactory;
        this.resultSet = resultSet;
    }

    public BasicResultSet(BasicJdbcObjectFactory aFactory, ResultSet resultSet) throws SQLException {
        this(aFactory, null, resultSet);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.factory.createResultSetMetaData(this, this.resultSet.getMetaData());
    }

    public boolean next() throws SQLException {
        return this.resultSet.next();
    }

    public void close() throws SQLException {
        this.resultSet.close();
    }

    public boolean wasNull() throws SQLException {
        return this.resultSet.wasNull();
    }

    public String getString(int columnIndex) throws SQLException {
        return this.resultSet.getString(columnIndex);
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.resultSet.getBoolean(columnIndex);
    }

    public byte getByte(int columnIndex) throws SQLException {
        return this.resultSet.getByte(columnIndex);
    }

    public short getShort(int columnIndex) throws SQLException {
        return this.resultSet.getShort(columnIndex);
    }

    public int getInt(int columnIndex) throws SQLException {
        return this.resultSet.getInt(columnIndex);
    }

    public long getLong(int columnIndex) throws SQLException {
        return this.resultSet.getLong(columnIndex);
    }

    public float getFloat(int columnIndex) throws SQLException {
        return this.resultSet.getFloat(columnIndex);
    }

    public double getDouble(int columnIndex) throws SQLException {
        return this.resultSet.getDouble(columnIndex);
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.resultSet.getBigDecimal(columnIndex, scale);
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.resultSet.getBytes(columnIndex);
    }

    public Date getDate(int columnIndex) throws SQLException {
        return this.resultSet.getDate(columnIndex);
    }

    public Time getTime(int columnIndex) throws SQLException {
        return this.resultSet.getTime(columnIndex);
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.resultSet.getTimestamp(columnIndex);
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.resultSet.getAsciiStream(columnIndex);
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return this.resultSet.getUnicodeStream(columnIndex);
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return this.resultSet.getBinaryStream(columnIndex);
    }

    public String getString(String columnName) throws SQLException {
        return this.resultSet.getString(columnName);
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return this.resultSet.getBoolean(columnName);
    }

    public byte getByte(String columnName) throws SQLException {
        return this.resultSet.getByte(columnName);
    }

    public short getShort(String columnName) throws SQLException {
        return this.resultSet.getShort(columnName);
    }

    public int getInt(String columnName) throws SQLException {
        return this.resultSet.getInt(columnName);
    }

    public long getLong(String columnName) throws SQLException {
        return this.resultSet.getLong(columnName);
    }

    public float getFloat(String columnName) throws SQLException {
        return this.resultSet.getFloat(columnName);
    }

    public double getDouble(String columnName) throws SQLException {
        return this.resultSet.getDouble(columnName);
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.resultSet.getBigDecimal(columnName, scale);
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return this.resultSet.getBytes(columnName);
    }

    public Date getDate(String columnName) throws SQLException {
        return this.resultSet.getDate(columnName);
    }

    public Time getTime(String columnName) throws SQLException {
        return this.resultSet.getTime(columnName);
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.resultSet.getTimestamp(columnName);
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.resultSet.getAsciiStream(columnName);
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.resultSet.getUnicodeStream(columnName);
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.resultSet.getBinaryStream(columnName);
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.resultSet.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.resultSet.clearWarnings();
    }

    public String getCursorName() throws SQLException {
        return this.resultSet.getCursorName();
    }

    public Object getObject(int columnIndex) throws SQLException {
        return this.resultSet.getObject(columnIndex);
    }

    public Object getObject(String columnName) throws SQLException {
        return this.resultSet.getObject(columnName);
    }

    public int findColumn(String columnName) throws SQLException {
        return this.resultSet.findColumn(columnName);
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return this.resultSet.getCharacterStream(columnIndex);
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.resultSet.getCharacterStream(columnName);
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.resultSet.getBigDecimal(columnIndex);
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.resultSet.getBigDecimal(columnName);
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.resultSet.isBeforeFirst();
    }

    public boolean isAfterLast() throws SQLException {
        return this.resultSet.isAfterLast();
    }

    public boolean isFirst() throws SQLException {
        return this.resultSet.isFirst();
    }

    public boolean isLast() throws SQLException {
        return this.resultSet.isLast();
    }

    public void beforeFirst() throws SQLException {
        this.resultSet.beforeFirst();
    }

    public void afterLast() throws SQLException {
        this.resultSet.afterLast();
    }

    public boolean first() throws SQLException {
        return this.resultSet.first();
    }

    public boolean last() throws SQLException {
        return this.resultSet.last();
    }

    public int getRow() throws SQLException {
        return this.resultSet.getRow();
    }

    public boolean absolute(int row) throws SQLException {
        return this.resultSet.absolute(row);
    }

    public boolean relative(int rows) throws SQLException {
        return this.resultSet.relative(rows);
    }

    public boolean previous() throws SQLException {
        return this.resultSet.previous();
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.resultSet.setFetchDirection(direction);
    }

    public int getFetchDirection() throws SQLException {
        return this.resultSet.getFetchDirection();
    }

    public void setFetchSize(int rows) throws SQLException {
        this.resultSet.setFetchSize(rows);
    }

    public int getFetchSize() throws SQLException {
        return this.resultSet.getFetchSize();
    }

    public int getType() throws SQLException {
        return this.resultSet.getType();
    }

    public int getConcurrency() throws SQLException {
        return this.resultSet.getConcurrency();
    }

    public boolean rowUpdated() throws SQLException {
        return this.resultSet.rowUpdated();
    }

    public boolean rowInserted() throws SQLException {
        return this.resultSet.rowInserted();
    }

    public boolean rowDeleted() throws SQLException {
        return this.resultSet.rowDeleted();
    }

    public void updateNull(int columnIndex) throws SQLException {
        this.resultSet.updateNull(columnIndex);
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.resultSet.updateBoolean(columnIndex, x);
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.resultSet.updateByte(columnIndex, x);
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        this.resultSet.updateShort(columnIndex, x);
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        this.resultSet.updateInt(columnIndex, x);
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        this.resultSet.updateLong(columnIndex, x);
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.resultSet.updateFloat(columnIndex, x);
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.resultSet.updateDouble(columnIndex, x);
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.resultSet.updateBigDecimal(columnIndex, x);
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        this.resultSet.updateString(columnIndex, x);
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.resultSet.updateBytes(columnIndex, x);
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.resultSet.updateDate(columnIndex, x);
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.resultSet.updateTime(columnIndex, x);
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.resultSet.updateTimestamp(columnIndex, x);
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.resultSet.updateAsciiStream(columnIndex, x, length);
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.resultSet.updateBinaryStream(columnIndex, x, length);
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.resultSet.updateCharacterStream(columnIndex, x, length);
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.resultSet.updateObject(columnIndex, x, scale);
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.resultSet.updateObject(columnIndex, x);
    }

    public void updateNull(String columnName) throws SQLException {
        this.resultSet.updateNull(columnName);
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.resultSet.updateBoolean(columnName, x);
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        this.resultSet.updateByte(columnName, x);
    }

    public void updateShort(String columnName, short x) throws SQLException {
        this.resultSet.updateShort(columnName, x);
    }

    public void updateInt(String columnName, int x) throws SQLException {
        this.resultSet.updateInt(columnName, x);
    }

    public void updateLong(String columnName, long x) throws SQLException {
        this.resultSet.updateLong(columnName, x);
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        this.resultSet.updateFloat(columnName, x);
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        this.resultSet.updateDouble(columnName, x);
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.resultSet.updateBigDecimal(columnName, x);
    }

    public void updateString(String columnName, String x) throws SQLException {
        this.resultSet.updateString(columnName, x);
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.resultSet.updateBytes(columnName, x);
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        this.resultSet.updateDate(columnName, x);
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        this.resultSet.updateTime(columnName, x);
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.resultSet.updateTimestamp(columnName, x);
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.resultSet.updateAsciiStream(columnName, x, length);
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.resultSet.updateBinaryStream(columnName, x, length);
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.resultSet.updateCharacterStream(columnName, reader, length);
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.resultSet.updateObject(columnName, x, scale);
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        this.resultSet.updateObject(columnName, x);
    }

    public void insertRow() throws SQLException {
        this.resultSet.insertRow();
    }

    public void updateRow() throws SQLException {
        this.resultSet.updateRow();
    }

    public void deleteRow() throws SQLException {
        this.resultSet.deleteRow();
    }

    public void refreshRow() throws SQLException {
        this.resultSet.refreshRow();
    }

    public void cancelRowUpdates() throws SQLException {
        this.resultSet.cancelRowUpdates();
    }

    public void moveToInsertRow() throws SQLException {
        this.resultSet.moveToInsertRow();
    }

    public void moveToCurrentRow() throws SQLException {
        this.resultSet.moveToCurrentRow();
    }

    public Statement getStatement() throws SQLException {
        return this.mystatement;
    }

    public Object getObject(int i, Map map) throws SQLException {
        return this.resultSet.getObject(i, map);
    }

    public Ref getRef(int i) throws SQLException {
        return this.resultSet.getRef(i);
    }

    public Blob getBlob(int i) throws SQLException {
        return this.factory.createBlob(this, this.resultSet.getBlob(i));
    }

    public Clob getClob(int i) throws SQLException {
        return this.factory.createClob(this, this.resultSet.getClob(i));
    }

    public Array getArray(int i) throws SQLException {
        return this.resultSet.getArray(i);
    }

    public Object getObject(String colName, Map map) throws SQLException {
        return this.resultSet.getObject(colName, map);
    }

    public Ref getRef(String colName) throws SQLException {
        return this.resultSet.getRef(colName);
    }

    public Blob getBlob(String colName) throws SQLException {
        return this.factory.createBlob(this, this.resultSet.getBlob(colName));
    }

    public Clob getClob(String colName) throws SQLException {
        return this.factory.createClob(this, this.resultSet.getClob(colName));
    }

    public Array getArray(String colName) throws SQLException {
        return this.resultSet.getArray(colName);
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.resultSet.getDate(columnIndex, cal);
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.resultSet.getDate(columnName, cal);
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.resultSet.getTime(columnIndex, cal);
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.resultSet.getTime(columnName, cal);
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.resultSet.getTimestamp(columnIndex, cal);
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.resultSet.getTimestamp(columnName, cal);
    }
}

