/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.basic;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public abstract class BasicDbPortingServices {
    public static final int VENDOR_UNKNOWN = -1;
    public static final int VENDOR_DB2_UDB = 0;
    public static final int VENDOR_DB2_UDB_AS400 = 1;
    public static final int VENDOR_DB2_UDB_OS390 = 2;
    public static final int VENDOR_INFORMIX = 3;
    public static final int VENDOR_MS_SQL_SERVER = 4;
    public static final int VENDOR_ORACLE = 5;
    public static final int VENDOR_SAPDB = 6;
    protected final Calendar utcCalendar = Calendar.getInstance(TimeZone.getTimeZone("Etc/UTC"));
    private final int timeZoneOffset = Calendar.getInstance().get(15);
    protected Connection connection;

    public BasicDbPortingServices(Connection connection) {
        this.connection = connection;
    }

    public abstract String getConnectionID() throws SQLException;

    public abstract Timestamp getUTCTimestamp() throws SQLException;

    protected Timestamp adjustUTCTimestamp(Timestamp timestamp) {
        Timestamp ts = new Timestamp(((Date)timestamp).getTime() + (long)this.timeZoneOffset);
        ts.setNanos(timestamp.getNanos());
        return ts;
    }

    public String getDatabaseProductName() throws SQLException {
        return this.connection.getMetaData().getDatabaseProductName();
    }

    public String getDatabaseProductVersion() throws SQLException {
        return this.connection.getMetaData().getDatabaseProductVersion();
    }

    public String getUserName() throws SQLException {
        return this.connection.getMetaData().getUserName();
    }

    public String getSchemaName() throws SQLException {
        return null;
    }

    public String getDatabaseName() throws SQLException {
        return null;
    }

    public String getDatabaseHost() throws SQLException {
        return null;
    }

    public int getVendorID() {
        return -1;
    }

    public Boolean isDatabaseKernel64Bit() throws SQLException {
        return null;
    }

    public boolean selectAllocatesResources(int transactionIsolationLevel) {
        return false;
    }
}

