/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.dbcatalog;

import com.sap.sql.dbcatalog.DbCatalogExpert;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

public class InfCatalogExpert
implements DbCatalogExpert {
    private Connection conn = null;
    private DatabaseMetaData md = null;
    private PreparedStatement selUniqueIndexColumns1 = null;
    private PreparedStatement selUniqueIndexColumns1ByOwner = null;
    private PreparedStatement selUniqueIndexColumns2 = null;
    private PreparedStatement selUniqueIndexColumns2ByOwner = null;
    private PreparedStatement selUniqueIndexColumns3 = null;

    InfCatalogExpert(Connection conn, DatabaseMetaData md) throws SQLException {
        this.conn = conn;
        this.md = md;
        this.selUniqueIndexColumns1 = this.conn.prepareStatement("select st.tabid, si.idxname from systables st, sysindexes si where st.tabid = si.tabid and st.tabname = ? and si.idxtype = 'U' ");
        this.selUniqueIndexColumns1ByOwner = this.conn.prepareStatement("select st.tabid, si.idxname from systables st, sysindexes si where st.tabid = si.tabid and st.tabname = ? and st.owner = ? and si.idxtype = 'U' ");
        this.selUniqueIndexColumns2 = this.conn.prepareStatement("select part1, part2, part3, part4, part5, part6, part7, part8, part9, part10, part11, part12, part13, part14, part15, part16 from sysindexes where idxname = ?");
        this.selUniqueIndexColumns2ByOwner = this.conn.prepareStatement("select part1, part2, part3, part4, part5, part6, part7, part8, part9, part10, part11, part12, part13, part14, part15, part16 from sysindexes where idxname = ? and owner = ?");
        this.selUniqueIndexColumns3 = this.conn.prepareStatement("select colname from syscolumns where tabid = ? and colno = ?");
    }

    public String identifyUserSchema() throws SQLException {
        return null;
    }

    public int identifyTableType(String schemaName, String tableName) throws SQLException {
        int tableType = 0;
        ResultSet rs = this.md.getTables(null, schemaName, tableName, null);
        if (rs.next()) {
            String tableTypeStr = rs.getString("TABLE_TYPE");
            if (tableTypeStr.compareTo("TABLE") == 0) {
                tableType = 1;
            } else if (tableTypeStr.compareTo("VIEW") == 0) {
                tableType = 2;
            }
        }
        rs.close();
        return tableType;
    }

    public HashMap identifyPrimaryKeys(String schemaName, String tableName) throws SQLException {
        HashMap<String, Integer> pKeysMap = new HashMap<String, Integer>(20);
        ResultSet rs = this.md.getPrimaryKeys(null, schemaName, tableName);
        int i = 1;
        i = 1;
        while (rs.next()) {
            pKeysMap.put(rs.getString("COLUMN_NAME"), new Integer(i));
            ++i;
        }
        rs.close();
        if (i == 1) {
            PreparedStatement pstmt = schemaName == null ? this.selUniqueIndexColumns1 : this.selUniqueIndexColumns1ByOwner;
            pstmt.setString(1, tableName);
            if (schemaName != null) {
                pstmt.setString(2, schemaName);
            }
            rs = pstmt.executeQuery();
            int tabid = 0;
            String indexName = null;
            if (!rs.next()) {
                rs.close();
                return pKeysMap;
            }
            tabid = rs.getInt(1);
            indexName = rs.getString(2);
            rs.close();
            pstmt = schemaName == null ? this.selUniqueIndexColumns2 : this.selUniqueIndexColumns2ByOwner;
            pstmt.setString(1, indexName);
            if (schemaName != null) {
                pstmt.setString(2, schemaName);
            }
            if ((rs = pstmt.executeQuery()).next()) {
                int j = 1;
                while (j <= 16) {
                    int colNo = rs.getInt(j);
                    if (colNo == 0) break;
                    if (colNo < 0) {
                        colNo = -colNo;
                    }
                    this.selUniqueIndexColumns3.setInt(1, tabid);
                    this.selUniqueIndexColumns3.setInt(2, colNo);
                    ResultSet rsIntern = this.selUniqueIndexColumns3.executeQuery();
                    if (rsIntern.next()) {
                        pKeysMap.put(rsIntern.getString(1).trim(), new Integer(j));
                    }
                    rsIntern.close();
                    ++j;
                }
            }
            rs.close();
        }
        return pKeysMap;
    }

    public ResultSet identifyColumns(String schemaName, String tableName) throws SQLException {
        return this.md.getColumns(null, schemaName, tableName, null);
    }

    public int identifyJdbcType(int origJdbcType, String typeName, String schemaName, String tableName, String columnName) throws SQLException {
        switch (origJdbcType) {
            case -1: {
                if (!typeName.equals("text")) break;
                return 2005;
            }
            case -4: {
                if (!typeName.equals("byte")) break;
                return 2004;
            }
        }
        return origJdbcType;
    }

    public long identifySize(int jdbcType, String typeName, long origSize) {
        if (jdbcType == 2004 || jdbcType == 2005) {
            return 0L;
        }
        return origSize;
    }

    public int identifyDecimals(int jdbcType, int origDecimals) {
        if (jdbcType == 5 || jdbcType == 4 || jdbcType == 8) {
            return 0;
        }
        return origDecimals;
    }

    public boolean identifyRemoveLastColumn() {
        return false;
    }
}

