/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.connect.port;

import com.sap.sql.connect.port.Db2DataSourceInfo;
import com.sap.sql.connect.port.Db4DataSourceInfo;
import com.sap.sql.connect.port.Db6DataSourceInfo;
import com.sap.sql.connect.port.MssDataSourceInfo;
import com.sap.sql.connect.port.OracleDataSourceInfo;
import com.sap.sql.connect.port.SapdbDataSourceInfo;
import java.sql.SQLException;
import java.util.Properties;

public abstract class DataSourceInfo {
    public static final int VENDOR_DB2_UDB = 0;
    public static final int VENDOR_DB2_UDB_AS400 = 1;
    public static final int VENDOR_DB2_UDB_OS390 = 2;
    public static final int VENDOR_MS_SQL_SERVER = 4;
    public static final int VENDOR_ORACLE = 5;
    public static final int VENDOR_SAPDB = 6;
    public static final int DS_TYPE_STANDARD = 1;
    public static final int DS_TYPE_POOL = 2;
    public static final int DS_TYPE_XA = 3;

    public static final DataSourceInfo getInstance(int vendor) {
        switch (vendor) {
            case 0: {
                return Db6DataSourceInfo.getInstance();
            }
            case 1: {
                return Db4DataSourceInfo.getInstance();
            }
            case 2: {
                return Db2DataSourceInfo.getInstance();
            }
            case 4: {
                return MssDataSourceInfo.getInstance();
            }
            case 5: {
                return OracleDataSourceInfo.getInstance();
            }
            case 6: {
                return SapdbDataSourceInfo.getInstance();
            }
        }
        throw new IllegalArgumentException("Illegal input parameter: vendor");
    }

    public abstract String getDefaultDataSourceClassName(int var1) throws SQLException;

    public abstract Properties getMandatoryDataSourceProperties(int var1, String var2) throws SQLException;
}

