/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.catalog.impl;

import com.sap.sql.catalog.CatalogBufferManagerSpi;
import com.sap.sql.catalog.data.TableData;
import com.sap.sql.catalog.impl.CatalogBuffer;
import com.sap.sql.catalog.impl.CatalogBufferInfo;
import com.sap.sql.catalog.impl.CatalogBufferSynchronizer;
import com.sap.sql.catalog.monitor.CatalogBufferMonitor;
import com.sap.sql.catalog.monitor.CatalogBufferMonitorGlobalInfo;
import com.sap.sql.log.Syslog;
import com.sap.sql.sync.SyncManager;
import com.sap.sql.sync.SyncRecordOutputStream;
import com.sap.tc.logging.Location;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;

public class CatalogBufferManagerImpl
implements CatalogBufferManagerSpi,
CatalogBufferMonitor {
    private static final Location TRACE = Location.getLocation((Class)(class$com$sap$sql$catalog$impl$CatalogBufferManagerImpl == null ? (class$com$sap$sql$catalog$impl$CatalogBufferManagerImpl = CatalogBufferManagerImpl.class$("com.sap.sql.catalog.impl.CatalogBufferManagerImpl")) : class$com$sap$sql$catalog$impl$CatalogBufferManagerImpl));
    private static final String CATALOG_SYNC_PREFIX = "CATALOG?";
    private static Hashtable buffers = new Hashtable();
    static /* synthetic */ Class class$com$sap$sql$catalog$impl$CatalogBufferManagerImpl;

    public CatalogBufferManagerImpl() {
        TRACE.debugT("CatalogBufferManagerImpl", "new instance created.");
    }

    public static synchronized CatalogBuffer getCatalogBuffer(String id, int entryCount) {
        CatalogBuffer buffer = (CatalogBuffer)buffers.get(id);
        if (buffer == null) {
            buffer = new CatalogBuffer(id, entryCount);
            buffers.put(id, buffer);
            CatalogBufferSynchronizer synchronizer = new CatalogBufferSynchronizer(buffer);
            String syncId = CatalogBufferManagerImpl.getCatalogSyncID(id);
            buffer.setSynchronizer(synchronizer);
            buffer.setSyncId(syncId);
            SyncManager.getInstance().registerSender(syncId);
            SyncManager.getInstance().registerReceiver(syncId, synchronizer);
        }
        buffer.increaseReferenceCount();
        TRACE.debugT("getCatalogBuffer", "new reference to catalog buffer (id = " + id + ").");
        return buffer;
    }

    public static synchronized void releaseCatalogBuffer(String id) {
        CatalogBuffer buffer = (CatalogBuffer)buffers.get(id);
        if (buffer != null) {
            buffer.decreaseReferenceCount();
            TRACE.debugT("releaseCatalogBuffer", "one reference to catalog buffer (id = " + id + ") released.");
            if (buffer.getReferenceCount() == 0) {
                buffer.close();
                buffers.remove(id);
            }
        }
    }

    public static String getCatalogSyncID(String connectionID) {
        return CATALOG_SYNC_PREFIX + connectionID;
    }

    public static synchronized SyncRecordOutputStream removeTable(String id, String tableName) throws SQLException {
        CatalogBuffer buffer = (CatalogBuffer)buffers.get(id);
        if (buffer != null) {
            buffer.invalidateTable(null, tableName);
        }
        return CatalogBufferManagerImpl.getSyncRecord(tableName);
    }

    public synchronized void resetBuffer(String id) {
        CatalogBuffer buffer = (CatalogBuffer)buffers.get(id);
        if (buffer != null) {
            buffer.resetBuffer();
        }
    }

    public synchronized void invalidateTable(String id, String schemaName, String tableName) {
        CatalogBuffer buffer = (CatalogBuffer)buffers.get(id);
        if (buffer != null) {
            buffer.invalidateTable(null, tableName);
        }
    }

    public String[] getBufferIds() {
        CatalogBufferManagerImpl catalogBufferManagerImpl = this;
        synchronized (catalogBufferManagerImpl) {
            String[] ids = new String[buffers.size()];
            int i = 0;
            Iterator iter = buffers.values().iterator();
            while (iter.hasNext()) {
                ids[i] = ((CatalogBuffer)iter.next()).getId();
                ++i;
            }
            String[] stringArray = ids;
            return stringArray;
        }
    }

    public CatalogBufferMonitorGlobalInfo getGlobalInfo(String bufferId) {
        CatalogBufferInfo info = null;
        CatalogBufferManagerImpl catalogBufferManagerImpl = this;
        synchronized (catalogBufferManagerImpl) {
            CatalogBuffer buffer = (CatalogBuffer)buffers.get(bufferId);
            if (buffer != null) {
                info = new CatalogBufferInfo(buffer.getId(), buffer.getSyncId(), buffer.getReferenceCount(), buffer.getEntryCount(), buffer.getNumberOfEntries(), buffer.getNumberOfExistenceEntries(), buffer.getDispalcementCount());
            }
        }
        return info;
    }

    public Hashtable getAllTableObjects(String bufferId) {
        Hashtable tableCollection = null;
        CatalogBufferManagerImpl catalogBufferManagerImpl = this;
        synchronized (catalogBufferManagerImpl) {
            CatalogBuffer buffer = (CatalogBuffer)buffers.get(bufferId);
            if (buffer != null) {
                tableCollection = buffer.getTableBufferCollection();
            }
        }
        return tableCollection;
    }

    public TableData getTableObject(String bufferId, String tableName) {
        TableData table = null;
        CatalogBufferManagerImpl catalogBufferManagerImpl = this;
        synchronized (catalogBufferManagerImpl) {
            CatalogBuffer buffer = (CatalogBuffer)buffers.get(bufferId);
            if (buffer != null) {
                table = (TableData)buffer.getTable(null, tableName);
            }
        }
        return table;
    }

    public Boolean getTableExistence(String bufferId, String tableName) {
        Boolean exists = null;
        CatalogBufferManagerImpl catalogBufferManagerImpl = this;
        synchronized (catalogBufferManagerImpl) {
            CatalogBuffer buffer = (CatalogBuffer)buffers.get(bufferId);
            if (buffer != null) {
                exists = buffer.getTableExistence(null, tableName);
            }
        }
        return exists;
    }

    public void resetAllBuffer() {
        String[] ids = this.getBufferIds();
        int i = 0;
        while (i < ids.length) {
            this.resetBuffer(ids[i]);
            ++i;
        }
    }

    private static SyncRecordOutputStream getSyncRecord(String tableName) throws SQLException {
        SyncRecordOutputStream sros = new SyncRecordOutputStream();
        TRACE.debugT("getSyncRecord", "create sync record for " + tableName);
        try {
            sros.writeString(tableName);
        }
        catch (SQLException ex) {
            throw Syslog.createAndLogOpenSQLException(class$com$sap$sql$catalog$impl$CatalogBufferManagerImpl == null ? (class$com$sap$sql$catalog$impl$CatalogBufferManagerImpl = CatalogBufferManagerImpl.class$("com.sap.sql.catalog.impl.CatalogBufferManagerImpl")) : class$com$sap$sql$catalog$impl$CatalogBufferManagerImpl, "com.sap.sql_0012", new Object[0], (Throwable)ex);
        }
        return sros;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

