/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.catalog.impl;

import com.sap.sql.catalog.monitor.CatalogBufferMonitorGlobalInfo;
import java.io.Serializable;

public class CatalogBufferInfo
implements CatalogBufferMonitorGlobalInfo,
Serializable {
    private String id;
    private String syncId;
    private int referenceCount;
    private long entryCount;
    private long numberOfEntries;
    private long numberOfExistenceEntries;
    private long displacementCount;

    public CatalogBufferInfo(String id, String syncId, int referenceCount, long entryCount, long numberOfEntries, long numberOfExistenceEntries, long displacementCount) {
        this.id = id;
        this.syncId = syncId;
        this.referenceCount = referenceCount;
        this.entryCount = entryCount;
        this.numberOfEntries = numberOfEntries;
        this.numberOfExistenceEntries = numberOfExistenceEntries;
        this.displacementCount = displacementCount;
    }

    public String getId() {
        return this.id;
    }

    public String getSyncId() {
        return this.syncId;
    }

    public int getReferenceCount() {
        return this.referenceCount;
    }

    public long getEntryCount() {
        return this.entryCount;
    }

    public long getNumberOfEntries() {
        return this.numberOfEntries;
    }

    public long getNumberOfFreeEntries() {
        long numberOfFreeEntries = this.entryCount - this.numberOfEntries;
        return numberOfFreeEntries < 0L ? 0L : numberOfFreeEntries;
    }

    public long getNumberOfExistenceEntries() {
        return this.numberOfExistenceEntries;
    }

    public long getDisplacmentCount() {
        return this.displacementCount;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Id = " + this.id);
        buf.append(", syncId = " + this.syncId);
        buf.append(", referenceCount = " + this.referenceCount);
        buf.append(", entryCount = " + this.entryCount);
        buf.append(", numberOfEntries = " + this.numberOfEntries);
        long numberOfFreeEntries = this.entryCount - this.numberOfEntries;
        buf.append(", numberOfFreeEntries = " + (numberOfFreeEntries < 0L ? 0L : numberOfFreeEntries));
        buf.append(", numberOfExistenceEntries = " + this.numberOfExistenceEntries);
        buf.append(", displacementCount = " + this.displacementCount);
        return buf.toString();
    }

    public String getHtmlHeader() {
        StringBuffer header = new StringBuffer();
        header.append("<th>SyncId</th>");
        header.append("<th>References</th>");
        header.append("<th>Max</th>");
        header.append("<th>Current</th>");
        header.append("<th>Free</th>");
        header.append("<th>Current Existence</th>");
        header.append("<th>Displacements</th>");
        return header.toString();
    }

    public String getHtmlRow() {
        StringBuffer row = new StringBuffer();
        long numberOfFreeEntries = this.entryCount - this.numberOfEntries;
        numberOfFreeEntries = numberOfFreeEntries < 0L ? 0L : numberOfFreeEntries;
        row.append("<td>" + this.syncId + "</td>");
        row.append("<td>" + this.referenceCount + "</td>");
        row.append("<td>" + this.entryCount + "</td>");
        row.append("<td>" + this.numberOfEntries + "</td>");
        row.append("<td>" + numberOfFreeEntries + "</td>");
        row.append("<td>" + this.numberOfExistenceEntries + "</td>");
        row.append("<td>" + this.displacementCount + "</td>");
        return row.toString();
    }
}

