/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.buffer;

import com.sap.sql.buffer.BufferNotAvailableException;
import com.sap.sql.buffer.BufferRecordProcessor;
import com.sap.sql.buffer.BufferResetException;
import com.sap.sql.buffer.DataWasDisplacedException;
import com.sap.sql.buffer.ExternalBufferException;
import com.sap.sql.buffer.IllegalArgumentException;
import com.sap.sql.buffer.ObjectInconsistentException;
import com.sap.sql.buffer.ResultSetClosedException;
import com.sap.sql.buffer.ResultSetExhaustedException;
import com.sap.sql.buffer.ResultSetNotOpenedException;
import com.sap.sql.buffer.TBJBuffer;
import com.sap.sql.buffer.TBJBufferBlob;
import com.sap.sql.buffer.TBJBufferClob;
import com.sap.sql.buffer.TBJBufferData;
import com.sap.sql.buffer.TBJBufferDirectory;
import com.sap.sql.buffer.TBJBufferKey;
import com.sap.sql.buffer.TBJBufferObject;
import com.sap.sql.buffer.TBJBufferRecord;
import com.sap.sql.buffer.TypeMismatchException;
import com.sap.sql.log.Syslog;
import com.sap.tc.logging.Location;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;

class TBJBufferResultSet
implements ResultSet {
    private static final Location TRACE = Location.getLocation((Class)(class$com$sap$sql$buffer$TBJBufferResultSet == null ? (class$com$sap$sql$buffer$TBJBufferResultSet = TBJBufferResultSet.class$("com.sap.sql.buffer.TBJBufferResultSet")) : class$com$sap$sql$buffer$TBJBufferResultSet));
    private static final int INTEGER = 0;
    private static final int SHORT = 1;
    private static final int LONG = 2;
    private static final int DOUBLE = 3;
    private static final int FLOAT = 4;
    private static final int BYTE = 5;
    private static final int BIG_DECIMAL = 6;
    private static final int DATE = 8;
    private static final int TIME = 9;
    private static final int TIMESTAMP = 10;
    private static final int READER = 11;
    private static final int INPUT_STREAM = 12;
    private static final int BLOB = 13;
    private static final int CLOB = 14;
    private static final int BOOLEAN = 15;
    private static final int BYTE_ARRAY = 16;
    private TBJBuffer buffer;
    private TBJBufferObject object;
    private TBJBufferRecord current;
    private TBJBufferKey key;
    private BufferRecordProcessor processor;
    private Iterator recordIterator;
    private int maxRows;
    private int savedConsistencyCounter;
    private int currentRowNumber = 0;
    private boolean wasNull = false;
    private int nextCalls = 0;
    private boolean resultSetIsClosed = false;
    private boolean resultSetIsExhausted = false;
    private boolean fullKeyGiven;
    private int searchKeyCount;
    static /* synthetic */ Class class$com$sap$sql$buffer$TBJBufferResultSet;

    TBJBufferResultSet(TBJBuffer buffer, TBJBufferObject object, int savedConsistencyCounter, TBJBufferKey key, BufferRecordProcessor processor, int maxRows) {
        int givenKeyCount = key != null ? key.getValueCount() : 0;
        this.buffer = buffer;
        this.object = object;
        this.savedConsistencyCounter = savedConsistencyCounter;
        this.key = key;
        this.processor = processor;
        this.searchKeyCount = givenKeyCount;
        this.fullKeyGiven = object.getKeyCount() == givenKeyCount;
        this.maxRows = maxRows == 0 ? Integer.MAX_VALUE : maxRows;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean next() throws BufferNotAvailableException, DataWasDisplacedException, ObjectInconsistentException, BufferResetException, ResultSetClosedException, ExternalBufferException {
        boolean entry2;
        block42: {
            boolean ex2;
            block41: {
                boolean bl;
                block40: {
                    boolean bl2;
                    block39: {
                        TBJBufferRecord record = null;
                        TBJBufferKey recordKey = null;
                        boolean found = false;
                        String method = "next()";
                        String methodName = "next";
                        this.buffer.checkAndSetTraceLevel(TRACE);
                        if (this.buffer.isPathOn()) {
                            this.buffer.entering(TRACE, "next()");
                        }
                        try {
                            try {
                                TBJBufferData data;
                                int actualConsistencyCounter;
                                block43: {
                                    block45: {
                                        block44: {
                                            if (this.resultSetIsClosed) {
                                                throw (ResultSetClosedException)this.buffer.getAndLogBufferException(11, this.getClass(), "next");
                                            }
                                            if (this.resultSetIsExhausted) {
                                                boolean bl3 = false;
                                                Object var15_15 = null;
                                                if (!this.buffer.isPathOn()) return bl3;
                                                this.buffer.exiting(TRACE, "next");
                                                return bl3;
                                            }
                                            if (this.currentRowNumber >= this.maxRows) {
                                                this.closeImplicitly();
                                                bl2 = false;
                                                break block39;
                                            }
                                            if (!this.buffer.isReady()) {
                                                throw this.buffer.getAndLogBufferNotAvailableException(this.getClass(), "next");
                                            }
                                            int bufType = this.object.getTable().getBufType();
                                            ++this.nextCalls;
                                            if (bufType == 2) {
                                                found = this.nextSingle();
                                                if (this.buffer.isDebugOn()) {
                                                    this.buffer.trace(100, TRACE, "    found= " + found);
                                                }
                                                bl = found;
                                                break block40;
                                            }
                                            actualConsistencyCounter = this.object.waitAndLockHotObject(this.buffer);
                                            data = this.object.getData();
                                            if (data == null || data.getReachability() != 0) {
                                                String objName = this.object.getName();
                                                this.buffer.missedReads();
                                                this.object.unlockHotObject();
                                                this.close();
                                                throw (DataWasDisplacedException)this.buffer.getAndLogBufferException(10, this.getClass(), "next", new Object[]{objName});
                                            }
                                            if (!this.fullKeyGiven) break block43;
                                            if (this.buffer.isDebugOn()) {
                                                this.buffer.trace(100, TRACE, "    full key is given");
                                            }
                                            if (this.nextCalls != 1) break block44;
                                            record = data.getRecord(this.buffer, this.key);
                                            if (record != null) {
                                                try {
                                                    found = this.processor.verifySearchCondition(record);
                                                }
                                                catch (Exception ex2) {
                                                    String objName = this.object.getName();
                                                    this.object.unlockHotObject();
                                                    this.close();
                                                    throw (ExternalBufferException)this.buffer.getAndLogBufferException(16, this.getClass(), "next", new Object[]{"Exception while verifying search condition on record \" " + record + "\" of \"" + objName + "\""}, ex2);
                                                }
                                                if (found) {
                                                    this.current = record;
                                                    ++this.currentRowNumber;
                                                }
                                            }
                                            break block45;
                                        }
                                        found = false;
                                    }
                                    this.object.unlockHotObject();
                                    if (!found) {
                                        this.closeImplicitly();
                                    }
                                    if (this.buffer.isDebugOn()) {
                                        this.buffer.trace(100, TRACE, "    found= " + found);
                                    }
                                    ex2 = found;
                                    break block41;
                                }
                                if (this.nextCalls == 1 || actualConsistencyCounter != this.savedConsistencyCounter) {
                                    if (this.buffer.isDebugOn()) {
                                        this.buffer.trace(100, TRACE, "    localize key");
                                    }
                                    this.recordIterator = data.locateRecord(this.buffer, this.key);
                                    this.savedConsistencyCounter = actualConsistencyCounter;
                                    if (this.nextCalls > 1 && this.recordIterator.hasNext()) {
                                        this.recordIterator.next();
                                        if (this.buffer.isDebugOn()) {
                                            this.buffer.trace(300, TRACE, "    chain ahead (" + this.nextCalls + "): " + this.object.getName() + ", " + this.key);
                                        }
                                    }
                                }
                                while (!found && this.recordIterator.hasNext()) {
                                    Map.Entry entry2 = (Map.Entry)this.recordIterator.next();
                                    recordKey = (TBJBufferKey)entry2.getKey();
                                    if (!recordKey.matchTo(this.buffer, this.key, this.searchKeyCount)) {
                                        if (!this.buffer.isDebugOn()) break;
                                        this.buffer.trace(100, TRACE, "    record was found but key does not match");
                                        break;
                                    }
                                    if (this.buffer.isDebugOn()) {
                                        this.buffer.trace(100, TRACE, "    record was found");
                                    }
                                    record = (TBJBufferRecord)entry2.getValue();
                                    try {
                                        found = this.processor.verifySearchCondition(record);
                                    }
                                    catch (Exception ex3) {
                                        String objName = this.object.getName();
                                        this.object.unlockHotObject();
                                        this.close();
                                        throw (ExternalBufferException)this.buffer.getAndLogBufferException(16, this.getClass(), "next", new Object[]{"Exception while verifying search condition on record \" " + record + "\" of \"" + objName + "\""}, ex3);
                                    }
                                }
                                if (found) {
                                    if (this.buffer.isDebugOn()) {
                                        this.buffer.trace(100, TRACE, "    record fulfills search condition");
                                    }
                                    this.current = record;
                                    ++this.currentRowNumber;
                                    this.key = recordKey;
                                }
                                this.object.unlockHotObject();
                                if (!found) {
                                    this.closeImplicitly();
                                }
                                if (this.buffer.isDebugOn()) {
                                    this.buffer.trace(100, TRACE, "    found= " + found + ", current row number= " + this.currentRowNumber);
                                }
                                entry2 = found;
                                break block42;
                            }
                            catch (TypeMismatchException ex4) {
                                String objName;
                                if (this.object != null) {
                                    objName = this.object.getName();
                                    this.object.unlockHotObject();
                                    TBJBuffer tBJBuffer = this.buffer;
                                    synchronized (tBJBuffer) {
                                        this.buffer.syncBegin(this.object);
                                        this.buffer.beginModification();
                                        if (!this.object.isExistent(this.buffer)) {
                                            this.object.clear(this.buffer);
                                        } else {
                                            TBJBufferDirectory dir = this.buffer.getDirectory();
                                            dir.removeTable(this.object.getTableName());
                                        }
                                        this.buffer.endModification();
                                        this.buffer.syncEnd();
                                    }
                                } else {
                                    objName = null;
                                }
                                this.close();
                                throw (ObjectInconsistentException)this.buffer.getAndLogBufferException(5, this.getClass(), "next", new Object[]{objName}, ex4);
                            }
                            catch (BufferResetException ex5) {
                                this.close();
                                throw ex5;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var15_20 = null;
                            if (!this.buffer.isPathOn()) throw throwable;
                            this.buffer.exiting(TRACE, "next");
                            throw throwable;
                        }
                    }
                    Object var15_16 = null;
                    if (!this.buffer.isPathOn()) return bl2;
                    this.buffer.exiting(TRACE, "next");
                    return bl2;
                }
                Object var15_17 = null;
                if (!this.buffer.isPathOn()) return bl;
                this.buffer.exiting(TRACE, "next");
                return bl;
            }
            Object var15_18 = null;
            if (!this.buffer.isPathOn()) return ex2;
            this.buffer.exiting(TRACE, "next");
            return ex2;
        }
        Object var15_19 = null;
        if (!this.buffer.isPathOn()) return entry2;
        this.buffer.exiting(TRACE, "next");
        return entry2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws BufferNotAvailableException {
        block7: {
            block6: {
                String method = "close()";
                String methodName = "close";
                if (this.buffer.isPathOn()) {
                    this.buffer.entering(TRACE, "close()");
                }
                try {
                    if (this.resultSetIsClosed) {
                        Object var4_3 = null;
                        if (!this.buffer.isPathOn()) return;
                        this.buffer.exiting(TRACE, "close");
                        return;
                    }
                    this.resultSetIsClosed = true;
                    if (this.resultSetIsExhausted) {
                        break block6;
                    }
                    this.closeImplicitly();
                    if (!this.buffer.isReady()) {
                        throw this.buffer.getAndLogBufferNotAvailableException(this.getClass(), "close");
                    }
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    if (!this.buffer.isPathOn()) throw throwable;
                    this.buffer.exiting(TRACE, "close");
                    throw throwable;
                }
            }
            Object var4_4 = null;
            if (!this.buffer.isPathOn()) return;
            this.buffer.exiting(TRACE, "close");
            return;
        }
        Object var4_5 = null;
        if (!this.buffer.isPathOn()) return;
        this.buffer.exiting(TRACE, "close");
    }

    public boolean wasNull() throws ResultSetClosedException, ResultSetNotOpenedException, ResultSetExhaustedException {
        String method = "wasNull()";
        String methodName = "wasNull";
        if (this.buffer.isPathOn()) {
            this.buffer.entering(TRACE, "wasNull()");
        }
        try {
            if (this.resultSetIsClosed) {
                throw (ResultSetClosedException)this.buffer.getAndLogBufferException(11, this.getClass(), "wasNull");
            }
            if (this.resultSetIsExhausted) {
                throw (ResultSetExhaustedException)this.buffer.getAndLogBufferException(13, this.getClass(), "wasNull");
            }
            if (this.nextCalls == 0) {
                throw (ResultSetNotOpenedException)this.buffer.getAndLogBufferException(12, this.getClass(), "wasNull");
            }
            boolean bl = this.wasNull;
            Object var5_4 = null;
            if (this.buffer.isPathOn()) {
                this.buffer.exiting(TRACE, "wasNull", new Boolean(this.wasNull));
            }
            return bl;
        }
        catch (Throwable throwable) {
            block7: {
                Object var5_5 = null;
                if (!this.buffer.isPathOn()) break block7;
                this.buffer.exiting(TRACE, "wasNull", new Boolean(this.wasNull));
            }
            throw throwable;
        }
    }

    public String getString(int columnIndex) throws ResultSetClosedException, ResultSetNotOpenedException, ResultSetExhaustedException, IllegalArgumentException {
        Object value = null;
        String method = "getString(int)";
        String methodName = "getString";
        if (this.buffer.isPathOn()) {
            this.buffer.entering(TRACE, "getString(int)", new Object[]{new Integer(columnIndex)});
        }
        try {
            value = this.getValue("getString", true, columnIndex, null);
            String string = value != null ? value.toString() : (String)value;
            Object var7_6 = null;
            if (this.buffer.isPathOn()) {
                this.buffer.exiting(TRACE, "getString", value);
            }
            return string;
        }
        catch (Throwable throwable) {
            block4: {
                Object var7_7 = null;
                if (!this.buffer.isPathOn()) break block4;
                this.buffer.exiting(TRACE, "getString", value);
            }
            throw throwable;
        }
    }

    public int getInt(int columnIndex) throws ResultSetClosedException, ResultSetNotOpenedException, ResultSetExhaustedException, IllegalArgumentException, TypeMismatchException {
        String method = "getInt(int)";
        String methodName = "getInt";
        Number number = this.getNumber("getInt(int)", "getInt", true, columnIndex, null, 0);
        return number != null ? number.intValue() : 0;
    }

    public boolean getBoolean(int columnIndex) throws ResultSetClosedException, ResultSetNotOpenedException, ResultSetExhaustedException, IllegalArgumentException {
        Boolean result = null;
        String method = "getBoolean(int)";
        String methodName = "getBoolean";
        try {
            result = (Boolean)this.getValueOfType("getBoolean(int)", "getBoolean", 15, true, columnIndex, null);
        }
        catch (TypeMismatchException ex) {
            // empty catch block
        }
        return result != null ? result : false;
    }

    public byte getByte(int columnIndex) throws ResultSetClosedException, ResultSetNotOpenedException, ResultSetExhaustedException, IllegalArgumentException, TypeMismatchException {
        String method = "getByte(int)";
        String methodName = "getByte";
        Number number = this.getNumber("getByte(int)", "getByte", true, columnIndex, null, 5);
        return number != null ? number.byteValue() : (byte)0;
    }

    public short getShort(int columnIndex) throws ResultSetClosedException, ResultSetNotOpenedException, ResultSetExhaustedException, IllegalArgumentException, TypeMismatchException {
        String method = "getShort(int)";
        String methodName = "getShort";
        Number number = this.getNumber("getShort(int)", "getShort", true, columnIndex, null, 1);
        return number != null ? number.shortValue() : (short)0;
    }

    public long getLong(int columnIndex) throws ResultSetClosedException, ResultSetNotOpenedException, ResultSetExhaustedException, IllegalArgumentException, TypeMismatchException {
        String method = "getLong(int)";
        String methodName = "getLong";
        Number number = this.getNumber("getLong(int)", "getLong", true, columnIndex, null, 2);
        return number != null ? number.longValue() : 0L;
    }

    public float getFloat(int columnIndex) throws ResultSetClosedException, ResultSetNotOpenedException, ResultSetExhaustedException, IllegalArgumentException, TypeMismatchException {
        String method = "getFloat(int)";
        String methodName = "getFloat";
        Number number = this.getNumber("getFloat(int)", "getFloat", true, columnIndex, null, 4);
        return number != null ? number.floatValue() : 0.0f;
    }

    public double getDouble(int columnIndex) throws ResultSetClosedException, ResultSetNotOpenedException, ResultSetExhaustedException, IllegalArgumentException, TypeMismatchException {
        String method = "getDouble(int)";
        String methodName = "getDouble";
        Number number = this.getNumber("getDouble(int)", "getDouble", true, columnIndex, null, 3);
        return number != null ? number.doubleValue() : 0.0;
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "getBigdecimal(int, int)");
        return null;
    }

    public byte[] getBytes(int columnIndex) throws ResultSetClosedException, ResultSetNotOpenedException, ResultSetExhaustedException, IllegalArgumentException, TypeMismatchException {
        byte[] ba_out;
        String method = "getBytes(int)";
        String methodName = "getBytes";
        byte[] ba = (byte[])this.getValueOfType("getBytes(int)", "getBytes", 16, true, columnIndex, null);
        if (ba != null) {
            ba_out = new byte[ba.length];
            System.arraycopy(ba, 0, ba_out, 0, ba.length);
        } else {
            ba_out = null;
        }
        return ba_out;
    }

    public Date getDate(int columnIndex) throws ResultSetClosedException, ResultSetNotOpenedException, ResultSetExhaustedException, IllegalArgumentException, TypeMismatchException {
        String method = "getDate(int)";
        String methodName = "getDate";
        Date date = (Date)this.getValueOfType("getDate(int)", "getDate", 8, true, columnIndex, null);
        return date != null ? (Date)date.clone() : null;
    }

    public Time getTime(int columnIndex) throws ResultSetClosedException, ResultSetNotOpenedException, ResultSetExhaustedException, IllegalArgumentException, TypeMismatchException {
        String method = "getTime(int)";
        String methodName = "getTime";
        Time time = (Time)this.getValueOfType("getTime(int)", "getTime", 9, true, columnIndex, null);
        return time != null ? (Time)time.clone() : null;
    }

    public Timestamp getTimestamp(int columnIndex) throws ResultSetClosedException, ResultSetNotOpenedException, ResultSetExhaustedException, IllegalArgumentException, TypeMismatchException {
        String method = "getTimestamp(int)";
        String methodName = "getTimestamp";
        Timestamp ts = (Timestamp)this.getValueOfType("getTimestamp(int)", "getTimestamp", 10, true, columnIndex, null);
        return ts != null ? (Timestamp)ts.clone() : null;
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws ResultSetClosedException, ResultSetNotOpenedException, ResultSetExhaustedException, IllegalArgumentException, TypeMismatchException {
        String method = "getTimestamp(int, Calendar)";
        String methodName = "getTimestamp";
        Timestamp ts = (Timestamp)this.getValueOfType("getTimestamp(int, Calendar)", "getTimestamp", 10, true, columnIndex, null);
        return ts != null ? (Timestamp)ts.clone() : null;
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "getAsciiStream(int)");
        return null;
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "getUnicodeStream(int)");
        return null;
    }

    public InputStream getBinaryStream(int columnIndex) throws ResultSetClosedException, ResultSetNotOpenedException, ResultSetExhaustedException, IllegalArgumentException, TypeMismatchException {
        String method = "getBinaryStream(int)";
        String methodName = "getBinaryStream";
        byte[] byteArray = (byte[])this.getValueOfType("getBinaryStream(int)", "getBinaryStream", 12, true, columnIndex, null);
        return byteArray != null ? new ByteArrayInputStream(byteArray) : null;
    }

    public boolean getBoolean(String columnName) throws ResultSetClosedException, ResultSetNotOpenedException, ResultSetExhaustedException, IllegalArgumentException {
        Boolean result = null;
        String method = "getBoolean(String)";
        String methodName = "getBoolean";
        try {
            result = (Boolean)this.getValueOfType("getBoolean(String)", "getBoolean", 15, false, 0, columnName);
        }
        catch (TypeMismatchException ex) {
            // empty catch block
        }
        return result != null ? result : false;
    }

    public String getString(String columnName) throws ResultSetClosedException, ResultSetNotOpenedException, ResultSetExhaustedException, IllegalArgumentException {
        Object value = null;
        String method = "getString(String)";
        String methodName = "getString";
        if (this.buffer.isPathOn()) {
            this.buffer.entering(TRACE, "getString(String)", new Object[]{columnName});
        }
        try {
            value = this.getValue("getString", false, 0, columnName);
            String string = value != null ? value.toString() : (String)value;
            Object var7_6 = null;
            if (this.buffer.isPathOn()) {
                this.buffer.exiting(TRACE, "getString", value);
            }
            return string;
        }
        catch (Throwable throwable) {
            block4: {
                Object var7_7 = null;
                if (!this.buffer.isPathOn()) break block4;
                this.buffer.exiting(TRACE, "getString", value);
            }
            throw throwable;
        }
    }

    public byte getByte(String columnName) throws ResultSetClosedException, ResultSetNotOpenedException, ResultSetExhaustedException, IllegalArgumentException, TypeMismatchException {
        String method = "getByte(String)";
        String methodName = "getByte";
        Number number = this.getNumber("getByte(String)", "getByte", false, 0, columnName, 5);
        return number != null ? number.byteValue() : (byte)0;
    }

    public short getShort(String columnName) throws ResultSetClosedException, ResultSetNotOpenedException, ResultSetExhaustedException, IllegalArgumentException, TypeMismatchException {
        String method = "getShort(String)";
        String methodName = "getShort";
        Number number = this.getNumber("getShort(String)", "getShort", false, 0, columnName, 1);
        return number != null ? number.shortValue() : (short)0;
    }

    public int getInt(String columnName) throws ResultSetClosedException, ResultSetNotOpenedException, ResultSetExhaustedException, IllegalArgumentException, TypeMismatchException {
        String method = "getInt(String)";
        String methodName = "getInt";
        Number number = this.getNumber("getInt(String)", "getInt", false, 0, columnName, 0);
        return number != null ? number.intValue() : 0;
    }

    public long getLong(String columnName) throws ResultSetClosedException, ResultSetNotOpenedException, ResultSetExhaustedException, IllegalArgumentException, TypeMismatchException {
        String method = "getLong(String)";
        String methodName = "getLong";
        Number number = this.getNumber("getLong(String)", "getLong", false, 0, columnName, 2);
        return number != null ? number.longValue() : 0L;
    }

    public float getFloat(String columnName) throws ResultSetClosedException, ResultSetNotOpenedException, ResultSetExhaustedException, IllegalArgumentException, TypeMismatchException {
        String method = "getFloat(String)";
        String methodName = "getFloat";
        Number number = this.getNumber("getFloat(String)", "getFloat", false, 0, columnName, 4);
        return number != null ? number.floatValue() : 0.0f;
    }

    public double getDouble(String columnName) throws ResultSetClosedException, ResultSetNotOpenedException, ResultSetExhaustedException, IllegalArgumentException, TypeMismatchException {
        String method = "getDouble(String)";
        String methodName = "getDouble";
        Number number = this.getNumber("getDouble(String)", "getDouble", false, 0, columnName, 3);
        return number != null ? number.doubleValue() : 0.0;
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "getBigDecimal(String, int)");
        return null;
    }

    public byte[] getBytes(String columnName) throws ResultSetClosedException, ResultSetNotOpenedException, ResultSetExhaustedException, IllegalArgumentException, TypeMismatchException {
        byte[] ba_out;
        String method = "getBytes(String)";
        String methodName = "getBytes";
        byte[] ba = (byte[])this.getValueOfType("getBytes(String)", "getBytes", 16, false, 0, columnName);
        if (ba != null) {
            ba_out = new byte[ba.length];
            System.arraycopy(ba, 0, ba_out, 0, ba.length);
        } else {
            ba_out = null;
        }
        return ba_out;
    }

    public Date getDate(String columnName) throws ResultSetClosedException, ResultSetNotOpenedException, ResultSetExhaustedException, IllegalArgumentException, TypeMismatchException {
        String method = "getDate(int)";
        String methodName = "getDate";
        Date date = (Date)this.getValueOfType("getDate(int)", "getDate", 8, false, 0, columnName);
        return date != null ? (Date)date.clone() : null;
    }

    public Time getTime(String columnName) throws ResultSetClosedException, ResultSetNotOpenedException, ResultSetExhaustedException, IllegalArgumentException, TypeMismatchException {
        String method = "getTime(int)";
        String methodName = "getTime";
        Time time = (Time)this.getValueOfType("getTime(int)", "getTime", 9, false, 0, columnName);
        return time != null ? (Time)time.clone() : null;
    }

    public Timestamp getTimestamp(String columnName) throws ResultSetClosedException, ResultSetNotOpenedException, ResultSetExhaustedException, IllegalArgumentException, TypeMismatchException {
        String method = "getTimestamp(String)";
        String methodName = "getTimestamp";
        Timestamp ts = (Timestamp)this.getValueOfType("getTimestamp(String)", "getTimestamp", 10, false, 0, columnName);
        return ts != null ? (Timestamp)ts.clone() : null;
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws ResultSetClosedException, ResultSetNotOpenedException, ResultSetExhaustedException, IllegalArgumentException, TypeMismatchException {
        String method = "getTimestamp(String, Calendar)";
        String methodName = "getTimestamp";
        Timestamp ts = (Timestamp)this.getValueOfType("getTimestamp(String, Calendar)", "getTimestamp", 10, false, 0, columnName);
        return ts != null ? (Timestamp)ts.clone() : null;
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "getAsciiStream(String)");
        return null;
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "getUnicodeStream(String)");
        return null;
    }

    public InputStream getBinaryStream(String columnName) throws ResultSetClosedException, ResultSetNotOpenedException, ResultSetExhaustedException, IllegalArgumentException, TypeMismatchException {
        String method = "getBinaryStream(int)";
        String methodName = "getBinaryStream";
        byte[] byteArray = (byte[])this.getValueOfType("getBinaryStream(int)", "getBinaryStream", 12, false, 0, columnName);
        return byteArray != null ? new ByteArrayInputStream(byteArray) : null;
    }

    public SQLWarning getWarnings() throws SQLException {
        Syslog.createUnsupportedMethodError(this, "getWarnings()");
        return null;
    }

    public void clearWarnings() throws SQLException {
        Syslog.createUnsupportedMethodError(this, "clearWarnings()");
    }

    public String getCursorName() throws SQLException {
        Syslog.createUnsupportedMethodError(this, "getCursorName()");
        return null;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        Syslog.createUnsupportedMethodError(this, "getMetaData()");
        return null;
    }

    public Object getObject(int columnIndex) throws ResultSetClosedException, ResultSetNotOpenedException, ResultSetExhaustedException, IllegalArgumentException {
        Object value = null;
        Object result = null;
        String method = "getObject(int)";
        String methodName = "getObject";
        if (this.buffer.isPathOn()) {
            this.buffer.entering(TRACE, "getObject(int)", new Object[]{new Integer(columnIndex)});
        }
        try {
            value = this.getValue("getObject", true, columnIndex, null);
            Object object = result = this.cloneValue(value);
            Object var8_7 = null;
            if (this.buffer.isPathOn()) {
                this.buffer.exiting(TRACE, "getObject", result);
            }
            return object;
        }
        catch (Throwable throwable) {
            block4: {
                Object var8_8 = null;
                if (!this.buffer.isPathOn()) break block4;
                this.buffer.exiting(TRACE, "getObject", result);
            }
            throw throwable;
        }
    }

    public Object getObject(String columnName) throws ResultSetClosedException, ResultSetNotOpenedException, ResultSetExhaustedException, IllegalArgumentException {
        Object value = null;
        Object result = null;
        String method = "getObject(String)";
        String methodName = "getObject";
        if (this.buffer.isPathOn()) {
            this.buffer.entering(TRACE, "getObject(String)", new Object[]{columnName});
        }
        try {
            value = this.getValue("getObject", false, 0, columnName);
            Object object = result = this.cloneValue(value);
            Object var8_7 = null;
            if (this.buffer.isPathOn()) {
                this.buffer.exiting(TRACE, "getObject", result);
            }
            return object;
        }
        catch (Throwable throwable) {
            block4: {
                Object var8_8 = null;
                if (!this.buffer.isPathOn()) break block4;
                this.buffer.exiting(TRACE, "getObject", result);
            }
            throw throwable;
        }
    }

    public int findColumn(String columnName) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "findColumn(String)");
        return 0;
    }

    public Reader getCharacterStream(int columnIndex) throws ResultSetClosedException, ResultSetNotOpenedException, ResultSetExhaustedException, IllegalArgumentException, TypeMismatchException {
        String method = "getCharacterStream(int)";
        String methodName = "getCharacterStream";
        char[] charArray = (char[])this.getValueOfType("getCharacterStream(int)", "getCharacterStream", 11, true, columnIndex, null);
        return charArray != null ? new CharArrayReader(charArray) : null;
    }

    public Reader getCharacterStream(String columnName) throws ResultSetClosedException, ResultSetNotOpenedException, ResultSetExhaustedException, IllegalArgumentException, TypeMismatchException {
        String method = "getCharacterStream(String)";
        String methodName = "getCharacterStream";
        char[] charArray = (char[])this.getValueOfType("getCharacterStream(String)", "getCharacterStream", 11, false, 0, columnName);
        return charArray != null ? new CharArrayReader(charArray) : null;
    }

    public BigDecimal getBigDecimal(int columnIndex) throws ResultSetClosedException, ResultSetNotOpenedException, ResultSetExhaustedException, IllegalArgumentException, TypeMismatchException {
        String method = "getBigDecimal(int)";
        String methodName = "getBigDecimal";
        return (BigDecimal)this.getNumber("getBigDecimal(int)", "getBigDecimal", true, columnIndex, null, 6);
    }

    public BigDecimal getBigDecimal(String columnName) throws ResultSetClosedException, ResultSetNotOpenedException, ResultSetExhaustedException, IllegalArgumentException, TypeMismatchException {
        String method = "getBigDecimal(String)";
        String methodName = "getBigDecimal";
        return (BigDecimal)this.getNumber("getBigDecimal(String)", "getBigDecimal", false, 0, columnName, 6);
    }

    public boolean isBeforeFirst() throws SQLException {
        Syslog.createUnsupportedMethodError(this, "isBeforeFirst()");
        return false;
    }

    public boolean isAfterLast() throws SQLException {
        Syslog.createUnsupportedMethodError(this, "isAfterLast()");
        return false;
    }

    public boolean isFirst() throws SQLException {
        Syslog.createUnsupportedMethodError(this, "isFirst()");
        return false;
    }

    public boolean isLast() throws SQLException {
        Syslog.createUnsupportedMethodError(this, "isLast()");
        return false;
    }

    public void beforeFirst() throws SQLException {
        Syslog.createUnsupportedMethodError(this, "beforeFirst()");
    }

    public void afterLast() throws SQLException {
        Syslog.createUnsupportedMethodError(this, "afterLast()");
    }

    public boolean first() throws SQLException {
        Syslog.createUnsupportedMethodError(this, "first()");
        return false;
    }

    public boolean last() throws SQLException {
        Syslog.createUnsupportedMethodError(this, "last()");
        return false;
    }

    public int getRow() throws ResultSetClosedException {
        if (this.resultSetIsClosed) {
            throw (ResultSetClosedException)this.buffer.getAndLogBufferException(11, this.getClass(), "getRow");
        }
        return this.currentRowNumber;
    }

    public boolean absolute(int row) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "absolute(int)");
        return false;
    }

    public boolean relative(int rows) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "relative(int)");
        return false;
    }

    public boolean previous() throws SQLException {
        Syslog.createUnsupportedMethodError(this, "previous()");
        return false;
    }

    public void setFetchDirection(int direction) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "setFetchDirection(int)");
    }

    public int getFetchDirection() throws SQLException {
        Syslog.createUnsupportedMethodError(this, "getFetchDirection()");
        return 0;
    }

    public void setFetchSize(int rows) throws ResultSetClosedException {
        if (this.resultSetIsClosed) {
            throw (ResultSetClosedException)this.buffer.getAndLogBufferException(11, this.getClass(), "setFetchSize");
        }
    }

    public int getFetchSize() throws ResultSetClosedException {
        if (this.resultSetIsClosed) {
            throw (ResultSetClosedException)this.buffer.getAndLogBufferException(11, this.getClass(), "getFetchSize");
        }
        return 0;
    }

    public int getType() throws ResultSetClosedException {
        if (this.resultSetIsClosed) {
            throw (ResultSetClosedException)this.buffer.getAndLogBufferException(11, this.getClass(), "getType");
        }
        return 1003;
    }

    public int getConcurrency() throws ResultSetClosedException {
        if (this.resultSetIsClosed) {
            throw (ResultSetClosedException)this.buffer.getAndLogBufferException(11, this.getClass(), "getConcurrency");
        }
        return 1007;
    }

    public boolean rowUpdated() throws SQLException {
        Syslog.createUnsupportedMethodError(this, "rowUpdated()");
        return false;
    }

    public boolean rowInserted() throws SQLException {
        Syslog.createUnsupportedMethodError(this, "rowInserted()");
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        Syslog.createUnsupportedMethodError(this, "rowDeleted()");
        return false;
    }

    public void updateNull(int columnIndex) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "updateNull(int)");
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "updateBoolean(int, boolean)");
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "updateByte(int, byte)");
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "updateShort(int, short)");
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "updateInt(int, int)");
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "updateLong(int, long)");
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "updateFloat(int, float)");
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "updateDouble(int)");
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "updateBigDecimal(int, BigDecimal)");
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "updateString(int, String)");
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "updateBytes(int, byte[])");
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "updateDate(int, Date)");
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "updateTime(int, Time)");
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "updateTimestamp(int, Timestamp)");
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "updateAsciiStream(int, InputStream, int)");
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "updateBinaryStream(int, InputStream, int)");
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "updateCharacterStream(int, Reader, int)");
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "updateObject(int, Object, int)");
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "updateObjec(int, Object)");
    }

    public void updateNull(String columnName) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "updateNull(String)");
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "updateBoolean(String, boolean)");
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "updateByte(String, byte)");
    }

    public void updateShort(String columnName, short x) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "updateShort(String, short)");
    }

    public void updateInt(String columnName, int x) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "updateInt(String, int)");
    }

    public void updateLong(String columnName, long x) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "updateLong(String, long)");
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "updateFloat(String, float)");
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "updateDouble(String, double)");
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "updateBigDecimal(String, BigDecimal)");
    }

    public void updateString(String columnName, String x) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "updateString(String, String)");
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "updateBytes(String, byte[])");
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "updateDate(String, Date)");
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "updateTime(String, Time)");
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "updateTimestamp(String, Timestamp)");
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "updateAsciiStream(String, InputStream, int)");
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "updateBinaryStream(String, InputStream, int)");
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "updateCharacterStream(String, Reader, int)");
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "updateObject(String, Object, int)");
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "updateObject(String, Object)");
    }

    public void insertRow() throws SQLException {
        Syslog.createUnsupportedMethodError(this, "insertRow()");
    }

    public void updateRow() throws SQLException {
        Syslog.createUnsupportedMethodError(this, "updateRow()");
    }

    public void deleteRow() throws SQLException {
        Syslog.createUnsupportedMethodError(this, "deleteRow()");
    }

    public void refreshRow() throws SQLException {
        Syslog.createUnsupportedMethodError(this, "refreshRow()");
    }

    public void cancelRowUpdates() throws SQLException {
        Syslog.createUnsupportedMethodError(this, "cancelRowUpdates()");
    }

    public void moveToInsertRow() throws SQLException {
        Syslog.createUnsupportedMethodError(this, "moveToInsertRow()");
    }

    public void moveToCurrentRow() throws SQLException {
        Syslog.createUnsupportedMethodError(this, "moveToCurrentRow()");
    }

    public Statement getStatement() throws SQLException {
        Syslog.createUnsupportedMethodError(this, "getStatement()");
        return null;
    }

    public Object getObject(int i, Map map) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "getObject(int, Map)");
        return null;
    }

    public Ref getRef(int i) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "getRef(int)");
        return null;
    }

    public Blob getBlob(int i) throws ResultSetClosedException, ResultSetNotOpenedException, ResultSetExhaustedException, IllegalArgumentException, TypeMismatchException {
        String method = "getBlob(int)";
        String methodName = "getBlob";
        byte[] byteArray = (byte[])this.getValueOfType("getBlob(int)", "getBlob", 13, true, i, null);
        return byteArray != null ? new TBJBufferBlob(this.buffer, byteArray) : null;
    }

    public Clob getClob(int i) throws ResultSetClosedException, ResultSetNotOpenedException, ResultSetExhaustedException, IllegalArgumentException, TypeMismatchException {
        String method = "getClob(int)";
        String methodName = "getClob";
        char[] charArray = (char[])this.getValueOfType("getClob(int)", "getClob", 14, true, i, null);
        return charArray != null ? new TBJBufferClob(this.buffer, charArray) : null;
    }

    public Array getArray(int i) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "getArray()");
        return null;
    }

    public Object getObject(String colName, Map map) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "getObject(String, Map)");
        return null;
    }

    public Ref getRef(String colName) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "getRef(String)");
        return null;
    }

    public Blob getBlob(String colName) throws ResultSetClosedException, ResultSetNotOpenedException, ResultSetExhaustedException, IllegalArgumentException, TypeMismatchException {
        String method = "getBlob(String)";
        String methodName = "getBlob";
        byte[] byteArray = (byte[])this.getValueOfType("getBlob(String)", "getBlob", 13, false, 0, colName);
        return byteArray != null ? new TBJBufferBlob(this.buffer, byteArray) : null;
    }

    public Clob getClob(String colName) throws ResultSetClosedException, ResultSetNotOpenedException, ResultSetExhaustedException, IllegalArgumentException, TypeMismatchException {
        String method = "getClob(String)";
        String methodName = "getClob";
        char[] charArray = (char[])this.getValueOfType("getClob(String)", "getClob", 14, false, 0, colName);
        return charArray != null ? new TBJBufferClob(this.buffer, charArray) : null;
    }

    public Array getArray(String colName) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "getArray(String)");
        return null;
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "getDate(int, Calendar)");
        return null;
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "getDate(String, Calendar)");
        return null;
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "getTime(int, Calendar)");
        return null;
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        Syslog.createUnsupportedMethodError(this, "getTime(String, Calendar)");
        return null;
    }

    private boolean nextSingle() throws BufferNotAvailableException, DataWasDisplacedException, TypeMismatchException, BufferResetException, ExternalBufferException {
        TBJBufferData data = this.object.getData();
        boolean found = false;
        String methodName = "nextSingle";
        if (this.nextCalls == 1) {
            TBJBufferRecord record;
            if (this.buffer.isDebugOn()) {
                this.buffer.trace(100, TRACE, "    first call");
            }
            this.object.waitAndLockHotObject(this.buffer);
            if (data.getReachability() != 0) {
                String objName = this.object.getName();
                this.buffer.missedReads();
                this.object.unlockHotObject();
                this.close();
                throw (DataWasDisplacedException)this.buffer.getAndLogBufferException(10, this.getClass(), "nextSingle", new Object[]{objName});
            }
            try {
                record = data.getRecord(this.buffer, this.key);
            }
            catch (DataWasDisplacedException ex) {
                this.object.unlockHotObject();
                this.close();
                throw ex;
            }
            if (record != null) {
                if (record == TBJBufferRecord.NOT_FOUND_RECORD) {
                    if (this.buffer.isDebugOn()) {
                        this.buffer.trace(100, TRACE, "    NOT_FOUND found");
                    }
                    this.current = record;
                } else {
                    if (this.buffer.isDebugOn()) {
                        this.buffer.trace(100, TRACE, "    record found");
                    }
                    this.current = record;
                }
                ++this.currentRowNumber;
                found = true;
            }
            this.object.unlockHotObject();
        } else if (this.nextCalls == 2) {
            if (this.buffer.isDebugOn()) {
                this.buffer.trace(100, TRACE, "    second call");
            }
            if (this.current != TBJBufferRecord.NOT_FOUND_RECORD) {
                try {
                    found = this.processor.verifySearchCondition(this.current);
                }
                catch (Exception ex) {
                    String objName = this.object.getName();
                    TBJBufferRecord tmpRecord = this.current;
                    this.object.unlockHotObject();
                    this.close();
                    throw (ExternalBufferException)this.buffer.getAndLogBufferException(16, this.getClass(), "nextSingle", new Object[]{"Exception while verifying search condition on record \" " + tmpRecord + "\" of \"" + objName + "\""}, ex);
                }
            }
        }
        if (!found) {
            this.closeImplicitly();
        }
        return found;
    }

    private void closeImplicitly() {
        this.resultSetIsExhausted = true;
        this.object.closeCursor();
        this.key = null;
        this.object = null;
        this.recordIterator = null;
        this.current = null;
    }

    private Object getValue(String methodName, boolean byIndex, int columnIndex, String columnName) throws ResultSetClosedException, ResultSetNotOpenedException, ResultSetExhaustedException, IllegalArgumentException {
        if (this.resultSetIsClosed) {
            throw (ResultSetClosedException)this.buffer.getAndLogBufferException(11, this.getClass(), methodName);
        }
        if (this.resultSetIsExhausted) {
            throw (ResultSetExhaustedException)this.buffer.getAndLogBufferException(13, this.getClass(), methodName);
        }
        if (this.nextCalls < 2 && (this.nextCalls == 0 || this.object.getTable().getBufType() == 2)) {
            throw (ResultSetNotOpenedException)this.buffer.getAndLogBufferException(12, this.getClass(), methodName);
        }
        int currentPosition = byIndex ? this.processor.getColumnPosition(columnIndex) : this.processor.getColumnPosition(columnName);
        Object value = this.current.getValue(currentPosition);
        this.wasNull = value == null;
        return value;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object getValueOfType(String method, String methodName, int type, boolean byIndex, int columnIndex, String columnName) throws ResultSetClosedException, ResultSetNotOpenedException, ResultSetExhaustedException, IllegalArgumentException, TypeMismatchException {
        Boolean bl;
        Object value;
        block9: {
            Object object;
            block8: {
                value = null;
                if (this.buffer.isPathOn()) {
                    Object[] objectArray;
                    if (byIndex) {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = new Integer(columnIndex);
                    } else {
                        Object[] objectArray3 = new Object[1];
                        objectArray = objectArray3;
                        objectArray3[0] = columnName;
                    }
                    this.buffer.entering(TRACE, method, objectArray);
                }
                try {
                    value = this.getValue(methodName, byIndex, columnIndex, columnName);
                    if (value == null) {
                        Object var8_8 = null;
                        Object var10_11 = null;
                        if (!this.buffer.isPathOn()) return var8_8;
                        this.buffer.exiting(TRACE, methodName, value);
                        return var8_8;
                    }
                    if (this.isInstanceOf(value, type)) {
                        object = value;
                        break block8;
                    }
                    if (type != 15) {
                        throw (TypeMismatchException)this.buffer.getAndLogBufferException(14, this.getClass(), methodName, new Object[]{"call of \"" + methodName + "\" with value \"" + value + "\""});
                    }
                    bl = new Boolean(value.toString());
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var10_14 = null;
                    if (!this.buffer.isPathOn()) throw throwable;
                    this.buffer.exiting(TRACE, methodName, value);
                    throw throwable;
                }
            }
            Object var10_12 = null;
            if (!this.buffer.isPathOn()) return object;
            this.buffer.exiting(TRACE, methodName, value);
            return object;
        }
        Object var10_13 = null;
        if (!this.buffer.isPathOn()) return bl;
        this.buffer.exiting(TRACE, methodName, value);
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Number getNumber(String method, String methodName, boolean byIndex, int index, String name, int type) throws ResultSetClosedException, ResultSetNotOpenedException, ResultSetExhaustedException, IllegalArgumentException, TypeMismatchException {
        Number number;
        Number nValue = null;
        if (this.buffer.isPathOn()) {
            Object[] objectArray;
            if (byIndex) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = new Integer(index);
            } else {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = name;
            }
            this.buffer.entering(TRACE, method, objectArray);
        }
        try {
            Object value = this.getValue(methodName, byIndex, index, name);
            if (value == null) {
                Number number2 = null;
                Object var12_11 = null;
                if (!this.buffer.isPathOn()) return number2;
                this.buffer.exiting(TRACE, methodName, nValue);
                return number2;
            }
            if (value instanceof Number) {
                nValue = (Number)value;
                if (type == 6 && !(nValue instanceof BigDecimal)) {
                    nValue = nValue instanceof Float || nValue instanceof Double ? new BigDecimal(nValue.toString()) : BigDecimal.valueOf(nValue.longValue());
                }
            } else {
                if (!(value instanceof String)) throw (TypeMismatchException)this.buffer.getAndLogBufferException(14, this.getClass(), methodName, new Object[]{"call of \"" + methodName + "\" with value \"" + value.toString() + "\""});
                String sValue = (String)value;
                try {
                    nValue = type == 0 ? (Number)new Integer(sValue) : (Number)(type == 1 ? (Number)new Short(sValue) : (Number)(type == 2 ? (Number)new Long(sValue) : (Number)(type == 5 ? (Number)new Byte(sValue) : (Number)(type == 3 ? (Number)new Double(sValue) : (Number)(type == 4 ? new Float(sValue) : new BigDecimal(sValue))))));
                }
                catch (NumberFormatException ex) {
                    throw (TypeMismatchException)this.buffer.getAndLogBufferException(14, this.getClass(), methodName, new Object[]{"call of \"" + methodName + "\" with value \"" + value + "\""}, ex);
                }
            }
            number = nValue;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            if (!this.buffer.isPathOn()) throw throwable;
            this.buffer.exiting(TRACE, methodName, nValue);
            throw throwable;
        }
        Object var12_12 = null;
        if (!this.buffer.isPathOn()) return number;
        this.buffer.exiting(TRACE, methodName, nValue);
        return number;
    }

    private boolean isInstanceOf(Object value, int type) {
        switch (type) {
            case 8: {
                return value instanceof Date;
            }
            case 9: {
                return value instanceof Time;
            }
            case 10: {
                return value instanceof Timestamp;
            }
            case 15: {
                return value instanceof Boolean;
            }
            case 16: {
                return value instanceof byte[];
            }
            case 13: {
                return value instanceof byte[];
            }
            case 12: {
                return value instanceof byte[];
            }
            case 14: {
                return value instanceof char[];
            }
            case 11: {
                return value instanceof char[];
            }
        }
        return false;
    }

    private Object cloneValue(Object orig) {
        Object clone;
        if (orig instanceof Date) {
            clone = ((Date)orig).clone();
        } else if (orig instanceof Time) {
            clone = ((Time)orig).clone();
        } else if (orig instanceof Timestamp) {
            clone = ((Timestamp)orig).clone();
        } else if (orig instanceof byte[]) {
            int length = ((byte[])orig).length;
            clone = new byte[length];
            System.arraycopy(orig, 0, clone, 0, length);
        } else if (orig instanceof char[]) {
            int length = ((char[])orig).length;
            clone = new char[length];
            System.arraycopy(orig, 0, clone, 0, length);
        } else {
            clone = orig;
        }
        return clone;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

