/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.buffer;

import com.sap.sql.buffer.TBJBuffer;
import com.sap.sql.buffer.TBJBufferRecordAbstract;
import com.sap.sql.buffer.TypeMismatchException;

class TBJBufferKey
extends TBJBufferRecordAbstract
implements Comparable {
    TBJBufferKey(int size) {
        this.columns = new Object[size];
        int i = 0;
        while (i < size) {
            this.columns[i] = TBJBufferRecordAbstract.UNDEFINED;
            ++i;
        }
    }

    TBJBufferKey(Object[] cols) {
        this.columns = cols;
    }

    TBJBufferKey() {
        this.columns = new Object[0];
    }

    public boolean equals(Object o) {
        if (!(o instanceof TBJBufferKey)) {
            return false;
        }
        TBJBufferKey k = (TBJBufferKey)o;
        int len1 = this.columns.length;
        int len2 = k.columns.length;
        if (len1 != len2) {
            return false;
        }
        int i = 0;
        while (i < len1) {
            Object v1 = this.columns[i];
            Object v2 = k.columns[i];
            if (v1 != v2) {
                try {
                    if (v1 instanceof byte[] ? TBJBufferKey.compareByteArray((byte[])v1, (byte[])v2) != 0 : (v1 instanceof char[] ? TBJBufferKey.compareCharArray((char[])v1, (char[])v2) != 0 : !v1.equals(v2))) {
                        return false;
                    }
                }
                catch (ClassCastException ex) {
                    return false;
                }
                catch (NullPointerException ex) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public int compareTo(Object o) {
        TBJBufferKey k = (TBJBufferKey)o;
        int len1 = this.columns.length;
        int len2 = k.columns.length;
        int minLen = Math.min(len1, len2);
        int result = 0;
        int i = 0;
        while (i < minLen) {
            Object v1 = this.columns[i];
            Object v2 = k.columns[i];
            try {
                result = TBJBufferKey.compareValues(v1, v2);
            }
            catch (ClassCastException ex) {
                throw new ClassCastException("Type mismatch at column= " + (i + 1) + ": " + v1.getClass().toString() + " =/= " + v2.getClass().toString() + ". Cause: " + ex.getMessage());
            }
            catch (NullPointerException ex) {
                throw new NullPointerException("Null value in key at column " + (i + 1) + ". Cause: " + ((Throwable)ex).getMessage());
            }
            if (result != 0) {
                return result;
            }
            ++i;
        }
        return len1 - len2;
    }

    public int hashCode() {
        int result = 37;
        int len = this.columns.length;
        int i = 0;
        while (i < len) {
            result = 37 * result + this.columns[i].hashCode();
            ++i;
        }
        return result;
    }

    protected boolean isValid() {
        int i = 0;
        while (i < this.columns.length) {
            if (this.columns[i] == null || this.columns[i] == TBJBufferRecordAbstract.UNDEFINED) {
                return false;
            }
            ++i;
        }
        return true;
    }

    boolean matchTo(TBJBuffer buffer, TBJBufferKey key, int len) throws TypeMismatchException {
        if (len > this.columns.length) {
            return false;
        }
        int i = 0;
        while (i < len) {
            int result;
            Object v1 = this.columns[i];
            Object v2 = key.columns[i];
            try {
                result = TBJBufferKey.compareValues(v1, v2);
            }
            catch (ClassCastException ex) {
                throw (TypeMismatchException)buffer.getAndLogBufferException(14, this.getClass(), "matchTo", new Object[]{"Type mismatch at column " + (i + 1) + ": " + v1.getClass().toString() + " =/= " + v2.getClass().toString()}, ex);
            }
            catch (NullPointerException ex) {
                throw (TypeMismatchException)buffer.getAndLogBufferException(14, this.getClass(), "matchTo", new Object[]{"Null value at column " + (i + 1)}, ex);
            }
            if (result != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static int compareValues(Object o1, Object o2) {
        int result;
        if (o1 instanceof Comparable) {
            result = ((Comparable)o1).compareTo(o2);
        } else if (o1 instanceof byte[]) {
            result = TBJBufferKey.compareByteArray((byte[])o1, (byte[])o2);
        } else if (o1 instanceof Boolean) {
            result = TBJBufferKey.compareBoolean((Boolean)o1, (Boolean)o2);
        } else if (o1 instanceof char[]) {
            result = TBJBufferKey.compareCharArray((char[])o1, (char[])o2);
        } else {
            if (o1 == null || o2 == null) {
                throw new NullPointerException("At least one key value is null");
            }
            throw new ClassCastException("Unsupported type in key");
        }
        return result;
    }

    private static int compareByteArray(byte[] a1, byte[] a2) {
        int len1 = a1.length;
        int len2 = a2.length;
        int minLen = Math.min(len1, len2);
        int i = 0;
        while (i < minLen) {
            int result = a1[i] - a2[i];
            if (result != 0) {
                return result;
            }
            ++i;
        }
        return len1 - len2;
    }

    private static int compareCharArray(char[] a1, char[] a2) {
        int len1 = a1.length;
        int len2 = a2.length;
        int minLen = Math.min(len1, len2);
        int i = 0;
        while (i < minLen) {
            int result = a1[i] - a2[i];
            if (result != 0) {
                return result;
            }
            ++i;
        }
        return len1 - len2;
    }

    private static int compareBoolean(Boolean b1, Boolean b2) {
        boolean bval2;
        boolean bval1 = b1;
        if (bval1 == (bval2 = b2.booleanValue())) {
            return 0;
        }
        if (!bval1) {
            return -1;
        }
        return 1;
    }
}

