/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.buffer;

import com.sap.sql.buffer.Buffer;
import com.sap.sql.buffer.BufferAccess;
import com.sap.sql.buffer.BufferLoadAccess;
import com.sap.sql.buffer.BufferNotAvailableException;
import com.sap.sql.buffer.BufferObjectInfo;
import com.sap.sql.buffer.BufferRecord;
import com.sap.sql.buffer.BufferRecordProcessor;
import com.sap.sql.buffer.BufferResetException;
import com.sap.sql.buffer.DataLockedException;
import com.sap.sql.buffer.DataNotLoadableException;
import com.sap.sql.buffer.DataWasDisplacedException;
import com.sap.sql.buffer.DuplicateKeyException;
import com.sap.sql.buffer.ExternalBufferException;
import com.sap.sql.buffer.IllegalArgumentException;
import com.sap.sql.buffer.NoMemoryAvailableException;
import com.sap.sql.buffer.ObjectExistsException;
import com.sap.sql.buffer.ObjectInconsistentException;
import com.sap.sql.buffer.ObjectNotDefinedException;
import com.sap.sql.buffer.RecordNotFoundException;
import com.sap.sql.buffer.TBJBuffer;
import com.sap.sql.buffer.TBJBufferData;
import com.sap.sql.buffer.TBJBufferDirectory;
import com.sap.sql.buffer.TBJBufferDirectoryIterator;
import com.sap.sql.buffer.TBJBufferGenericDirectory;
import com.sap.sql.buffer.TBJBufferKey;
import com.sap.sql.buffer.TBJBufferObject;
import com.sap.sql.buffer.TBJBufferObjectInfo;
import com.sap.sql.buffer.TBJBufferRecord;
import com.sap.sql.buffer.TBJBufferRecordProcessor;
import com.sap.sql.buffer.TBJBufferResultSet;
import com.sap.sql.buffer.TBJBufferStatus;
import com.sap.sql.buffer.TBJBufferTable;
import com.sap.sql.buffer.TBJBufferTransactionHandling;
import com.sap.sql.buffer.TypeMismatchException;
import com.sap.tc.logging.Location;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

class TBJBufferAccess
implements BufferAccess {
    private static final Location TRACE = Location.getLocation((Class)(class$com$sap$sql$buffer$TBJBufferAccess == null ? (class$com$sap$sql$buffer$TBJBufferAccess = TBJBufferAccess.class$("com.sap.sql.buffer.TBJBufferAccess")) : class$com$sap$sql$buffer$TBJBufferAccess));
    private static final int INSERT = 0;
    private static final int UPDATE = 1;
    private static final int DELETE = 2;
    private static final int INVALIDATE = 3;
    private static final boolean FULL_KEY_REQUIRED = true;
    private static final boolean CREATE_OBJECT = true;
    private static final int SUCCEESSFUL = 0;
    private static final int FAILED = 1;
    private static final int UNKNOWN = 2;
    private static final int ILLEGAL_INPUT = 3;
    private TBJBuffer buffer;
    static /* synthetic */ Class class$com$sap$sql$buffer$TBJBufferAccess;

    public TBJBufferAccess(Buffer buffer) {
        this.buffer = (TBJBuffer)buffer;
    }

    public void defineObject(String tableName, int keyCount, int genKeyCount, int fieldCount, int[] keyIndex) throws BufferNotAvailableException, ObjectExistsException, IllegalArgumentException, BufferResetException {
        String method = "defineObject(String, int, int, int, int[])";
        String methodName = "defineObject";
        this.buffer.checkAndSetTraceLevel(TRACE);
        if (this.buffer.isPathOn()) {
            this.buffer.entering(TRACE, "defineObject(String, int, int, int, int[])", new Object[]{tableName, new Integer(keyCount), new Integer(genKeyCount), new Integer(fieldCount), keyIndex});
        }
        try {
            if (!this.buffer.isReady()) {
                throw this.buffer.getAndLogBufferNotAvailableException(this.getClass(), "defineObject");
            }
            if (tableName == null) {
                throw (IllegalArgumentException)this.buffer.getAndLogBufferException(1, this.getClass(), "defineObject", new Object[]{"tableName = null"});
            }
            if (keyCount == 0) {
                throw (IllegalArgumentException)this.buffer.getAndLogBufferException(1, this.getClass(), "defineObject", new Object[]{"keyCount = 0 for \"" + tableName + "\""});
            }
            if (keyCount < 0 || genKeyCount < 0 || fieldCount < 0) {
                throw (IllegalArgumentException)this.buffer.getAndLogBufferException(1, this.getClass(), "defineObject", new Object[]{"keyCount or genKeyCount or fieldCount < 0 for \"" + tableName + "\""});
            }
            if (genKeyCount > keyCount || keyCount > fieldCount || keyIndex != null && keyIndex.length != keyCount) {
                throw (IllegalArgumentException)this.buffer.getAndLogBufferException(1, this.getClass(), "defineObject", new Object[]{"inconsistent count parameters for \"" + tableName + "\""});
            }
            if (keyIndex != null) {
                int i = 0;
                while (i < keyIndex.length) {
                    if (keyIndex[i] <= 0 || keyIndex[i] > fieldCount) {
                        throw (IllegalArgumentException)this.buffer.getAndLogBufferException(1, this.getClass(), "defineObject", new Object[]{"illegal index in keyIndex for \"" + tableName + "\""});
                    }
                    ++i;
                }
            }
            TBJBuffer tBJBuffer = this.buffer;
            synchronized (tBJBuffer) {
                this.buffer.syncBegin();
                this.buffer.beginModification();
                TBJBufferDirectory dir = this.buffer.getDirectory();
                if (this.buffer.isDebugOn()) {
                    this.buffer.trace(100, TRACE, "    #Tables= " + dir.getTableCount() + ", #Objects= " + dir.getObjectCount());
                }
                try {
                    dir.createTable(tableName, keyCount, genKeyCount, fieldCount, keyIndex);
                }
                catch (ObjectExistsException ex) {
                    this.buffer.endModification();
                    this.buffer.syncEnd();
                    throw ex;
                }
                if (this.buffer.isDebugOn()) {
                    this.buffer.trace(100, TRACE, "    #Tables= " + dir.getTableCount() + ", #Objects= " + dir.getObjectCount());
                }
                this.buffer.endModification();
                this.buffer.syncEnd();
            }
            Object var13_13 = null;
            if (this.buffer.isPathOn()) {
                this.buffer.exiting(TRACE, "defineObject");
            }
            return;
        }
        catch (Throwable throwable) {
            block19: {
                Object var13_14 = null;
                if (!this.buffer.isPathOn()) break block19;
                this.buffer.exiting(TRACE, "defineObject");
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    public ResultSet getResultSet(String tableName, BufferRecord key, BufferRecordProcessor processor, int maxRows) throws BufferNotAvailableException, DataLockedException, DataNotLoadableException, ObjectNotDefinedException, ObjectInconsistentException, IllegalArgumentException, BufferResetException {
        givenKey = (TBJBufferKey)key;
        isReachable = true;
        rs = null;
        method = "getResultSet(String, BufferRecord, Object, int)";
        methodName = "getResultSet";
        this.buffer.checkAndSetTraceLevel(TBJBufferAccess.TRACE);
        if (this.buffer.isPathOn()) {
            this.buffer.entering(TBJBufferAccess.TRACE, "getResultSet(String, BufferRecord, Object, int)", new Object[]{tableName, key, processor, new Integer(maxRows)});
        }
        try {
            if (!this.buffer.isReady()) {
                throw this.buffer.getAndLogBufferNotAvailableException(this.getClass(), "getResultSet");
            }
            if (tableName == null) {
                throw (IllegalArgumentException)this.buffer.getAndLogBufferException(1, this.getClass(), "getResultSet", new Object[]{"tableName = null"});
            }
            if (givenKey != null && !givenKey.isValid()) {
                throw (IllegalArgumentException)this.buffer.getAndLogBufferException(1, this.getClass(), "getResultSet", new Object[]{"given key is not valid for \"" + tableName + "\""});
            }
            if (processor == null) {
                processor = new TBJBufferRecordProcessor();
            }
            dir = this.buffer.getDirectory();
            if (this.buffer.isDebugOn()) {
                this.buffer.trace(100, TBJBufferAccess.TRACE, "    #Tables= " + dir.getTableCount() + ", #Objects= " + dir.getObjectCount());
            }
            if ((object = dir.locateObjectWithWait(tableName, givenKey, true, true)) == null) {
                this.buffer.missedReads();
                throw (DataLockedException)this.buffer.getAndLogBufferException(8, this.getClass(), "getResultSet", new Object[]{tableName + " " + (givenKey != null ? givenKey.toString() : ""), null, "there exists a global invalidation"});
            }
            object.incrementUsedCounter();
            bufType = object.getTable().getBufType();
            objectConsistencyCounter = object.waitAndOpenCursor(this.buffer);
            status = object.getStatus();
            if (status == 2) {
                reachable = object.getReachability();
                if (reachable == 0) {
                    if (givenKey != null) {
                        keyCount = object.getKeyCount();
                        bufKey = givenKey.getValueCount() > keyCount ? givenKey.getKey(keyCount, null) : givenKey;
                    } else {
                        bufKey = new TBJBufferKey();
                    }
                    this.buffer.hitReads();
                    object.incrementReads(true);
                    rs = new TBJBufferResultSet(this.buffer, object, objectConsistencyCounter, bufKey, processor, maxRows);
                    if (bufType == 2) {
                        try {
                            if (rs.next()) ** GOTO lbl85
                            rs.close();
                            rs = null;
                        }
                        catch (ObjectInconsistentException ex) {
                            throw ex;
                        }
                        catch (SQLException ex) {}
                    }
                } else if (reachable == 1) {
                    this.buffer.missedReads();
                    isReachable = false;
                    var17_18 = this.buffer;
                    synchronized (var17_18) {
                        this.buffer.syncBegin(object);
                        this.buffer.beginModification();
                        dir.removeFromQueue(object);
                        object.beginModification();
                        object.closeCursor();
                        status = object.setStatus(4);
                        object.incrementReads(false);
                        object.endModification();
                        this.buffer.endModification();
                        this.buffer.syncEnd();
                    }
                } else {
                    this.buffer.missedReads();
                    object.incrementReads(false);
                    isReachable = false;
                    object.closeCursor();
                }
            } else if (status == 0 && object.isLoadable(this.buffer)) {
                this.buffer.missedReads();
                object.incrementReads(false);
                rs = null;
            } else {
                if (status == 5) {
                    this.buffer.missedReads();
                    object.incrementReads(false);
                    throw (DataNotLoadableException)this.buffer.getAndLogBufferException(9, this.getClass(), "getResultSet", new Object[]{tableName + " " + (givenKey != null ? givenKey.toString() : ""), TBJBufferStatus.printStatus(status)});
                }
                this.buffer.missedReads();
                object.incrementReads(false);
                throw (DataLockedException)this.buffer.getAndLogBufferException(8, this.getClass(), "getResultSet", new Object[]{tableName + " " + (givenKey != null ? givenKey.toString() : ""), TBJBufferStatus.printStatus(status), "reloadCounter = " + new Integer(object.getReloadCounter()) + ", fixingCounter = " + new Integer(object.getFixingCounter())});
            }
lbl85:
            // 6 sources

            if (!isReachable) {
                if (status == 4) {
                    throw (DataLockedException)this.buffer.getAndLogBufferException(8, this.getClass(), "getResultSet", new Object[]{tableName + " " + (givenKey != null ? givenKey.toString() : ""), TBJBufferStatus.printStatus(status), "object was displaced"});
                }
                throw (DataLockedException)this.buffer.getAndLogBufferException(8, this.getClass(), "getResultSet", new Object[]{tableName + " " + (givenKey != null ? givenKey.toString() : ""), TBJBufferStatus.printStatus(status), "object is only softly reachable"});
            }
            if (this.buffer.isDebugOn()) {
                this.buffer.trace(100, TBJBufferAccess.TRACE, "    #Tables= " + dir.getTableCount() + ", #Objects= " + dir.getObjectCount());
            }
            var17_19 = rs;
            var21_23 = null;
            if (this.buffer.isPathOn()) {
                this.buffer.exiting(TBJBufferAccess.TRACE, "getResultSet");
            }
            return var17_19;
        }
        catch (Throwable var20_25) {
            block31: {
                var21_24 = null;
                if (!this.buffer.isPathOn()) break block31;
                this.buffer.exiting(TBJBufferAccess.TRACE, "getResultSet");
            }
            throw var20_25;
        }
    }

    public BufferLoadAccess loadData(String tableName, BufferRecord key) throws BufferNotAvailableException, NoMemoryAvailableException, DataLockedException, DataNotLoadableException, ObjectNotDefinedException, ObjectInconsistentException, IllegalArgumentException, BufferResetException {
        TBJBufferKey givenKey = (TBJBufferKey)key;
        String method = "loadData(String, BufferRecord)";
        String methodName = "loadData";
        this.buffer.checkAndSetTraceLevel(TRACE);
        if (this.buffer.isPathOn()) {
            this.buffer.entering(TRACE, "loadData(String, BufferRecord)", new Object[]{tableName, key});
        }
        try {
            TBJBufferData data;
            if (!this.buffer.isReady()) {
                throw this.buffer.getAndLogBufferNotAvailableException(this.getClass(), "loadData");
            }
            if (tableName == null) {
                throw (IllegalArgumentException)this.buffer.getAndLogBufferException(1, this.getClass(), "loadData", new Object[]{"tableName = null"});
            }
            if (givenKey != null && !givenKey.isValid()) {
                throw (IllegalArgumentException)this.buffer.getAndLogBufferException(1, this.getClass(), "loadData", new Object[]{"given key is not valid for \"" + tableName + "\""});
            }
            TBJBuffer tBJBuffer = this.buffer;
            synchronized (tBJBuffer) {
                try {
                    try {
                        TBJBufferObject object;
                        this.buffer.syncBegin();
                        TBJBufferDirectory dir = this.buffer.getDirectory();
                        if (this.buffer.isDebugOn()) {
                            this.buffer.trace(100, TRACE, "    #Tables= " + dir.getTableCount() + ", #Objects= " + dir.getObjectCount());
                        }
                        if ((object = dir.locateObject(tableName, givenKey, true, true)) == null) {
                            throw (DataLockedException)this.buffer.getAndLogBufferException(8, this.getClass(), "loadData", new Object[]{tableName + " " + key, null, "generic region is not yet created"});
                        }
                        int status = object.getStatus();
                        int bufType = object.getTable().getBufType();
                        if (status == 0 && object.getFixingCounter() == 0) {
                            if (this.buffer.isDebugOn()) {
                                this.buffer.trace(100, TRACE, "    status= LOADABLE");
                            }
                            if (!dir.addToQueue(object)) {
                                throw (NoMemoryAvailableException)this.buffer.getAndLogBufferException(2, this.getClass(), "loadData");
                            }
                            object.beginModification();
                            object.setStatus(1);
                            data = object.getData();
                            if (data != null && !object.isHotObject() && !object.hasOpenCursors()) {
                                if (this.buffer.isDebugOn()) {
                                    this.buffer.trace(100, TRACE, "    old data can be freed.");
                                }
                                object.clearData(this.buffer);
                                object.setData(null);
                                data.allocContainer();
                                data.setKey(givenKey);
                                data.setConsistencyCounter();
                            } else {
                                if (this.buffer.isDebugOn()) {
                                    this.buffer.trace(100, TRACE, "    new data object created.");
                                }
                                data = new TBJBufferData(this.buffer, object, givenKey, true);
                            }
                            object.endModification();
                            if (this.buffer.isDebugOn()) {
                                this.buffer.trace(100, TRACE, "    status= LOADING");
                            }
                        } else if (bufType == 2 && status == 2 && object.getFixingCounter() == 0) {
                            if (!dir.addToQueue(object)) {
                                if (this.buffer.isDebugOn()) {
                                    this.buffer.trace(100, TRACE, "    SINGLE buffered: load queue is full");
                                }
                                throw (NoMemoryAvailableException)this.buffer.getAndLogBufferException(2, this.getClass(), "loadData");
                            }
                            if (this.buffer.isDebugOn()) {
                                this.buffer.trace(100, TRACE, "    SINGLE buffered: new data object created.");
                            }
                            data = new TBJBufferData(this.buffer, object, givenKey, false);
                            if (this.buffer.isDebugOn()) {
                                this.buffer.trace(100, TRACE, "    status= VALID");
                            }
                        } else {
                            if (status == 5) {
                                throw (DataNotLoadableException)this.buffer.getAndLogBufferException(9, this.getClass(), "loadData", new Object[]{tableName + " " + key, TBJBufferStatus.printStatus(status)});
                            }
                            throw (DataLockedException)this.buffer.getAndLogBufferException(8, this.getClass(), "loadData", new Object[]{tableName + " " + key, TBJBufferStatus.printStatus(object.getStatus()), "reloadCounter = " + new Integer(object.getReloadCounter()) + ", fixingCounter = " + new Integer(object.getFixingCounter())});
                        }
                        Object var17_12 = null;
                        this.buffer.syncEnd();
                    }
                    catch (ObjectNotDefinedException ex) {
                        throw ex;
                    }
                    catch (IllegalArgumentException ex) {
                        throw ex;
                    }
                    catch (ObjectInconsistentException ex) {
                        throw ex;
                    }
                    catch (BufferResetException ex) {
                        throw ex;
                    }
                }
                catch (Throwable throwable) {
                    Object var17_13 = null;
                    this.buffer.syncEnd();
                    throw throwable;
                }
            }
            TBJBufferData tBJBufferData = data;
            Object var20_21 = null;
            if (this.buffer.isPathOn()) {
                this.buffer.exiting(TRACE, "loadData");
            }
            return tBJBufferData;
        }
        catch (Throwable throwable) {
            block36: {
                Object var20_22 = null;
                if (!this.buffer.isPathOn()) break block36;
                this.buffer.exiting(TRACE, "loadData");
            }
            throw throwable;
        }
    }

    public void insertRecord(Object transaction, String tableName, BufferRecord record) throws BufferNotAvailableException, IllegalArgumentException, NoMemoryAvailableException, DuplicateKeyException, BufferResetException {
        TBJBufferRecord rec = (TBJBufferRecord)record;
        int result = 2;
        int fcode = 0;
        String method = "insertRecord(Object, String, BufferRecord)";
        String methodName = "insertRecord";
        this.buffer.checkAndSetTraceLevel(TRACE);
        if (this.buffer.isPathOn()) {
            this.buffer.entering(TRACE, "insertRecord(Object, String, BufferRecord)", new Object[]{transaction, tableName, record});
        }
        try {
            if (!this.buffer.isReady()) {
                throw this.buffer.getAndLogBufferNotAvailableException(this.getClass(), "insertRecord");
            }
            if (tableName == null || record == null) {
                String syslogDetails = tableName == null ? "tableName = null" : "record = null for \"" + tableName + "\"";
                throw (IllegalArgumentException)this.buffer.getAndLogBufferException(1, this.getClass(), "insertRecord", new Object[]{syslogDetails});
            }
            if (!rec.isValid()) {
                throw (IllegalArgumentException)this.buffer.getAndLogBufferException(1, this.getClass(), "insertRecord", new Object[]{"record \"" + record.toString() + "\" of \"" + tableName + "\" is not valid"});
            }
            TBJBuffer tBJBuffer = this.buffer;
            synchronized (tBJBuffer) {
                this.buffer.syncBegin();
                TBJBufferDirectory dir = this.buffer.getDirectory();
                if (this.buffer.isDebugOn()) {
                    this.buffer.trace(100, TRACE, "    #Tables= " + dir.getTableCount() + ", #Objects= " + dir.getObjectCount());
                }
                result = this.modify(dir, fcode, transaction, tableName, rec);
                if (this.buffer.isDebugOn()) {
                    this.buffer.trace(100, TRACE, "    #Tables= " + dir.getTableCount() + ", #Objects= " + dir.getObjectCount());
                }
                this.buffer.syncEnd();
            }
            if (result == 3) {
                throw (IllegalArgumentException)this.buffer.getAndLogBufferException(1, this.getClass(), "insertRecord", new Object[]{"record key of \"" + tableName + "\" contains NULL values"});
            }
            if (result == 1) {
                throw (DuplicateKeyException)this.buffer.getAndLogBufferException(6, this.getClass(), "insertRecord", new Object[]{record, tableName});
            }
            Object var13_13 = null;
            if (this.buffer.isPathOn()) {
                this.buffer.exiting(TRACE, "insertRecord" + (result == 0 ? ": ok" : (result == 1 ? ": failed" : "")));
            }
            return;
        }
        catch (Throwable throwable) {
            block14: {
                Object var13_14 = null;
                if (!this.buffer.isPathOn()) break block14;
                this.buffer.exiting(TRACE, "insertRecord" + (result == 0 ? ": ok" : (result == 1 ? ": failed" : "")));
            }
            throw throwable;
        }
    }

    public void updateRecord(Object transaction, String tableName, BufferRecord record) throws BufferNotAvailableException, IllegalArgumentException, NoMemoryAvailableException, RecordNotFoundException, BufferResetException {
        TBJBufferRecord rec = (TBJBufferRecord)record;
        int result = 2;
        int fcode = 1;
        String method = "updateRecord(Object, String, BufferRecord)";
        String methodName = "updateRecord";
        this.buffer.checkAndSetTraceLevel(TRACE);
        if (this.buffer.isPathOn()) {
            this.buffer.entering(TRACE, "updateRecord(Object, String, BufferRecord)", new Object[]{transaction, tableName, record});
        }
        try {
            if (!this.buffer.isReady()) {
                throw this.buffer.getAndLogBufferNotAvailableException(this.getClass(), "updateRecord");
            }
            if (tableName == null || record == null) {
                String syslogDetails = tableName == null ? "tableName = null" : "record = null for \"" + tableName + "\"";
                throw (IllegalArgumentException)this.buffer.getAndLogBufferException(1, this.getClass(), "updateRecord", new Object[]{syslogDetails});
            }
            TBJBuffer tBJBuffer = this.buffer;
            synchronized (tBJBuffer) {
                this.buffer.syncBegin();
                TBJBufferDirectory dir = this.buffer.getDirectory();
                if (this.buffer.isDebugOn()) {
                    this.buffer.trace(100, TRACE, "    #Tables= " + dir.getTableCount() + ", #Objects= " + dir.getObjectCount());
                }
                result = this.modify(dir, fcode, transaction, tableName, rec);
                if (this.buffer.isDebugOn()) {
                    this.buffer.trace(100, TRACE, "    #Tables= " + dir.getTableCount() + ", #Objects= " + dir.getObjectCount());
                }
                this.buffer.syncEnd();
            }
            if (result == 3) {
                throw (IllegalArgumentException)this.buffer.getAndLogBufferException(1, this.getClass(), "updateRecord", new Object[]{"record \"" + record + "\" of object \"" + tableName + "\" is invalid"});
            }
            if (result == 1) {
                throw (RecordNotFoundException)this.buffer.getAndLogBufferException(7, this.getClass(), "updateRecord", new Object[]{record, tableName});
            }
            Object var13_13 = null;
            if (this.buffer.isPathOn()) {
                this.buffer.exiting(TRACE, "updateRecord" + (result == 0 ? ": ok" : (result == 1 ? ": failed" : "")));
            }
            return;
        }
        catch (Throwable throwable) {
            block13: {
                Object var13_14 = null;
                if (!this.buffer.isPathOn()) break block13;
                this.buffer.exiting(TRACE, "updateRecord" + (result == 0 ? ": ok" : (result == 1 ? ": failed" : "")));
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void deleteRecords(Object transaction, String tableName, BufferRecord key, BufferRecordProcessor processor) throws BufferNotAvailableException, IllegalArgumentException, RecordNotFoundException, BufferResetException, ExternalBufferException {
        TBJBufferDirectory dir = null;
        TBJBufferGenericDirectory genDir = null;
        TBJBufferKey tbKey = (TBJBufferKey)key;
        TBJBufferKey genericKey = null;
        int givenKeyCount = tbKey == null ? 0 : tbKey.getValueCount();
        int genKeyCount = 0;
        boolean txRuns = transaction != null;
        int result = 2;
        String method = "deleteRecords(Object, String, BufferRecord, Object)";
        String methodName = "deleteRecords";
        this.buffer.checkAndSetTraceLevel(TRACE);
        if (this.buffer.isPathOn()) {
            this.buffer.entering(TRACE, "deleteRecords(Object, String, BufferRecord, Object)", new Object[]{transaction, tableName, key, processor});
        }
        try {
            block36: {
                if (!this.buffer.isReady()) {
                    throw this.buffer.getAndLogBufferNotAvailableException(this.getClass(), "deleteRecords");
                }
                if (tableName == null) {
                    throw (IllegalArgumentException)this.buffer.getAndLogBufferException(1, this.getClass(), "deleteRecords", new Object[]{"tableName = null"});
                }
                if (tbKey != null && !tbKey.isValid()) {
                    throw (IllegalArgumentException)this.buffer.getAndLogBufferException(1, this.getClass(), "deleteRecords", new Object[]{"given key is not valid for \"" + tableName + "\""});
                }
                TBJBuffer tBJBuffer = this.buffer;
                // MONITORENTER : tBJBuffer
                try {
                    block35: {
                        try {
                            TBJBufferObject object2;
                            TBJBufferKey givenKey;
                            boolean fullKeyGiven;
                            this.buffer.syncBegin();
                            dir = this.buffer.getDirectory();
                            if (this.buffer.isDebugOn()) {
                                this.buffer.trace(100, TRACE, "    #Tables= " + dir.getTableCount() + ", #Objects= " + dir.getObjectCount());
                            }
                            TBJBufferTransactionHandling tx = dir.getTxHandling();
                            TBJBufferTable table = dir.getTable(tableName);
                            if (table == null) {
                                if (!txRuns) {
                                    if (this.buffer.isDebugOn()) {
                                        this.buffer.trace(100, TRACE, "    table not defined, no transaction");
                                    }
                                    Object var26_18 = null;
                                    if (this.buffer.isDebugOn() && dir != null) {
                                        this.buffer.trace(100, TRACE, "    #Tables= " + dir.getTableCount() + ", #Objects= " + dir.getObjectCount());
                                    }
                                    this.buffer.syncEnd();
                                    // MONITOREXIT : tBJBuffer
                                    Object var29_23 = null;
                                    if (!this.buffer.isPathOn()) return;
                                    this.buffer.exiting(TRACE, "deleteRecords" + (result == 0 ? ": ok" : (result == 1 ? ": failed" : "")));
                                    return;
                                }
                                this.buffer.beginModification();
                                table = dir.createDummyTable(tableName);
                                this.buffer.endModification();
                                TBJBufferObject object2 = table.getObject();
                                object2.beginModification();
                                object2.invalidate(this.buffer, txRuns);
                                tx.setModification(this.buffer, transaction, object2);
                                object2.endModification();
                                if (this.buffer.isDebugOn()) {
                                    this.buffer.trace(100, TRACE, "    #Tables= " + dir.getTableCount() + ", #Objects= " + dir.getObjectCount());
                                }
                                Object var26_19 = null;
                                if (this.buffer.isDebugOn() && dir != null) {
                                    this.buffer.trace(100, TRACE, "    #Tables= " + dir.getTableCount() + ", #Objects= " + dir.getObjectCount());
                                }
                                this.buffer.syncEnd();
                                // MONITOREXIT : tBJBuffer
                                Object var29_24 = null;
                                if (!this.buffer.isPathOn()) return;
                                this.buffer.exiting(TRACE, "deleteRecords" + (result == 0 ? ": ok" : (result == 1 ? ": failed" : "")));
                                return;
                            }
                            int keyCount = table.getKeyCount();
                            if (givenKeyCount == keyCount) {
                                fullKeyGiven = true;
                                givenKey = tbKey;
                            } else if (givenKeyCount < keyCount) {
                                fullKeyGiven = false;
                                givenKey = givenKeyCount == 0 ? new TBJBufferKey() : tbKey;
                            } else {
                                fullKeyGiven = true;
                                givenKey = tbKey.getKey(keyCount, null);
                            }
                            if (table.isGeneric()) {
                                genKeyCount = table.getGenKeyCount();
                                genDir = table.getGenericDirectory();
                                genericKey = givenKeyCount > genKeyCount ? givenKey.getKey(genKeyCount, null) : givenKey;
                                object2 = genDir.getObject(this.buffer, genericKey);
                            } else {
                                object2 = table.getObject();
                            }
                            if (object2 != null) {
                                object2.beginModification();
                                result = this.deleteRecordsOfObject(dir, object2, givenKey, fullKeyGiven, keyCount, txRuns, processor);
                                tx.setModification(this.buffer, transaction, object2);
                                object2.endModification();
                                break block35;
                            }
                            if (givenKeyCount < genKeyCount) {
                                TBJBufferDirectoryIterator iter = genDir.getObjects(this.buffer, genericKey);
                                while (iter.hasNext()) {
                                    object2 = iter.next();
                                    if (object2 == null || object2.isDummy()) continue;
                                    if (!object2.matchKey(this.buffer, genericKey)) break;
                                    object2.beginModification();
                                    this.deleteRecordsOfObject(dir, object2, givenKey, fullKeyGiven, keyCount, txRuns, processor);
                                    tx.setModification(this.buffer, transaction, object2);
                                    object2.endModification();
                                }
                            }
                            if (!txRuns) break block35;
                            object2 = genDir.checkDummies(this.buffer, genericKey);
                            if (object2 == null) {
                                this.buffer.beginModification();
                                object2 = dir.createDummyObject(table, genericKey);
                                this.buffer.endModification();
                            }
                            object2.beginModification();
                            object2.invalidate(this.buffer, txRuns);
                            tx.setModification(this.buffer, transaction, object2);
                            object2.endModification();
                        }
                        catch (TypeMismatchException ex) {
                            dir.removeInconsistentTable(tableName, transaction);
                            this.buffer.getAndLogBufferException(5, this.getClass(), "deleteRecords", new Object[]{tableName}, ex);
                            Object var26_21 = null;
                            if (this.buffer.isDebugOn() && dir != null) {
                                this.buffer.trace(100, TRACE, "    #Tables= " + dir.getTableCount() + ", #Objects= " + dir.getObjectCount());
                            }
                            this.buffer.syncEnd();
                            break block36;
                        }
                        catch (BufferResetException ex) {
                            throw ex;
                        }
                        catch (ExternalBufferException ex) {
                            throw ex;
                        }
                    }
                    Object var26_20 = null;
                    if (this.buffer.isDebugOn() && dir != null) {
                        this.buffer.trace(100, TRACE, "    #Tables= " + dir.getTableCount() + ", #Objects= " + dir.getObjectCount());
                    }
                    this.buffer.syncEnd();
                }
                catch (Throwable throwable) {
                    Object var26_22 = null;
                    if (this.buffer.isDebugOn() && dir != null) {
                        this.buffer.trace(100, TRACE, "    #Tables= " + dir.getTableCount() + ", #Objects= " + dir.getObjectCount());
                    }
                    this.buffer.syncEnd();
                    throw throwable;
                }
            }
            // MONITOREXIT : tBJBuffer
            if (result == 1) {
                throw (RecordNotFoundException)this.buffer.getAndLogBufferException(7, this.getClass(), "deleteRecords", new Object[]{key, tableName});
            }
            Object var29_25 = null;
            if (!this.buffer.isPathOn()) return;
            this.buffer.exiting(TRACE, "deleteRecords" + (result == 0 ? ": ok" : (result == 1 ? ": failed" : "")));
            return;
        }
        catch (Throwable throwable) {
            Object var29_26 = null;
            if (!this.buffer.isPathOn()) throw throwable;
            this.buffer.exiting(TRACE, "deleteRecords" + (result == 0 ? ": ok" : (result == 1 ? ": failed" : "")));
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void invalidateObject(Object transaction, String tableName, BufferRecord key) throws BufferNotAvailableException, IllegalArgumentException {
        TBJBufferDirectory dir = null;
        TBJBufferKey givenKey = (TBJBufferKey)key;
        int givenKeyCount = givenKey == null ? 0 : givenKey.getValueCount();
        boolean txRuns = transaction != null;
        String method = "invalidateObject(Object, String, BufferRecord)";
        String methodName = "invalidateObject";
        this.buffer.checkAndSetTraceLevel(TRACE);
        if (this.buffer.isPathOn()) {
            this.buffer.entering(TRACE, "invalidateObject(Object, String, BufferRecord)", new Object[]{transaction, tableName, key});
        }
        try {
            if (!this.buffer.isReady()) {
                throw this.buffer.getAndLogBufferNotAvailableException(this.getClass(), "invalidateObject");
            }
            if (tableName == null) {
                throw (IllegalArgumentException)this.buffer.getAndLogBufferException(1, this.getClass(), "invalidateObject", new Object[]{"tableName = null"});
            }
            if (givenKey != null && !givenKey.isValid()) {
                throw (IllegalArgumentException)this.buffer.getAndLogBufferException(1, this.getClass(), "invalidateObject", new Object[]{"given key is not valid for \"" + tableName + "\""});
            }
            TBJBuffer tBJBuffer = this.buffer;
            synchronized (tBJBuffer) {
                block32: {
                    try {
                        block31: {
                            try {
                                int genKeyCount;
                                TBJBufferKey genericKey;
                                this.buffer.syncBegin();
                                dir = this.buffer.getDirectory();
                                if (this.buffer.isDebugOn()) {
                                    this.buffer.trace(100, TRACE, "    #Tables= " + dir.getTableCount() + ", #Objects= " + dir.getObjectCount());
                                }
                                TBJBufferTransactionHandling tx = dir.getTxHandling();
                                TBJBufferTable table = dir.getTable(tableName);
                                if (table == null) {
                                    if (!txRuns) {
                                        if (this.buffer.isDebugOn()) {
                                            this.buffer.trace(100, TRACE, "    table not defined, no transaction");
                                        }
                                        Object var22_13 = null;
                                        if (this.buffer.isDebugOn() && dir != null) {
                                            this.buffer.trace(100, TRACE, "    #Tables= " + dir.getTableCount() + ", #Objects= " + dir.getObjectCount());
                                        }
                                        this.buffer.syncEnd();
                                        // MONITOREXIT @DISABLED, blocks:[0, 2, 3, 5, 21, 22] lbl36 : MonitorExitStatement: MONITOREXIT : var17_10
                                        Object var25_18 = null;
                                        if (!this.buffer.isPathOn()) return;
                                        this.buffer.exiting(TRACE, "invalidateObject");
                                        return;
                                    }
                                    this.buffer.beginModification();
                                    table = dir.createDummyTable(tableName);
                                    this.buffer.endModification();
                                }
                                int keyCount = table.getKeyCount();
                                if (!table.isGeneric()) {
                                    boolean fullKeyGiven;
                                    int bufType = table.getBufType();
                                    TBJBufferObject object = table.getObject();
                                    object.beginModification();
                                    boolean bl = fullKeyGiven = bufType == 2 && table.getKeyCount() == givenKeyCount;
                                    if (fullKeyGiven) {
                                        try {
                                            this.deleteRecordsOfObject(dir, object, givenKey, fullKeyGiven, keyCount, txRuns, null);
                                        }
                                        catch (ExternalBufferException ex) {}
                                    } else {
                                        object.invalidate(this.buffer, txRuns);
                                    }
                                    tx.setModification(this.buffer, transaction, object);
                                    object.endModification();
                                    break block31;
                                }
                                TBJBufferGenericDirectory genDir = table.getGenericDirectory();
                                TBJBufferObject object = genDir.getObject(this.buffer, genericKey = givenKeyCount > (genKeyCount = table.getGenKeyCount()) ? givenKey.getKey(genKeyCount, null) : (givenKeyCount == 0 ? new TBJBufferKey() : givenKey));
                                if (object != null) {
                                    object.beginModification();
                                    object.invalidate(this.buffer, txRuns);
                                    tx.setModification(this.buffer, transaction, object);
                                    object.endModification();
                                    break block31;
                                }
                                if (givenKeyCount < genKeyCount) {
                                    TBJBufferDirectoryIterator iter = genDir.getObjects(this.buffer, genericKey);
                                    while (iter.hasNext()) {
                                        object = iter.next();
                                        if (object == null) continue;
                                        if (!object.matchKey(this.buffer, genericKey)) break;
                                        object.beginModification();
                                        object.invalidate(this.buffer, txRuns);
                                        tx.setModification(this.buffer, transaction, object);
                                        object.endModification();
                                    }
                                }
                                if (!txRuns) break block31;
                                object = genDir.checkDummies(this.buffer, genericKey);
                                if (object != null) {
                                    object.beginModification();
                                    object.invalidate(this.buffer, txRuns);
                                    tx.setModification(this.buffer, transaction, object);
                                    object.endModification();
                                    break block31;
                                }
                                this.buffer.beginModification();
                                object = dir.createDummyObject(table, genericKey);
                                this.buffer.endModification();
                                object.beginModification();
                                object.invalidate(this.buffer, txRuns);
                                tx.setModification(this.buffer, transaction, object);
                                object.endModification();
                            }
                            catch (TypeMismatchException ex) {
                                dir.removeInconsistentTable(tableName, transaction);
                                this.buffer.getAndLogBufferException(5, this.getClass(), "invalidateObject", new Object[]{tableName}, ex);
                                Object var22_15 = null;
                                if (this.buffer.isDebugOn() && dir != null) {
                                    this.buffer.trace(100, TRACE, "    #Tables= " + dir.getTableCount() + ", #Objects= " + dir.getObjectCount());
                                }
                                this.buffer.syncEnd();
                                break block32;
                            }
                            catch (BufferResetException ex) {
                                Object var22_16 = null;
                                if (this.buffer.isDebugOn() && dir != null) {
                                    this.buffer.trace(100, TRACE, "    #Tables= " + dir.getTableCount() + ", #Objects= " + dir.getObjectCount());
                                }
                                this.buffer.syncEnd();
                            }
                        }
                        Object var22_14 = null;
                        if (this.buffer.isDebugOn() && dir != null) {
                            this.buffer.trace(100, TRACE, "    #Tables= " + dir.getTableCount() + ", #Objects= " + dir.getObjectCount());
                        }
                        this.buffer.syncEnd();
                    }
                    catch (Throwable throwable) {
                        Object var22_17 = null;
                        if (this.buffer.isDebugOn() && dir != null) {
                            this.buffer.trace(100, TRACE, "    #Tables= " + dir.getTableCount() + ", #Objects= " + dir.getObjectCount());
                        }
                        this.buffer.syncEnd();
                        throw throwable;
                    }
                }
            }
            Object var25_19 = null;
            if (!this.buffer.isPathOn()) return;
            this.buffer.exiting(TRACE, "invalidateObject");
            return;
        }
        catch (Throwable throwable) {
            Object var25_20 = null;
            if (!this.buffer.isPathOn()) throw throwable;
            this.buffer.exiting(TRACE, "invalidateObject");
            throw throwable;
        }
    }

    public void removeObject(String tableName) throws BufferNotAvailableException, IllegalArgumentException, BufferResetException {
        String method = "removeObject(String)";
        String methodName = "removeObject";
        this.buffer.checkAndSetTraceLevel(TRACE);
        if (this.buffer.isPathOn()) {
            this.buffer.entering(TRACE, "removeObject(String)", new Object[]{tableName});
        }
        try {
            if (!this.buffer.isReady()) {
                throw this.buffer.getAndLogBufferNotAvailableException(this.getClass(), "removeObject");
            }
            if (tableName == null) {
                throw (IllegalArgumentException)this.buffer.getAndLogBufferException(1, this.getClass(), "removeObject", new Object[]{"tableName = null"});
            }
            TBJBuffer tBJBuffer = this.buffer;
            synchronized (tBJBuffer) {
                this.buffer.syncBegin();
                TBJBufferDirectory dir = this.buffer.getDirectory();
                if (this.buffer.isDebugOn()) {
                    this.buffer.trace(100, TRACE, "    #Tables= " + dir.getTableCount() + ", #Objects= " + dir.getObjectCount());
                }
                this.buffer.beginModification();
                dir.removeTable(tableName);
                this.buffer.endModification();
                if (this.buffer.isDebugOn()) {
                    this.buffer.trace(100, TRACE, "    #Tables= " + dir.getTableCount() + ", #Objects= " + dir.getObjectCount());
                }
                this.buffer.syncEnd();
            }
            Object var8_7 = null;
            if (this.buffer.isPathOn()) {
                this.buffer.exiting(TRACE, "removeObject");
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (this.buffer.isPathOn()) {
                this.buffer.exiting(TRACE, "removeObject");
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resetObject(String tableName, BufferRecord key) throws BufferNotAvailableException, IllegalArgumentException, ObjectInconsistentException, BufferResetException {
        TBJBufferDirectory dir = null;
        TBJBufferKey givenKey = (TBJBufferKey)key;
        TBJBufferKey genericKey = null;
        TBJBufferGenericDirectory genDir = null;
        int genKeyCount = 0;
        int givenKeyCount = givenKey == null ? 0 : givenKey.getValueCount();
        String method = "resetObject(String, BufferRecord)";
        String methodName = "resetObject";
        this.buffer.checkAndSetTraceLevel(TRACE);
        if (this.buffer.isPathOn()) {
            this.buffer.entering(TRACE, "resetObject(String, BufferRecord)", new Object[]{tableName, key});
        }
        try {
            if (!this.buffer.isReady()) {
                throw this.buffer.getAndLogBufferNotAvailableException(this.getClass(), "resetObject");
            }
            if (tableName == null) {
                throw (IllegalArgumentException)this.buffer.getAndLogBufferException(1, this.getClass(), "resetObject", new Object[]{"tableName = null"});
            }
            if (givenKey != null && !givenKey.isValid()) {
                throw (IllegalArgumentException)this.buffer.getAndLogBufferException(1, this.getClass(), "resetObject", new Object[]{"given key is not valid for \"" + tableName + "\""});
            }
            TBJBuffer tBJBuffer = this.buffer;
            synchronized (tBJBuffer) {
                try {
                    block20: {
                        try {
                            TBJBufferObject object;
                            TBJBufferTable table;
                            this.buffer.syncBegin();
                            dir = this.buffer.getDirectory();
                            if (this.buffer.isDebugOn()) {
                                this.buffer.trace(100, TRACE, "    #Tables= " + dir.getTableCount() + ", #Objects= " + dir.getObjectCount());
                            }
                            if ((table = dir.getTable(tableName)) == null) {
                                if (this.buffer.isDebugOn()) {
                                    this.buffer.trace(100, TRACE, "    table  \"" + tableName + "\" not defined");
                                }
                                Object var17_13 = null;
                                this.buffer.syncEnd();
                                // MONITOREXIT @DISABLED, blocks:[0, 2, 3, 4, 13] lbl33 : MonitorExitStatement: MONITOREXIT : var13_11
                                Object var20_16 = null;
                                if (!this.buffer.isPathOn()) return;
                                this.buffer.exiting(TRACE, "resetObject");
                                return;
                            }
                            if (table.isGeneric()) {
                                genDir = table.getGenericDirectory();
                                genKeyCount = table.getGenKeyCount();
                                genericKey = givenKeyCount > genKeyCount ? givenKey.getKey(genKeyCount, null) : (givenKeyCount == 0 ? new TBJBufferKey() : givenKey);
                                object = genDir.getObject(this.buffer, genericKey);
                            } else {
                                object = table.getObject();
                            }
                            if (object != null) {
                                object.reset(this.buffer);
                                break block20;
                            }
                            if (givenKeyCount >= genKeyCount) break block20;
                            TBJBufferDirectoryIterator iter = genDir.getObjects(this.buffer, genericKey);
                            while (iter.hasNext()) {
                                object = iter.next();
                                if (object == null) continue;
                                if (!object.matchKey(this.buffer, genericKey)) break;
                                object.reset(this.buffer);
                            }
                        }
                        catch (TypeMismatchException ex) {
                            this.buffer.beginModification();
                            dir.removeInconsistentTable(tableName, null);
                            this.buffer.endModification();
                            throw (ObjectInconsistentException)this.buffer.getAndLogBufferException(5, this.getClass(), "resetObject", new Object[]{"whiling resetting object " + tableName}, ex);
                        }
                        catch (BufferResetException ex) {
                            throw ex;
                        }
                    }
                    Object var17_14 = null;
                    this.buffer.syncEnd();
                }
                catch (Throwable throwable) {
                    Object var17_15 = null;
                    this.buffer.syncEnd();
                    throw throwable;
                }
            }
            Object var20_17 = null;
            if (!this.buffer.isPathOn()) return;
            this.buffer.exiting(TRACE, "resetObject");
            return;
        }
        catch (Throwable throwable) {
            Object var20_18 = null;
            if (!this.buffer.isPathOn()) throw throwable;
            this.buffer.exiting(TRACE, "resetObject");
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BufferObjectInfo getObjectInfo(String tableName, BufferRecord key) throws BufferNotAvailableException, ObjectNotDefinedException, IllegalArgumentException, BufferResetException {
        TBJBufferObjectInfo tBJBufferObjectInfo;
        TBJBufferKey givenKey = (TBJBufferKey)key;
        String method = "getObjectInfo(String, BufferRecord)";
        String methodName = "getObjectInfo";
        this.buffer.checkAndSetTraceLevel(TRACE);
        if (this.buffer.isPathOn()) {
            this.buffer.entering(TRACE, "getObjectInfo(String, BufferRecord)", new Object[]{tableName, key});
        }
        try {
            TBJBufferObject object;
            if (!this.buffer.isReady()) {
                throw this.buffer.getAndLogBufferNotAvailableException(this.getClass(), "getObjectInfo");
            }
            if (tableName == null) {
                throw (IllegalArgumentException)this.buffer.getAndLogBufferException(1, this.getClass(), "getObjectInfo", new Object[]{"tableName = null"});
            }
            if (givenKey != null && !givenKey.isValid()) {
                throw (IllegalArgumentException)this.buffer.getAndLogBufferException(1, this.getClass(), "getObjectInfo", new Object[]{"given key is not valid for \"" + tableName + "\""});
            }
            TBJBufferDirectory dir = this.buffer.getDirectory();
            if (this.buffer.isDebugOn()) {
                this.buffer.trace(100, TRACE, "    #Tables= " + dir.getTableCount() + ", #Objects= " + dir.getObjectCount());
            }
            try {
                object = dir.locateObjectWithWait(tableName, givenKey, false, false);
            }
            catch (ObjectNotDefinedException ex) {
                throw ex;
            }
            catch (IllegalArgumentException ex) {
                throw ex;
            }
            catch (BufferResetException ex) {
                throw ex;
            }
            catch (ObjectInconsistentException ex) {
                BufferObjectInfo bufferObjectInfo = null;
                Object var15_15 = null;
                if (!this.buffer.isPathOn()) return bufferObjectInfo;
                this.buffer.exiting(TRACE, "getObjectInfo");
                return bufferObjectInfo;
            }
            if (object == null) {
                BufferObjectInfo bufferObjectInfo = null;
                Object var15_16 = null;
                if (!this.buffer.isPathOn()) return bufferObjectInfo;
                this.buffer.exiting(TRACE, "getObjectInfo");
                return bufferObjectInfo;
            }
            object.waitAndLockHotObject(this.buffer);
            TBJBufferObjectInfo info = object.getInfo();
            object.unlockHotObject();
            if (this.buffer.isDebugOn()) {
                this.buffer.trace(100, TRACE, "    #Tables= " + dir.getTableCount() + ", #Objects= " + dir.getObjectCount());
            }
            tBJBufferObjectInfo = info;
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            if (!this.buffer.isPathOn()) throw throwable;
            this.buffer.exiting(TRACE, "getObjectInfo");
            throw throwable;
        }
        Object var15_17 = null;
        if (!this.buffer.isPathOn()) return tBJBufferObjectInfo;
        this.buffer.exiting(TRACE, "getObjectInfo");
        return tBJBufferObjectInfo;
    }

    public void commit(Object transaction) throws BufferNotAvailableException, BufferResetException {
        String method = "commit(Object)";
        String methodName = "commit";
        this.buffer.checkAndSetTraceLevel(TRACE);
        if (this.buffer.isPathOn()) {
            this.buffer.entering(TRACE, "commit(Object)", new Object[]{transaction});
        }
        try {
            if (!this.buffer.isReady()) {
                throw this.buffer.getAndLogBufferNotAvailableException(this.getClass(), "commit");
            }
            if (transaction == null) {
                if (this.buffer.isDebugOn()) {
                    this.buffer.trace(100, TRACE, "    no transaction");
                }
                Object var8_4 = null;
                if (this.buffer.isPathOn()) {
                    this.buffer.exiting(TRACE, "commit");
                }
                return;
            }
            TBJBuffer tBJBuffer = this.buffer;
            synchronized (tBJBuffer) {
                this.buffer.syncBegin();
                TBJBufferDirectory dir = this.buffer.getDirectory();
                if (this.buffer.isDebugOn()) {
                    this.buffer.trace(100, TRACE, "    #Tables= " + dir.getTableCount() + ", #Objects= " + dir.getObjectCount());
                }
                this.endTransaction(this.buffer, false, dir, transaction);
                if (this.buffer.isDebugOn()) {
                    this.buffer.trace(100, TRACE, "    #Tables= " + dir.getTableCount() + ", #Objects= " + dir.getObjectCount());
                }
                this.buffer.syncEnd();
            }
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            if (this.buffer.isPathOn()) {
                this.buffer.exiting(TRACE, "commit");
            }
            throw throwable;
        }
        Object var8_5 = null;
        if (this.buffer.isPathOn()) {
            this.buffer.exiting(TRACE, "commit");
        }
    }

    public void rollback(Object transaction) throws BufferNotAvailableException, BufferResetException {
        String method = "rollback(Object)";
        String methodName = "rollback";
        this.buffer.checkAndSetTraceLevel(TRACE);
        if (this.buffer.isPathOn()) {
            this.buffer.entering(TRACE, "rollback(Object)", new Object[]{transaction});
        }
        try {
            if (!this.buffer.isReady()) {
                throw this.buffer.getAndLogBufferNotAvailableException(this.getClass(), "rollback");
            }
            if (transaction == null) {
                if (this.buffer.isDebugOn()) {
                    this.buffer.trace(100, TRACE, "    no transaction");
                }
                Object var8_4 = null;
                if (this.buffer.isPathOn()) {
                    this.buffer.exiting(TRACE, "rollback");
                }
                return;
            }
            TBJBuffer tBJBuffer = this.buffer;
            synchronized (tBJBuffer) {
                this.buffer.syncBegin();
                TBJBufferDirectory dir = this.buffer.getDirectory();
                if (this.buffer.isDebugOn()) {
                    this.buffer.trace(100, TRACE, "    #Tables= " + dir.getTableCount() + ", #Objects= " + dir.getObjectCount());
                }
                this.endTransaction(this.buffer, true, dir, transaction);
                if (this.buffer.isDebugOn()) {
                    this.buffer.trace(100, TRACE, "    #Tables= " + dir.getTableCount() + ", #Objects= " + dir.getObjectCount());
                }
                this.buffer.syncEnd();
            }
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            if (this.buffer.isPathOn()) {
                this.buffer.exiting(TRACE, "rollback");
            }
            throw throwable;
        }
        Object var8_5 = null;
        if (this.buffer.isPathOn()) {
            this.buffer.exiting(TRACE, "rollback");
        }
    }

    public BufferRecord getBufferRecord(int numberOfFields) throws BufferNotAvailableException, NoMemoryAvailableException, IllegalArgumentException {
        String method = "getBufferRecord(int)";
        String methodName = "getBufferRecord";
        this.buffer.checkAndSetTraceLevel(TRACE);
        if (this.buffer.isPathOn()) {
            this.buffer.entering(TRACE, "getBufferRecord(int)", new Object[]{new Integer(numberOfFields)});
        }
        try {
            if (!this.buffer.isReady()) {
                throw this.buffer.getAndLogBufferNotAvailableException(this.getClass(), "getBufferRecord");
            }
            if (numberOfFields < 0) {
                throw (IllegalArgumentException)this.buffer.getAndLogBufferException(1, this.getClass(), "getBufferRecord", new Object[]{"numberOfFields < 0"});
            }
            TBJBufferRecord tBJBufferRecord = new TBJBufferRecord(numberOfFields);
            Object var6_5 = null;
            if (this.buffer.isPathOn()) {
                this.buffer.exiting(TRACE, "getBufferRecord");
            }
            return tBJBufferRecord;
        }
        catch (Throwable throwable) {
            block6: {
                Object var6_6 = null;
                if (!this.buffer.isPathOn()) break block6;
                this.buffer.exiting(TRACE, "getBufferRecord");
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BufferRecord getBufferKey(int numberOfKeyFields) {
        TBJBufferKey tBJBufferKey;
        String method = "getBufferKey(int)";
        String methodName = "getBufferKey";
        this.buffer.checkAndSetTraceLevel(TRACE);
        if (this.buffer.isPathOn()) {
            this.buffer.entering(TRACE, "getBufferKey(int)", new Object[]{new Integer(numberOfKeyFields)});
        }
        try {
            if (numberOfKeyFields < 0) {
                TBJBufferKey tBJBufferKey2 = new TBJBufferKey(0);
                Object var6_6 = null;
                if (!this.buffer.isPathOn()) return tBJBufferKey2;
                this.buffer.exiting(TRACE, "getBufferKey");
                return tBJBufferKey2;
            }
            tBJBufferKey = new TBJBufferKey(numberOfKeyFields);
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (!this.buffer.isPathOn()) throw throwable;
            this.buffer.exiting(TRACE, "getBufferKey");
            throw throwable;
        }
        Object var6_7 = null;
        if (!this.buffer.isPathOn()) return tBJBufferKey;
        this.buffer.exiting(TRACE, "getBufferKey");
        return tBJBufferKey;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isLoadable(long size) throws BufferNotAvailableException {
        boolean bl;
        String method = "isLoadable(long)";
        String methodName = "isLoadable";
        this.buffer.checkAndSetTraceLevel(TRACE);
        if (this.buffer.isPathOn()) {
            this.buffer.entering(TRACE, "isLoadable(long)", new Object[]{new Long(size)});
        }
        try {
            if (!this.buffer.isReady()) {
                throw this.buffer.getAndLogBufferNotAvailableException(this.getClass(), "isLoadable");
            }
            if (size > this.buffer.getMaxLobSize() || !this.buffer.memoryIsAvailable(size)) {
                boolean bl2 = false;
                Object var7_6 = null;
                if (!this.buffer.isPathOn()) return bl2;
                this.buffer.exiting(TRACE, "isLoadable");
                return bl2;
            }
            bl = true;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (!this.buffer.isPathOn()) throw throwable;
            this.buffer.exiting(TRACE, "isLoadable");
            throw throwable;
        }
        Object var7_7 = null;
        if (!this.buffer.isPathOn()) return bl;
        this.buffer.exiting(TRACE, "isLoadable");
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int modify(TBJBufferDirectory dir, int fcode, Object transaction, String tableName, TBJBufferRecord rec) {
        int ex3;
        int result;
        block43: {
            int n;
            block41: {
                int n2;
                block40: {
                    int n3;
                    block39: {
                        TBJBufferKey genericKey = null;
                        int givenColumnCount = rec.getValueCount();
                        boolean opWasSuccessful = false;
                        result = 2;
                        boolean txRuns = transaction != null;
                        boolean removeFromQueue = false;
                        if (this.buffer.isDebugOn()) {
                            this.buffer.trace(100, TRACE, "---> TBJBufferAccess.modify: " + fcode);
                        }
                        try {
                            try {
                                TBJBufferObject object;
                                TBJBufferTransactionHandling tx;
                                block42: {
                                    TBJBufferKey key;
                                    tx = dir.getTxHandling();
                                    TBJBufferTable table = dir.getTable(tableName);
                                    if (table == null) {
                                        if (!txRuns) {
                                            if (this.buffer.isDebugOn()) {
                                                this.buffer.trace(100, TRACE, "    table not defined, no transaction");
                                            }
                                            int n4 = result;
                                            Object var26_23 = null;
                                            if (!this.buffer.isDebugOn()) return n4;
                                            this.buffer.trace(100, TRACE, "<--- TBJBufferAccess.modify: " + (result == 0 ? ": ok" : (result == 1 ? ": failed" : "")));
                                            return n4;
                                        }
                                        table = dir.createDummyTable(tableName);
                                        fcode = 3;
                                    }
                                    int keyCount = table.getKeyCount();
                                    int genKeyCount = table.getGenKeyCount();
                                    int columnCount = table.getColumnCount();
                                    TBJBufferGenericDirectory genDir = table.getGenericDirectory();
                                    if (columnCount != 0 && givenColumnCount != columnCount || genKeyCount > keyCount) {
                                        if (this.buffer.isDebugOn()) {
                                            this.buffer.trace(100, TRACE, "    object is inconsistent");
                                        }
                                        dir.removeInconsistentTable(tableName, transaction);
                                        this.buffer.getAndLogBufferException(5, this.getClass(), "modify", new Object[]{tableName});
                                        n3 = 2;
                                        break block39;
                                    }
                                    if (keyCount > 0) {
                                        key = rec.getKey(keyCount, table.getKeyIndex());
                                        if (!key.isValid()) {
                                            n2 = 3;
                                            break block40;
                                        }
                                    } else {
                                        key = new TBJBufferKey();
                                    }
                                    if (table.isGeneric()) {
                                        genericKey = key.getKey(genKeyCount, null);
                                        object = genDir.getObject(this.buffer, genericKey);
                                    } else {
                                        object = table.getObject();
                                    }
                                    if (object == null) {
                                        object = genDir.checkDummies(this.buffer, genericKey);
                                        if (object == null) {
                                            if (!txRuns) {
                                                if (this.buffer.isDebugOn()) {
                                                    this.buffer.trace(100, TRACE, "    object not defined, no transaction");
                                                }
                                                n = result;
                                                break block41;
                                            }
                                            this.buffer.beginModification();
                                            object = dir.createDummyObject(table, genericKey);
                                            this.buffer.endModification();
                                        }
                                        fcode = 3;
                                    }
                                    object.beginModification();
                                    TBJBufferData data = object.getData();
                                    int status = object.getStatus();
                                    if (!object.isDummy() && !object.isHotObject() && status == 2) {
                                        int reachable = object.getReachability();
                                        if (reachable == 1) {
                                            fcode = 3;
                                            removeFromQueue = true;
                                        }
                                        if (this.buffer.isDebugOn()) {
                                            this.buffer.trace(100, TRACE, "    reachable= " + TBJBufferData.printReachability(reachable));
                                        }
                                    } else {
                                        if (this.buffer.isDebugOn()) {
                                            this.buffer.trace(100, TRACE, "    object is hot or dummy or status != VALID, but " + TBJBufferStatus.printStatus(status));
                                        }
                                        fcode = 3;
                                    }
                                    if (fcode == 0) {
                                        try {
                                            if (!this.buffer.memoryIsAvailable(rec.size())) {
                                                fcode = 3;
                                                break block42;
                                            }
                                            opWasSuccessful = data.insertRecord(this.buffer, table.getBufType(), key, rec);
                                            if (opWasSuccessful) {
                                                object.incrementModifications(true);
                                                result = 0;
                                                break block42;
                                            }
                                            if (this.buffer.isDebugOn()) {
                                                this.buffer.trace(100, TRACE, "    duplicate key");
                                            }
                                            result = 1;
                                            fcode = 3;
                                        }
                                        catch (DataWasDisplacedException ex2) {
                                            fcode = 3;
                                            removeFromQueue = true;
                                        }
                                    } else if (fcode == 1) {
                                        try {
                                            opWasSuccessful = data.updateRecord(this.buffer, table.getBufType(), key, rec);
                                            if (opWasSuccessful) {
                                                object.incrementModifications(true);
                                                result = 0;
                                            } else {
                                                if (this.buffer.isDebugOn()) {
                                                    this.buffer.trace(100, TRACE, "    record not found");
                                                }
                                                fcode = 3;
                                                result = 1;
                                            }
                                        }
                                        catch (DataWasDisplacedException ex3) {
                                            fcode = 3;
                                            removeFromQueue = true;
                                        }
                                    }
                                }
                                if (fcode == 3) {
                                    object.incrementModifications(false);
                                    object.invalidate(this.buffer, txRuns);
                                    if (removeFromQueue) {
                                        this.buffer.beginModification();
                                        dir.removeFromQueue(object);
                                        this.buffer.endModification();
                                    }
                                }
                                tx.setModification(this.buffer, transaction, object);
                                object.endModification();
                                ex3 = result;
                                break block43;
                            }
                            catch (TypeMismatchException ex4) {
                                dir.removeInconsistentTable(tableName, transaction);
                                this.buffer.getAndLogBufferException(5, this.getClass(), "modify", new Object[]{tableName}, ex4);
                                int n5 = 2;
                                Object var26_28 = null;
                                if (!this.buffer.isDebugOn()) return n5;
                                this.buffer.trace(100, TRACE, "<--- TBJBufferAccess.modify: " + (result == 0 ? ": ok" : (result == 1 ? ": failed" : "")));
                                return n5;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var26_29 = null;
                            if (!this.buffer.isDebugOn()) throw throwable;
                            this.buffer.trace(100, TRACE, "<--- TBJBufferAccess.modify: " + (result == 0 ? ": ok" : (result == 1 ? ": failed" : "")));
                            throw throwable;
                        }
                    }
                    Object var26_24 = null;
                    if (!this.buffer.isDebugOn()) return n3;
                    this.buffer.trace(100, TRACE, "<--- TBJBufferAccess.modify: " + (result == 0 ? ": ok" : (result == 1 ? ": failed" : "")));
                    return n3;
                }
                Object var26_25 = null;
                if (!this.buffer.isDebugOn()) return n2;
                this.buffer.trace(100, TRACE, "<--- TBJBufferAccess.modify: " + (result == 0 ? ": ok" : (result == 1 ? ": failed" : "")));
                return n2;
            }
            Object var26_26 = null;
            if (!this.buffer.isDebugOn()) return n;
            this.buffer.trace(100, TRACE, "<--- TBJBufferAccess.modify: " + (result == 0 ? ": ok" : (result == 1 ? ": failed" : "")));
            return n;
        }
        Object var26_27 = null;
        if (!this.buffer.isDebugOn()) return ex3;
        this.buffer.trace(100, TRACE, "<--- TBJBufferAccess.modify: " + (result == 0 ? ": ok" : (result == 1 ? ": failed" : "")));
        return ex3;
    }

    private void endTransaction(TBJBuffer buffer, boolean rollback, TBJBufferDirectory dir, Object transaction) {
        Set modifiedObjects;
        TBJBufferTransactionHandling tx;
        ArrayList<TBJBufferObject> dummyObjects = new ArrayList<TBJBufferObject>();
        if (buffer.isDebugOn()) {
            buffer.trace(100, TRACE, "---> TBJBufferAccess.endTransaction: rollback = " + rollback);
        }
        if ((tx = dir.getTxHandling()).getModCount() > 0L && (modifiedObjects = tx.getModifiedObjects(transaction)) != null) {
            TBJBufferObject object;
            Iterator iter = modifiedObjects.iterator();
            while (iter.hasNext()) {
                object = (TBJBufferObject)iter.next();
                if (object.isDummy() && object.getFixingCounter() <= 1) {
                    dummyObjects.add(object);
                    continue;
                }
                object.endTransaction(buffer, rollback);
            }
            int i = 0;
            while (i < dummyObjects.size()) {
                object = (TBJBufferObject)dummyObjects.get(i);
                object.beginModification();
                dir.removeObject(object);
                object.endModification();
                ++i;
            }
            tx.clearTransaction(buffer, transaction);
        }
        if (buffer.isDebugOn()) {
            buffer.trace(100, TRACE, "<--- TBJBufferAccess.endTransaction");
        }
    }

    private int deleteRecordsOfObject(TBJBufferDirectory dir, TBJBufferObject object, TBJBufferKey givenKey, boolean fullKeyGiven, int definedKeyCount, boolean txRuns, BufferRecordProcessor processor) throws TypeMismatchException, ExternalBufferException {
        TBJBufferData data = object.getData();
        int status = object.getStatus();
        boolean removeFromQueue = false;
        boolean found = false;
        int fcode = 3;
        int result = 2;
        if (!object.isDummy() && !object.isHotObject() && status == 2) {
            int reachable = object.getReachability();
            if (reachable != 1) {
                try {
                    found = data.deleteRecords(this.buffer, fullKeyGiven, definedKeyCount, givenKey, processor);
                    if (fullKeyGiven && !found) {
                        fcode = 3;
                        result = 1;
                    }
                    object.incrementModifications(true);
                    fcode = 2;
                    result = 0;
                }
                catch (DataWasDisplacedException ex) {
                    removeFromQueue = true;
                }
                catch (TypeMismatchException ex) {
                    throw ex;
                }
                catch (ExternalBufferException ex) {
                    object.incrementModifications(false);
                    object.invalidate(this.buffer, txRuns);
                    throw ex;
                }
            } else {
                removeFromQueue = true;
            }
            if (this.buffer.isDebugOn()) {
                this.buffer.trace(100, TRACE, "    reachable= " + TBJBufferData.printReachability(reachable));
            }
        }
        if (fcode == 3) {
            object.incrementModifications(false);
            object.invalidate(this.buffer, txRuns);
            if (removeFromQueue) {
                this.buffer.beginModification();
                dir.removeFromQueue(object);
                this.buffer.endModification();
            }
        }
        if (this.buffer.isDebugOn()) {
            this.buffer.trace(100, TRACE, "    status= " + TBJBufferStatus.printStatus(object.getStatus()));
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

