/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.buffer;

import com.sap.sql.buffer.BufferLoadAccess;
import com.sap.sql.buffer.BufferNotAvailableException;
import com.sap.sql.buffer.BufferObjectInfo;
import com.sap.sql.buffer.BufferRecord;
import com.sap.sql.buffer.BufferRecordProcessor;
import com.sap.sql.buffer.BufferResetException;
import com.sap.sql.buffer.DataLockedException;
import com.sap.sql.buffer.DataNotLoadableException;
import com.sap.sql.buffer.DuplicateKeyException;
import com.sap.sql.buffer.ExternalBufferException;
import com.sap.sql.buffer.IllegalArgumentException;
import com.sap.sql.buffer.NoMemoryAvailableException;
import com.sap.sql.buffer.ObjectExistsException;
import com.sap.sql.buffer.ObjectInconsistentException;
import com.sap.sql.buffer.ObjectNotDefinedException;
import com.sap.sql.buffer.RecordNotFoundException;
import java.sql.ResultSet;

public interface BufferAccess {
    public void defineObject(String var1, int var2, int var3, int var4, int[] var5) throws BufferNotAvailableException, ObjectExistsException, IllegalArgumentException, BufferResetException;

    public ResultSet getResultSet(String var1, BufferRecord var2, BufferRecordProcessor var3, int var4) throws BufferNotAvailableException, DataLockedException, DataNotLoadableException, ObjectNotDefinedException, ObjectInconsistentException, IllegalArgumentException, BufferResetException;

    public BufferLoadAccess loadData(String var1, BufferRecord var2) throws BufferNotAvailableException, NoMemoryAvailableException, DataLockedException, DataNotLoadableException, ObjectNotDefinedException, ObjectInconsistentException, IllegalArgumentException, BufferResetException;

    public void insertRecord(Object var1, String var2, BufferRecord var3) throws BufferNotAvailableException, IllegalArgumentException, NoMemoryAvailableException, DuplicateKeyException, BufferResetException;

    public void updateRecord(Object var1, String var2, BufferRecord var3) throws BufferNotAvailableException, IllegalArgumentException, NoMemoryAvailableException, RecordNotFoundException, BufferResetException;

    public void deleteRecords(Object var1, String var2, BufferRecord var3, BufferRecordProcessor var4) throws BufferNotAvailableException, IllegalArgumentException, RecordNotFoundException, BufferResetException, ExternalBufferException;

    public void invalidateObject(Object var1, String var2, BufferRecord var3) throws BufferNotAvailableException, IllegalArgumentException;

    public void removeObject(String var1) throws BufferNotAvailableException, IllegalArgumentException, BufferResetException;

    public void resetObject(String var1, BufferRecord var2) throws BufferNotAvailableException, IllegalArgumentException, ObjectInconsistentException, BufferResetException;

    public BufferObjectInfo getObjectInfo(String var1, BufferRecord var2) throws BufferNotAvailableException, ObjectNotDefinedException, IllegalArgumentException, BufferResetException;

    public void commit(Object var1) throws BufferNotAvailableException, BufferResetException;

    public void rollback(Object var1) throws BufferNotAvailableException, BufferResetException;

    public BufferRecord getBufferRecord(int var1) throws BufferNotAvailableException, NoMemoryAvailableException, IllegalArgumentException;

    public BufferRecord getBufferKey(int var1);

    public boolean isLoadable(long var1) throws BufferNotAvailableException;
}

