/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql;

import com.sap.sql.sqlj.common.runtime.ConnectionContextFactory;
import java.sql.SQLException;
import sqlj.runtime.ConnectionContext;
import sqlj.runtime.ExecutionContext;
import sqlj.runtime.profile.RTStatement;

public class BatchExecutionContext
extends ExecutionContext {
    private static final int AUTO_BATCH_SIZE = 100;
    private int m_batchLimit;

    public BatchExecutionContext() {
        super.setBatching(true);
    }

    public void setBatchLimit(int batchLimit) {
        if (batchLimit == -7) {
            super.setBatchLimit(-7);
        } else if (batchLimit == -8) {
            super.setBatchLimit(100);
        } else if (batchLimit > 0) {
            super.setBatchLimit(batchLimit);
        } else {
            throw new IllegalArgumentException("batch limit must not be negative");
        }
        this.m_batchLimit = batchLimit;
    }

    public int getBatchLimit() {
        return this.m_batchLimit;
    }

    public synchronized void setBatching(boolean doBatch) {
        if (!doBatch) {
            throw new IllegalArgumentException("BatchExecutionContext can't switch off batching");
        }
    }

    public RTStatement registerStatement(ConnectionContext connCtx, Object profileKey, int stmtNdx) throws SQLException {
        ConnectionContextFactory.trySettingExecutionContextViaBatch(connCtx);
        try {
            return super.registerStatement(connCtx, profileKey, stmtNdx);
        }
        catch (IllegalStateException ex) {
            this.cancel();
            throw ex;
        }
    }
}

