/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.data.values.meta.base;

import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.core.data.types.api.IComplexType;
import com.sap.caf.mp.core.data.types.api.IElement;
import com.sap.caf.mp.core.data.types.api.IMessage;
import com.sap.caf.mp.core.data.types.api.IMessagepart;
import com.sap.caf.mp.core.data.types.api.ISimpleType;
import com.sap.caf.mp.core.data.types.api.IStructure;
import com.sap.caf.mp.core.data.types.api.IType;
import com.sap.caf.mp.core.data.values.api.IComplexTypeValue;
import com.sap.caf.mp.core.data.values.api.IElementValue;
import com.sap.caf.mp.core.data.values.api.IMessageValue;
import com.sap.caf.mp.core.data.values.api.IMessagepartValue;
import com.sap.caf.mp.core.data.values.api.ISimpleTypeValue;
import com.sap.caf.mp.core.data.values.api.IStructureValue;
import com.sap.caf.mp.core.data.values.api.ITypeValue;
import com.sap.caf.mp.core.data.values.base.ComplexTypeValue;
import com.sap.caf.mp.core.data.values.base.ElementValue;
import com.sap.caf.mp.core.data.values.base.MessageValue;
import com.sap.caf.mp.core.data.values.base.MessagepartValue;
import com.sap.caf.mp.core.data.values.base.SimpleTypeValue;
import com.sap.caf.mp.core.data.values.meta.api.ITypeValueFactory;
import com.sap.caf.mp.core.data.values.meta.api.ITypeValueRejection;

public class TypeValueFactory
implements ITypeValueFactory {
    public IComplexTypeValue createComplexTypeValue(IComplexType type) throws InvocationException {
        return new ComplexTypeValue(type);
    }

    public IElementValue createElementValue(IElement type) throws InvocationException {
        return new ElementValue(type);
    }

    public IMessageValue createMessageValue(IMessage message) throws InvocationException {
        return new MessageValue(message);
    }

    public IMessagepartValue createMessagepartValue(IMessagepart messagepart) throws InvocationException {
        return new MessagepartValue(messagepart);
    }

    public ISimpleTypeValue createSimpleTypeValue(ISimpleType type) throws InvocationException {
        return new SimpleTypeValue(type);
    }

    public IStructureValue createStructureValue(IStructure type) throws InvocationException {
        if (type == null) {
            throw new InvocationException("Structure invalid");
        }
        switch (type.getStructureCast()) {
            case 1: {
                return this.createElementValue((IElement)type);
            }
            case 2: {
                return this.createTypeValue((IType)type);
            }
        }
        throw new InvocationException("Structure unknown");
    }

    public ITypeValue createTypeValue(IType type) throws InvocationException {
        if (type == null) {
            throw new InvocationException("Type invalid");
        }
        switch (type.getTypeCast()) {
            case 1: {
                return this.createComplexTypeValue((IComplexType)type);
            }
            case 2: {
                return this.createSimpleTypeValue((ISimpleType)type);
            }
        }
        throw new InvocationException("Type unknown");
    }

    public ITypeValueRejection validateComplexTypeValue(IComplexTypeValue value) {
        return null;
    }

    public ITypeValueRejection validateElementValue(IElementValue value) {
        return null;
    }

    public ITypeValueRejection validateMessageValue(IMessageValue value) {
        return null;
    }

    public ITypeValueRejection validateMessagepartValue(IMessagepartValue value) {
        return null;
    }

    public ITypeValueRejection validateSimpleTypeValue(ISimpleTypeValue value) {
        return null;
    }

    public ITypeValueRejection validateStructureValue(IStructureValue value) {
        return null;
    }

    public ITypeValueRejection validateTypeValue(ITypeValue value) {
        return null;
    }
}

