/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.data.values.base;

import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.logging.BaseLogManager;
import com.sap.caf.mp.base.util.ExternalDate;
import com.sap.caf.mp.base.util.StringUtilities;
import com.sap.caf.mp.core.data.types.api.ISimpleType;
import com.sap.caf.mp.core.data.values.api.ISimpleTypeValue;
import com.sap.caf.mp.core.data.values.base.TypeValue;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SimpleTypeValue
extends TypeValue
implements ISimpleTypeValue {
    private static final String ENCODING_UTF8 = "UTF-8";
    private String m_value = null;

    public SimpleTypeValue(ISimpleType type) throws InvocationException {
        super(type);
    }

    public ISimpleType getSimpleType() {
        return (ISimpleType)this.getType();
    }

    public String getValue() {
        return this.m_value;
    }

    public BigDecimal getValueBigDecimal() {
        BigDecimal l_decimal;
        String l_value = this.getValue();
        if (l_value == null) {
            l_decimal = null;
        } else {
            try {
                l_decimal = new BigDecimal(l_value);
            }
            catch (NumberFormatException l_exception) {
                l_decimal = new BigDecimal(0.0);
            }
        }
        return l_decimal;
    }

    public Boolean getValueBoolean() {
        String l_value = this.getValue();
        return l_value == null ? null : new Boolean(l_value);
    }

    public byte[] getValueByteArray() {
        byte[] l_array;
        String l_value = this.getValue();
        if (l_value == null) {
            l_array = null;
        } else {
            try {
                l_array = StringUtilities.fromHexString((String)l_value);
            }
            catch (Exception ex) {
                BaseLogManager.warn(this.getClass(), (String)("Unable to unmarshal byte array: " + ex.getMessage()));
                l_array = null;
            }
        }
        return l_array;
    }

    public Date getValueDate() {
        Date l_date;
        String l_value = this.getValue();
        if (l_value == null) {
            l_date = null;
        } else {
            try {
                SimpleDateFormat l_format = new SimpleDateFormat("EEE MMM d HH:mm:ss ZZZ yyyy");
                l_date = l_format.parse(l_value);
            }
            catch (ParseException l_format_exception) {
                try {
                    l_date = ExternalDate.parseTimeStamp((String)l_value);
                }
                catch (InvocationException l_date_exception) {
                    l_date = new Date(0L);
                }
            }
        }
        return l_date;
    }

    public Double getValueDouble() {
        Double l_double;
        String l_value = this.getValue();
        if (l_value == null) {
            l_double = null;
        } else {
            try {
                l_double = new Double(l_value);
            }
            catch (NumberFormatException l_exception) {
                l_double = new Double(0.0);
            }
        }
        return l_double;
    }

    public Integer getValueInteger() {
        Integer l_integer;
        String l_value = this.getValue();
        if (l_value == null) {
            l_integer = null;
        } else {
            try {
                l_integer = new Integer(l_value);
            }
            catch (NumberFormatException l_exception) {
                l_integer = new Integer(0);
            }
        }
        return l_integer;
    }

    public String getValueString() {
        return this.m_value;
    }

    public void setValue(String value) throws InvocationException {
        this.m_value = value;
    }

    public void setValueBigDecimal(BigDecimal value) throws InvocationException {
        this.setValue(value == null ? null : value.toString());
    }

    public void setValueBoolean(Boolean value) throws InvocationException {
        this.setValue(value == null ? null : value.toString());
    }

    public void setValueByteArray(byte[] value) throws InvocationException {
        String l_value = value == null ? null : StringUtilities.toHexString((byte[])value);
        this.setValue(l_value);
    }

    public void setValueDate(Date value) throws InvocationException {
        this.setValue(value == null ? null : value.toString());
    }

    public void setValueDouble(Double value) throws InvocationException {
        this.setValue(value == null ? null : value.toString());
    }

    public void setValueInteger(Integer value) throws InvocationException {
        this.setValue(value == null ? null : value.toString());
    }

    public void setValueString(String value) throws InvocationException {
        this.setValue(value);
    }
}

