/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.data.values.base;

import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.logging.BaseLogManager;
import com.sap.caf.mp.core.data.types.api.IComplexType;
import com.sap.caf.mp.core.data.types.api.IElement;
import com.sap.caf.mp.core.data.types.api.IMessage;
import com.sap.caf.mp.core.data.types.api.IMessagepart;
import com.sap.caf.mp.core.data.types.api.ISimpleType;
import com.sap.caf.mp.core.data.types.api.IStructure;
import com.sap.caf.mp.core.data.types.api.IType;
import com.sap.caf.mp.core.data.types.base.MessageUtils;
import com.sap.caf.mp.core.data.values.api.IComplexTypeValue;
import com.sap.caf.mp.core.data.values.api.IElementValue;
import com.sap.caf.mp.core.data.values.api.IMessageValue;
import com.sap.caf.mp.core.data.values.api.IMessagepartValue;
import com.sap.caf.mp.core.data.values.api.ISimpleTypeValue;
import com.sap.caf.mp.core.data.values.api.IStructureValue;
import com.sap.caf.mp.core.data.values.api.ITypeValue;
import com.sap.caf.mp.core.data.values.base.ComplexTypeValue;
import com.sap.caf.mp.core.data.values.base.ElementValue;
import com.sap.caf.mp.core.data.values.base.MessageValue;
import com.sap.caf.mp.core.data.values.base.MessagepartValue;
import com.sap.caf.mp.core.data.values.base.SimpleTypeValue;
import com.sap.caf.mp.core.data.values.base.TypeValue;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;

public class MessageValueUtils {
    private static final String PATH_TOKEN_DELIMETER = "/";
    static /* synthetic */ Class class$com$sap$caf$mp$core$data$values$base$MessageValueUtils;

    public static String dumpMessageValue(IMessageValue value) {
        StringBuffer result = new StringBuffer();
        MessageValueUtils.appendOpeningTag(value.getMessage().getName(), result);
        Enumeration enumeration = value.getMessagepartValueEnumeration();
        while (enumeration.hasMoreElements()) {
            IMessagepartValue partvalue = (IMessagepartValue)enumeration.nextElement();
            MessageValueUtils.appendPartValue(partvalue, result);
        }
        MessageValueUtils.appendClosingTag(value.getMessage().getName(), result);
        return result.toString();
    }

    private static void appendPartValue(IMessagepartValue partValue, StringBuffer value) {
        MessageValueUtils.appendOpeningTag(partValue.getMessagepart().getName(), value);
        IStructure structure = partValue.getMessagepart().getStructure();
        if (structure instanceof IElement) {
            IElementValue elementValue = (IElementValue)partValue.getStructureValue();
            MessageValueUtils.appendElementValue(elementValue, value);
        } else if (structure instanceof IComplexType) {
            IComplexTypeValue complexValue = (IComplexTypeValue)partValue.getStructureValue();
            MessageValueUtils.appendComplexTypeValue(complexValue, value);
        } else if (structure instanceof ISimpleType) {
            ISimpleTypeValue simpleValue = (ISimpleTypeValue)partValue.getStructureValue();
            MessageValueUtils.appendSimpleTypeValue(simpleValue, value);
        }
        MessageValueUtils.appendClosingTag(partValue.getMessagepart().getName(), value);
    }

    private static void appendElementValue(IElementValue elementValue, StringBuffer value) {
        if (elementValue == null) {
            return;
        }
        Enumeration enumeration = elementValue.getTypeValueEnumeration();
        while (enumeration.hasMoreElements()) {
            MessageValueUtils.appendOpeningTag(elementValue.getElement().getName(), value);
            ITypeValue typeValue = (ITypeValue)enumeration.nextElement();
            if (typeValue instanceof IComplexTypeValue) {
                MessageValueUtils.appendComplexTypeValue((IComplexTypeValue)typeValue, value);
            } else {
                MessageValueUtils.appendSimpleTypeValue((ISimpleTypeValue)typeValue, value);
            }
            MessageValueUtils.appendClosingTag(elementValue.getElement().getName(), value);
        }
    }

    private static void appendComplexTypeValue(IComplexTypeValue typeValue, StringBuffer value) {
        Enumeration enumeration = typeValue.getElementValueEnumeration();
        while (enumeration.hasMoreElements()) {
            IElementValue elementValue = (IElementValue)enumeration.nextElement();
            MessageValueUtils.appendElementValue(elementValue, value);
        }
    }

    private static void appendSimpleTypeValue(ISimpleTypeValue typeValue, StringBuffer value) {
        if (typeValue.getSimpleType().getBase() == 1) {
            String stringValue = typeValue.getValueString();
            if (stringValue.length() >= 20) {
                value.append("BINARY, length=" + stringValue.length() / 2 + ", start=" + stringValue.substring(0, 20));
            } else {
                value.append("BINARY, length=" + stringValue.length() / 2);
            }
        } else {
            value.append(typeValue.getValueString());
        }
    }

    private static void appendOpeningTag(String tag, StringBuffer value) {
        value.append("<" + tag + ">");
    }

    private static void appendClosingTag(String tag, StringBuffer value) {
        value.append("</" + tag + ">");
    }

    private static ISimpleTypeValue locateSimpleTypeValue(Stack path, IComplexTypeValue value) {
        IElementValue l_element_value;
        if (!path.empty() && (l_element_value = value.getElementValue((String)path.pop())) != null) {
            return MessageValueUtils.locateSimpleTypeValue(path, l_element_value);
        }
        return null;
    }

    private static ISimpleTypeValue locateSimpleTypeValue(Stack path, IElementValue value) {
        ITypeValue l_type_value = value.getTypeValue(0);
        if (l_type_value != null) {
            return MessageValueUtils.locateSimpleTypeValue(path, l_type_value);
        }
        return null;
    }

    private static ISimpleTypeValue locateSimpleTypeValue(Stack path, IMessageValue value) {
        IMessagepartValue l_messagepart_value;
        if (!path.empty() && (l_messagepart_value = value.getMessagepartValue((String)path.pop())) != null) {
            return MessageValueUtils.locateSimpleTypeValue(path, l_messagepart_value);
        }
        return null;
    }

    private static ISimpleTypeValue locateSimpleTypeValue(Stack path, IMessagepartValue value) {
        IStructureValue l_structure_value = value.getStructureValue();
        if (l_structure_value != null) {
            return MessageValueUtils.locateSimpleTypeValue(path, l_structure_value);
        }
        return null;
    }

    private static ISimpleTypeValue locateSimpleTypeValue(Stack path, ISimpleTypeValue value) {
        if (path.empty()) {
            return value;
        }
        return null;
    }

    private static ISimpleTypeValue locateSimpleTypeValue(Stack path, IStructureValue value) {
        IStructure l_structure = value.getStructure();
        if (l_structure != null) {
            switch (l_structure.getStructureCast()) {
                case 1: {
                    IElementValue l_element_value = (IElementValue)value;
                    IElement l_element = l_element_value.getElement();
                    if (l_element != null && !path.empty() && ((String)path.pop()).equals(l_element.getName())) {
                        return MessageValueUtils.locateSimpleTypeValue(path, l_element_value);
                    }
                }
                case 2: {
                    return MessageValueUtils.locateSimpleTypeValue(path, (ITypeValue)value);
                }
            }
        }
        return null;
    }

    private static ISimpleTypeValue locateSimpleTypeValue(Stack path, ITypeValue value) {
        IType l_type = value.getType();
        if (l_type != null) {
            switch (l_type.getTypeCast()) {
                case 1: {
                    return MessageValueUtils.locateSimpleTypeValue(path, (IComplexTypeValue)value);
                }
                case 2: {
                    return MessageValueUtils.locateSimpleTypeValue(path, (ISimpleTypeValue)value);
                }
            }
        }
        return null;
    }

    public static ISimpleTypeValue locateSimpleTypeValue(String path, IMessageValue value) {
        if (path != null && value != null) {
            return MessageValueUtils.locateSimpleTypeValue(MessageValueUtils.tokenizePath(path), value);
        }
        return null;
    }

    private static Stack tokenizePath(String path) {
        Stack<String> l_forward_stack = new Stack<String>();
        StringTokenizer l_tokenizer = new StringTokenizer(path, PATH_TOKEN_DELIMETER);
        while (l_tokenizer.hasMoreElements()) {
            String l_token = l_tokenizer.nextToken();
            if (l_token.length() <= 0) continue;
            l_forward_stack.push(l_token);
        }
        Stack l_backward_stack = new Stack();
        while (!l_forward_stack.empty()) {
            l_backward_stack.push(l_forward_stack.pop());
        }
        return l_backward_stack;
    }

    private static SimpleTypeValue constructSimpleTypeValue(String name, ISimpleType type, Properties parameters) throws InvocationException {
        if (!parameters.containsKey(name)) {
            return null;
        }
        String value = (String)parameters.get(name);
        SimpleTypeValue typevalue = new SimpleTypeValue(type);
        typevalue.setValue(value);
        return typevalue;
    }

    private static ComplexTypeValue constructComplexTypeValue(IComplexType type, Properties parameters) throws InvocationException {
        ComplexTypeValue complexTypeValue = null;
        Enumeration elements = type.getElementEnumeration();
        while (elements.hasMoreElements()) {
            IElement element = (IElement)elements.nextElement();
            ITypeValue typevalue = MessageValueUtils.constructTypeValue(element.getName(), element.getType(), parameters);
            if (typevalue == null) continue;
            if (complexTypeValue == null) {
                complexTypeValue = new ComplexTypeValue(type);
            }
            ElementValue elementvalue = new ElementValue(element);
            elementvalue.addTypeValue(typevalue);
            complexTypeValue.addElementValue(elementvalue);
        }
        return complexTypeValue;
    }

    private static ITypeValue constructTypeValue(String name, IType type, Properties parameters) throws InvocationException {
        TypeValue typevalue = null;
        if (type.getTypeCast() == 2) {
            typevalue = MessageValueUtils.constructSimpleTypeValue(name, (ISimpleType)type, parameters);
        } else if (type.getTypeCast() == 1) {
            typevalue = MessageValueUtils.constructComplexTypeValue((IComplexType)type, parameters);
        }
        return typevalue;
    }

    private static IStructureValue constructStructureValue(String name, IStructure structure, Properties parameters) throws InvocationException {
        IStructureValue structvalue = null;
        if (structure.getStructureCast() == 1) {
            IElement element = (IElement)structure;
            ITypeValue typevalue = MessageValueUtils.constructTypeValue(element.getName(), element.getType(), parameters);
            if (typevalue != null) {
                ElementValue elementvalue = new ElementValue(element);
                elementvalue.addTypeValue(typevalue);
                structvalue = elementvalue;
            }
        } else if (structure.getStructureCast() == 2) {
            structvalue = MessageValueUtils.constructTypeValue(name, (IType)structure, parameters);
        }
        return structvalue;
    }

    private static MessagepartValue constructMessagepartValue(IMessagepart part, Properties parameters) throws InvocationException {
        MessagepartValue partvalue = null;
        IStructure structure = part.getStructure();
        IStructureValue structvalue = MessageValueUtils.constructStructureValue(part.getName(), structure, parameters);
        if (structvalue != null) {
            partvalue = new MessagepartValue(part);
            partvalue.setStructureValue(structvalue);
        }
        return partvalue;
    }

    public static IMessageValue constructMessageValue(IMessage message, Properties parameters) throws InvocationException {
        MessageValue value = new MessageValue(message);
        Enumeration parts = message.getMessagepartEnumeration();
        while (parts.hasMoreElements()) {
            IMessagepart part = (IMessagepart)parts.nextElement();
            MessagepartValue partvalue = MessageValueUtils.constructMessagepartValue(part, parameters);
            if (partvalue == null) continue;
            value.addMessagepartValue(partvalue);
        }
        BaseLogManager.info((Class)(class$com$sap$caf$mp$core$data$values$base$MessageValueUtils == null ? (class$com$sap$caf$mp$core$data$values$base$MessageValueUtils = MessageValueUtils.class$("com.sap.caf.mp.core.data.values.base.MessageValueUtils")) : class$com$sap$caf$mp$core$data$values$base$MessageValueUtils), (String)"Constructing message value.");
        BaseLogManager.info((Class)(class$com$sap$caf$mp$core$data$values$base$MessageValueUtils == null ? (class$com$sap$caf$mp$core$data$values$base$MessageValueUtils = MessageValueUtils.class$("com.sap.caf.mp.core.data.values.base.MessageValueUtils")) : class$com$sap$caf$mp$core$data$values$base$MessageValueUtils), (String)(" Message:" + MessageUtils.dumpMessageValue(message)));
        BaseLogManager.info((Class)(class$com$sap$caf$mp$core$data$values$base$MessageValueUtils == null ? (class$com$sap$caf$mp$core$data$values$base$MessageValueUtils = MessageValueUtils.class$("com.sap.caf.mp.core.data.values.base.MessageValueUtils")) : class$com$sap$caf$mp$core$data$values$base$MessageValueUtils), (String)(" Parameters:" + parameters.toString()));
        BaseLogManager.info((Class)(class$com$sap$caf$mp$core$data$values$base$MessageValueUtils == null ? (class$com$sap$caf$mp$core$data$values$base$MessageValueUtils = MessageValueUtils.class$("com.sap.caf.mp.core.data.values.base.MessageValueUtils")) : class$com$sap$caf$mp$core$data$values$base$MessageValueUtils), (String)(" MessageValue:" + MessageValueUtils.dumpMessageValue(value)));
        return value;
    }

    public static Map getSimpleData(IMessageValue messageValue) throws InvocationException {
        Hashtable result = new Hashtable();
        Hashtable structures = new Hashtable();
        for (int i = 0; i < messageValue.getMessagepartValueCount(); ++i) {
            IMessagepartValue messagePartValue = messageValue.getMessagepartValue(i);
            MessageValueUtils.getSimpleDataFromStructureValue(messagePartValue.getMessagepart().getName(), messagePartValue.getStructureValue(), result, structures);
        }
        return result;
    }

    private static void getSimpleDataFromStructureValue(String name, IStructureValue structureValue, Map result, Map structures) throws InvocationException {
        IStructure structure = structureValue.getStructure();
        if (!structures.containsKey(structure)) {
            block0 : switch (structure.getStructureCast()) {
                case 2: {
                    switch (((IType)structure).getTypeCast()) {
                        case 1: {
                            IComplexTypeValue complexTypeValue = (IComplexTypeValue)structureValue;
                            for (int i = 0; i < complexTypeValue.getElementValueCount(); ++i) {
                                MessageValueUtils.getSimpleDataFromStructureValue(null, complexTypeValue.getElementValue(i), result, structures);
                            }
                            break block0;
                        }
                        case 2: {
                            ISimpleTypeValue simpleTypeValue = (ISimpleTypeValue)structureValue;
                            if (result.put(name, simpleTypeValue.getValue()) != null) {
                                throw new InvocationException("Error in the passed message value, more than one element with one and the same names!");
                            } else {
                                break;
                            }
                        }
                    }
                    break;
                }
                case 1: {
                    IElementValue elementValue = (IElementValue)structureValue;
                    for (int i = 0; i < elementValue.getTypeValueCount(); ++i) {
                        MessageValueUtils.getSimpleDataFromStructureValue(elementValue.getElement().getName(), elementValue.getTypeValue(i), result, structures);
                    }
                    break;
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

