/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.data.values.base;

import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.util.Hashvector;
import com.sap.caf.mp.core.data.types.api.IMessage;
import com.sap.caf.mp.core.data.types.api.IMessagepart;
import com.sap.caf.mp.core.data.values.api.IMessageValue;
import com.sap.caf.mp.core.data.values.api.IMessagepartValue;
import java.util.Enumeration;

public class MessageValue
implements IMessageValue {
    private IMessage m_message;
    private Hashvector m_hashvector;

    public MessageValue(IMessage message) throws InvocationException {
        if (message == null) {
            throw new InvocationException("Message invalid");
        }
        this.m_message = message;
        this.m_hashvector = new Hashvector();
    }

    public IMessagepartValue addMessagepartValue(IMessagepartValue value) throws InvocationException {
        if (value == null) {
            throw new InvocationException("MessagepartValue invalid");
        }
        IMessagepart l_messagepart = value.getMessagepart();
        if (l_messagepart == null) {
            throw new InvocationException("Messagepart of MessagepartValue invalid");
        }
        String l_name = l_messagepart.getName();
        if (l_name == null) {
            throw new InvocationException("Name of Messagepart of MessagepartValue invalid");
        }
        if (l_messagepart != this.getMessage().getMessagepart(l_name)) {
            throw new InvocationException("Messagepart of MessagepartValue mismatching");
        }
        return (IMessagepartValue)this.m_hashvector.addValue((Object)l_name, (Object)value);
    }

    public IMessage getMessage() {
        return this.m_message;
    }

    public IMessagepartValue getMessagepartValue(String name) {
        return (IMessagepartValue)this.m_hashvector.getValue((Object)name);
    }

    public IMessagepartValue getMessagepartValue(int index) {
        return (IMessagepartValue)this.m_hashvector.getValue(index);
    }

    public int getMessagepartValueCount() {
        return this.m_hashvector.getValueCount();
    }

    public Enumeration getMessagepartValueEnumeration() {
        return this.m_hashvector.getValueEnumeration();
    }
}

