/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.data.types.meta.base;

import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.core.data.service.interfce.api.IOperation;
import com.sap.caf.mp.core.data.service.interfce.api.IOperationpart;
import com.sap.caf.mp.core.data.service.interfce.api.IPorttype;
import com.sap.caf.mp.core.data.service.interfce.base.Operation;
import com.sap.caf.mp.core.data.service.interfce.base.Operationpart;
import com.sap.caf.mp.core.data.service.interfce.base.Porttype;
import com.sap.caf.mp.core.data.types.api.IComplexType;
import com.sap.caf.mp.core.data.types.api.IElement;
import com.sap.caf.mp.core.data.types.api.IMessage;
import com.sap.caf.mp.core.data.types.api.IMessagepart;
import com.sap.caf.mp.core.data.types.api.ISimpleType;
import com.sap.caf.mp.core.data.types.api.IStructure;
import com.sap.caf.mp.core.data.types.api.IType;
import com.sap.caf.mp.core.data.types.base.ComplexType;
import com.sap.caf.mp.core.data.types.base.Element;
import com.sap.caf.mp.core.data.types.base.Message;
import com.sap.caf.mp.core.data.types.base.Messagepart;
import com.sap.caf.mp.core.data.types.base.SimpleType;
import com.sap.caf.mp.core.data.types.meta.api.ITypeFactory;
import com.sap.caf.mp.core.data.types.meta.api.ITypeLayout;
import com.sap.caf.mp.core.data.types.meta.api.ITypeRejection;
import com.sap.caf.mp.core.data.types.meta.base.TypeLayout;
import java.util.Enumeration;

public class TypeFactory
implements ITypeFactory {
    public IComplexType createComplexType() {
        return new ComplexType();
    }

    public IElement createElement(String name) throws InvocationException {
        return new Element(name);
    }

    public IMessage createMessage(String name) throws InvocationException {
        return new Message(name);
    }

    public IMessage createMessage(String uuid, String name) throws InvocationException {
        return new Message(uuid, name);
    }

    public IMessagepart createMessagepart(String name) throws InvocationException {
        return new Messagepart(name);
    }

    public IOperation createOperation(String name) throws InvocationException {
        return new Operation(name);
    }

    public IOperationpart createOperationpart(String name) throws InvocationException {
        return new Operationpart(name);
    }

    public IPorttype createPorttype(String name) throws InvocationException {
        return new Porttype(name);
    }

    public IPorttype createPorttype(String uuid, String name) throws InvocationException {
        return new Porttype(uuid, name);
    }

    public ISimpleType createSimpleType(int base) throws InvocationException {
        return new SimpleType(base);
    }

    private void expandTypeLayout(ITypeLayout layout, IComplexType complex) throws InvocationException {
        Enumeration l_enumeration;
        if (complex != null && (l_enumeration = complex.getElementEnumeration()) != null) {
            while (l_enumeration.hasMoreElements()) {
                layout.addTypeLayout(this.extractTypeLayout((IElement)l_enumeration.nextElement()));
            }
        }
    }

    private void expandTypeLayout(ITypeLayout layout, ISimpleType simple) throws InvocationException {
        if (simple != null) {
            // empty if block
        }
    }

    private void expandTypeLayout(ITypeLayout layout, IStructure structure) throws InvocationException {
        if (structure != null) {
            switch (structure.getStructureCast()) {
                case 1: {
                    layout.addTypeLayout(this.extractTypeLayout((IElement)structure));
                    break;
                }
                case 2: {
                    this.expandTypeLayout(layout, (IType)structure);
                    break;
                }
                default: {
                    throw new InvocationException("Structure unknown");
                }
            }
        }
    }

    private void expandTypeLayout(ITypeLayout layout, IType type) throws InvocationException {
        if (type != null) {
            switch (type.getTypeCast()) {
                case 1: {
                    this.expandTypeLayout(layout, (IComplexType)type);
                    break;
                }
                case 2: {
                    this.expandTypeLayout(layout, (ISimpleType)type);
                    break;
                }
                default: {
                    throw new InvocationException("Type unknown");
                }
            }
        }
    }

    public ITypeLayout extractTypeLayout(IElement element) throws InvocationException {
        TypeLayout l_layout = null;
        if (element != null) {
            l_layout = new TypeLayout(element.getName());
            l_layout.setTextbag(element.getTextbag());
            this.expandTypeLayout((ITypeLayout)l_layout, element.getType());
        }
        return l_layout;
    }

    public ITypeLayout extractTypeLayout(IMessage message) throws InvocationException {
        TypeLayout l_layout = null;
        if (message != null) {
            l_layout = new TypeLayout(message.getName());
            l_layout.setTextbag(message.getTextbag());
            Enumeration l_enumeration = message.getMessagepartEnumeration();
            if (l_enumeration != null) {
                while (l_enumeration.hasMoreElements()) {
                    l_layout.addTypeLayout(this.extractTypeLayout((IMessagepart)l_enumeration.nextElement()));
                }
            }
        }
        return l_layout;
    }

    public ITypeLayout extractTypeLayout(IMessagepart messagepart) throws InvocationException {
        TypeLayout l_layout = null;
        if (messagepart != null) {
            l_layout = new TypeLayout(messagepart.getName());
            l_layout.setTextbag(messagepart.getTextbag());
            this.expandTypeLayout((ITypeLayout)l_layout, messagepart.getStructure());
        }
        return l_layout;
    }

    public ITypeLayout extractTypeLayout(IOperation operation) throws InvocationException {
        TypeLayout l_layout = null;
        if (operation != null) {
            Enumeration l_enumeration;
            IOperationpart l_output_operationpart;
            l_layout = new TypeLayout(operation.getName());
            l_layout.setTextbag(operation.getTextbag());
            IOperationpart l_input_operationpart = operation.getInputOperationpart();
            if (l_input_operationpart != null) {
                l_layout.addTypeLayout(this.extractTypeLayout(l_input_operationpart));
            }
            if ((l_output_operationpart = operation.getOutputOperationpart()) != null) {
                l_layout.addTypeLayout(this.extractTypeLayout(l_output_operationpart));
            }
            if ((l_enumeration = operation.getFaultOperationpartEnumeration()) != null) {
                while (l_enumeration.hasMoreElements()) {
                    l_layout.addTypeLayout(this.extractTypeLayout((IOperationpart)l_enumeration.nextElement()));
                }
            }
        }
        return l_layout;
    }

    public ITypeLayout extractTypeLayout(IOperationpart operationpart) throws InvocationException {
        TypeLayout l_layout = null;
        if (operationpart != null) {
            l_layout = new TypeLayout(operationpart.getName());
            l_layout.setTextbag(operationpart.getTextbag());
            IMessage l_message = operationpart.getMessage();
            if (l_message != null) {
                l_layout.addTypeLayout(this.extractTypeLayout(l_message));
            }
        }
        return l_layout;
    }

    public ITypeLayout extractTypeLayout(IPorttype porttype) throws InvocationException {
        TypeLayout l_layout = null;
        if (porttype != null) {
            l_layout = new TypeLayout(porttype.getName());
            l_layout.setTextbag(porttype.getTextbag());
            Enumeration l_enumeration = porttype.getOperationEnumeration();
            if (l_enumeration != null) {
                while (l_enumeration.hasMoreElements()) {
                    l_layout.addTypeLayout(this.extractTypeLayout((IOperation)l_enumeration.nextElement()));
                }
            }
        }
        return l_layout;
    }

    public ITypeRejection validateComplexType(IComplexType type) {
        return null;
    }

    public ITypeRejection validateElement(IElement element) {
        return null;
    }

    public ITypeRejection validateMessage(IMessage message) {
        return null;
    }

    public ITypeRejection validateMessagepart(IMessagepart messagepart) {
        return null;
    }

    public ITypeRejection validateOperation(IOperation operation) {
        return null;
    }

    public ITypeRejection validateOperationpart(IOperationpart operationpart) {
        return null;
    }

    public ITypeRejection validatePorttype(IPorttype porttype) {
        return null;
    }

    public ITypeRejection validateSimpleType(ISimpleType type) {
        return null;
    }

    public ITypeRejection validateStructure(IStructure structure) {
        return null;
    }

    public ITypeRejection validateType(IType type) {
        return null;
    }
}

