/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.data.types.meta.base;

import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.core.data.service.interfce.api.IOperation;
import com.sap.caf.mp.core.data.service.interfce.api.IOperationpart;
import com.sap.caf.mp.core.data.service.interfce.api.IPorttype;
import com.sap.caf.mp.core.data.types.api.IComplexType;
import com.sap.caf.mp.core.data.types.api.IElement;
import com.sap.caf.mp.core.data.types.api.IMessage;
import com.sap.caf.mp.core.data.types.api.IMessagepart;
import com.sap.caf.mp.core.data.types.api.ISimpleType;
import com.sap.caf.mp.core.data.types.api.IStructure;
import com.sap.caf.mp.core.data.types.api.IType;
import com.sap.caf.mp.core.data.types.meta.api.ILayoutFactory;
import com.sap.caf.mp.core.data.types.meta.api.ILayoutNode;
import com.sap.caf.mp.core.data.types.meta.base.LayoutNode;
import java.util.Enumeration;

public class LayoutFactory
implements ILayoutFactory {
    private void expandLayout(LayoutNode node, IComplexType complex) throws InvocationException {
        Enumeration l_enumeration;
        if (complex != null && (l_enumeration = complex.getElementEnumeration()) != null) {
            while (l_enumeration.hasMoreElements()) {
                node.addLayoutNode(this.extractLayout((IElement)l_enumeration.nextElement()));
            }
        }
    }

    private void expandLayout(LayoutNode node, ISimpleType simple) throws InvocationException {
        if (simple != null) {
            // empty if block
        }
    }

    private void expandLayout(LayoutNode node, IStructure structure) throws InvocationException {
        if (structure != null) {
            switch (structure.getStructureCast()) {
                case 1: {
                    node.addLayoutNode(this.extractLayout((IElement)structure));
                    break;
                }
                case 2: {
                    this.expandLayout(node, (IType)structure);
                    break;
                }
                default: {
                    throw new InvocationException("Structure unknown");
                }
            }
        }
    }

    private void expandLayout(LayoutNode node, IType type) throws InvocationException {
        if (type != null) {
            switch (type.getTypeCast()) {
                case 1: {
                    this.expandLayout(node, (IComplexType)type);
                    break;
                }
                case 2: {
                    this.expandLayout(node, (ISimpleType)type);
                    break;
                }
                default: {
                    throw new InvocationException("Type unknown");
                }
            }
        }
    }

    public ILayoutNode extractLayout(IElement element) throws InvocationException {
        LayoutNode l_node = null;
        if (element != null) {
            l_node = new LayoutNode(element.getName(), element.getTextbag());
            this.expandLayout(l_node, element.getType());
        }
        return l_node;
    }

    public ILayoutNode extractLayout(IMessage message) throws InvocationException {
        LayoutNode l_node = null;
        if (message != null) {
            l_node = new LayoutNode(message.getName(), message.getTextbag());
            Enumeration l_enumeration = message.getMessagepartEnumeration();
            if (l_enumeration != null) {
                while (l_enumeration.hasMoreElements()) {
                    l_node.addLayoutNode(this.extractLayout((IMessagepart)l_enumeration.nextElement()));
                }
            }
        }
        return l_node;
    }

    public ILayoutNode extractLayout(IMessagepart messagepart) throws InvocationException {
        LayoutNode l_node = null;
        if (messagepart != null) {
            l_node = new LayoutNode(messagepart.getName(), messagepart.getTextbag());
            this.expandLayout(l_node, messagepart.getStructure());
        }
        return l_node;
    }

    public ILayoutNode extractLayout(IOperation operation) throws InvocationException {
        LayoutNode l_node = null;
        if (operation != null) {
            Enumeration l_enumeration;
            IOperationpart l_output_operationpart;
            l_node = new LayoutNode(operation.getName(), operation.getTextbag());
            IOperationpart l_input_operationpart = operation.getInputOperationpart();
            if (l_input_operationpart != null) {
                l_node.addLayoutNode(this.extractLayout(l_input_operationpart));
            }
            if ((l_output_operationpart = operation.getOutputOperationpart()) != null) {
                l_node.addLayoutNode(this.extractLayout(l_output_operationpart));
            }
            if ((l_enumeration = operation.getFaultOperationpartEnumeration()) != null) {
                while (l_enumeration.hasMoreElements()) {
                    l_node.addLayoutNode(this.extractLayout((IOperationpart)l_enumeration.nextElement()));
                }
            }
        }
        return l_node;
    }

    public ILayoutNode extractLayout(IOperationpart operationpart) throws InvocationException {
        LayoutNode l_node = null;
        if (operationpart != null) {
            l_node = new LayoutNode(operationpart.getName(), operationpart.getTextbag());
            IMessage l_message = operationpart.getMessage();
            if (l_message != null) {
                l_node.addLayoutNode(this.extractLayout(l_message));
            }
        }
        return l_node;
    }

    public ILayoutNode extractLayout(IPorttype porttype) throws InvocationException {
        LayoutNode l_node = null;
        if (porttype != null) {
            l_node = new LayoutNode(porttype.getName(), porttype.getTextbag());
            Enumeration l_enumeration = porttype.getOperationEnumeration();
            if (l_enumeration != null) {
                while (l_enumeration.hasMoreElements()) {
                    l_node.addLayoutNode(this.extractLayout((IOperation)l_enumeration.nextElement()));
                }
            }
        }
        return l_node;
    }
}

