/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.data.types.base;

import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.core.data.types.api.ISimpleType;
import com.sap.caf.mp.core.data.types.base.Type;
import com.sap.caf.mp.core.data.values.api.ISimpleTypeValue;
import java.util.Enumeration;
import java.util.Vector;

public class SimpleType
extends Type
implements ISimpleType {
    private int m_base;
    private int m_min_length;
    private int m_max_length;
    private int m_fraction_digits;
    private int m_total_digits;
    private Vector m_pattern_vector;
    private Vector m_constant_vector;

    public SimpleType(int base) {
        super(2);
        this.m_base = base;
        this.m_min_length = 0;
        this.m_max_length = 0;
        this.m_fraction_digits = 0;
        this.m_total_digits = 0;
        this.m_constant_vector = new Vector();
        this.m_pattern_vector = new Vector();
    }

    public void addConstant(ISimpleTypeValue constant) throws InvocationException {
        if (constant == null) {
            throw new InvocationException("Constant invalid");
        }
        this.m_constant_vector.add(constant);
    }

    public void addPattern(String pattern) throws InvocationException {
        if (pattern == null) {
            throw new InvocationException("Pattern invalid");
        }
        this.m_pattern_vector.add(pattern);
    }

    public int getBase() {
        return this.m_base;
    }

    public ISimpleTypeValue getConstant(int index) {
        ISimpleTypeValue l_constant;
        try {
            l_constant = (ISimpleTypeValue)this.m_constant_vector.elementAt(index);
        }
        catch (ArrayIndexOutOfBoundsException l_exception) {
            l_constant = null;
        }
        return l_constant;
    }

    public int getConstantCount() {
        return this.m_constant_vector.size();
    }

    public Enumeration getConstantEnumeration() {
        return this.m_constant_vector.elements();
    }

    public int getFractionDigits() {
        return this.m_fraction_digits;
    }

    public int getMaxLength() {
        return this.m_max_length;
    }

    public int getMinLength() {
        return this.m_min_length;
    }

    public String getPattern(int index) {
        String l_string;
        try {
            l_string = (String)this.m_pattern_vector.elementAt(index);
        }
        catch (ArrayIndexOutOfBoundsException l_exception) {
            l_string = null;
        }
        return l_string;
    }

    public int getPatternCount() {
        return this.m_pattern_vector.size();
    }

    public Enumeration getPatternEnumeration() {
        return this.m_pattern_vector.elements();
    }

    public int getTotalDigits() {
        return this.m_total_digits;
    }

    public void setFractionDigits(int digits) throws InvocationException {
        this.m_fraction_digits = digits;
    }

    public void setMaxLength(int length) throws InvocationException {
        this.m_max_length = length;
    }

    public void setMinLength(int length) throws InvocationException {
        this.m_min_length = length;
    }

    public void setTotalDigits(int digits) throws InvocationException {
        this.m_total_digits = digits;
    }
}

