/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.data.persistence.base;

import com.sap.caf.mp.base.db.ICNConnectionPool;
import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.core.svc.persist.INumberRange;
import java.sql.Connection;
import java.util.Hashtable;

public class PersistenceContext {
    private INumberRange m_numberrange;
    private Connection m_connection;
    private Hashtable m_component_buffer;
    private Hashtable m_statement_buffer;
    private int m_luid;

    public PersistenceContext(ICNConnectionPool pool, INumberRange numberrange) throws EngineException {
        this.m_numberrange = numberrange;
        this.m_connection = pool.getConnection();
        this.m_component_buffer = new Hashtable();
        this.m_statement_buffer = new Hashtable();
        this.m_luid = 0;
    }

    public int drawLuid() {
        return ++this.m_luid;
    }

    public int drawNumber(String name) throws EngineException {
        return this.m_numberrange.getNextNumber(name);
    }

    public Hashtable getComponentBuffer() {
        return this.m_component_buffer;
    }

    public Connection getConnection() {
        return this.m_connection;
    }

    public Hashtable getStatementBuffer() {
        return this.m_statement_buffer;
    }
}

