/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.data.mapping.base;

import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.base.logging.BaseLogManager;
import com.sap.caf.mp.core.data.mapping.base.SimpleMappingRule;
import com.sap.caf.mp.core.data.types.api.IComplexType;
import com.sap.caf.mp.core.data.types.api.IElement;
import com.sap.caf.mp.core.data.types.api.IMessage;
import com.sap.caf.mp.core.data.types.api.IMessagepart;
import com.sap.caf.mp.core.data.types.api.ISimpleType;
import com.sap.caf.mp.core.data.types.api.IStructure;
import com.sap.caf.mp.core.data.types.api.IType;
import com.sap.caf.mp.core.data.types.meta.base.TypeFactory;
import com.sap.caf.mp.core.data.values.api.IComplexTypeValue;
import com.sap.caf.mp.core.data.values.api.IElementValue;
import com.sap.caf.mp.core.data.values.api.IMessageValue;
import com.sap.caf.mp.core.data.values.api.IMessagepartValue;
import com.sap.caf.mp.core.data.values.api.ISimpleTypeValue;
import com.sap.caf.mp.core.data.values.api.IStructureValue;
import com.sap.caf.mp.core.data.values.api.ITypeValue;
import com.sap.caf.mp.core.data.values.base.MessageValueUtils;
import com.sap.caf.mp.core.data.values.meta.api.ITypeValueFactory;
import com.sap.caf.mp.core.data.values.meta.base.TypeValueFactory;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class SingleValueMapping {
    private static final String TOKEN_PATH_DELIMETER = "/";
    private static final String TOKEN_RULE_DELIMETER = ",";
    private static final String TOKEN_SUBRULE_ENTRANCE = "[";
    private static final String TOKEN_SUBRULE_EXIT = "]";
    private ITypeValueFactory m_factory = new TypeValueFactory();
    private Vector m_vector = new Vector();
    static /* synthetic */ Class class$com$sap$caf$mp$core$data$mapping$base$SingleValueMapping;

    public void addMappingRule(SimpleMappingRule rule) throws InvocationException {
        if (rule == null) {
            throw new InvocationException("MappingRule invalid");
        }
        this.m_vector.add(rule);
    }

    private NameEntry createNameEntry(IMessageValue content) {
        String l_name;
        IMessage l_body;
        if (content != null && (l_body = content.getMessage()) != null && (l_name = l_body.getName()) != null) {
            NameEntry l_named = new NameEntry(l_name);
            ValueEntry l_valued = this.createValueEntry(content);
            if (l_valued != null) {
                l_named.addValueEntry(l_valued);
            }
            return l_named;
        }
        return null;
    }

    private NameEntry createNameEntry(IMessagepartValue content) {
        String l_name;
        IMessagepart l_body;
        if (content != null && (l_body = content.getMessagepart()) != null && (l_name = l_body.getName()) != null) {
            NameEntry l_named = new NameEntry(l_name);
            ValueEntry l_valued = this.createValueEntry(content.getStructureValue());
            if (l_valued != null) {
                l_named.addValueEntry(l_valued);
            }
            return l_named;
        }
        return null;
    }

    private NameEntry createNameEntry(IElementValue content) {
        String l_name;
        IElement l_element;
        if (content != null && (l_element = content.getElement()) != null && (l_name = l_element.getName()) != null) {
            NameEntry l_named = new NameEntry(l_name);
            Enumeration l_enumeration = content.getTypeValueEnumeration();
            if (l_enumeration != null) {
                while (l_enumeration.hasMoreElements()) {
                    ValueEntry l_valued = this.createValueEntry((ITypeValue)l_enumeration.nextElement());
                    if (l_valued == null) continue;
                    l_named.addValueEntry(l_valued);
                }
            }
            return l_named;
        }
        return null;
    }

    private ValueEntry createValueEntry(IMessageValue content) {
        if (content != null) {
            ValueEntry l_valued = new ValueEntry();
            Enumeration l_enumeration = content.getMessagepartValueEnumeration();
            if (l_enumeration != null) {
                while (l_enumeration.hasMoreElements()) {
                    NameEntry l_named = this.createNameEntry((IMessagepartValue)l_enumeration.nextElement());
                    if (l_named == null) continue;
                    l_valued.addNameEntry(l_named);
                }
            }
            return l_valued;
        }
        return null;
    }

    private ValueEntry createValueEntry(IStructureValue content) {
        if (content != null) {
            IStructure l_body = content.getStructure();
            if (l_body != null) {
                switch (l_body.getStructureCast()) {
                    case 1: {
                        return this.createValueEntry((IElementValue)content);
                    }
                    case 2: {
                        return this.createValueEntry((ITypeValue)content);
                    }
                }
            }
            return new ValueEntry();
        }
        return null;
    }

    private ValueEntry createValueEntry(IElementValue content) {
        if (content != null) {
            ValueEntry l_valued = new ValueEntry();
            NameEntry l_named = this.createNameEntry(content);
            if (l_named != null) {
                l_valued.addNameEntry(l_named);
            }
            return l_valued;
        }
        return null;
    }

    private ValueEntry createValueEntry(ITypeValue content) {
        if (content != null) {
            IType l_body = content.getType();
            if (l_body != null) {
                switch (l_body.getTypeCast()) {
                    case 1: {
                        return this.createValueEntry((IComplexTypeValue)content);
                    }
                    case 2: {
                        return this.createValueEntry((ISimpleTypeValue)content);
                    }
                }
            }
            return new ValueEntry();
        }
        return null;
    }

    private ValueEntry createValueEntry(IComplexTypeValue content) {
        if (content != null) {
            ValueEntry l_valued = new ValueEntry();
            Enumeration l_enumeration = content.getElementValueEnumeration();
            if (l_enumeration != null) {
                while (l_enumeration.hasMoreElements()) {
                    NameEntry l_named = this.createNameEntry((IElementValue)l_enumeration.nextElement());
                    if (l_named == null) continue;
                    l_valued.addNameEntry(l_named);
                }
            }
            return l_valued;
        }
        return null;
    }

    private ValueEntry createValueEntry(ISimpleTypeValue content) {
        if (content != null) {
            ValueEntry l_valued = new ValueEntry();
            l_valued.setValue(content.getValue());
            return l_valued;
        }
        return null;
    }

    private IMessageValue createMessageValue(IMessage body, NameEntry content) {
        try {
            IMessageValue l_value = this.m_factory.createMessageValue(body);
            Enumeration l_enumeration = body.getMessagepartEnumeration();
            if (l_enumeration != null) {
                ValueEntry l_valued = content.getValueEntry(0);
                while (l_enumeration.hasMoreElements()) {
                    IMessagepart l_messagepart = (IMessagepart)l_enumeration.nextElement();
                    if (l_messagepart == null) continue;
                    try {
                        l_value.addMessagepartValue(this.createMessagepartValue(l_messagepart, l_valued));
                    }
                    catch (InvocationException l_exception) {}
                }
            }
            return l_value;
        }
        catch (InvocationException invocationException) {
            return null;
        }
    }

    private IMessagepartValue createMessagepartValue(IMessagepart body, ValueEntry content) {
        return this.createMessagepartValue(body, this.extractNameEntry(content, body.getName()));
    }

    private IMessagepartValue createMessagepartValue(IMessagepart body, NameEntry content) {
        try {
            IMessagepartValue l_value = this.m_factory.createMessagepartValue(body);
            IStructure l_structure = body.getStructure();
            if (l_structure != null) {
                try {
                    l_value.setStructureValue(this.createStructureValue(l_structure, this.extractValueEntry(content, 0)));
                }
                catch (InvocationException l_exception) {
                    // empty catch block
                }
            }
            return l_value;
        }
        catch (InvocationException invocationException) {
            return null;
        }
    }

    private IStructureValue createStructureValue(IStructure body, ValueEntry content) {
        switch (body.getStructureCast()) {
            case 1: {
                return this.createElementValue((IElement)body, content);
            }
            case 2: {
                return this.createTypeValue((IType)body, content);
            }
        }
        return null;
    }

    private IElementValue createElementValue(IElement body, ValueEntry content) {
        return this.createElementValue(body, this.extractNameEntry(content, body.getName()));
    }

    private IElementValue createElementValue(IElement body, NameEntry content) {
        try {
            IElementValue l_value = this.m_factory.createElementValue(body);
            IType l_type = body.getType();
            if (l_type != null) {
                if (content != null) {
                    Enumeration l_enumeration = content.getValueEntryEnumeration();
                    while (l_enumeration.hasMoreElements()) {
                        try {
                            l_value.addTypeValue(this.createTypeValue(l_type, (ValueEntry)l_enumeration.nextElement()));
                        }
                        catch (InvocationException l_exception) {}
                    }
                }
                for (int l_index = body.getMinOccurs() - l_value.getTypeValueCount(); l_index > 0; --l_index) {
                    try {
                        l_value.addTypeValue(this.createTypeValue(l_type, null));
                        continue;
                    }
                    catch (InvocationException l_exception) {
                        break;
                    }
                }
            }
            return l_value;
        }
        catch (InvocationException invocationException) {
            return null;
        }
    }

    private ITypeValue createTypeValue(IType body, ValueEntry content) {
        switch (body.getTypeCast()) {
            case 1: {
                return this.createComplexTypeValue((IComplexType)body, content);
            }
            case 2: {
                if (content == null) break;
                return this.createSimpleTypeValue((ISimpleType)body, content);
            }
        }
        return null;
    }

    private IComplexTypeValue createComplexTypeValue(IComplexType body, ValueEntry content) {
        try {
            IComplexTypeValue l_value = this.m_factory.createComplexTypeValue(body);
            Enumeration l_enumeration = body.getElementEnumeration();
            if (l_enumeration != null) {
                while (l_enumeration.hasMoreElements()) {
                    IElement l_element = (IElement)l_enumeration.nextElement();
                    if (l_element == null) continue;
                    try {
                        l_value.addElementValue(this.createElementValue(l_element, this.extractNameEntry(content, l_element.getName())));
                    }
                    catch (InvocationException l_exception) {}
                }
            }
            return l_value;
        }
        catch (InvocationException invocationException) {
            return null;
        }
    }

    private ISimpleTypeValue createSimpleTypeValue(ISimpleType body, ValueEntry content) {
        try {
            ISimpleTypeValue l_value = this.m_factory.createSimpleTypeValue(body);
            try {
                l_value.setValue(content.getValue());
            }
            catch (InvocationException l_exception) {
                // empty catch block
            }
            return l_value;
        }
        catch (InvocationException invocationException) {
            return null;
        }
    }

    private TreeMappingRule createTreeMappingRule(String pathTarget, String pathSource, String value) {
        TreeMappingRule l_rule = null;
        if (pathTarget != null) {
            Stack l_stackTarget = null;
            StringTokenizer l_tokenizerTarget = null;
            int l_indexLowerTarget = pathTarget.indexOf(TOKEN_SUBRULE_ENTRANCE);
            if (l_indexLowerTarget < 0) {
                l_stackTarget = this.createStack(pathTarget);
            } else {
                int l_indexUpperTarget = pathTarget.lastIndexOf(TOKEN_SUBRULE_EXIT);
                if (l_indexUpperTarget < l_indexLowerTarget) {
                    l_indexUpperTarget = pathTarget.length();
                }
                l_stackTarget = this.createStack(pathTarget.substring(0, l_indexLowerTarget));
                l_tokenizerTarget = new StringTokenizer(pathTarget.substring(l_indexLowerTarget + 1, l_indexUpperTarget), TOKEN_RULE_DELIMETER);
            }
            Stack l_stackSource = null;
            StringTokenizer l_tokenizerSource = null;
            if (pathSource != null) {
                int l_indexLowerSource = pathSource.indexOf(TOKEN_SUBRULE_ENTRANCE);
                if (l_indexLowerSource < 0) {
                    l_stackSource = this.createStack(pathSource);
                } else {
                    int l_indexUpperSource = pathSource.lastIndexOf(TOKEN_SUBRULE_EXIT);
                    if (l_indexUpperSource < l_indexLowerSource) {
                        l_indexUpperSource = pathSource.length();
                    }
                    l_stackSource = this.createStack(pathSource.substring(0, l_indexLowerSource));
                    l_tokenizerSource = new StringTokenizer(pathSource.substring(l_indexLowerSource + 1, l_indexUpperSource), TOKEN_RULE_DELIMETER);
                }
            }
            l_rule = new TreeMappingRule(l_stackTarget, l_stackSource, value);
            if (l_tokenizerTarget != null && l_tokenizerSource != null) {
                while (l_tokenizerTarget.hasMoreTokens() && l_tokenizerSource.hasMoreTokens()) {
                    l_rule.addChild(this.createTreeMappingRule(l_tokenizerTarget.nextToken(), l_tokenizerSource.nextToken(), null));
                }
            }
        }
        return l_rule;
    }

    private Stack createStack(String path) {
        Stack l_stack = new Stack();
        this.extendStack(l_stack, new StringTokenizer(path, TOKEN_PATH_DELIMETER));
        return l_stack;
    }

    private Vector createValueEntryVector(NameEntry entry, Stack path, String value) {
        Vector l_vector = new Vector();
        if (entry != null && path != null) {
            this.extendValueEntryVector(l_vector, entry, path);
        }
        this.extendValueEntryVector(l_vector, value);
        return l_vector;
    }

    private Vector createValueEntryVector(ValueEntry entry, Stack path, String value) {
        Vector l_vector = new Vector();
        if (path != null) {
            this.extendValueEntryVector(l_vector, entry, path);
        }
        this.extendValueEntryVector(l_vector, value);
        return l_vector;
    }

    private NameEntry extendNameEntry(NameEntry entry, Stack path) {
        String l_name;
        NameEntry l_named;
        if (path.empty()) {
            return entry;
        }
        ValueEntry l_valued = entry.getValueEntry(0);
        if (l_valued == null) {
            l_valued = new ValueEntry();
            entry.addValueEntry(l_valued);
        }
        if ((l_named = l_valued.getNameEntry(l_name = (String)path.pop())) == null) {
            l_named = new NameEntry(l_name);
            l_valued.addNameEntry(l_named);
        }
        return this.extendNameEntry(l_named, path);
    }

    private void extendStack(Stack stack, StringTokenizer tokenizer) {
        if (tokenizer.hasMoreTokens()) {
            String l_token = tokenizer.nextToken();
            this.extendStack(stack, tokenizer);
            stack.push(l_token);
        }
    }

    private void extendValueEntryVector(Vector vector, String value) {
        if (vector.size() == 0 && value != null) {
            ValueEntry l_entry = new ValueEntry();
            l_entry.setValue(value);
            vector.add(l_entry);
        }
    }

    private void extendValueEntryVector(Vector vector, NameEntry entry, Stack path) {
        Enumeration l_enumeration = entry.getValueEntryEnumeration();
        while (l_enumeration.hasMoreElements()) {
            this.extendValueEntryVector(vector, (ValueEntry)l_enumeration.nextElement(), path);
        }
    }

    private void extendValueEntryVector(Vector vector, ValueEntry entry, Stack path) {
        if (path.empty()) {
            vector.add(entry);
        } else {
            String l_name = (String)path.pop();
            NameEntry l_entry = entry.getNameEntry(l_name);
            if (l_entry != null) {
                this.extendValueEntryVector(vector, l_entry, path);
            }
            path.push(l_name);
        }
    }

    private NameEntry extractNameEntry(ValueEntry holder, String name) {
        if (holder != null) {
            return holder.getNameEntry(name);
        }
        return null;
    }

    private ValueEntry extractValueEntry(NameEntry holder, int index) {
        if (holder != null) {
            return holder.getValueEntry(index);
        }
        return null;
    }

    private Vector handleSourcePath(NameEntry root, Stack path) {
        Vector l_vector = new Vector();
        this.extendValueEntryVector(l_vector, root, path);
        return l_vector;
    }

    private Vector handleTargetPath(NameEntry root, Stack path) {
        Vector l_vector = new Vector();
        this.handleTargetPath(root, path, l_vector);
        return l_vector;
    }

    private void handleTargetPath(NameEntry entry, Stack path, Vector vector) {
        if (path.empty()) {
            vector.add(entry);
        } else {
            if (entry.getValueEntryCount() == 0) {
                entry.addValueEntry(new ValueEntry());
            }
            Enumeration l_enumeration = entry.getValueEntryEnumeration();
            while (l_enumeration.hasMoreElements()) {
                String l_name;
                ValueEntry l_valued = (ValueEntry)l_enumeration.nextElement();
                NameEntry l_named = l_valued.getNameEntry(l_name = (String)path.pop());
                if (l_named == null) {
                    l_named = new NameEntry(l_name);
                    l_valued.addNameEntry(l_named);
                }
                this.handleTargetPath(l_named, path, vector);
            }
        }
    }

    private NameEntry locateNameEntry(NameEntry entry, Stack path) {
        NameEntry l_named;
        if (path.empty()) {
            return entry;
        }
        ValueEntry l_valued = entry.getValueEntry(0);
        if (l_valued != null && (l_named = l_valued.getNameEntry((String)path.pop())) != null) {
            return this.locateNameEntry(l_named, path);
        }
        return null;
    }

    public IMessageValue map(IMessage target, IMessageValue source) {
        try {
            return this.map(this.m_factory.createMessageValue(target), source);
        }
        catch (InvocationException invocationException) {
            return null;
        }
    }

    public IMessageValue map(IMessageValue target, IMessageValue source) {
        NameEntry l_target;
        IMessage l_message;
        if (target != null && (l_message = target.getMessage()) != null && (l_target = this.createNameEntry(target)) != null) {
            NameEntry l_source = this.createNameEntry(source);
            Enumeration l_rule_enumeration = this.m_vector.elements();
            while (l_rule_enumeration.hasMoreElements()) {
                SimpleMappingRule l_rule = (SimpleMappingRule)l_rule_enumeration.nextElement();
                if (l_rule == null) continue;
                this.mapTree(l_target, l_rule.getTarget(), l_source, l_rule.getSource(), l_rule.getValue());
            }
            IMessageValue l_value = this.createMessageValue(l_message, l_target);
            BaseLogManager.info(this.getClass(), (String)"SingleValueMapping Begin:----------------------------------");
            SingleValueMapping.dumpNameEntry(l_target);
            BaseLogManager.info(this.getClass(), (String)"SingleValueMapping End----------------------------------");
            BaseLogManager.info(this.getClass(), (String)MessageValueUtils.dumpMessageValue(l_value));
            BaseLogManager.info(this.getClass(), (String)"----------------------------------");
            return l_value;
        }
        return null;
    }

    private void mapEveryEntry(NameEntry rootTarget, String pathTarget, NameEntry rootSource, String pathSource, String value) {
        if (pathTarget != null) {
            Vector l_vectorSource;
            Enumeration l_enumerationTarget = this.handleTargetPath(rootTarget, this.createStack(pathTarget)).elements();
            if (rootSource != null && pathSource != null && (l_vectorSource = this.handleSourcePath(rootSource, this.createStack(pathSource))).size() > 0) {
                while (l_enumerationTarget.hasMoreElements()) {
                    Enumeration l_enumerationSource = l_vectorSource.elements();
                    while (l_enumerationSource.hasMoreElements()) {
                        ((NameEntry)l_enumerationTarget.nextElement()).addValueEntry(new ValueEntry((ValueEntry)l_enumerationSource.nextElement(), true));
                    }
                }
                return;
            }
            if (value != null) {
                while (l_enumerationTarget.hasMoreElements()) {
                    ValueEntry l_valued = new ValueEntry();
                    l_valued.setValue(value);
                    ((NameEntry)l_enumerationTarget.nextElement()).addValueEntry(l_valued);
                }
            }
        }
    }

    private void mapFirstEntry(NameEntry rootTarget, String pathTarget, NameEntry rootSource, String pathSource, String value) {
        if (pathTarget != null) {
            NameEntry l_namedSource;
            NameEntry l_namedTarget = this.extendNameEntry(rootTarget, this.createStack(pathTarget));
            if (rootSource != null && pathSource != null && (l_namedSource = this.locateNameEntry(rootSource, this.createStack(pathSource))) != null && l_namedSource.getValueEntryCount() > 0) {
                Enumeration l_enumeration = l_namedSource.getValueEntryEnumeration();
                while (l_enumeration.hasMoreElements()) {
                    l_namedTarget.addValueEntry(new ValueEntry((ValueEntry)l_enumeration.nextElement(), true));
                }
                return;
            }
            if (value != null) {
                ValueEntry l_valued = new ValueEntry();
                l_valued.setValue(value);
                l_namedTarget.addValueEntry(l_valued);
            }
        }
    }

    private void mapTree(NameEntry rootTarget, String pathTarget, NameEntry rootSource, String pathSource, String value) {
        Vector l_vectorSource;
        TreeMappingRule l_rule = this.createTreeMappingRule(pathTarget, pathSource, value);
        if (l_rule != null && (l_vectorSource = this.createValueEntryVector(rootSource, l_rule.getSource(), l_rule.getValue())).size() > 0) {
            this.mapTree(rootTarget, l_rule.getTarget(), l_vectorSource, l_rule);
        }
    }

    private void mapTree(ValueEntry valuedTarget, ValueEntry valuedSource, TreeMappingRule rule) {
        if (rule.getChildCount() > 0) {
            Enumeration l_enumerationChild = rule.getChildEnumeration();
            while (l_enumerationChild.hasMoreElements()) {
                TreeMappingRule l_rule = (TreeMappingRule)l_enumerationChild.nextElement();
                Vector l_vectorSource = this.createValueEntryVector(valuedSource, l_rule.getSource(), l_rule.getValue());
                if (l_vectorSource.size() <= 0) continue;
                Stack l_stackTarget = l_rule.getTarget();
                if (l_stackTarget.empty()) {
                    Enumeration l_enumerationSource = l_vectorSource.elements();
                    while (l_enumerationSource.hasMoreElements()) {
                        this.mapTree(valuedTarget, (ValueEntry)l_enumerationSource.nextElement(), l_rule);
                    }
                    continue;
                }
                String l_name = (String)l_stackTarget.pop();
                NameEntry l_namedTarget = valuedTarget.getNameEntry(l_name);
                if (l_namedTarget == null) {
                    l_namedTarget = new NameEntry(l_name);
                    valuedTarget.addNameEntry(l_namedTarget);
                }
                this.mapTree(l_namedTarget, l_stackTarget, l_vectorSource, l_rule);
                l_stackTarget.push(l_name);
            }
        } else {
            this.mapTree(valuedTarget, valuedSource);
        }
    }

    private void mapTree(NameEntry namedTarget, Stack stackTarget, Vector vectorSource, TreeMappingRule rule) {
        if (stackTarget.empty()) {
            Enumeration l_enumeration = vectorSource.elements();
            while (l_enumeration.hasMoreElements()) {
                ValueEntry l_valuedSource = (ValueEntry)l_enumeration.nextElement();
                ValueEntry l_valuedTarget = new ValueEntry(l_valuedSource, false);
                namedTarget.addValueEntry(l_valuedTarget);
                this.mapTree(l_valuedTarget, l_valuedSource, rule);
            }
        } else {
            if (namedTarget.getValueEntryCount() == 0) {
                namedTarget.addValueEntry(new ValueEntry());
            }
            String l_name = (String)stackTarget.pop();
            Enumeration l_enumeration = namedTarget.getValueEntryEnumeration();
            while (l_enumeration.hasMoreElements()) {
                ValueEntry l_valuedTarget = (ValueEntry)l_enumeration.nextElement();
                NameEntry l_namedTarget = l_valuedTarget.getNameEntry(l_name);
                if (l_namedTarget == null) {
                    l_namedTarget = new NameEntry(l_name);
                    l_valuedTarget.addNameEntry(l_namedTarget);
                }
                this.mapTree(l_namedTarget, stackTarget, vectorSource, rule);
            }
            stackTarget.push(l_name);
        }
    }

    private void mapTree(ValueEntry valuedTarget, ValueEntry valuedSource) {
        Enumeration l_enumerationNamed = valuedSource.getNameEntryEnumeration();
        while (l_enumerationNamed.hasMoreElements()) {
            NameEntry l_namedSource = (NameEntry)l_enumerationNamed.nextElement();
            NameEntry l_namedTarget = valuedTarget.getNameEntry(l_namedSource.getName());
            if (l_namedTarget == null) {
                l_namedTarget = new NameEntry(l_namedSource, false);
                valuedTarget.addNameEntry(l_namedTarget);
            }
            Enumeration l_enumerationValued = l_namedSource.getValueEntryEnumeration();
            while (l_enumerationValued.hasMoreElements()) {
                ValueEntry l_valuedSource = (ValueEntry)l_enumerationValued.nextElement();
                ValueEntry l_valuedTarget = new ValueEntry(l_valuedSource, false);
                l_namedTarget.addValueEntry(l_valuedTarget);
                this.mapTree(l_valuedTarget, l_valuedSource);
            }
        }
    }

    private static void dumpNameEntry(NameEntry entry) {
        String l_name = entry.getName();
        BaseLogManager.info((Class)(class$com$sap$caf$mp$core$data$mapping$base$SingleValueMapping == null ? (class$com$sap$caf$mp$core$data$mapping$base$SingleValueMapping = SingleValueMapping.class$("com.sap.caf.mp.core.data.mapping.base.SingleValueMapping")) : class$com$sap$caf$mp$core$data$mapping$base$SingleValueMapping), (String)("<" + l_name + ">"));
        Enumeration l_valued_enumeration = entry.getValueEntryEnumeration();
        while (l_valued_enumeration.hasMoreElements()) {
            ValueEntry l_valued = (ValueEntry)l_valued_enumeration.nextElement();
            BaseLogManager.info((Class)(class$com$sap$caf$mp$core$data$mapping$base$SingleValueMapping == null ? SingleValueMapping.class$("com.sap.caf.mp.core.data.mapping.base.SingleValueMapping") : class$com$sap$caf$mp$core$data$mapping$base$SingleValueMapping), (String)l_valued.getValue());
            Enumeration l_named_enumeration = l_valued.getNameEntryEnumeration();
            while (l_named_enumeration.hasMoreElements()) {
                SingleValueMapping.dumpNameEntry((NameEntry)l_named_enumeration.nextElement());
            }
        }
        BaseLogManager.info((Class)(class$com$sap$caf$mp$core$data$mapping$base$SingleValueMapping == null ? (class$com$sap$caf$mp$core$data$mapping$base$SingleValueMapping = SingleValueMapping.class$("com.sap.caf.mp.core.data.mapping.base.SingleValueMapping")) : class$com$sap$caf$mp$core$data$mapping$base$SingleValueMapping), (String)("</" + l_name + ">"));
    }

    public static void main(String[] args) {
        try {
            TypeFactory l_factoryType = new TypeFactory();
            TypeValueFactory l_factoryValue = new TypeValueFactory();
            IMessage l_first_message = l_factoryType.createMessage("First_Message");
            IMessagepart l_first_messagepart = l_factoryType.createMessagepart("First_Messagepart");
            l_first_message.addMessagepart(l_first_messagepart);
            IComplexType l_first_complex_type = l_factoryType.createComplexType();
            l_first_messagepart.setStructure(l_first_complex_type);
            ISimpleType l_first_simple_type = l_factoryType.createSimpleType(12);
            IElement l_first_element_one = l_factoryType.createElement("First_Element_One");
            l_first_element_one.setType(l_first_simple_type);
            l_first_complex_type.addElement(l_first_element_one);
            IElement l_first_element_two = l_factoryType.createElement("First_Element_Two");
            l_first_element_two.setType(l_first_simple_type);
            l_first_complex_type.addElement(l_first_element_two);
            IMessageValue l_first_message_value = l_factoryValue.createMessageValue(l_first_message);
            IMessagepartValue l_first_messagepart_value = l_factoryValue.createMessagepartValue(l_first_messagepart);
            l_first_message_value.addMessagepartValue(l_first_messagepart_value);
            IComplexTypeValue l_first_complex_type_value = l_factoryValue.createComplexTypeValue(l_first_complex_type);
            l_first_messagepart_value.setStructureValue(l_first_complex_type_value);
            IElementValue l_first_element_value_one = l_factoryValue.createElementValue(l_first_element_one);
            l_first_complex_type_value.addElementValue(l_first_element_value_one);
            ISimpleTypeValue l_first_string_value_one = l_factoryValue.createSimpleTypeValue(l_first_simple_type);
            l_first_element_value_one.addTypeValue(l_first_string_value_one);
            l_first_string_value_one.setValue("abc");
            IElementValue l_first_element_value_two = l_factoryValue.createElementValue(l_first_element_two);
            l_first_complex_type_value.addElementValue(l_first_element_value_two);
            ISimpleTypeValue l_first_string_value_two = l_factoryValue.createSimpleTypeValue(l_first_simple_type);
            l_first_element_value_two.addTypeValue(l_first_string_value_two);
            l_first_string_value_two.setValue("xyz");
            System.out.println(MessageValueUtils.dumpMessageValue(l_first_message_value));
            IMessage l_second_message = l_factoryType.createMessage("Second_Message");
            IMessagepart l_second_messagepart = l_factoryType.createMessagepart("Second_Messagepart");
            l_second_message.addMessagepart(l_second_messagepart);
            IComplexType l_second_complex_type = l_factoryType.createComplexType();
            l_second_messagepart.setStructure(l_second_complex_type);
            ISimpleType l_second_simple_type = l_factoryType.createSimpleType(12);
            IElement l_second_element_one = l_factoryType.createElement("Second_Element_One");
            l_second_element_one.setType(l_second_simple_type);
            l_second_complex_type.addElement(l_second_element_one);
            IElement l_second_element_two = l_factoryType.createElement("Second_Element_Two");
            l_second_element_two.setType(l_second_simple_type);
            l_second_complex_type.addElement(l_second_element_two);
            SingleValueMapping l_mapping = new SingleValueMapping();
            l_mapping.addMappingRule(new SimpleMappingRule("Second_Messagepart[Second_Element_One,Second_Element_Two]", "First_Messagepart[First_Element_Two,First_Element_One]", "Default 1"));
            IMessageValue l_second_message_value = l_mapping.map(l_second_message, l_first_message_value);
            System.out.println(MessageValueUtils.dumpMessageValue(l_second_message_value));
        }
        catch (Exception l_exception) {
            l_exception.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TreeMappingRule {
        private Stack m_source;
        private Stack m_target;
        private String m_value;
        private Vector m_vector;

        public TreeMappingRule(Stack target, Stack source, String value) {
            this.m_target = target;
            this.m_source = source;
            this.m_value = value;
            this.m_vector = new Vector();
        }

        public void addChild(TreeMappingRule child) {
            this.m_vector.add(child);
        }

        public TreeMappingRule getChild(int index) {
            TreeMappingRule l_child;
            try {
                l_child = (TreeMappingRule)this.m_vector.elementAt(index);
            }
            catch (ArrayIndexOutOfBoundsException l_exception) {
                l_child = null;
            }
            return l_child;
        }

        public int getChildCount() {
            return this.m_vector.size();
        }

        public Enumeration getChildEnumeration() {
            return this.m_vector.elements();
        }

        public Stack getSource() {
            return this.m_source;
        }

        public Stack getTarget() {
            return this.m_target;
        }

        public String getValue() {
            return this.m_value;
        }
    }

    private class ValueEntry {
        private String m_value;
        private Hashtable m_hashtable;

        public ValueEntry() {
            this.initialize();
        }

        public ValueEntry(ValueEntry source, boolean deep) {
            this.initialize();
            this.setValue(source.getValue());
            if (deep) {
                Enumeration l_enumeration = source.getNameEntryEnumeration();
                while (l_enumeration.hasMoreElements()) {
                    this.addNameEntry(new NameEntry((NameEntry)l_enumeration.nextElement(), true));
                }
            }
        }

        public NameEntry addNameEntry(NameEntry entry) {
            return this.m_hashtable.put(entry.getName(), entry);
        }

        public NameEntry getNameEntry(String name) {
            if (name != null) {
                return (NameEntry)this.m_hashtable.get(name);
            }
            return null;
        }

        public Enumeration getNameEntryEnumeration() {
            return this.m_hashtable.elements();
        }

        public String getValue() {
            return this.m_value;
        }

        private final void initialize() {
            this.m_value = null;
            this.m_hashtable = new Hashtable();
        }

        public void setValue(String value) {
            this.m_value = value;
        }
    }

    private class NameEntry {
        private String m_name;
        private Vector m_vector;

        public NameEntry(String name) {
            this.initialize(name);
        }

        public NameEntry(NameEntry source, boolean deep) {
            this.initialize(source.getName());
            if (deep) {
                Enumeration l_enumeration = source.getValueEntryEnumeration();
                while (l_enumeration.hasMoreElements()) {
                    this.addValueEntry(new ValueEntry((ValueEntry)l_enumeration.nextElement(), true));
                }
            }
        }

        public void addValueEntry(ValueEntry entry) {
            this.m_vector.add(entry);
        }

        public String getName() {
            return this.m_name;
        }

        public ValueEntry getValueEntry(int index) {
            ValueEntry l_entry;
            try {
                l_entry = (ValueEntry)this.m_vector.elementAt(index);
            }
            catch (ArrayIndexOutOfBoundsException l_exception) {
                l_entry = null;
            }
            return l_entry;
        }

        public int getValueEntryCount() {
            return this.m_vector.size();
        }

        public Enumeration getValueEntryEnumeration() {
            return this.m_vector.elements();
        }

        private final void initialize(String name) {
            this.m_name = name;
            this.m_vector = new Vector();
        }
    }
}

