/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.ejb;

import com.tssap.j2ee.core.utils.UtilsPlugin;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public final class EjbPlugin
extends Plugin {
    public static final String ID = "com.tssap.j2ee.core.ejb";
    private boolean myTracing;
    private static EjbPlugin ourInstance;
    private int myGlobalIsAutomaticSynchronizationEnabled = 0;

    public EjbPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        ourInstance = this;
        this.myTracing = UtilsPlugin.getTraceDebugOption((IPluginDescriptor)descriptor);
    }

    public static EjbPlugin getDefault() {
        return ourInstance;
    }

    public boolean isTracing() {
        return this.myTracing;
    }

    public static void logInfo(String text) {
        EjbPlugin instance = EjbPlugin.getDefault();
        if (instance == null) {
            return;
        }
        if (!instance.isDebugging()) {
            return;
        }
        EjbPlugin.log(1, text);
    }

    public static void logError(String text) {
        EjbPlugin.log(4, text);
    }

    public static void logError(String text, Throwable cause) {
        EjbPlugin.log(4, text, cause);
    }

    public static void logWarning(String text) {
        EjbPlugin.log(2, text);
    }

    public static void logWarning(String text, Throwable cause) {
        EjbPlugin.log(2, text, cause);
    }

    protected static void log(int type, String text) {
        EjbPlugin instance = EjbPlugin.getDefault();
        if (instance != null && instance.isTracing()) {
            EjbPlugin.log(type, text, new Throwable());
        } else {
            EjbPlugin.log(type, text, null);
        }
    }

    protected static void log(int type, String text, Throwable cause) {
        EjbPlugin instance = EjbPlugin.getDefault();
        if (instance == null) {
            System.err.println(text);
            if (cause != null) {
                cause.printStackTrace(System.err);
            }
        } else {
            String id = instance.getDescriptor().getUniqueIdentifier();
            Status status = new Status(type, id, 0, text, cause);
            instance.getLog().log((IStatus)status);
        }
    }

    public void setGlobalAutomaticSynchronizationEnabled(boolean enabled) {
        if (enabled) {
            --this.myGlobalIsAutomaticSynchronizationEnabled;
            if (this.myGlobalIsAutomaticSynchronizationEnabled < 0) {
                throw new IllegalStateException("Illegal state reached: myGlobalIsAutomaticSynchronizationEnabled < 0");
            }
        } else {
            ++this.myGlobalIsAutomaticSynchronizationEnabled;
        }
    }

    public boolean isGlobalAutomaticSynchronizationEnabled() {
        return this.myGlobalIsAutomaticSynchronizationEnabled == 0;
    }
}

