/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tablebrowser.tree;

import com.sap.dictionary.tools.tablebrowser.tree.TableContentProvider2;
import com.sap.sql.catalog.Column;
import com.sap.sql.catalog.Table;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TableSelectionDialog2
extends TitleAreaDialog
implements SelectionListener {
    private static final String TITLE = "Dictionary Table Browser";
    private IProject project;
    private Shell shell;
    private Tree tree;
    private Table table;
    private Table tblCurrent;
    private TableContentProvider2 contentProvider;

    public TableSelectionDialog2(IProject project, Shell parentShell) {
        this(project, parentShell, null);
    }

    public TableSelectionDialog2(IProject project, Shell parentShell, Table tblCurrent) {
        super(parentShell);
        this.project = project;
        this.shell = parentShell;
        this.tblCurrent = tblCurrent;
        this.table = tblCurrent;
    }

    public Table getTable() {
        return this.table;
    }

    protected Control createDialogArea(Composite parent) {
        Composite cParent = (Composite)super.createDialogArea(parent);
        Composite cContent = new Composite(cParent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.numColumns = 1;
        cContent.setLayout((Layout)layout);
        cContent.setLayoutData((Object)new GridData(1808));
        cContent.setFont(cParent.getFont());
        this.tree = new Tree(cContent, 2048);
        this.tree.addSelectionListener((SelectionListener)this);
        this.contentProvider = new TableContentProvider2(this.tree, this.project, this.shell, (Dialog)this, this.tblCurrent);
        GridData data = new GridData(1040);
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        this.tree.setLayoutData((Object)data);
        this.setTitle(TITLE);
        this.getShell().setText(TITLE);
        this.setMessage("Select DB Table from your Dictionary Projects");
        return cParent;
    }

    protected Point getInitialSize() {
        Point size = super.getInitialSize();
        size.y += 100;
        return size;
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        this.widgetSelected(event);
    }

    public void widgetSelected(SelectionEvent event) {
        if (this.tree.equals(event.getSource())) {
            TreeItem[] selection = this.tree.getSelection();
            if (selection != null && selection.length > 0) {
                TreeItem element = selection[0];
                if (element.getData() instanceof Table) {
                    this.table = (Table)element.getData();
                    this.getButton(0).setEnabled(true);
                    return;
                }
                if (element.getData() instanceof Column) {
                    Column column = (Column)element.getData();
                    this.table = column.getTable();
                    this.getButton(0).setEnabled(true);
                    return;
                }
            }
            this.getButton(0).setEnabled(false);
        }
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button superButton = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            superButton.setEnabled(false);
        }
        return superButton;
    }

    public void setOKButton(boolean enabled) {
        this.getButton(0).setEnabled(enabled);
    }
}

