/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tablebrowser.tree;

import com.sap.dictionary.database.catalog.DbGeneralStructure;
import com.sap.dictionary.database.catalog.XmlCatalogReader;
import com.sap.dictionary.tools.generation.eclipse.GenerationAction;
import com.sap.dictionary.tools.generation.eclipse.GenerationEclipse;
import com.sap.dictionary.tools.tablebrowser.TableBrowserPlugin;
import com.sap.dictionary.tools.tablebrowser.tree.TableSelectionDialog2;
import com.sap.dictionary.tools.ui.image.DictionaryImage;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.sql.catalog.Column;
import com.sap.sql.catalog.ColumnIterator;
import com.sap.sql.catalog.Table;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TableContentProvider2 {
    private static final String WARNING_THREAD_NOT_FINISHED = "Dialog were closed before thread was finished.";
    private static final String GEN_TABLE_FILE_EXTENSION = "gdbtable";
    private static final String PP_FILE_EXTENSION = "jar";
    private static final String ECLIPSE_PROJECT_DDIC_NATURE = "com.sap.dictionary.tools.archivebuilder.DictionaryNature";
    private static final String ECLIPSE_PROJECT_WEBDYNPRO_NATURE = "com.sap.ide.webdynpro.archivebuilder.WebDynproNature";
    private static final String ECLIPSE_PROJECT_COMPONENT_NATURE = "com.sap.ide.eclipse.component.provider.componentnature";
    private static final String PROJECT_SUBPATH_GEN_TABLES = GenerationEclipse.getGenerationOutputPathInfix() + "/dbtables";
    private static Image imgProject = SapIdeUtilImages.getWorkbenchImage((String)"IMG_OBJ_PROJECT");
    private static Image imgTable = SapIdeUtilImages.getSapImage((ISapImage)DictionaryImage.ICON_OUTLINE_UITABLE);
    private static Image imgColumn = SapIdeUtilImages.getSapImage((ISapImage)DictionaryImage.ICON_OUTLINE_FIELD);
    private static TracerI tracer = TracingManager.getTracer((Class)(class$com$sap$dictionary$tools$tablebrowser$tree$TableContentProvider2 == null ? (class$com$sap$dictionary$tools$tablebrowser$tree$TableContentProvider2 = TableContentProvider2.class$("com.sap.dictionary.tools.tablebrowser.tree.TableContentProvider2")) : class$com$sap$dictionary$tools$tablebrowser$tree$TableContentProvider2));
    private Tree tree;
    private TreeItem item;
    private Display display;
    private Table tblCurrent;
    private Dialog dialog;
    static /* synthetic */ Class class$com$sap$dictionary$tools$tablebrowser$tree$TableContentProvider2;

    public TableContentProvider2(Tree tree, IProject project, Shell shell, Dialog dialog) {
        this(tree, project, shell, dialog, null);
    }

    public TableContentProvider2(Tree tree, IProject project, Shell shell, Dialog dialog, Table tblCurrent) {
        this.display = shell.getDisplay();
        this.tree = tree;
        this.tblCurrent = tblCurrent;
        this.dialog = dialog;
        if (project != null) {
            Thread thread = new Thread(new SubTreeProject(project, tree));
            thread.setPriority(1);
            thread.start();
        } else {
            Thread thread = new Thread(new SubTreeWorkspace(tree));
            thread.setPriority(1);
            thread.start();
        }
    }

    private synchronized TreeItem createTreeItem(Object data) {
        if (!this.tree.isDisposed()) {
            int index = -1;
            if (data instanceof Table) {
                String name = ((Table)data).getName();
                TreeItem[] items = this.tree.getItems();
                int i = 0;
                while (i < items.length) {
                    if (items[i].getText().compareTo(name) > 0) {
                        index = i;
                        break;
                    }
                    ++i;
                }
            }
            TreeItem ti = null;
            ti = index == -1 ? new TreeItem(this.tree, 0) : new TreeItem(this.tree, 0, index);
            this.setTreeItemParameters(ti, data);
            return ti;
        }
        return null;
    }

    private synchronized TreeItem createTreeItem(TreeItem item, Object data) {
        this.item = item;
        if (!this.item.isDisposed()) {
            int index = -1;
            if (data instanceof Table) {
                String name = ((Table)data).getName();
                TreeItem[] items = this.tree.getItems();
                int i = 0;
                while (i < items.length) {
                    if (items[i].getText().compareTo(name) > 0) {
                        index = i;
                        break;
                    }
                    ++i;
                }
            }
            TreeItem ti = null;
            ti = index == -1 ? new TreeItem(this.item, 0) : (index > item.getItemCount() ? new TreeItem(this.item, 0) : new TreeItem(this.item, 0, index));
            this.setTreeItemParameters(ti, data);
            return ti;
        }
        return null;
    }

    private void setTreeItemParameters(TreeItem ti, Object data) {
        if (data instanceof Column) {
            Column column = (Column)data;
            ti.setText(column.getName() + " : " + column.getTypeName());
            ti.setImage(imgColumn);
            ti.setData((Object)column);
        } else if (data instanceof Table) {
            Table table = (Table)data;
            ti.setText(table.getName());
            ti.setImage(imgTable);
            ti.setData((Object)table);
            if (this.tblCurrent != null && table.getName().equals(this.tblCurrent.getName())) {
                TreeItem[] tiSelected = new TreeItem[]{ti};
                this.tree.setSelection(tiSelected);
                ((TableSelectionDialog2)this.dialog).setOKButton(true);
            }
        } else if (data instanceof IProject) {
            IProject project = (IProject)data;
            ti.setText(project.getName());
            ti.setImage(imgProject);
            ti.setData((Object)project);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ TreeItem access$200(TableContentProvider2 x0, Object x1) {
        return x0.createTreeItem(x1);
    }

    static /* synthetic */ TreeItem access$1200(TableContentProvider2 x0, TreeItem x1, Object x2) {
        return x0.createTreeItem(x1, x2);
    }

    class SubTreeTable
    implements Runnable {
        private Table table;
        private TreeItem item;

        public SubTreeTable(Table table, TreeItem parent) {
            this.table = table;
            this.item = parent;
        }

        public void run() {
            ColumnIterator colIt = this.table.getColumns();
            while (colIt.hasNext()) {
                Column column = colIt.next();
                TableContentProvider2.this.display.asyncExec(new Runnable(this, column){
                    private final /* synthetic */ Column val$column;
                    private final /* synthetic */ SubTreeTable this$1;
                    {
                        this.this$1 = this$1;
                        this.val$column = val$column;
                    }

                    public void run() {
                        TableContentProvider2.access$1200(SubTreeTable.access$1400(this.this$1), SubTreeTable.access$1300(this.this$1), this.val$column);
                    }
                });
            }
        }

        static /* synthetic */ TreeItem access$1300(SubTreeTable x0) {
            return x0.item;
        }

        static /* synthetic */ TableContentProvider2 access$1400(SubTreeTable x0) {
            return x0.TableContentProvider2.this;
        }
    }

    class SubTreeProject
    implements Runnable {
        private IProject project;
        private Tree tree;
        private TreeItem item;
        private TreeItem tiTable;

        public SubTreeProject(IProject project, Tree parent) {
            this.project = project;
            this.tree = parent;
            this.item = null;
        }

        public SubTreeProject(IProject project, TreeItem parent) {
            this.project = project;
            this.tree = null;
            this.item = parent;
        }

        public void run() {
            block14: {
                IPath projectPath = this.project.getLocation();
                if (projectPath != null) {
                    try {
                        if (this.project.isNatureEnabled(TableContentProvider2.ECLIPSE_PROJECT_DDIC_NATURE) && !this.project.isNatureEnabled(TableContentProvider2.ECLIPSE_PROJECT_WEBDYNPRO_NATURE)) {
                            Display.getDefault().syncExec(new Runnable(this){
                                private final /* synthetic */ SubTreeProject this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                public void run() {
                                    MetamodelManager.getMetamodelManager((String)SubTreeProject.access$500(this.this$1).getName()).saveAllMetaData();
                                    boolean isAutoBuilding = ResourcesPlugin.getWorkspace().isAutoBuilding();
                                    if (!isAutoBuilding) {
                                        GenerationAction generationAction = new GenerationAction(SubTreeProject.access$500(this.this$1), true);
                                        generationAction.run((IAction)null);
                                    }
                                }
                            });
                            String tablePath = projectPath.toString() + PROJECT_SUBPATH_GEN_TABLES;
                            XmlCatalogReader reader = new XmlCatalogReader(tablePath);
                            IFolder projectFolder = this.project.getFolder(PROJECT_SUBPATH_GEN_TABLES);
                            projectFolder.accept(new IResourceVisitor(this, reader){
                                private final /* synthetic */ XmlCatalogReader val$reader;
                                private final /* synthetic */ SubTreeProject this$1;
                                {
                                    this.this$1 = this$1;
                                    this.val$reader = val$reader;
                                }

                                public boolean visit(IResource resource) throws CoreException {
                                    if ("gdbtable".equalsIgnoreCase(resource.getFileExtension())) {
                                        String tableName = SubTreeProject.access$700(this.this$1, resource);
                                        SubTreeProject.access$800(this.this$1, this.val$reader, tableName);
                                    }
                                    return true;
                                }
                            });
                        }
                    }
                    catch (SQLException e2) {
                        tracer.error("catalog reader", (Throwable)e2);
                    }
                    catch (CoreException e) {
                        tracer.error("error", (Throwable)e);
                    }
                    try {
                        if (!this.project.hasNature(TableContentProvider2.ECLIPSE_PROJECT_COMPONENT_NATURE)) break block14;
                        IJavaProject jProject = JavaCore.create((IProject)this.project);
                        IClasspathEntry[] cpEntries = jProject.getRawClasspath();
                        int i = 0;
                        while (i < cpEntries.length) {
                            if (1 == cpEntries[i].getEntryKind() && TableContentProvider2.PP_FILE_EXTENSION.equalsIgnoreCase(cpEntries[i].getPath().getFileExtension())) {
                                try {
                                    ZipFile zipFile = new ZipFile(cpEntries[i].getPath().toFile());
                                    XmlCatalogReader zipReader = new XmlCatalogReader(zipFile.getName());
                                    Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                                    while (enumeration.hasMoreElements()) {
                                        ZipEntry zipEntry = enumeration.nextElement();
                                        String fileExtension = zipEntry.getName().substring(zipEntry.getName().lastIndexOf(46) + 1);
                                        if (!TableContentProvider2.GEN_TABLE_FILE_EXTENSION.equalsIgnoreCase(fileExtension)) continue;
                                        String tableName = zipEntry.getName().substring(0, zipEntry.getName().lastIndexOf(46));
                                        this.getTableFromCatalogReader(zipReader, tableName);
                                    }
                                }
                                catch (ZipException e) {
                                    tracer.error("zip file", (Throwable)e);
                                }
                                catch (IOException e) {
                                    tracer.error("zip gile", (Throwable)e);
                                }
                                catch (SQLException e2) {
                                    tracer.error("", (Throwable)e2);
                                }
                            }
                            ++i;
                        }
                    }
                    catch (CoreException e) {
                        tracer.error("core", (Throwable)e);
                    }
                }
            }
        }

        private void getTableFromCatalogReader(XmlCatalogReader reader, String tableName) {
            try {
                if (reader.existsTable(tableName)) {
                    String predAct;
                    Table table = reader.getTable(tableName);
                    if (table instanceof DbGeneralStructure && (predAct = ((DbGeneralStructure)table).getPredefinedAction()) != null && predAct.equals("DROP")) {
                        return;
                    }
                    if (this.tree != null) {
                        TableContentProvider2.this.display.syncExec(new Runnable(this, table){
                            private final /* synthetic */ Table val$table;
                            private final /* synthetic */ SubTreeProject this$1;
                            {
                                this.this$1 = this$1;
                                this.val$table = val$table;
                            }

                            public void run() {
                                SubTreeProject.access$902(this.this$1, TableContentProvider2.access$200(SubTreeProject.access$1000(this.this$1), this.val$table));
                            }
                        });
                    } else {
                        TableContentProvider2.this.display.syncExec(new Runnable(this, table){
                            private final /* synthetic */ Table val$table;
                            private final /* synthetic */ SubTreeProject this$1;
                            {
                                this.this$1 = this$1;
                                this.val$table = val$table;
                            }

                            public void run() {
                                SubTreeProject.access$902(this.this$1, TableContentProvider2.access$1200(SubTreeProject.access$1000(this.this$1), SubTreeProject.access$1100(this.this$1), this.val$table));
                            }
                        });
                    }
                    if (this.tiTable != null) {
                        Thread thread = new Thread(new SubTreeTable(table, this.tiTable));
                        thread.setPriority(1);
                        thread.start();
                    }
                }
            }
            catch (SQLException e) {
                tracer.error("sql error", (Throwable)e);
            }
        }

        private String getTableName(IResource file) {
            String tableName = file.getName().substring(0, file.getName().lastIndexOf(46));
            return tableName.toUpperCase();
        }

        static /* synthetic */ IProject access$500(SubTreeProject x0) {
            return x0.project;
        }

        static /* synthetic */ String access$700(SubTreeProject x0, IResource x1) {
            return x0.getTableName(x1);
        }

        static /* synthetic */ void access$800(SubTreeProject x0, XmlCatalogReader x1, String x2) {
            x0.getTableFromCatalogReader(x1, x2);
        }

        static /* synthetic */ TreeItem access$902(SubTreeProject x0, TreeItem x1) {
            x0.tiTable = x1;
            return x0.tiTable;
        }

        static /* synthetic */ TableContentProvider2 access$1000(SubTreeProject x0) {
            return x0.TableContentProvider2.this;
        }

        static /* synthetic */ TreeItem access$1100(SubTreeProject x0) {
            return x0.item;
        }
    }

    class SubTreeWorkspace
    implements Runnable {
        private Tree tree;
        private TreeItem tiProject;

        public SubTreeWorkspace(Tree parent) {
            this.tree = parent;
        }

        public void run() {
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IProject[] projects = workspaceRoot.getProjects();
            int i = 0;
            while (i < projects.length) {
                try {
                    if (projects[i].isOpen() && (projects[i].isNatureEnabled(TableContentProvider2.ECLIPSE_PROJECT_DDIC_NATURE) && !projects[i].isNatureEnabled(TableContentProvider2.ECLIPSE_PROJECT_WEBDYNPRO_NATURE) || this.isComponentWithTables(projects[i]))) {
                        int j = i;
                        TableContentProvider2.this.display.syncExec(new Runnable(this, projects, j){
                            private final /* synthetic */ IProject[] val$projects;
                            private final /* synthetic */ int val$j;
                            private final /* synthetic */ SubTreeWorkspace this$1;
                            {
                                this.this$1 = this$1;
                                this.val$projects = val$projects;
                                this.val$j = val$j;
                            }

                            public void run() {
                                SubTreeWorkspace.access$002(this.this$1, TableContentProvider2.access$200(SubTreeWorkspace.access$100(this.this$1), this.val$projects[this.val$j]));
                            }
                        });
                        if (this.tiProject != null) {
                            Thread thread = new Thread(new SubTreeProject(projects[i], this.tiProject));
                            thread.setPriority(1);
                            thread.start();
                        }
                    }
                }
                catch (CoreException e) {
                    tracer.error("subtreeworkspcae class", (Throwable)e);
                }
                ++i;
            }
        }

        private boolean isComponentWithTables(IProject project) throws CoreException {
            if (project.isNatureEnabled(TableContentProvider2.ECLIPSE_PROJECT_COMPONENT_NATURE)) {
                IJavaProject jProject = JavaCore.create((IProject)project);
                try {
                    IClasspathEntry[] cpEntries = jProject.getRawClasspath();
                    int i = 0;
                    while (i < cpEntries.length) {
                        if (1 == cpEntries[i].getEntryKind() && TableContentProvider2.PP_FILE_EXTENSION.equalsIgnoreCase(cpEntries[i].getPath().getFileExtension())) {
                            try {
                                ZipFile zipFile = new ZipFile(cpEntries[i].getPath().toFile());
                                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                                while (enumeration.hasMoreElements()) {
                                    ZipEntry zipEntry = enumeration.nextElement();
                                    String fileExtension = zipEntry.getName().substring(zipEntry.getName().lastIndexOf(46) + 1);
                                    if (!TableContentProvider2.GEN_TABLE_FILE_EXTENSION.equalsIgnoreCase(fileExtension)) continue;
                                    return true;
                                }
                            }
                            catch (ZipException e) {
                                tracer.error("get zip file", (Throwable)e);
                            }
                            catch (IOException e) {
                                tracer.error("get zip file", (Throwable)e);
                            }
                        }
                        ++i;
                    }
                }
                catch (JavaModelException e) {
                    TableBrowserPlugin.tracer.error("dc lookup", (Throwable)e);
                }
            }
            return false;
        }

        static /* synthetic */ TreeItem access$002(SubTreeWorkspace x0, TreeItem x1) {
            x0.tiProject = x1;
            return x0.tiProject;
        }

        static /* synthetic */ TableContentProvider2 access$100(SubTreeWorkspace x0) {
            return x0.TableContentProvider2.this;
        }
    }
}

