/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tablebrowser;

import com.sap.dictionary.tools.tablebrowser.TableContentProvider;
import com.sap.dictionary.tools.tablebrowser.TableLabelProvider;
import com.sap.sql.catalog.Column;
import com.sap.sql.catalog.Table;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TableSelectionDialog
extends TitleAreaDialog
implements ISelectionChangedListener {
    private static final String TITLE = "Dictionary Table Browser";
    private IProject project;
    private Shell shell;
    private TreeViewer treeViewer;
    private Table table;

    public TableSelectionDialog(IProject project, Shell parentShell) {
        super(parentShell);
        this.project = project;
        this.shell = parentShell;
    }

    public Table getTable() {
        return this.table;
    }

    protected Control createDialogArea(Composite parent) {
        Composite cParent = (Composite)super.createDialogArea(parent);
        Composite cContent = new Composite(cParent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.numColumns = 1;
        cContent.setLayout((Layout)layout);
        cContent.setLayoutData((Object)new GridData(1808));
        cContent.setFont(cParent.getFont());
        this.treeViewer = new TreeViewer(cContent);
        this.treeViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        if (this.project != null) {
            this.treeViewer.setInput((Object)this.project);
        } else {
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            this.treeViewer.setInput((Object)workspaceRoot);
        }
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        GridData data = new GridData(1040);
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        this.treeViewer.getControl().setLayoutData((Object)data);
        this.setTitle(TITLE);
        return cParent;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.treeViewer.equals(event.getSource())) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection != null && selection.size() > 0) {
                Object element = selection.getFirstElement();
                if (element instanceof Table) {
                    this.table = (Table)element;
                    this.getButton(0).setEnabled(true);
                    return;
                }
                if (element instanceof Column) {
                    Column column = (Column)element;
                    this.table = column.getTable();
                    this.getButton(0).setEnabled(true);
                    return;
                }
            }
            this.getButton(0).setEnabled(false);
        }
    }

    protected Point getInitialSize() {
        Point size = super.getInitialSize();
        size.y += 100;
        return size;
    }
}

