/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tablebrowser;

import com.sap.dictionary.database.catalog.DbGeneralStructure;
import com.sap.dictionary.database.catalog.XmlCatalogReader;
import com.sap.dictionary.tools.generation.eclipse.GenerationEclipse;
import com.sap.dictionary.tools.tablebrowser.TableNotFoundException;
import com.sap.dictionary.tools.tablebrowser.tree.TableSelectionDialog2;
import com.sap.sql.catalog.Table;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.io.IOException;
import java.sql.SQLException;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class TableSelection {
    private static final String GEN_TABLE_FILE_EXTENSION = "gdbtable";
    private static final String ZIP_FILE_EXTENSION = "zip";
    private static final String ECLIPSE_PROJECT_DDIC_NATURE = "com.sap.dictionary.tools.archivebuilder.DictionaryNature";
    private static final String ECLIPSE_PROJECT_WEBDYNPRO_NATURE = "com.sap.ide.webdynpro.archivebuilder.WebDynproNature";
    private static final String ECLIPSE_PROJECT_COMPONENT_NATURE = "com.sap.ide.eclipse.component.provider.componentnature";
    private static final String PROJECT_SUBPATH_GEN_TABLES = GenerationEclipse.getGenerationOutputPathInfix() + "/dbtables";
    private static TracerI tracer = TracingManager.getTracer((Class)(class$com$sap$dictionary$tools$tablebrowser$TableSelection == null ? (class$com$sap$dictionary$tools$tablebrowser$TableSelection = TableSelection.class$("com.sap.dictionary.tools.tablebrowser.TableSelection")) : class$com$sap$dictionary$tools$tablebrowser$TableSelection));
    private IProject project;
    private Table table;
    static /* synthetic */ Class class$com$sap$dictionary$tools$tablebrowser$TableSelection;

    public TableSelection() {
        this(null);
    }

    public TableSelection(IProject project) {
        this.project = project;
    }

    public boolean open() {
        if (!this.dictionaryProjectsAvailable()) {
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"No DB Tables found!", (String)"You have to create a dictionary project with db tables.");
            return false;
        }
        TableSelectionDialog2 dialog = new TableSelectionDialog2(this.project, Display.getDefault().getActiveShell());
        if (dialog.open() == 0) {
            this.table = dialog.getTable();
            return true;
        }
        return false;
    }

    public boolean open(Table tblCurrent) {
        if (!this.dictionaryProjectsAvailable()) {
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"No DB Tables found!", (String)"You have to create a dictionary project with db tables.");
            return false;
        }
        TableSelectionDialog2 dialog = new TableSelectionDialog2(this.project, Display.getDefault().getActiveShell(), tblCurrent);
        if (dialog.open() == 0) {
            this.table = dialog.getTable();
            return true;
        }
        return false;
    }

    public boolean open(String tblCurrentName) throws TableNotFoundException {
        if (!this.dictionaryProjectsAvailable()) {
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"No DB Tables found!", (String)"You have to create a dictionary project with db tables.");
            return false;
        }
        Table tblCurrent = this.getTableByName(tblCurrentName);
        return this.open(tblCurrent);
    }

    public Table getTable() {
        return this.table;
    }

    public Table getTableByName(String tableName) throws TableNotFoundException {
        String predAct;
        String tblName = tableName.toUpperCase();
        if (this.project != null) {
            this.table = this.getTableFromProject(tblName, this.project);
        } else {
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IProject[] projects = workspaceRoot.getProjects();
            int i = 0;
            while (i < projects.length) {
                this.table = this.getTableFromProject(tblName, projects[i]);
                if (this.table != null) break;
                ++i;
            }
        }
        if (this.table == null) {
            throw new TableNotFoundException(tblName);
        }
        if (this.table instanceof DbGeneralStructure && (predAct = ((DbGeneralStructure)this.table).getPredefinedAction()) != null && predAct.equals("DROP")) {
            throw new TableNotFoundException(tblName);
        }
        return this.table;
    }

    private Table getTableFromProject(String tableName, IProject project) {
        block16: {
            if (project == null || !project.isOpen()) {
                return null;
            }
            IPath projectPath = project.getLocation();
            if (projectPath != null) {
                try {
                    String tablePath;
                    XmlCatalogReader reader;
                    if (project.isNatureEnabled(ECLIPSE_PROJECT_DDIC_NATURE) && !project.isNatureEnabled(ECLIPSE_PROJECT_WEBDYNPRO_NATURE) && (reader = new XmlCatalogReader(tablePath = projectPath.toString() + PROJECT_SUBPATH_GEN_TABLES)).existsTable(tableName)) {
                        return reader.getTable(tableName);
                    }
                }
                catch (CoreException e) {
                    tracer.error("get tables", (Throwable)e);
                }
                catch (SQLException e) {
                    tracer.error("get tables", (Throwable)e);
                }
                try {
                    if (!project.hasNature(ECLIPSE_PROJECT_COMPONENT_NATURE)) break block16;
                    IJavaProject jProject = JavaCore.create((IProject)project);
                    IClasspathEntry[] cpEntries = jProject.getRawClasspath();
                    int i = 0;
                    while (i < cpEntries.length) {
                        if (1 == cpEntries[i].getEntryKind() && ZIP_FILE_EXTENSION.equalsIgnoreCase(cpEntries[i].getPath().getFileExtension())) {
                            try {
                                ZipFile zipFile = new ZipFile(cpEntries[i].getPath().toFile());
                                XmlCatalogReader zipReader = new XmlCatalogReader(zipFile.getName());
                                if (zipReader.existsTable(tableName)) {
                                    return zipReader.getTable(tableName);
                                }
                            }
                            catch (ZipException e) {
                                tracer.error(ZIP_FILE_EXTENSION, (Throwable)e);
                            }
                            catch (IOException e) {
                                tracer.error(ZIP_FILE_EXTENSION, (Throwable)e);
                            }
                        }
                        ++i;
                    }
                }
                catch (JavaModelException e) {
                    tracer.error("", (Throwable)e);
                }
                catch (CoreException e) {
                    tracer.error("", (Throwable)e);
                }
                catch (SQLException e) {
                    tracer.error("", (Throwable)e);
                }
            }
        }
        return null;
    }

    private boolean dictionaryProjectsAvailable() {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = workspaceRoot.getProjects();
        int i = 0;
        while (i < projects.length) {
            try {
                if (projects[i].isOpen() && projects[i].hasNature(ECLIPSE_PROJECT_DDIC_NATURE) && !projects[i].hasNature(ECLIPSE_PROJECT_WEBDYNPRO_NATURE)) {
                    return true;
                }
            }
            catch (CoreException e) {
                tracer.error("couldn't get ddic nature for project " + projects[i].getName(), (Throwable)e);
            }
            ++i;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

