/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tablebrowser;

import com.sap.dictionary.database.catalog.XmlCatalogReader;
import com.sap.dictionary.tools.generation.eclipse.GenerationEclipse;
import com.sap.sql.catalog.Column;
import com.sap.sql.catalog.ColumnIterator;
import com.sap.sql.catalog.Table;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.sql.SQLException;
import java.util.Vector;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class TableContentProvider
implements ITreeContentProvider {
    private static final String GEN_TABLE_FILE_EXTENSION = "gdbtable";
    private static final String ECLIPSE_PROJECT_DDIC_NATURE = "com.sap.dictionary.tools.archivebuilder.DictionaryNature";
    private static final String ECLIPSE_PROJECT_WEBDYNPRO_NATURE = "com.sap.ide.webdynpro.archivebuilder.WebDynproNature";
    private static final String PROJECT_SUBPATH_GEN_TABLES = GenerationEclipse.getGenerationOutputPathInfix() + "/dbtables";
    private static TracerI tracer = TracingManager.getTracer((Class)(class$com$sap$dictionary$tools$tablebrowser$TableContentProvider == null ? (class$com$sap$dictionary$tools$tablebrowser$TableContentProvider = TableContentProvider.class$("com.sap.dictionary.tools.tablebrowser.TableContentProvider")) : class$com$sap$dictionary$tools$tablebrowser$TableContentProvider));
    static /* synthetic */ Class class$com$sap$dictionary$tools$tablebrowser$TableContentProvider;

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof Column) {
            return null;
        }
        if (parentElement instanceof Table) {
            Table table = (Table)parentElement;
            ColumnIterator colIt = table.getColumns();
            Object[] objects = new Object[table.getColumnCnt()];
            int i = 0;
            while (colIt.hasNext()) {
                objects[i] = colIt.next();
                ++i;
            }
            return objects;
        }
        if (parentElement instanceof IProject) {
            final Vector vReturn = new Vector();
            IProject project = (IProject)parentElement;
            IPath projectPath = project.getLocation();
            if (projectPath != null) {
                String tablePath = projectPath.toString() + PROJECT_SUBPATH_GEN_TABLES;
                try {
                    final XmlCatalogReader reader = new XmlCatalogReader(tablePath);
                    IFolder projectFolder = project.getFolder(PROJECT_SUBPATH_GEN_TABLES);
                    projectFolder.accept(new IResourceVisitor(){

                        public boolean visit(IResource resource) throws CoreException {
                            if (TableContentProvider.GEN_TABLE_FILE_EXTENSION.equalsIgnoreCase(resource.getFileExtension())) {
                                try {
                                    String tableName = TableContentProvider.this.getTableName(resource);
                                    if (reader.existsTable(tableName)) {
                                        Table table = reader.getTable(tableName);
                                        vReturn.add(table);
                                    }
                                }
                                catch (SQLException e) {
                                    tracer.error(e.getMessage(), (Throwable)e);
                                }
                            }
                            return true;
                        }
                    });
                }
                catch (SQLException e2) {
                    tracer.error("init catalog reader", (Throwable)e2);
                }
                catch (CoreException e) {
                    tracer.error("core exception:", (Throwable)e);
                }
            }
            return vReturn.toArray();
        }
        if (parentElement instanceof IWorkspaceRoot) {
            Vector<IProject> vReturn = new Vector<IProject>();
            IWorkspaceRoot workspaceRoot = (IWorkspaceRoot)parentElement;
            IProject[] projects = workspaceRoot.getProjects();
            int i = 0;
            while (i < projects.length) {
                try {
                    if (projects[i].isNatureEnabled(ECLIPSE_PROJECT_DDIC_NATURE) && !projects[i].isNatureEnabled(ECLIPSE_PROJECT_WEBDYNPRO_NATURE)) {
                        vReturn.add(projects[i]);
                    }
                }
                catch (CoreException e) {
                    tracer.error(e.getMessage(), (Throwable)e);
                }
                ++i;
            }
            return vReturn.toArray();
        }
        return null;
    }

    private String getTableName(IResource file) {
        String tableName = file.getName().substring(0, file.getName().lastIndexOf(46));
        return tableName.toUpperCase();
    }

    public Object getParent(Object element) {
        if (element instanceof Column) {
            Column column = (Column)element;
            return column.getTable();
        }
        if (element instanceof Table) {
            return null;
        }
        if (element instanceof IProject) {
            IProject project = (IProject)element;
            return project.getWorkspace();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof Column) {
            return false;
        }
        if (element instanceof Table) {
            Table table = (Table)element;
            return table.getColumnCnt() > 0;
        }
        if (element instanceof IProject) {
            return this.getChildren(element).length > 0;
        }
        if (element instanceof IWorkspaceRoot) {
            return this.getChildren(element).length > 0;
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

