/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.wizard.java;

import com.sap.ide.eclipse.dii.component.IDCExtendedProject;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.InvalidDefinitionException;
import com.sap.tc.devconf.RepositoryAccessException;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.List;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;

public class Util {
    public static final String SRC_DEFAULT = "src/packages";
    public static final String BUILD_OUTPUT_DEFAULT = "bin";
    private static TracerI theTracer = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$component$wizard$java$Util == null ? (class$com$sap$ide$eclipse$component$wizard$java$Util = Util.class$("com.sap.ide.eclipse.component.wizard.java.Util")) : class$com$sap$ide$eclipse$component$wizard$java$Util));
    static /* synthetic */ Class class$com$sap$ide$eclipse$component$wizard$java$Util;

    public static boolean isJavaProject(IProject project) {
        try {
            return project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (Throwable e) {
            com.sap.ide.eclipse.component.core.Util.logExceptionMessage(theTracer, 3, "check for DC Nature failed", e);
            return false;
        }
    }

    public static boolean isJavaProject(IProjectDescription projectDesc) {
        try {
            return projectDesc.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (Throwable e) {
            com.sap.ide.eclipse.component.core.Util.logExceptionMessage(theTracer, 3, "check Java Nature failed", e);
            return false;
        }
    }

    public static void setJavaCommand(IProject project, ICommand newCommand) throws CoreException {
        ICommand[] newCommands;
        if (project == null || project.getDescription() == null) {
            return;
        }
        IProjectDescription description = project.getDescription();
        ICommand[] oldCommands = description.getBuildSpec();
        ICommand oldJavaCommand = Util.getJavaCommand(description);
        if (oldJavaCommand == null) {
            newCommands = new ICommand[oldCommands.length + 1];
            System.arraycopy(oldCommands, 0, newCommands, 1, oldCommands.length);
            newCommands[0] = newCommand;
        } else {
            int i = 0;
            int max = oldCommands.length;
            while (i < max) {
                if (oldCommands[i] == oldJavaCommand) {
                    oldCommands[i] = newCommand;
                    break;
                }
                ++i;
            }
            newCommands = oldCommands;
        }
        description.setBuildSpec(newCommands);
        project.setDescription(description, null);
    }

    public static ICommand getJavaCommand(IProjectDescription description) throws CoreException {
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals("org.eclipse.jdt.core.javabuilder")) {
                return commands[i];
            }
            ++i;
        }
        return null;
    }

    public static boolean isInPackageFolder(IJavaElement element) {
        if (element == null) {
            return false;
        }
        try {
            IPackageFragmentRoot root = null;
            IJavaElement tempElement = element;
            while (tempElement != null && !(tempElement instanceof IPackageFragmentRoot)) {
                tempElement = tempElement.getParent();
            }
            if (tempElement instanceof IPackageFragmentRoot) {
                root = (IPackageFragmentRoot)tempElement;
            }
            if (root == null) {
                return false;
            }
            IPath path = root.getPath();
            String rootName = path.removeFirstSegments(1).makeRelative().toString();
            IProject prj = element.getJavaProject().getProject();
            IDCExtendedProject dcPrj = (IDCExtendedProject)prj.getNature("com.sap.ide.eclipse.component.provider.dcnature");
            if (dcPrj != null) {
                IDevelopmentComponentNode dcNode = dcPrj.getDCNode();
                if (dcNode == null) {
                    return false;
                }
                DevelopmentComponent dc = dcNode.getDevelopmentComponent(false);
                if (dc == null) {
                    return false;
                }
                List folders = dc.getPackageFolders();
                if (folders != null && folders.contains(rootName)) {
                    return true;
                }
            }
        }
        catch (RepositoryAccessException e) {
            com.sap.ide.eclipse.component.core.Util.logExceptionMessage(theTracer, 3, "check for Package Folder failed", e);
        }
        catch (InvalidDefinitionException e) {
            com.sap.ide.eclipse.component.core.Util.logExceptionMessage(theTracer, 3, "check for Package Folder failed", e);
        }
        catch (CoreException e) {
            com.sap.ide.eclipse.component.core.Util.logExceptionMessage(theTracer, 3, "check for Package Folder failed", e);
        }
        return false;
    }

    public static String getPackageName(IJavaElement element) {
        if (element == null || element.getParent() == null) {
            return "";
        }
        if (element instanceof IPackageFragment) {
            IPackageFragment pack = (IPackageFragment)element;
            return pack.getElementName();
        }
        if (element.getParent() == null) {
            return "";
        }
        if (element.getParent() instanceof IPackageFragment) {
            IPackageFragment pack = (IPackageFragment)element.getParent();
            return pack.getElementName();
        }
        return "";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

