/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.wizard.java;

import com.sap.ide.eclipse.component.core.Util;
import com.tssap.dii.component.IStartCreateProjectWizard;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.NewJavaProjectPreferencePage;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathsBlock;
import org.eclipse.jdt.ui.wizards.JavaCapabilityConfigurationPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;

public class NewProjectWizardPage
extends JavaCapabilityConfigurationPage {
    private IPath fCurrProjectLocation;
    private boolean fProjectCreated;
    private IStartCreateProjectWizard projectWizard = null;
    private TracerI theTracer = TracingManager.getTracer(((Object)((Object)this)).getClass());

    public NewProjectWizardPage(IStartCreateProjectWizard projectWizard) {
        this.init(projectWizard);
    }

    public void init(IStartCreateProjectWizard projectWizard) {
        this.projectWizard = projectWizard;
        this.fCurrProjectLocation = this.projectWizard != null ? projectWizard.getProjectDescription().getLocation() : null;
        this.fProjectCreated = false;
    }

    private boolean canDetectExistingClassPath(IPath projLocation) {
        return projLocation.toFile().exists() && !Platform.getLocation().equals((Object)projLocation);
    }

    private void update() {
        IPath projLocation = this.projectWizard.getProjectDescription().getLocation();
        if (!projLocation.equals((Object)this.fCurrProjectLocation) && this.canDetectExistingClassPath(projLocation)) {
            String title = NewWizardMessages.getString((String)"NewProjectCreationWizardPage.EarlyCreationDialog.title");
            String description = NewWizardMessages.getString((String)"NewProjectCreationWizardPage.EarlyCreationDialog.description");
            if (MessageDialog.openQuestion((Shell)this.getShell(), (String)title, (String)description)) {
                this.createAndDetect();
            }
        }
        this.fCurrProjectLocation = projLocation;
        IJavaProject prevProject = this.getJavaProject();
        IProject currProject = this.projectWizard.getProjectHandle();
        if (prevProject == null || !currProject.equals((Object)prevProject.getProject())) {
            this.init(JavaCore.create((IProject)currProject), null, null, false);
        }
    }

    private void createAndDetect() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask(NewWizardMessages.getString((String)"NewProjectCreationWizardPage.EarlyCreationOperation.desc"), 3);
                try {
                    NewProjectWizardPage.this.createProject((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    NewProjectWizardPage.this.initFromExistingStructures((IProgressMonitor)new SubProgressMonitor(monitor, 2));
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            this.getContainer().run(false, true, op);
        }
        catch (InvocationTargetException e) {
            String title = NewWizardMessages.getString((String)"NewProjectCreationWizardPage.EarlyCreationOperation.error.title");
            String message = NewWizardMessages.getString((String)"NewProjectCreationWizardPage.EarlyCreationOperation.error.desc");
            ExceptionHandler.handle((InvocationTargetException)e, (Shell)this.getShell(), (String)title, (String)message);
        }
        catch (InterruptedException e) {
            Util.logExceptionMessage(this.theTracer, 3, "Operation canceled", e);
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.update();
        }
        super.setVisible(visible);
    }

    public IWizardPage getPreviousPage() {
        if (this.fProjectCreated) {
            return null;
        }
        return super.getPreviousPage();
    }

    public IRunnableWithProgress getRunnable() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask(NewWizardMessages.getString((String)"NewProjectCreationWizardPage.NormalCreationOperation.desc"), 4);
                try {
                    try {
                        NewProjectWizardPage.this.createProject((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        if (NewProjectWizardPage.this.getJavaProject() == null) {
                            NewProjectWizardPage.this.initFromExistingStructures((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        } else {
                            monitor.worked(1);
                        }
                        NewProjectWizardPage.this.configureJavaProject((IProgressMonitor)new SubProgressMonitor(monitor, 2));
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    Object var4_2 = null;
                }
                catch (Throwable throwable) {
                    Object var4_3 = null;
                    monitor.done();
                    throw throwable;
                }
                monitor.done();
            }
        };
    }

    private void createProject(IProgressMonitor monitor) throws CoreException {
        IProject project = this.projectWizard.getProjectHandle();
        IPath projectLocation = this.projectWizard.getProjectDescription().getLocation();
        BuildPathsBlock.createProject((IProject)project, (IPath)projectLocation, (IProgressMonitor)monitor);
        this.fProjectCreated = true;
    }

    private void initFromExistingStructures(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(NewWizardMessages.getString((String)"NewProjectCreationWizardPage.DetectingClasspathOperation.desc"), 2);
        try {
            IProject project = this.projectWizard.getProjectHandle();
            if (project.getFile(".classpath").exists()) {
                this.init(JavaCore.create((IProject)project), null, null, false);
                monitor.worked(2);
            } else {
                final HashSet sourceFolders = new HashSet();
                IResourceVisitor visitor = new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        return NewProjectWizardPage.this.doVisit(resource, sourceFolders);
                    }
                };
                project.accept(visitor);
                monitor.worked(1);
                IClasspathEntry[] entries = null;
                IPath outputLocation = null;
                if (!sourceFolders.isEmpty()) {
                    int nSourceFolders = sourceFolders.size();
                    IClasspathEntry[] jreEntries = NewJavaProjectPreferencePage.getDefaultJRELibrary();
                    entries = new IClasspathEntry[nSourceFolders + jreEntries.length];
                    Iterator iter = sourceFolders.iterator();
                    int i = 0;
                    while (i < nSourceFolders) {
                        entries[i] = JavaCore.newSourceEntry((IPath)((IPath)iter.next()));
                        ++i;
                    }
                    System.arraycopy(jreEntries, 0, entries, nSourceFolders, jreEntries.length);
                    IPath projPath = project.getFullPath();
                    if (nSourceFolders == 1 && entries[0].getPath().equals((Object)projPath)) {
                        outputLocation = projPath;
                    }
                    if (!JavaConventions.validateClasspath((IJavaProject)JavaCore.create((IProject)project), (IClasspathEntry[])entries, outputLocation).isOK()) {
                        outputLocation = null;
                        entries = null;
                    }
                }
                this.init(JavaCore.create((IProject)project), outputLocation, entries, false);
                monitor.worked(1);
            }
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    private boolean doVisit(IResource resource, HashSet sourceFolders) throws JavaModelException {
        ICompilationUnit cu;
        if (!sourceFolders.isEmpty()) {
            IResource curr = resource;
            while (curr.getType() != 8) {
                if (sourceFolders.contains(curr.getFullPath())) {
                    return false;
                }
                curr = curr.getParent();
            }
        }
        if (resource.getType() == 1 && "java".equals(resource.getFileExtension()) && (cu = JavaCore.createCompilationUnitFrom((IFile)((IFile)resource))) != null) {
            IPath packPath = resource.getParent().getFullPath();
            IPackageDeclaration[] decls = cu.getPackageDeclarations();
            if (decls.length == 0) {
                sourceFolders.add(packPath);
            } else {
                Path relpath = new Path(decls[0].getElementName().replace('.', '/'));
                int remainingSegments = packPath.segmentCount() - relpath.segmentCount();
                if (remainingSegments >= 0) {
                    IPath prefix = packPath.uptoSegment(remainingSegments);
                    IPath common = packPath.removeFirstSegments(remainingSegments);
                    if (common.equals((Object)relpath)) {
                        sourceFolders.add(prefix);
                    }
                }
            }
        }
        return true;
    }

    public void performCancel() {
        if (this.fProjectCreated) {
            try {
                this.projectWizard.getProjectHandle().delete(false, false, null);
            }
            catch (CoreException e) {
                JavaPlugin.log((Throwable)e);
            }
        }
        this.fProjectCreated = false;
    }
}

