/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.wizard.java;

import com.sap.ide.eclipse.component.core.DCController;
import com.sap.ide.eclipse.component.wizard.IWizardValidator;
import com.sap.ide.eclipse.component.wizard.ProjectWizard;
import com.sap.ide.eclipse.component.wizard.java.NewProjectWizardPage;
import com.sap.ide.eclipse.component.wizard.java.Util;
import com.tssap.dii.component.IConnectedWizard;
import com.tssap.dii.component.IStartCreateProjectWizard;
import com.tssap.dii.dtri.util.RepositoryObject;
import com.tssap.dii.dtri.util.RepositoryServiceException;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.preferences.NewJavaProjectPreferencePage;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public class NewProjectWizard
extends NewElementWizard
implements IConnectedWizard,
IWizardValidator {
    public static final String NEW_PROJECT_WIZARD_ID = "org.eclipse.jdt.ui.wizards.NewProjectCreationWizard";
    private NewProjectWizardPage fJavaPage;
    private IStartCreateProjectWizard startWizard;
    private static TracerI theTracer = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$component$wizard$java$NewProjectWizard == null ? (class$com$sap$ide$eclipse$component$wizard$java$NewProjectWizard = NewProjectWizard.class$("com.sap.ide.eclipse.component.wizard.java.NewProjectWizard")) : class$com$sap$ide$eclipse$component$wizard$java$NewProjectWizard));
    static /* synthetic */ Class class$com$sap$ide$eclipse$component$wizard$java$NewProjectWizard;

    public NewProjectWizard() {
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_NEWJPRJ);
        this.setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(NewWizardMessages.getString((String)"NewProjectCreationWizard.title"));
    }

    public void addPages() {
        super.addPages();
        this.fJavaPage = new NewProjectWizardPage(this.startWizard);
        this.addPage((IWizardPage)this.fJavaPage);
    }

    public boolean performFinish() {
        if (this.startWizard == null) {
            return false;
        }
        ((ProjectWizard)this.startWizard).reset();
        ICommand command = this.startWizard.getProjectDescription().newCommand();
        command.setBuilderName("org.eclipse.jdt.core.javabuilder");
        try {
            this.setJavaCommand(this.startWizard.getProjectDescription(), command);
        }
        catch (CoreException e) {
            com.sap.ide.eclipse.component.core.Util.logExceptionMessage(theTracer, 3, "Setting Java Command", e);
        }
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(this.fJavaPage.getRunnable());
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            String title = NewWizardMessages.getString((String)"NewProjectCreationWizard.op_error.title");
            String message = NewWizardMessages.getString((String)"NewProjectCreationWizard.op_error_create.message");
            ExceptionHandler.handle((InvocationTargetException)e, (Shell)this.getShell(), (String)title, (String)message);
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
        op = new WorkspaceModifyDelegatingOperation(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (NewProjectWizard.this.startWizard != null) {
                    DCController controller = ((ProjectWizard)NewProjectWizard.this.startWizard).getDCController();
                    Properties props = NewProjectWizard.this.createProperties(NewProjectWizard.this.fJavaPage.getJavaProject());
                    IProject project = NewProjectWizard.this.fJavaPage.getJavaProject().getProject();
                    IStatus status = controller.fillProject(project, props, ((ProjectWizard)NewProjectWizard.this.startWizard).getActivity(), monitor);
                    if (status.getSeverity() == 4) {
                        NewProjectWizard.this.fJavaPage.performCancel();
                        throw new InvocationTargetException(new CoreException(status));
                    }
                    try {
                        controller.getProject().refreshLocal(2, monitor);
                    }
                    catch (CoreException e) {
                        com.sap.ide.eclipse.component.core.Util.logExceptionMessage(theTracer, 3, controller.getName() + ": Refresh Project failed ", e);
                    }
                    NewProjectWizard.addFoldersToDTRControl(props, project, ((ProjectWizard)NewProjectWizard.this.startWizard).getActivity(), monitor);
                    if (!status.isOK()) {
                        NewProjectWizard.this.fJavaPage.performCancel();
                        throw new InvocationTargetException(new CoreException(status));
                    }
                }
            }
        });
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            CoreException coreEx;
            IStatus status;
            String title = NewWizardMessages.getString((String)"NewProjectCreationWizard.op_error.title");
            String message = NewWizardMessages.getString((String)"NewProjectCreationWizard.op_error_create.message");
            ExceptionHandler.handle((InvocationTargetException)e, (Shell)this.getShell(), (String)title, (String)message);
            if (e.getTargetException() instanceof CoreException && (status = (coreEx = (CoreException)e.getTargetException()).getStatus()) != null) {
                return status.getSeverity() != 4;
            }
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
        this.changetoJavaPerspective();
        this.selectAndReveal((IResource)this.fJavaPage.getJavaProject().getProject());
        return true;
    }

    private static void addFoldersToDTRControl(Properties props, IProject project, IVfsActivity activity, IProgressMonitor monitor) {
        Object obj;
        if (activity == null || project == null || props == null) {
            return;
        }
        RepositoryObject anObjectToEdit = null;
        try {
            anObjectToEdit = new RepositoryObject("Package and Source Folders", project.getName(), project);
        }
        catch (RepositoryServiceException ex) {
            com.sap.ide.eclipse.component.core.Util.logExceptionMessage(theTracer, 3, "add to DTR for SRC and PACKAGE Folders failed", ex);
            return;
        }
        ArrayList list = new ArrayList();
        if (((Hashtable)props).containsKey("DCPackageFolder") && (obj = ((Hashtable)props).get("DCPackageFolder")) instanceof Collection) {
            list.addAll((Collection)obj);
        }
        if (((Hashtable)props).containsKey("DCSourceFolder") && (obj = ((Hashtable)props).get("DCSourceFolder")) instanceof Collection) {
            list.addAll((Collection)obj);
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            String path = (String)it.next();
            IFolder srcFolder = project.getFolder(path);
            if (srcFolder == null) continue;
            if (!srcFolder.exists()) {
                try {
                    srcFolder.create(true, true, monitor);
                }
                catch (CoreException e) {
                    com.sap.ide.eclipse.component.core.Util.logExceptionMessage(theTracer, 3, "Create " + srcFolder + " failed.", e);
                }
            }
            if (!srcFolder.exists()) continue;
            try {
                anObjectToEdit.addlResource((IResource)srcFolder);
            }
            catch (RepositoryServiceException ex) {
                com.sap.ide.eclipse.component.core.Util.logExceptionMessage(theTracer, 3, "add to DTR for SRC and PACKAGE Folders failed", ex);
            }
        }
        try {
            anObjectToEdit.addToSourceControll(false, activity);
        }
        catch (RepositoryServiceException ex) {
            com.sap.ide.eclipse.component.core.Util.logExceptionMessage(theTracer, 3, "add to DTR for SRC and PACKAGE Folders failed", ex);
        }
    }

    private Properties createProperties(IJavaProject project) {
        Properties props = new Properties();
        IClasspathEntry[] entries = null;
        try {
            entries = project.getRawClasspath();
        }
        catch (JavaModelException e) {
            com.sap.ide.eclipse.component.core.Util.logExceptionMessage(theTracer, 3, "Get classpath for Java project failed", e);
        }
        if (entries != null) {
            ArrayList<String> list = new ArrayList<String>();
            int last = -1;
            int i = 0;
            while (i < entries.length) {
                if (entries[i].getEntryKind() == 3) {
                    list.add(entries[i].getPath().removeFirstSegments(1).toString());
                    last = i;
                }
                ++i;
            }
            if (list.size() == 1 && last >= 0 && "".equals(list.get(0))) {
                list.clear();
                list.add("src/packages");
                IPath path = project.getProject().getLocation().append("src/packages");
                if (!path.toFile().exists()) {
                    path.toFile().mkdirs();
                }
                entries[last] = JavaCore.newSourceEntry((IPath)entries[last].getPath().append("src/packages"));
                IPath outputLocation = null;
                try {
                    outputLocation = project.getOutputLocation();
                    if (outputLocation != null && outputLocation.isPrefixOf(entries[last].getPath())) {
                        project.setOutputLocation(outputLocation.append("bin"), (IProgressMonitor)new NullProgressMonitor());
                    }
                }
                catch (JavaModelException e) {
                    com.sap.ide.eclipse.component.core.Util.logExceptionMessage(theTracer, 3, "Setting Output Location failed", e);
                }
                try {
                    project.setRawClasspath(entries, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (JavaModelException e) {
                    com.sap.ide.eclipse.component.core.Util.logExceptionMessage(theTracer, 3, "Setting Classpath failed", e);
                }
            }
            ((Hashtable)props).put("DCPackageFolder", list);
        }
        return props;
    }

    private void setJavaCommand(IProjectDescription description, ICommand newCommand) throws CoreException {
        ICommand[] newCommands;
        ICommand[] oldCommands = description.getBuildSpec();
        ICommand oldJavaCommand = this.getJavaCommand(description);
        if (oldJavaCommand == null) {
            newCommands = new ICommand[oldCommands.length + 1];
            System.arraycopy(oldCommands, 0, newCommands, 1, oldCommands.length);
            newCommands[0] = newCommand;
        } else {
            int i = 0;
            int max = oldCommands.length;
            while (i < max) {
                if (oldCommands[i] == oldJavaCommand) {
                    oldCommands[i] = newCommand;
                    break;
                }
                ++i;
            }
            newCommands = oldCommands;
        }
        description.setBuildSpec(newCommands);
    }

    private ICommand getJavaCommand(IProjectDescription description) throws CoreException {
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals("org.eclipse.jdt.core.javabuilder")) {
                return commands[i];
            }
            ++i;
        }
        return null;
    }

    public boolean performCancel() {
        this.fJavaPage.performCancel();
        return super.performCancel();
    }

    public void init(IStartCreateProjectWizard wizard) {
        if (this.fJavaPage != null) {
            this.fJavaPage.init(wizard);
        }
        this.startWizard = wizard;
        if (wizard != null) {
            ((ProjectWizard)wizard).addValidator(this);
        }
    }

    public boolean completeProject(IProject newProj, Properties properties) {
        IClasspathEntry[] jreLibs;
        Iterator it;
        IJavaProject javaProject = JavaCore.create((IProject)newProj);
        try {
            ICommand command = newProj.getDescription().newCommand();
            command.setBuilderName("org.eclipse.jdt.core.javabuilder");
            Util.setJavaCommand(newProj, command);
        }
        catch (Throwable e) {
            com.sap.ide.eclipse.component.core.Util.logExceptionMessage(theTracer, 3, "Setting Java command failed", e);
        }
        int length = 1;
        ArrayList<String> srcFolder = null;
        if (((Hashtable)properties).containsKey("DCPackageFolder")) {
            srcFolder = (List)((Hashtable)properties).get("DCPackageFolder");
        }
        if (srcFolder != null && !srcFolder.isEmpty()) {
            length = srcFolder.size();
        }
        ++length;
        ArrayList<IClasspathEntry> entriesList = new ArrayList<IClasspathEntry>();
        List libs = null;
        if (((Hashtable)properties).containsKey("UsedDCsPaths")) {
            libs = (List)((Hashtable)properties).get("UsedDCsPaths");
        }
        int i = 0;
        if (libs != null && !libs.isEmpty()) {
            it = libs.iterator();
            while (it.hasNext()) {
                String lib = (String)it.next();
                if (lib.toLowerCase().endsWith(".jar")) {
                    entriesList.add(JavaCore.newLibraryEntry((IPath)new Path(lib), null, null));
                } else {
                    File[] files;
                    File dir = new File(lib + "/lib/java");
                    if (dir.exists() && dir.isDirectory() && (files = dir.listFiles()) != null) {
                        int j = 0;
                        while (j < files.length) {
                            if (files[j].toString().toLowerCase().endsWith(".jar")) {
                                entriesList.add(JavaCore.newLibraryEntry((IPath)new Path(files[j].toString()), null, null));
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        } else if (srcFolder == null || srcFolder.isEmpty()) {
            srcFolder = new ArrayList<String>();
            IPath path = newProj.getLocation().append("src/packages");
            if (!path.toFile().exists()) {
                path.toFile().mkdirs();
            }
            srcFolder.add("src/packages");
        }
        if (srcFolder != null) {
            it = srcFolder.iterator();
            while (it.hasNext()) {
                String src = (String)it.next();
                entriesList.add(JavaCore.newSourceEntry((IPath)newProj.getFullPath().append(src)));
                ++i;
            }
        }
        if ((jreLibs = NewJavaProjectPreferencePage.getDefaultJRELibrary()) != null && jreLibs.length > 0) {
            entriesList.addAll(Arrays.asList(jreLibs));
        }
        try {
            javaProject.setRawClasspath(entriesList.toArray(new IClasspathEntry[entriesList.size()]), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (JavaModelException e) {
            com.sap.ide.eclipse.component.core.Util.logExceptionMessage(theTracer, 3, "Setting classpath failed", e);
            return false;
        }
        return true;
    }

    protected void changetoJavaPerspective() {
        IPerspectiveRegistry reg = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor persp = reg.findPerspectiveWithId("org.eclipse.jdt.ui.JavaPerspective");
        if (persp == null) {
            return;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        page.setPerspective(persp);
    }

    public void finalProject() {
    }

    public IStatus validate() {
        return new Status(0, "com.sap.ide.eclipse.component.provider", 0, "", null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

