/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.wizard.dbcontent;

import com.sap.ide.eclipse.component.core.DCController;
import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.provider.ComponentProviderPlugin;
import com.sap.ide.eclipse.component.wizard.IWizardValidator;
import com.sap.ide.eclipse.component.wizard.ProjectWizard;
import com.tssap.dii.component.IConnectedWizard;
import com.tssap.dii.component.IStartCreateProjectWizard;
import com.tssap.dii.dtri.util.RepositoryObject;
import com.tssap.dii.dtri.util.RepositoryServiceException;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewDbContentWizard
extends BasicNewResourceWizard
implements IExecutableExtension,
IConnectedWizard,
IWizardValidator {
    private static TracerI theTracer = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$component$wizard$dbcontent$NewDbContentWizard == null ? (class$com$sap$ide$eclipse$component$wizard$dbcontent$NewDbContentWizard = NewDbContentWizard.class$("com.sap.ide.eclipse.component.wizard.dbcontent.NewDbContentWizard")) : class$com$sap$ide$eclipse$component$wizard$dbcontent$NewDbContentWizard));
    protected IProject newProject;
    private IConfigurationElement configElement;
    private static String WINDOW_PROBLEMS_TITLE = "ResourceMessages.getString(\"NewProject.errorOpeningWindow\")";
    private static final String FINAL_PERSPECTIVE = "finalPerspective";
    private static final String PREFERRED_PERSPECTIVES = "preferredPerspectives";
    protected IStartCreateProjectWizard startWizard;
    static /* synthetic */ Class class$com$sap$ide$eclipse$component$wizard$dbcontent$NewDbContentWizard;

    public NewDbContentWizard() {
        AbstractUIPlugin plugin = (AbstractUIPlugin)Platform.getPlugin((String)"org.eclipse.ui");
        IDialogSettings workbenchSettings = plugin.getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("NewDbContentWizard");
        if (section == null) {
            section = workbenchSettings.addNewSection("NewDbContentWizard");
        }
        this.setDialogSettings(section);
    }

    public void addPages() {
        super.addPages();
    }

    protected IProject createNewProject() {
        if (this.newProject != null) {
            return this.newProject;
        }
        final IProject newProjectHandle = this.startWizard.getProjectHandle();
        final IProjectDescription description = this.startWizard.getProjectDescription();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                NewDbContentWizard.this.createProject(description, newProjectHandle, monitor);
            }
        };
        try {
            IWizardContainer wizardContainer = this.getContainer();
            if (wizardContainer != null) {
                this.getContainer().run(true, true, (IRunnableWithProgress)op);
            } else {
                op.run((IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof CoreException) {
                if (((CoreException)t).getStatus().getCode() == 275) {
                    MessageDialog.openError((Shell)this.getShell(), (String)"ResourceMessages.getString(\"NewProject.errorMessage\")", (String)"ResourceMessages.format(\"NewProject.caseVariantExistsError\", new String[] { newProjectHandle.getName()} )");
                } else {
                    ErrorDialog.openError((Shell)this.getShell(), (String)"ResourceMessages.getString(\"NewProject.errorMessage\")", null, (IStatus)((CoreException)t).getStatus());
                }
            } else {
                Platform.getPlugin((String)"org.eclipse.ui").getLog().log((IStatus)new Status(4, "org.eclipse.ui", 0, t.toString(), t));
                MessageDialog.openError((Shell)this.getShell(), (String)"ResourceMessages.getString(\"NewProject.errorMessage\")", (String)"ResourceMessages.format(\"NewProject.internalError\", new Object[] {t.getMessage()})");
            }
            return null;
        }
        this.newProject = newProjectHandle;
        return this.newProject;
    }

    private void createProject(IProjectDescription description, IProject projectHandle, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            monitor.beginTask("", 2000);
            projectHandle.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            projectHandle.open((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    public IProject getNewProject() {
        return this.newProject;
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("ResourceMessages.getString(\"NewProject.windowTitle\")");
    }

    protected void initializeDefaultPageImageDescriptor() {
        String iconPath = "icons/full/";
        try {
            URL installURL = Platform.getPlugin((String)"org.eclipse.ui").getDescriptor().getInstallURL();
            URL url = new URL(installURL, iconPath + "wizban/newprj_wiz.gif");
            ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
            this.setDefaultPageImageDescriptor(desc);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private static void openInNewWindow(IPerspectiveDescriptor desc) {
        block2: {
            try {
                PlatformUI.getWorkbench().openWorkbenchWindow(desc.getId(), (IAdaptable)ResourcesPlugin.getWorkspace().getRoot());
            }
            catch (WorkbenchException e) {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window == null) break block2;
                ErrorDialog.openError((Shell)window.getShell(), (String)WINDOW_PROBLEMS_TITLE, (String)e.getMessage(), (IStatus)e.getStatus());
            }
        }
    }

    protected static void addFoldersToDTRControl(Properties props, IProject project, IVfsActivity activity, IProgressMonitor monitor) {
        Object obj;
        if (activity == null || project == null || props == null) {
            return;
        }
        RepositoryObject anObjectToEdit = null;
        try {
            anObjectToEdit = new RepositoryObject("Package and Source Folders", project.getName(), project);
        }
        catch (RepositoryServiceException ex) {
            Util.logExceptionMessage(theTracer, 3, "add to DTR for SRC and PACKAGE Folders failed", ex);
            return;
        }
        ArrayList list = new ArrayList();
        if (((Hashtable)props).containsKey("DCPackageFolder") && (obj = ((Hashtable)props).get("DCPackageFolder")) instanceof Collection) {
            list.addAll((Collection)obj);
        }
        if (((Hashtable)props).containsKey("DCSourceFolder") && (obj = ((Hashtable)props).get("DCSourceFolder")) instanceof Collection) {
            list.addAll((Collection)obj);
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            String path = (String)it.next();
            IFolder srcFolder = project.getFolder(path);
            if (srcFolder == null) continue;
            if (!srcFolder.exists()) {
                try {
                    srcFolder.create(true, true, monitor);
                }
                catch (CoreException e) {
                    Util.logExceptionMessage(theTracer, 3, "Create " + srcFolder + " failed.", e);
                }
            }
            if (!srcFolder.exists()) continue;
            try {
                anObjectToEdit.addlResource((IResource)srcFolder);
            }
            catch (RepositoryServiceException ex) {
                Util.logExceptionMessage(theTracer, 3, "add to DTR for SRC and PACKAGE Folders failed", ex);
            }
        }
        try {
            anObjectToEdit.addToSourceControll(false, activity);
        }
        catch (RepositoryServiceException ex) {
            Util.logExceptionMessage(theTracer, 3, "add to DTR for SRC and PACKAGE Folders failed", ex);
        }
    }

    public boolean performFinish() {
        IFile contentFile;
        block19: {
            if (this.startWizard == null) {
                return false;
            }
            ((ProjectWizard)this.startWizard).reset();
            contentFile = null;
            try {
                NullProgressMonitor progressMonitor = new NullProgressMonitor();
                if (this.startWizard == null) break block19;
                DCController controller = ((ProjectWizard)this.startWizard).getDCController();
                this.createNewProject();
                if (this.newProject == null) {
                    return false;
                }
                Properties props = new Properties();
                ArrayList<String> sourceFolders = new ArrayList<String>();
                String SOURCEFOLDER_NAME = "src";
                try {
                    IFolder sourceFolder = this.newProject.getFolder("src");
                    sourceFolder.create(true, false, (IProgressMonitor)progressMonitor);
                    ComponentProviderPlugin myPlugin = ComponentProviderPlugin.getPlugin();
                    String installUrl = myPlugin.getDescriptor().getInstallURL().toExternalForm();
                    if (!installUrl.endsWith("/")) {
                        installUrl = installUrl + "/";
                    }
                    String templateFolderUrl = installUrl + "templates/dbcontent/";
                    String[] templateNames = new String[]{"dbcontent.xsd", "dbcontent.xml"};
                    int i = 0;
                    while (i < templateNames.length) {
                        try {
                            String templateName = templateNames[i];
                            URL templateUrl = new URL(templateFolderUrl + templateName);
                            InputStream input = templateUrl.openStream();
                            IFile targetFile = sourceFolder.getFile(templateName);
                            boolean force = true;
                            targetFile.create(input, force, (IProgressMonitor)progressMonitor);
                            if (templateName.equals("dbcontent.xml")) {
                                contentFile = targetFile;
                            }
                        }
                        catch (FileNotFoundException e) {
                            boolean j = false;
                        }
                        catch (MalformedURLException e) {
                            boolean j = false;
                        }
                        catch (IOException e) {
                            boolean j = false;
                        }
                        ++i;
                    }
                }
                catch (CoreException e) {
                    Util.logExceptionMessage(theTracer, 3, "Creating source folder failed", e);
                }
                sourceFolders.add("src");
                ((Hashtable)props).put("DCSourceFolder", sourceFolders);
                IProject project = this.newProject;
                IStatus status = controller.fillProject(project, props, this.startWizard.getActivity(), (IProgressMonitor)progressMonitor);
                if (status.getSeverity() == 4) {
                    try {
                        this.newProject.delete(true, (IProgressMonitor)progressMonitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                try {
                    controller.getProject().refreshLocal(2, (IProgressMonitor)progressMonitor);
                }
                catch (CoreException e) {
                    Util.logExceptionMessage(theTracer, 3, controller.getName() + ": Refresh Project failed ", e);
                }
                NewDbContentWizard.addFoldersToDTRControl(props, project, this.startWizard.getActivity(), (IProgressMonitor)progressMonitor);
            }
            catch (InvocationTargetException e) {
                CoreException coreEx;
                IStatus status;
                if (e.getTargetException() instanceof CoreException && (status = (coreEx = (CoreException)e.getTargetException()).getStatus()) != null) {
                    return status.getSeverity() != 4;
                }
                return false;
            }
        }
        this.changeToResourcePerspectiveAndOpenTemplate(contentFile);
        this.selectAndReveal((IResource)this.newProject);
        return true;
    }

    private static void replaceCurrentPerspective(IPerspectiveDescriptor persp) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        page.setPerspective(persp);
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.configElement = cfig;
    }

    protected void updatePerspective() {
        NewDbContentWizard.updatePerspective(this.configElement);
    }

    public static void updatePerspective(IConfigurationElement configElement) {
        IWorkbenchWindow window;
        if (configElement == null) {
            return;
        }
        AbstractUIPlugin uiPlugin = (AbstractUIPlugin)Platform.getPlugin((String)"org.eclipse.ui");
        String perspSetting = uiPlugin.getPreferenceStore().getString("PROJECT_OPEN_NEW_PERSPECTIVE");
        if (perspSetting.equals("NO_NEW_PERSPECTIVE")) {
            return;
        }
        String finalPerspId = configElement.getAttribute(FINAL_PERSPECTIVE);
        if (finalPerspId == null) {
            return;
        }
        IPerspectiveRegistry reg = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor finalPersp = reg.findPerspectiveWithId(finalPerspId);
        if (finalPersp == null) {
            WorkbenchPlugin.log((String)("Unable to find persective " + finalPerspId + " in NewDbContentWizard.updatePerspective"));
            return;
        }
        ArrayList<String> preferredPerspIds = new ArrayList<String>();
        preferredPerspIds.add(finalPerspId);
        String preferred = configElement.getAttribute(PREFERRED_PERSPECTIVES);
        if (preferred != null) {
            StringTokenizer tok = new StringTokenizer(preferred, " \t\n\r\f,");
            while (tok.hasMoreTokens()) {
                preferredPerspIds.add(tok.nextToken());
            }
        }
        if ((window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
            IPerspectiveDescriptor currentPersp;
            IWorkbenchPage page = window.getActivePage();
            if (page != null && (currentPersp = page.getPerspective()) != null && preferredPerspIds.contains(currentPersp.getId())) {
                return;
            }
            if (!NewDbContentWizard.confirmPerspectiveSwitch(window, finalPersp)) {
                return;
            }
        }
        if (perspSetting.equals("OPEN_PERSPECTIVE_WINDOW")) {
            NewDbContentWizard.openInNewWindow(finalPersp);
            return;
        }
        if (perspSetting.equals("OPEN_PERSPECTIVE_REPLACE")) {
            NewDbContentWizard.replaceCurrentPerspective(finalPersp);
            return;
        }
    }

    private static boolean confirmPerspectiveSwitch(IWorkbenchWindow window, IPerspectiveDescriptor finalPersp) {
        return true;
    }

    public void init(IStartCreateProjectWizard iStartCreateProjectWizard) {
        this.startWizard = iStartCreateProjectWizard;
        if (iStartCreateProjectWizard != null) {
            ((ProjectWizard)iStartCreateProjectWizard).addValidator(this);
        }
    }

    public void finalProject() {
    }

    public boolean completeProject(IProject newProj, Properties properties) {
        ArrayList<String> srcFolder = null;
        if (((Hashtable)properties).containsKey("DCPackageFolder")) {
            srcFolder = (List)((Hashtable)properties).get("DCPackageFolder");
        }
        if (srcFolder == null || srcFolder.isEmpty()) {
            srcFolder = new ArrayList<String>();
            IPath path = newProj.getLocation().append("src/packages");
            if (!path.toFile().exists()) {
                path.toFile().mkdirs();
            }
            srcFolder.add("src/packages");
        }
        return true;
    }

    public IStatus validate() {
        return new Status(0, "com.sap.ide.eclipse.component.provider", 0, "", null);
    }

    public String getProjectName() {
        return this.startWizard.getProjectHandle().getName();
    }

    protected void changeToResourcePerspectiveAndOpenTemplate(IFile templateFile) {
        IPerspectiveRegistry reg = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor persp = reg.findPerspectiveWithId("org.eclipse.ui.resourcePerspective");
        if (persp == null) {
            return;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        page.setPerspective(persp);
        if (templateFile != null) {
            String editorID = "com.tssap.editors.xmleditor";
            try {
                page.openEditor((IEditorInput)new FileEditorInput(templateFile), editorID, true);
            }
            catch (PartInitException e) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

