/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.wizard;

import com.sap.ide.eclipse.component.core.ComponentTreeViewer;
import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.provider.ui.message.ComponentProviderMessages;
import com.sap.ide.eclipse.component.wizard.DCWizardUtil;
import com.sap.ide.eclipse.component.wizard.ProjectWizard;
import com.sap.tc.devconf.ICompartmentNode;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.tssap.selena.model.elements.Element;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SelectSCPage
extends WizardPage {
    public static final String NAME = "SelectSCPage";
    private TracerI theTracer = TracingManager.getTracer(((Object)((Object)this)).getClass());
    private ComponentTreeViewer componentTree;
    private boolean changeFlag = false;

    public SelectSCPage() {
        super(NAME);
        this.setTitle(ComponentProviderMessages.getString("titleSelectPageSC"));
        this.setDescription(ComponentProviderMessages.getString("descSelectSCPage"));
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        IStatus status;
        this.changeFlag = false;
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FillLayout());
        this.buildComponentTree(container);
        this.setControl((Control)container);
        ProjectWizard projectWizard = this.getProjectWizard();
        if (projectWizard != null && !(status = projectWizard.canStartWizard()).isOK() && ProjectWizard.NO_CONFIGURATIONS == status.getCode()) {
            this.changeFlag = true;
            this.updateStatus(status.getMessage());
            DCWizardUtil.startImportConfiguration(this.getShell(), this.getShell().getLocation());
        }
    }

    private void buildComponentTree(Composite container) {
        this.componentTree = new ComponentTreeViewer(container, 17, true);
        this.componentTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectSCPage.this.dialogChanged();
            }
        });
        this.componentTree.getControl().setLayoutData((Object)new GridData(1808));
    }

    public IDevelopmentConfiguration getCurrentConfiguration() {
        if (this.componentTree == null || this.componentTree.getSelectedSC() == null) {
            return null;
        }
        return (IDevelopmentConfiguration)this.componentTree.getPathToSelectedObject().get(0);
    }

    public boolean dialogChanged() {
        if (this.componentTree.getSelectedSC() == null) {
            this.updateStatus(ComponentProviderMessages.getString("errorNoSelectSelectSCPage"));
            return false;
        }
        this.changeFlag = true;
        this.updateStatus(null);
        return true;
    }

    public void updateStatus(String message) {
        if (this.changeFlag) {
            this.setErrorMessage(message);
        } else {
            this.changeFlag = true;
        }
        this.setPageComplete(message == null);
    }

    public ICompartmentNode getSComponent() {
        return this.componentTree.getSelectedSC();
    }

    public Element getSelectedElement() {
        return this.componentTree.getSelectedElement();
    }

    public ProjectWizard getProjectWizard() {
        IWizard wizard = super.getWizard();
        if (wizard instanceof ProjectWizard) {
            return (ProjectWizard)wizard;
        }
        return null;
    }

    public boolean isTreeEmpty() {
        if (this.componentTree == null) {
            return false;
        }
        return this.componentTree.isTreeEmpty();
    }

    public IWizardPage getNextPage() {
        if (this.getProjectWizard() != null) {
            try {
                this.getProjectWizard().getDCController().setDefaultInfrastructure(this.getSComponent(), this.getCurrentConfiguration());
            }
            catch (Throwable e) {
                Util.logExceptionMessage(this.theTracer, 2, "setDefaultInfrastructure Problems", e);
            }
        }
        return super.getNextPage();
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }
}

