/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.wizard;

import com.sap.ide.eclipse.component.core.SelectDCsDialog;
import com.sap.ide.eclipse.component.provider.actions.dc.DcCreateProjectAction;
import com.sap.ide.eclipse.component.provider.ui.message.ComponentProviderMessages;
import com.sap.ide.eclipse.component.wizard.ImportWizard;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.WorkbenchMessages;

public class SelectForSyncPage
extends WizardPage {
    private IDevelopmentComponentNode currentDCNode = null;
    public static final String NAME = "SelectForSyncPage";
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 250;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 300;
    static String SELECT_ALL_TITLE = WorkbenchMessages.getString((String)"SelectionDialog.selectLabel");
    static String DESELECT_ALL_TITLE = WorkbenchMessages.getString((String)"SelectionDialog.deselectLabel");
    protected CheckboxTableViewer listViewer;
    protected Object inputElement = null;

    public SelectForSyncPage() {
        super(NAME);
        this.setTitle(ComponentProviderMessages.getString("SelectForSyncPage.title"));
        this.setDescription(ComponentProviderMessages.getString("SelectForSyncPage.description"));
        this.setPageComplete(true);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        this.initializeDialogUnits((Control)composite);
        Control dialogArea = this.createDialogArea(composite);
        this.setControl((Control)composite);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)this.superCreateDialogArea(parent);
        Font font = parent.getFont();
        composite.setFont(font);
        this.listViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        GridData data = new GridData(1808);
        data.heightHint = 250;
        data.widthHint = 300;
        this.listViewer.getTable().setLayoutData((Object)data);
        this.listViewer.setLabelProvider((IBaseLabelProvider)new SelectDCsDialog.DCLabelProvider());
        this.listViewer.setContentProvider((IContentProvider)new SelectDCsDialog.DCContentProvider());
        this.listViewer.getControl().setFont(font);
        this.addSelectionButtons(composite);
        this.initializeViewer();
        return composite;
    }

    private void initializeViewer() {
        this.listViewer.setInput(this.inputElement);
    }

    protected Control superCreateDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        return composite;
    }

    private void addSelectionButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 131072);
        buttonComposite.setFont(composite.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        buttonComposite.setLayout((Layout)layout);
        GridData data = new GridData(640);
        data.grabExcessHorizontalSpace = true;
        composite.setData((Object)data);
        Button selectButton = this.createButton(buttonComposite, 18, SELECT_ALL_TITLE, false);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectForSyncPage.this.listViewer.setAllChecked(true);
            }
        };
        selectButton.addSelectionListener((SelectionListener)listener);
        Button deselectButton = this.createButton(buttonComposite, 19, DESELECT_ALL_TITLE, false);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectForSyncPage.this.listViewer.setAllChecked(false);
            }
        };
        deselectButton.addSelectionListener((SelectionListener)listener);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Shell shell;
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        button.setText(label);
        button.setData((Object)new Integer(id));
        if (defaultButton && (shell = parent.getShell()) != null) {
            shell.setDefaultButton(button);
        }
        button.setFont(parent.getFont());
        this.setButtonLayoutData(button);
        return button;
    }

    public void updateDCList(IDevelopmentComponentNode dcNode) {
        if (dcNode == null || dcNode.equals(this.currentDCNode)) {
            return;
        }
        this.currentDCNode = dcNode;
        ArrayList<IDevelopmentComponentNode> selectedDCList = new ArrayList<IDevelopmentComponentNode>();
        selectedDCList.add(dcNode);
        Map dependenciesMap = DcCreateProjectAction.collectDependencies(selectedDCList, true);
        Collection buildDCs = DcCreateProjectAction.collectBuildDependencies(dependenciesMap, null);
        HashSet<IDevelopmentComponentNode> dependentDCs = new HashSet<IDevelopmentComponentNode>();
        dependentDCs.addAll(buildDCs);
        Iterator it = dependenciesMap.values().iterator();
        while (it.hasNext()) {
            Collection lst = (Collection)it.next();
            if (lst == null) continue;
            dependentDCs.addAll(lst);
        }
        dependentDCs.addAll(selectedDCList);
        this.inputElement = new ArrayList();
        Iterator it2 = dependentDCs.iterator();
        while (it2.hasNext()) {
            IDevelopmentComponentNode dcNodeElement = (IDevelopmentComponentNode)it2.next();
            if (dcNodeElement.isLocalOnly()) continue;
            ((Collection)this.inputElement).add(dcNodeElement);
        }
        this.initializeViewer();
        SelectDCsDialog.initializeSelection(this.listViewer, selectedDCList, this.currentDCNode.isSynched() ? null : selectedDCList);
        Iterator itemsToCheck = DcCreateProjectAction.getInitialSelection(dependentDCs, selectedDCList, false).iterator();
        while (itemsToCheck.hasNext()) {
            this.listViewer.setChecked(itemsToCheck.next(), true);
        }
    }

    private ImportWizard getImportWizard() {
        if (this.getWizard() != null && this.getWizard() instanceof ImportWizard) {
            return (ImportWizard)this.getWizard();
        }
        return null;
    }

    public List getForSyncDCs() {
        IDevelopmentComponentNode dcNode;
        ArrayList<Object> list = new ArrayList<Object>();
        ImportWizard wizard = this.getImportWizard();
        if (!(wizard == null || (dcNode = wizard.getSelectedDCNode()) != null && dcNode.equals(this.currentDCNode))) {
            return list;
        }
        Object[] children = ((IStructuredContentProvider)this.listViewer.getContentProvider()).getElements(this.inputElement);
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                Object element = children[i];
                if (this.listViewer.getChecked(element)) {
                    list.add(element);
                }
                ++i;
            }
        }
        return list;
    }
}

