/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.wizard;

import com.sap.ide.eclipse.component.core.DCController;
import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.provider.ui.message.ComponentProviderMessages;
import com.sap.ide.eclipse.component.wizard.ProjectWizard;
import com.tssap.dtr.client.eclipse.ui.ActivitySelectionViewer;
import com.tssap.dtr.client.eclipse.ui.ActivityViewerInput;
import com.tssap.dtr.client.eclipse.ui.util.WorkspacesWithDefaultActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SelectActivityPage
extends WizardPage
implements DCController.ChangeListener {
    private ActivityViewerInput initialInput = null;
    public static final String NAME = "SelectActivityPage";
    private TracerI theTracer = TracingManager.getTracer(this.getClass());
    private ActivitySelectionViewer activityViewer;
    private boolean changeFlag = false;

    public SelectActivityPage() {
        super(NAME);
        this.setTitle(ComponentProviderMessages.getString("selectActivityPage.title"));
        this.setDescription(ComponentProviderMessages.getString("selectActivityPage.desc"));
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.changeFlag = false;
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 1;
        layout.verticalSpacing = 9;
        this.buildActivityViewer(container);
        this.setControl((Control)container);
    }

    private void buildActivityViewer(Composite container) {
        this.activityViewer = new ActivitySelectionViewer(container, false, null, null);
        if (this.initialInput != null) {
            this.activityViewer.setInput((Object)this.initialInput);
        } else {
            this.setWorkspace(null);
        }
        this.activityViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectActivityPage.this.dialogChanged();
            }
        });
        this.activityViewer.getControl().setLayoutData((Object)new GridData(1808));
        Button newButton = new Button(container, 0);
        newButton.setText("New Activity...");
        newButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IAction action = SelectActivityPage.this.activityViewer.getCreateActivityAction();
                action.run();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        newButton.setLayoutData((Object)new GridData(128));
    }

    public boolean dialogChanged() {
        ISelection selection = this.activityViewer.getSelection();
        if (!this.activityViewer.isSelectionValid()) {
            this.updateStatus(ComponentProviderMessages.getString("NoSelectActivityPage.error"));
            return false;
        }
        this.changeFlag = true;
        this.updateStatus(null);
        return true;
    }

    public void updateStatus(String message) {
        if (this.changeFlag) {
            this.setErrorMessage(message);
        } else {
            this.changeFlag = true;
        }
        this.setPageComplete(message == null);
    }

    public ProjectWizard getProjectWizard() {
        IWizard wizard = super.getWizard();
        if (wizard instanceof ProjectWizard) {
            return (ProjectWizard)wizard;
        }
        return null;
    }

    public void setWorkspace(IVfsWorkspace workspace) {
        if (this.activityViewer != null) {
            this.activityViewer.setInput((Object)new ActivityViewerInput(workspace, null));
        }
        this.initialInput = new ActivityViewerInput(workspace, null);
    }

    public boolean isVisiable() {
        if (this.activityViewer != null && this.activityViewer.getInput() != null) {
            IVfsWorkspace workspace = ((ActivityViewerInput)this.activityViewer.getInput()).fWorkspace;
            if (workspace == null) {
                return false;
            }
            return !WorkspacesWithDefaultActivity.usingDefaultActivity((IVfsWorkspace)workspace);
        }
        return false;
    }

    public boolean canFlipToNextPage() {
        return super.isPageComplete() && this.getNextPage() != null;
    }

    public void update(DCController controller) {
        try {
            if (controller.getDevConfiguration() == null || controller.getDevConfiguration().isInOfflineMode()) {
                return;
            }
            boolean active = !controller.getCompartment().hasInactiveSourceState();
            IVfsWorkspace workspace = controller.getDevConfiguration().getWorkspaceOfCompartment(controller.getCompartment().getName(), active);
            this.setWorkspace(workspace);
        }
        catch (Throwable e) {
            Util.logExceptionMessage(this.theTracer, 2, "Failed to set Workspace", e);
        }
    }

    public IWizardPage getNextPage() {
        if (this.getProjectWizard() != null) {
            return this.getProjectWizard().getAddtionalStartingPage();
        }
        return super.getNextPage();
    }

    public boolean isPageComplete() {
        ProjectWizard wizard = this.getProjectWizard();
        if (wizard != null) {
            if (wizard.getDCController().isForLocalDevelopment()) {
                return true;
            }
            if (this.isCurrentPage() && this.getNextPage() != null) {
                return false;
            }
            try {
                return this.getActivity() != null;
            }
            catch (Throwable e) {
                return false;
            }
        }
        return super.isPageComplete();
    }

    public IVfsActivity getActivity() throws VfsException {
        if (this.activityViewer != null) {
            Object obj;
            IVfsWorkspace workspace;
            if (this.activityViewer.getInput() != null && WorkspacesWithDefaultActivity.usingDefaultActivity((IVfsWorkspace)(workspace = ((ActivityViewerInput)this.activityViewer.getInput()).fWorkspace))) {
                return workspace.getDefaultActivity();
            }
            ISelection selection = this.activityViewer.getSelection();
            if (!selection.isEmpty() && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof IVfsActivity) {
                return (IVfsActivity)obj;
            }
        }
        return null;
    }
}

