/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.wizard;

import com.sap.ide.eclipse.component.core.DCController;
import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.provider.ComponentCategoryImage;
import com.sap.ide.eclipse.component.provider.ComponentProviderPlugin;
import com.sap.ide.eclipse.component.provider.ui.message.ComponentProviderMessages;
import com.sap.ide.eclipse.component.wizard.DCDefinitionPage;
import com.sap.ide.eclipse.component.wizard.DCWizardUtil;
import com.sap.ide.eclipse.component.wizard.IWizardValidator;
import com.sap.ide.eclipse.component.wizard.SelectActivityPage;
import com.sap.ide.eclipse.component.wizard.SelectSCPage;
import com.sap.ide.eclipse.dii.component.IDCExtendedProject;
import com.sap.tc.complib.ComponentType;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.devconf.ICompartmentNode;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.tssap.dii.component.IConnectedWizard;
import com.tssap.dii.component.IStartCreateProjectWizard;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.ui.dialogs.ProblemDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;

public class ProjectWizard
extends Wizard
implements INewWizard,
IStartCreateProjectWizard {
    public static int NOT_LOGGED_IN = -1;
    public static int NO_CONFIGURATIONS = -2;
    public static String LANGUAGE_PROPERTY = "language";
    public static final String LOCALIZATION_NAME_SPACE = "http://xml.sap.com/2003/06/Localization";
    public static final String LOCALIZATION_ELEMENT_NAME = "localization";
    public static final String TERMINOLOGY_DOMAIN_ELEMENT = "domain";
    public static final String TERMINOLOGY_LOCALE_ELEMENT = "originalLocale";
    private DCController dcController;
    private DCDefinitionPage dcPage;
    private SelectSCPage selectSCPage;
    private SelectActivityPage activityPage;
    private IStructuredSelection selection;
    private IWorkbench workbench;
    private List validatorList = new ArrayList();
    private IWizard wizardInstance = null;
    private boolean wizardInstanceInitialized = false;
    private IVfsActivity activity;
    private List controllerList;
    private TracerI theTracer = TracingManager.getTracer(((Object)((Object)this)).getClass());

    public ProjectWizard() {
        this.setNeedsProgressMonitor(true);
        this.setForcePreviousAndNextButtons(true);
        this.setWindowTitle(ComponentProviderMessages.getString("titleNewDCWizard"));
    }

    public void addPages() {
        if (this.dcController == null) {
            this.dcController = new DCController();
        }
        if (this.dcController.getDevConfiguration() == null) {
            this.selectSCPage = new SelectSCPage();
            this.addPage((IWizardPage)this.selectSCPage);
        }
        this.dcPage = new DCDefinitionPage();
        this.dcController.addChangeListener(this.dcPage);
        this.addPage((IWizardPage)this.dcPage);
        this.activityPage = new SelectActivityPage();
        this.dcController.addChangeListener(this.activityPage);
        this.activityPage.update(this.dcController);
        this.addPage((IWizardPage)this.activityPage);
    }

    public void addValidator(IWizardValidator validator) {
        this.validatorList.add(validator);
    }

    public List getValidatorList() {
        return this.validatorList;
    }

    public DCController getDCController() {
        return this.dcController;
    }

    public void reset() {
        this.activity = null;
        this.getControllerList().clear();
        this.dcController.setProject(null);
    }

    private List getControllerList() {
        if (this.controllerList == null) {
            this.controllerList = new ArrayList();
        }
        return this.controllerList;
    }

    public void createPageControls(Composite composite) {
        super.createPageControls(composite);
        Rectangle rec = this.getShell().getBounds();
        rec.height = 600;
        this.getShell().setBounds(rec);
    }

    public boolean performFinish() {
        if (this.wizardInstance != null && this.wizardInstance.getPageCount() == 0) {
            this.wizardInstance.performFinish();
        }
        try {
            if (this.dcController.getProject() != null) {
                this.dcController.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                DCWizardUtil.updateModel(this.dcController.getProject(), this.dcController.getDevConfiguration());
                Iterator it = this.getControllerList().iterator();
                while (it.hasNext()) {
                    DCController controller = (DCController)it.next();
                    IProject dcProject = controller.getProject();
                    if (dcProject == null || !dcProject.isOpen() || !(dcProject.getNature("com.sap.ide.eclipse.component.provider.dcnature") instanceof IDCExtendedProject)) continue;
                    IDCExtendedProject extendedProject = (IDCExtendedProject)dcProject.getNature("com.sap.ide.eclipse.component.provider.dcnature");
                    DCWizardUtil.updateModel(dcProject, this.dcController.getDevConfiguration());
                }
                if (this.wizardInstance instanceof IConnectedWizard) {
                    ((IConnectedWizard)this.wizardInstance).finalProject();
                }
                return true;
            }
            if (this.wizardInstance != null) {
                return false;
            }
            this.reset();
            IStatus status = this.dcController.validateDCName();
            if (4 == status.getSeverity()) {
                this.dcPage.updateStatus(status.getMessage());
                return false;
            }
            if (!this.isValid()) {
                return false;
            }
            IProject prj = this.createProject(this.getProjectDescription());
            boolean success = this.fillProject(prj, null);
            if (success) {
                prj.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                DCWizardUtil.updateModel(prj, this.dcController.getDevConfiguration());
            } else if (prj != null && prj.exists()) {
                prj.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            return success;
        }
        catch (Throwable e) {
            Util.logExceptionMessage(this.theTracer, 2, "Wizard failed", e);
            Util.showException(e, "Error", "Wizard failed", this.getShell());
            this.getContainer().getShell().close();
            return false;
        }
    }

    public boolean isValid() {
        if (this.dcController.getProject() != null) {
            return true;
        }
        if (!this.dcController.validate().isOK()) {
            return false;
        }
        IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(this.dcController.getProjectDescription().getName());
        return !proj.exists();
    }

    public IProject createProject(IProjectDescription prjDescription) {
        IProject newProj;
        if (prjDescription == null) {
            prjDescription = this.getProjectDescription();
        }
        if (!(newProj = ResourcesPlugin.getWorkspace().getRoot().getProject(prjDescription.getName())).exists()) {
            try {
                newProj.create(prjDescription, (IProgressMonitor)new NullProgressMonitor());
                if (!newProj.isOpen()) {
                    newProj.open(null);
                }
            }
            catch (CoreException e) {
                Util.logExceptionMessage(this.theTracer, 2, "Project creation failed", e);
                return null;
            }
        }
        this.dcController.setProject(newProj);
        return newProj;
    }

    public boolean fillProject(IProject project, Properties properties) {
        ProgressMonitorDialog progressMonitor = new ProgressMonitorDialog(this.getShell());
        progressMonitor.create();
        progressMonitor.open();
        IStatus status = this.fillProject(this.dcController, project, properties, progressMonitor.getProgressMonitor());
        progressMonitor.getProgressMonitor().done();
        if (progressMonitor != null && !progressMonitor.getShell().isDisposed()) {
            progressMonitor.close();
        }
        if (status != null && !status.isOK()) {
            ProblemDialog.open((Shell)this.getShell(), (String)"DC Creation", (String)"Development Component Creation completed with some problems.", (IStatus)status);
        }
        return status != null && 4 != status.getSeverity();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus fillProject(DCController myDCController, IProject project, Properties properties, IProgressMonitor monitor) {
        IStatus status;
        block17: {
            Status e2;
            block16: {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                Object workspace = null;
                status = null;
                try {
                    if (this.activity == null && !myDCController.isForLocalDevelopment()) {
                        try {
                            this.activity = this.activityPage.getActivity();
                        }
                        catch (Throwable e2) {
                            Util.logExceptionMessage(this.theTracer, 2, "Failed to get Activity", e2);
                            Status status2 = new Status(4, "com.sap.ide.eclipse.component.provider", 0, myDCController.getName() + ": Get Activity failed", e2);
                            Object var10_12 = null;
                            if (monitor == null) return status2;
                            monitor.done();
                            return status2;
                        }
                        if (this.activity == null) {
                            e2 = new Status(4, "com.sap.ide.eclipse.component.provider", 0, myDCController.getName() + ": Get Activity failed", null);
                            Object var10_13 = null;
                            if (monitor == null) return e2;
                            break block16;
                        }
                    }
                    status = myDCController.fillProject(project, properties, this.activity, monitor);
                    break block17;
                }
                catch (Throwable throwable) {
                    Object var10_15 = null;
                    if (monitor != null) {
                        monitor.done();
                    }
                    throw throwable;
                }
            }
            monitor.done();
            return e2;
        }
        Object var10_14 = null;
        if (monitor != null) {
            monitor.done();
        }
        if (myDCController.getParentDCName() != null) {
            boolean shouldWarn = true;
            if (myDCController.getParentDC() != null) {
                DevelopmentComponent parDC = null;
                try {
                    parDC = myDCController.getParentDC().getDevelopmentComponent(false);
                }
                catch (Throwable e) {
                    Util.logExceptionMessage(this.theTracer, 3, "get parent DC failed", e);
                }
                if (parDC != null && parDC.getEnclosingComponent() == null && this.typeEquals(parDC.getComponentType(), myDCController.getDCType())) {
                    shouldWarn = false;
                }
            }
            if (shouldWarn) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)"Warning", (String)"For generated Dependencies to used DC\u00ef\u00bf\u00bds you have \nto provide these Dependencies to your top parent DC if necessary.");
            }
        }
        if (status != null) {
            return status;
        }
        return new Status(0, "com.sap.ide.eclipse.component.provider", 0, myDCController.getName() + ": Fill Project Succes", null);
    }

    private boolean typeEquals(ComponentType t1, ComponentType t2) {
        if (t1 == null && t2 == null) {
            return true;
        }
        if (t1 == null || t2 == null) {
            return false;
        }
        return (t1.getVendor() != null && t1.getVendor().equals(t2.getVendor()) || t1.getVendor() == null && t2.getVendor() == null) && (t1.getType() != null && t1.getType().equals(t2.getType()) || t1.getType() == null && t2.getType() == null) && (t1.getSubType() != null && t1.getSubType().equals(t2.getSubType()) || t1.getSubType() == null && t2.getSubType() == null);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.workbench = workbench;
        this.setDefaultPageImageDescriptor(ComponentCategoryImage.getImageDescriptor("Development Component Wizard"));
    }

    public void init(IDevelopmentConfiguration configuration, ICompartmentNode compartment, IDevelopmentComponentNode parent) throws Throwable {
        this.dcController = new DCController(parent);
        try {
            this.dcController.setDefaultInfrastructure(compartment, configuration);
        }
        catch (Throwable e) {
            Util.logExceptionMessage(this.theTracer, 2, "Initialize Wizard failed", e);
        }
        this.dcController.setParentDC(parent);
        this.setDefaultPageImageDescriptor(ComponentCategoryImage.getImageDescriptor("Development Component Wizard"));
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public IWorkbench getWorkbench() {
        if (this.workbench == null) {
            this.workbench = ComponentProviderPlugin.getPlugin().getWorkbench();
        }
        return this.workbench;
    }

    public IProjectDescription getProjectDescription() {
        return this.dcController.getProjectDescription();
    }

    public IProject getProjectHandle() {
        if (this.dcController.getProject() == null && this.getProjectDescription() != null) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectDescription().getName());
        }
        return this.dcController.getProject();
    }

    public boolean hasAddtionalPages() {
        return this.wizardInstance != null;
    }

    public IWizardPage getAddtionalStartingPage() {
        if (this.wizardInstance == null) {
            return null;
        }
        return this.wizardInstance.getStartingPage();
    }

    public DCController createDCController() {
        DCController dcCtrl = new DCController(this.dcController);
        this.getControllerList().add(dcCtrl);
        return dcCtrl;
    }

    public void createConnectedWizard() throws CoreException {
        this.validatorList.clear();
        if (this.wizardInstance != null) {
            this.wizardInstance.dispose();
        }
        this.wizardInstanceInitialized = false;
        this.wizardInstance = null;
        this.wizardInstance = DCWizardUtil.getConnectedWizard(this.dcController.getDCType());
    }

    public void initializeConnectedWizard() throws CoreException {
        if (this.wizardInstance == null) {
            this.createConnectedWizard();
        }
        if (this.wizardInstanceInitialized) {
            return;
        }
        if (this.wizardInstance != null && this.wizardInstance.getPageCount() <= 0) {
            if (this.wizardInstance instanceof IConnectedWizard) {
                this.wizardInstanceInitialized = true;
                IConnectedWizard connectedWizard = (IConnectedWizard)this.wizardInstance;
                this.reset();
                connectedWizard.init((IStartCreateProjectWizard)this);
            }
            if (this.wizardInstance instanceof IWorkbenchWizard) {
                IWorkbenchWizard workbenchWizard = (IWorkbenchWizard)this.wizardInstance;
                workbenchWizard.init(this.getWorkbench(), this.getSelection());
            }
            this.wizardInstance.addPages();
        }
    }

    public void dispose() {
        if (this.wizardInstance != null) {
            this.wizardInstance.dispose();
        }
        super.dispose();
    }

    public IStatus canStartWizard() {
        if (this.selectSCPage != null && this.selectSCPage.isTreeEmpty()) {
            return new Status(4, "com.sap.ide.eclipse.component.provider", NO_CONFIGURATIONS, ComponentProviderMessages.getString("noConfigurationsInstalled.error"), null);
        }
        return new Status(0, "com.sap.ide.eclipse.component.provider", 0, "", null);
    }

    public String getName() {
        return this.dcController.getName();
    }

    public String getVendor() {
        return this.dcController.getVendor();
    }

    public String getLanguage() {
        return this.dcController.getLanguage();
    }

    public String getBuildVariant() {
        return this.dcController.getBuildVariant();
    }

    public String getConfigurationName() {
        IDevelopmentConfiguration config = this.dcController.getDevConfiguration();
        if (config != null && config.getConfigurationData() != null) {
            return config.getConfigurationData().getName();
        }
        return null;
    }

    public IVfsActivity getActivity() {
        if (this.activity == null && !this.dcController.isForLocalDevelopment()) {
            try {
                this.activity = this.activityPage.getActivity();
            }
            catch (Throwable e) {
                Util.logExceptionMessage(this.theTracer, 2, "get Activity failed", e);
            }
        }
        return this.activity;
    }

    public boolean isLocal() {
        return this.dcController.isForLocalDevelopment();
    }

    public String getDcType() {
        return this.dcController.getDCType().getType();
    }

    public String getDcSubType() {
        return this.dcController.getDCType().getSubType();
    }

    public String getDcTypeVendor() {
        return this.dcController.getDCType().getVendor();
    }
}

