/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.wizard;

import com.sap.ide.eclipse.component.devconf.DevConfManager;
import com.sap.ide.eclipse.component.provider.ui.message.ComponentProviderMessages;
import com.sap.ide.eclipse.component.wizard.DevConfWizard;
import com.sap.ide.login.UserValidator;
import com.sap.lcr.api.sapmodel.SAP_DesignTimeConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class LoadDevConfPage
extends WizardPage {
    protected int lastSelection = 0;
    public static final String NAME = "LoadConfigurationPage";
    private boolean changeFlag = false;
    private Text configFile;
    private Button selectFileButton;
    private Label selectFileLabel;
    private Button localRadioButton;
    private Button remoteRadioButton;
    private Combo naturesComboBox;
    private Label tabelLabel;
    private TableTree configTable;
    private TableTreeViewer tableViewer;
    private Label urlLabel;
    private Label internalNameLabel;
    private List confs = null;

    public LoadDevConfPage() {
        super(NAME);
        this.setTitle(ComponentProviderMessages.getString("titleLoadConfigurationPage"));
        this.setDescription(ComponentProviderMessages.getString("descLoadConfigurationPage"));
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.changeFlag = false;
        this.setPageComplete(false);
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 5;
        this.buildRadioSelect(container);
        this.buildFileUpload(container);
        this.buildConfigsTable(container);
        this.dialogChanged();
        this.setControl((Control)container);
        Rectangle bounds = this.getShell().getBounds();
        bounds.height = 550;
        bounds.width = 650;
        this.getShell().setBounds(bounds);
    }

    private void buildConfigsTable(Composite container) {
        this.tabelLabel = new Label(container, 0);
        this.tabelLabel.setText(ComponentProviderMessages.getString("comfigurationList.label"));
        this.tabelLabel.setEnabled(false);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.tabelLabel.setLayoutData((Object)gd);
        this.naturesComboBox = new Combo(container, 12);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.naturesComboBox.setLayoutData((Object)gd);
        this.naturesComboBox.setItems(new String[]{"All"});
        this.naturesComboBox.select(0);
        this.naturesComboBox.setEnabled(false);
        this.naturesComboBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int index = LoadDevConfPage.this.naturesComboBox.getSelectionIndex();
                if (index > 0) {
                    String text = LoadDevConfPage.this.naturesComboBox.getItem(index);
                    LoadDevConfPage.this.tableViewer.setInput((Object)LoadDevConfPage.this.getInputRoot(text));
                } else {
                    LoadDevConfPage.this.tableViewer.setInput((Object)LoadDevConfPage.this.getInputRoot(null));
                }
            }
        });
        gd = new GridData(1808);
        gd.horizontalSpan = 3;
        this.configTable = new TableTree(container, 67588);
        TableColumn column1 = new TableColumn(this.configTable.getTable(), 0);
        column1.setText(ComponentProviderMessages.getString("comfigurationList.name.column"));
        column1.setWidth(200);
        TableColumn column2 = new TableColumn(this.configTable.getTable(), 0);
        column2.setText(ComponentProviderMessages.getString("comfigurationList.description.column"));
        column2.setWidth(250);
        TableColumn column3 = new TableColumn(this.configTable.getTable(), 0);
        column3.setText(ComponentProviderMessages.getString("comfigurationList.internalName.column"));
        column3.setWidth(150);
        this.configTable.getTable().setHeaderVisible(true);
        this.configTable.setLayoutData((Object)gd);
        this.configTable.setEnabled(false);
        this.configTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LoadDevConfPage.this.dialogChanged();
            }
        });
        this.tableViewer = new TableTreeViewer(this.configTable);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new OutViewLableProvider());
        this.tableViewer.setContentProvider((IContentProvider)new OutViewContentProvider());
        this.tableViewer.setInput((Object)"");
        this.setTableSorter(new OutViewSorter(0));
        SelectionAdapter headerListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int column = LoadDevConfPage.this.configTable.getTable().indexOf((TableColumn)e.widget);
                OutViewSorter oldSorter = (OutViewSorter)LoadDevConfPage.this.tableViewer.getSorter();
                if (oldSorter != null && column == oldSorter.getCol()) {
                    oldSorter.setReversed(!oldSorter.isReversed());
                    LoadDevConfPage.this.tableViewer.refresh();
                } else {
                    LoadDevConfPage.this.setTableSorter(new OutViewSorter(column));
                }
            }
        };
        column1.addSelectionListener((SelectionListener)headerListener);
        column2.addSelectionListener((SelectionListener)headerListener);
        column3.addSelectionListener((SelectionListener)headerListener);
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (LoadDevConfPage.this.isPageComplete()) {
                    IWizardPage page = LoadDevConfPage.this.getNextPage();
                    if (page == null) {
                        return;
                    }
                    LoadDevConfPage.super.getContainer().showPage(page);
                }
            }
        });
    }

    private void setTableSorter(OutViewSorter sorter) {
        this.tableViewer.setSorter((ViewerSorter)sorter);
    }

    protected void fillTable() {
        this.confs = DevConfManager.listRemoteDevConfNames(this.getShell());
        this.tableViewer.setInput((Object)this.getInputRoot(null));
        String[] natures = this.getAllNatures();
        this.naturesComboBox.setItems(natures);
        this.naturesComboBox.select(0);
        this.naturesComboBox.setEnabled(natures.length > 1);
    }

    protected void buildRadioSelect(Composite container) {
        Group radioButtonGroup = new Group(container, 16);
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 512;
        radioButtonGroup.setLayout((Layout)fillLayout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        radioButtonGroup.setLayoutData((Object)gd);
        this.localRadioButton = new Button((Composite)radioButtonGroup, 16);
        this.localRadioButton.setText(ComponentProviderMessages.getString("LocaleFileSelector.label"));
        this.localRadioButton.setSelection(true);
        this.remoteRadioButton = new Button((Composite)radioButtonGroup, 16);
        this.remoteRadioButton.setText(ComponentProviderMessages.getString("RemoteSelector.label"));
        final Shell shell = this.getShell();
        this.localRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (LoadDevConfPage.this.localRadioButton.getSelection()) {
                    LoadDevConfPage.this.lastSelection = LoadDevConfPage.this.configTable.getTable().getSelectionIndex();
                    LoadDevConfPage.this.configFile.setEnabled(true);
                    LoadDevConfPage.this.selectFileButton.setEnabled(true);
                    LoadDevConfPage.this.selectFileLabel.setEnabled(true);
                    LoadDevConfPage.this.configTable.getTable().deselect(LoadDevConfPage.this.configTable.getTable().getSelectionIndices());
                    LoadDevConfPage.this.configTable.setEnabled(false);
                    LoadDevConfPage.this.tabelLabel.setEnabled(false);
                } else {
                    UserValidator.Data data;
                    if (!UserValidator.isDefaultServerOnline() && (data = UserValidator.getDefaultServerData((int)UserValidator.USER_LOGIN, (Shell)shell)) == null) {
                        LoadDevConfPage.this.localRadioButton.setSelection(true);
                        LoadDevConfPage.this.remoteRadioButton.setSelection(false);
                        return;
                    }
                    LoadDevConfPage.this.configFile.setEnabled(false);
                    LoadDevConfPage.this.selectFileButton.setEnabled(false);
                    LoadDevConfPage.this.selectFileLabel.setEnabled(false);
                    if (LoadDevConfPage.this.configTable.getItemCount() <= 0) {
                        LoadDevConfPage.this.fillTable();
                    }
                    LoadDevConfPage.this.configTable.setEnabled(true);
                    LoadDevConfPage.this.tabelLabel.setEnabled(true);
                    if (LoadDevConfPage.this.configTable.getItemCount() > 0) {
                        LoadDevConfPage.this.configTable.getTable().select(LoadDevConfPage.this.lastSelection);
                    }
                }
                LoadDevConfPage.this.dialogChanged();
            }
        });
    }

    private void buildFileUpload(Composite container) {
        this.selectFileLabel = new Label(container, 0);
        this.selectFileLabel.setText(ComponentProviderMessages.getString("loadConfigFileLabel"));
        this.configFile = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.configFile.setLayoutData((Object)gd);
        this.configFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LoadDevConfPage.this.dialogChanged();
            }
        });
        this.selectFileButton = new Button(container, 0);
        this.selectFileButton.setText(ComponentProviderMessages.getString("loadConfigFileButton"));
        this.selectFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dialog = new FileDialog(LoadDevConfPage.this.getShell(), 65536);
                dialog.setText(ComponentProviderMessages.getString("selectFolderDialog"));
                String retValue = dialog.open();
                if (retValue != null) {
                    LoadDevConfPage.this.configFile.setText(retValue);
                }
            }
        });
    }

    private void dialogChanged() {
        if (this.localRadioButton.getSelection()) {
            if (this.getDevConfFile() == null || this.getDevConfFile().length() <= 0) {
                this.updateStatus(ComponentProviderMessages.getString("fileUrlRequired"));
                return;
            }
        } else {
            if (this.configTable.getItemCount() <= 0) {
                this.updateStatus(ComponentProviderMessages.getString("errorListConfigurations"));
                return;
            }
            if (this.getRemoteConfigName() == null) {
                this.updateStatus(ComponentProviderMessages.getString("errorAtLeastOneRemoteConfig"));
                return;
            }
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        if (this.changeFlag) {
            this.setErrorMessage(message);
        } else {
            this.changeFlag = true;
        }
        this.setPageComplete(message == null && this.changeFlag);
    }

    public String getDevConfFile() {
        if (this.localRadioButton.getSelection()) {
            return this.configFile.getText();
        }
        return null;
    }

    public String getRemoteConfigName() {
        TableTreeItem[] selection;
        if (!this.localRadioButton.getSelection() && (selection = this.configTable.getSelection()) != null && selection.length > 0 && selection[0].getData() != null) {
            Data data = (Data)selection[0].getData();
            if (data.getConfiguration() == null) {
                return null;
            }
            return data.getConfiguration().getName();
        }
        return null;
    }

    public String getConfigRoot() {
        return null;
    }

    public IWizardPage getNextPage() {
        DevConfWizard wizard = this.getDevConfWizard();
        if (wizard != null && !wizard.initDevConf()) {
            return null;
        }
        return super.getNextPage();
    }

    private DevConfWizard getDevConfWizard() {
        if (this.getWizard() != null && this.getWizard() instanceof DevConfWizard) {
            return (DevConfWizard)this.getWizard();
        }
        return null;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete() && super.getNextPage() != null;
    }

    private String[] getAllNatures() {
        HashSet<String> set = new HashSet<String>();
        if (this.confs != null) {
            Iterator it = this.confs.iterator();
            while (it.hasNext()) {
                SAP_DesignTimeConfiguration designConfig = (SAP_DesignTimeConfiguration)it.next();
                String[] value = designConfig.getNatures();
                if (value == null) continue;
                set.addAll(Arrays.asList(value));
            }
        }
        Object[] array = set.toArray(new String[set.size()]);
        Arrays.sort(array);
        ArrayList<Object> list = new ArrayList<Object>();
        list.addAll(Arrays.asList(array));
        list.add(0, "All");
        return list.toArray(new String[list.size()]);
    }

    private Data[] getInputRoot(String filterNature) {
        HashMap<String, Data> nodeMap = new HashMap<String, Data>();
        ArrayList<Data> list = new ArrayList<Data>();
        Random random = new Random();
        if (this.confs != null) {
            Iterator it = this.confs.iterator();
            while (it.hasNext()) {
                String caption;
                String[] natures;
                SAP_DesignTimeConfiguration designConfig = (SAP_DesignTimeConfiguration)it.next();
                if (filterNature != null && ((natures = designConfig.getNatures()) == null || !Arrays.asList(natures).contains(filterNature))) continue;
                String path = designConfig.getDisplayPath();
                if (path == null) {
                    path = "";
                }
                String string = caption = designConfig.getCaption() != null ? designConfig.getCaption() : designConfig.getName();
                if (caption == null) {
                    caption = "unknown";
                }
                path = path + "/" + caption;
                StringTokenizer tokonizer = new StringTokenizer(path, "/");
                String lokalPath = "";
                Data parent = null;
                boolean firstToken = true;
                while (tokonizer.hasMoreTokens()) {
                    String token = tokonizer.nextToken().trim();
                    Data data = (Data)nodeMap.get(lokalPath = lokalPath + (firstToken ? "" : "/") + token);
                    if (data == null) {
                        data = new Data(parent, token, null, null);
                        nodeMap.put(lokalPath, data);
                        if (parent == null) {
                            list.add(data);
                        } else {
                            parent.addChild(data);
                        }
                        parent = data;
                    } else {
                        parent = data;
                    }
                    if (!tokonizer.hasMoreTokens() && parent.getConfiguration() == null) {
                        parent.setConfiguration(designConfig);
                    }
                    firstToken = false;
                }
            }
        }
        Object[] array = list.toArray(new Data[list.size()]);
        Arrays.sort(array);
        return array;
    }

    protected class Data
    implements Comparable {
        Data parent;
        String label;
        SAP_DesignTimeConfiguration config;
        ArrayList children = new ArrayList();

        public Data(Data parent, String label, SAP_DesignTimeConfiguration type, Image image) {
            this.parent = parent;
            this.label = label;
            this.config = type;
        }

        public String getLabel() {
            return this.label;
        }

        public Data getParent() {
            return this.parent;
        }

        public SAP_DesignTimeConfiguration getConfiguration() {
            return this.config;
        }

        public void setConfiguration(SAP_DesignTimeConfiguration type) {
            this.config = type;
        }

        public Data[] getChildren() {
            Object[] array = this.children.toArray(new Data[this.children.size()]);
            Arrays.sort(array);
            return array;
        }

        public boolean hasChildren() {
            return !this.children.isEmpty();
        }

        public void addChild(Data child) {
            this.children.add(child);
        }

        public String toString() {
            if (this.label != null) {
                return this.label;
            }
            return super.toString();
        }

        public int compareTo(Object obj) {
            if (obj == null) {
                return -1;
            }
            return this.toString().compareTo(obj.toString());
        }
    }

    class OutViewLableProvider
    implements ITableLabelProvider {
        OutViewLableProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            Data data = (Data)element;
            if (data == null) {
                return "null";
            }
            if (columnIndex == 0) {
                return data.getLabel();
            }
            SAP_DesignTimeConfiguration rec = data.getConfiguration();
            if (rec == null) {
                return "";
            }
            switch (columnIndex) {
                case 1: {
                    return rec.getDescription() != null ? rec.getDescription() : "";
                }
                case 2: {
                    return rec.getName() != null ? rec.getName() : "";
                }
            }
            return "";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    class OutViewContentProvider
    implements ITreeContentProvider {
        OutViewContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Data[]) {
                return (Object[])inputElement;
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Data) {
                return ((Data)parentElement).getChildren();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof Data) {
                return ((Data)element).hasChildren();
            }
            return true;
        }
    }

    class OutViewSorter
    extends ViewerSorter {
        private boolean isReversed = false;
        private int col;

        private OutViewSorter() {
            this(0);
        }

        private OutViewSorter(int column) {
            this.col = column;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int ret = 0;
            Data rec1 = (Data)e1;
            Data rec2 = (Data)e2;
            if (rec1 == null) {
                ret = 1;
            } else if (rec2 == null) {
                ret = -1;
            }
            if (rec1.getConfiguration() == null && rec2.getConfiguration() == null) {
                return rec1.getLabel().compareTo(rec2.getLabel());
            }
            if (rec1.getConfiguration() != null && rec2.getConfiguration() != null) {
                String name1 = null;
                String name2 = null;
                switch (this.col) {
                    case 0: {
                        name1 = rec1.getLabel();
                        name2 = rec2.getLabel();
                        break;
                    }
                    case 1: {
                        name1 = rec1.getConfiguration().getDescription();
                        name2 = rec2.getConfiguration().getDescription();
                        break;
                    }
                    case 2: {
                        name1 = rec1.getConfiguration().getName();
                        name2 = rec2.getConfiguration().getName();
                        break;
                    }
                }
                if (name1 == null && name2 == null) {
                    name1 = rec1.getLabel();
                    name2 = rec2.getLabel();
                }
                if (name1 == null) {
                    name1 = "";
                }
                if (name2 == null) {
                    name2 = "";
                }
                return name1.compareToIgnoreCase(name2);
            }
            return rec1.getConfiguration() != null ? 1 : -1;
        }

        public int getCol() {
            return this.col;
        }

        public boolean isReversed() {
            return this.isReversed;
        }

        public void setReversed(boolean isReversed) {
            this.isReversed = isReversed;
        }
    }
}

