/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.wizard;

import com.sap.ide.eclipse.component.core.ComponentTreeViewer;
import com.sap.ide.eclipse.component.provider.ui.message.ComponentProviderMessages;
import com.sap.ide.eclipse.component.wizard.ImportWizard;
import com.sap.ide.login.UserValidator;
import com.sap.tc.devconf.ICompartmentNode;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.tssap.selena.model.elements.Element;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DtrPage
extends WizardPage {
    public static final String NAME = "DTRPage";
    private ComponentTreeViewer componentTree;
    private boolean changeFlag = false;
    private boolean noValidate = false;
    private Composite treeComosite = null;

    public DtrPage() {
        super(NAME);
        this.setTitle(ComponentProviderMessages.getString("titleDTRPage"));
        this.setDescription(ComponentProviderMessages.getString("descDTRPage"));
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.changeFlag = false;
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 1;
        layout.verticalSpacing = 9;
        this.buildComponentTree(container);
        this.setControl((Control)container);
    }

    private void buildComponentTree(Composite container) {
        this.treeComosite = new Composite(container, 0);
        this.treeComosite.setLayoutData((Object)new GridData(1808));
        this.treeComosite.setLayout((Layout)new GridLayout());
        this.updateComponentTree();
    }

    private void updateComponentTree() {
        int i;
        Control[] children;
        if (this.treeComosite != null) {
            if (this.componentTree != null && this.componentTree.getControl() != null && !this.componentTree.getControl().isDisposed() && (children = this.treeComosite.getChildren()) != null) {
                i = 0;
                while (i < children.length) {
                    children[i].dispose();
                    ++i;
                }
            }
            this.componentTree = new ComponentTreeViewer(this.treeComosite, 0, 66, null, null, true);
            this.componentTree.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    DtrPage.this.dialogChanged(false);
                }
            });
            this.componentTree.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    DtrPage.this.dialogChanged(false);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        if (this.componentTree != null && this.componentTree.getControl() != null && !this.componentTree.getControl().isDisposed() && (children = this.treeComosite.getChildren()) != null) {
            i = 0;
            while (i < children.length) {
                children[i].setLayoutData((Object)new GridData(1808));
                ++i;
            }
        }
    }

    public IDevelopmentConfiguration getCurrentConfiguration() {
        if (this.componentTree.getSelectedDC() != null) {
            return (IDevelopmentConfiguration)this.componentTree.getPathToSelectedObject().get(0);
        }
        return null;
    }

    public ICompartmentNode getCurrentSC() {
        if (this.componentTree.getSelectedDC() != null) {
            return (ICompartmentNode)this.componentTree.getPathToSelectedObject().get(1);
        }
        return null;
    }

    public Element getSelectedElement() {
        if (this.componentTree != null) {
            return this.componentTree.getSelectedElement();
        }
        return null;
    }

    private void dialogChanged(boolean first) {
        if (this.noValidate) {
            return;
        }
        if (!UserValidator.isDefaultServerOnline()) {
            this.changeFlag = true;
            UserValidator.getDefaultServerData((int)UserValidator.USER_LOGIN, (Shell)this.getShell());
            if (!UserValidator.isDefaultServerOnline()) {
                this.updateStatus(ComponentProviderMessages.getString("noImportWithoutLoggedIn.error"));
                this.getContainer().getShell().close();
            } else {
                this.updateComponentTree();
            }
            return;
        }
        if (first) {
            return;
        }
        if (this.componentTree.getSelectedDC() == null) {
            this.updateStatus(ComponentProviderMessages.getString("errorNoSelectDTRPage"));
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        if (this.changeFlag) {
            this.setErrorMessage(message);
        } else {
            this.changeFlag = true;
        }
        this.setPageComplete(message == null);
    }

    public IDevelopmentComponentNode getDComponent() {
        return this.componentTree.getSelectedDC();
    }

    public boolean isActiveBranch() {
        return this.componentTree.isSlectedActiveBranch();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.dialogChanged(true);
        }
        super.setVisible(visible);
    }

    private ImportWizard getImportWizard() {
        if (this.getWizard() != null && this.getWizard() instanceof ImportWizard) {
            return (ImportWizard)this.getWizard();
        }
        return null;
    }

    public IWizardPage getNextPage() {
        ImportWizard wizard = this.getImportWizard();
        if (wizard != null) {
            wizard.notifyDCSelctionChenged();
        }
        return super.getNextPage();
    }

    public boolean canFlipToNextPage() {
        return super.isPageComplete() && this.hasSyncPage();
    }

    private boolean hasSyncPage() {
        IDevelopmentComponentNode dcNode = this.getDComponent();
        if (dcNode != null) {
            return !dcNode.getConfiguration().isInOfflineMode();
        }
        return false;
    }

    public boolean isPageComplete() {
        if (!this.isCurrentPage()) {
            return true;
        }
        if (super.isPageComplete()) {
            return !this.hasSyncPage();
        }
        return false;
    }
}

