/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.wizard;

import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.devconf.DevConfManager;
import com.sap.ide.eclipse.component.devconf.DevConfValidator;
import com.sap.ide.eclipse.component.provider.ComponentCategoryImage;
import com.sap.ide.eclipse.component.provider.ComponentMetaDataUtil;
import com.sap.ide.eclipse.component.provider.ComponentProviderPlugin;
import com.sap.ide.eclipse.component.provider.DCProjectUtil;
import com.sap.ide.eclipse.component.provider.actions.DevConfRemoveAction;
import com.sap.ide.eclipse.component.provider.preference.DevConfPreferencePage;
import com.sap.ide.eclipse.component.provider.ui.message.ComponentProviderMessages;
import com.sap.ide.eclipse.component.wizard.BuildVariantPage;
import com.sap.ide.eclipse.component.wizard.LoadDevConfPage;
import com.sap.ide.login.UserValidator;
import com.sap.tc.complib.ConfigurationFactory;
import com.sap.tc.complib.DevelopmentConfiguration;
import com.sap.tc.complib.provider.ConfigurationInputProvider;
import com.sap.tc.complib.provider.ProviderException;
import com.sap.tc.complib.validate.ValidationException;
import com.sap.tc.complib.xml.XMLException;
import com.sap.tc.devconf.ConnectionContext;
import com.sap.tc.devconf.DevelopmentConfigurationFactory;
import com.sap.tc.devconf.IConnectionContext;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.devconf.SyncException;
import com.tssap.dtr.client.lib.vfs.config.Configuration;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import com.tssap.dtr.client.lib.vfs.config.IConfiguration;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class DevConfWizard
extends Wizard
implements IImportWizard {
    private ByteArrayInputStream _stream;
    private LoadDevConfPage loadDevConfPage;
    private BuildVariantPage buildVariantPage;
    private IDevelopmentConfiguration createdDevConf = null;
    private DevelopmentConfiguration descDevConf = null;
    private TracerI theTracer = TracingManager.getTracer(((Object)((Object)this)).getClass());

    public DevConfWizard() {
        this.setDefaultPageImageDescriptor(ComponentCategoryImage.getImageDescriptor("Development Configuration Wizard"));
        this.setNeedsProgressMonitor(false);
    }

    public void addPages() {
        this.loadDevConfPage = new LoadDevConfPage();
        this.addPage((IWizardPage)this.loadDevConfPage);
        this.buildVariantPage = new BuildVariantPage();
        this.addPage((IWizardPage)this.buildVariantPage);
    }

    private InputStream getInputStream() {
        if (this._stream != null) {
            this._stream.reset();
            return this._stream;
        }
        String fileName = this.loadDevConfPage.getDevConfFile();
        InputStream source = null;
        if (fileName != null) {
            try {
                source = new FileInputStream(new File(fileName));
            }
            catch (Exception e) {
                Util.logExceptionMessage(this.theTracer, 2, "Getting Input Stream failed", e);
                Util.showException(e, "Error", "Getting Input Stream failed", this.getShell());
                return null;
            }
        }
        String remoteName = this.loadDevConfPage.getRemoteConfigName();
        try {
            source = DevConfManager.getDevConfStream(remoteName, this.getShell());
        }
        catch (Throwable e) {
            Util.logExceptionMessage(this.theTracer, 2, "Getting Input Stream failed", e);
            Util.showException(e, "Error", "Getting Input Stream failed", this.getShell());
            return null;
        }
        if (source == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)MessageFormat.format(ComponentProviderMessages.getString("getRemoteDevelopmentConfigurationError"), remoteName));
            return null;
        }
        if (source != null) {
            this._stream = null;
            ByteArrayOutputStream byteArrOut = new ByteArrayOutputStream();
            byte[] buf = new byte[12288];
            long initTime1 = System.currentTimeMillis();
            try {
                int ln;
                while ((ln = source.read(buf)) != -1) {
                    byteArrOut.write(buf, 0, (int)e);
                }
                source.close();
            }
            catch (IOException e) {
                Util.logExceptionMessage(this.theTracer, 2, "Getting Input Stream failed", e);
                Util.showException(e, "Error", "Getting Input Stream failed", this.getShell());
                return null;
            }
            this._stream = new ByteArrayInputStream(byteArrOut.toByteArray());
        }
        return this._stream;
    }

    public boolean performFinish() {
        try {
            String root = this.loadDevConfPage.getConfigRoot();
            if (!this.validateRoot(root)) {
                return false;
            }
            InputStream source = this.getInputStream();
            if (source == null) {
                return false;
            }
            if (this.descDevConf == null) {
                this.descDevConf = this.getDevConfInfo(source);
                source = this.getInputStream();
            }
            if (this.descDevConf == null) {
                return false;
            }
            String name = this.descDevConf.getName();
            if (name == null) {
                return false;
            }
            IDevelopmentConfiguration existentDevconfig = this.findDevelopmentConfiguration(name);
            if (existentDevconfig != null) {
                File file;
                root = existentDevconfig.getConfigurationRootFolder();
                UniqueName remainConfigName = null;
                remainConfigName = ComponentMetaDataUtil.createDevConfLocalName(existentDevconfig);
                Model remainConfigModel1 = ModelAccess.getModel((UniqueName)remainConfigName);
                remainConfigName = ComponentMetaDataUtil.createDevConfName(existentDevconfig);
                Model remainConfigModel2 = ModelAccess.getModel((UniqueName)remainConfigName);
                if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)"Warning", (String)("The Development Configuration with name " + name + " already exists.\nDo you want to overwrite it?"))) {
                    return false;
                }
                UserValidator.Data data = null;
                if (!existentDevconfig.isLocalConfiguration()) {
                    data = UserValidator.getDefaultServerData((int)UserValidator.LAZY_LOGIN, (Shell)this.getShell());
                }
                if (existentDevconfig.isLocalConfiguration() || data != null && data.isOnline()) {
                    String user = data != null ? data.getUser() : null;
                    String password = data != null ? data.getPassword() : null;
                    DCProjectUtil.removeDevConfProjects(existentDevconfig);
                    try {
                        DevelopmentConfigurationFactory.getInstance().removeConfiguration(existentDevconfig.getConfigurationRootFolder(), user, password);
                    }
                    catch (SyncException e) {
                        Util.showException(e, "Error", "Removing Devlopment configuration failed", this.getShell());
                        if (7 != e.getErrorCode()) {
                            Util.logExceptionMessage(this.theTracer, 2, name + ":Remove Configuration  failed", e);
                        }
                        return false;
                    }
                    catch (Throwable e) {
                        Util.logExceptionMessage(this.theTracer, 2, name + ":Remove Configuration failed", e);
                        Util.showException(e, "Error", "Removing Devlopment configuration failed", this.getShell());
                        return false;
                    }
                } else {
                    return false;
                }
                if (remainConfigModel1 != null) {
                    remainConfigModel1.delete();
                }
                if (remainConfigModel2 != null) {
                    remainConfigModel2.delete();
                }
                if ((file = new File(root)) != null && file.exists() && !file.delete() && !DevConfRemoveAction.emptyContents(file)) {
                    MessageDialog.openWarning((Shell)ComponentProviderPlugin.getPlugin().getMyShell(), (String)"Warning", (String)"Removing of Root Folder failed.");
                }
            }
            if (root == null) {
                root = DevConfPreferencePage.getDevConfPoolRoot() + this.generateNextFolderNumber(DevConfPreferencePage.getDevConfPoolRoot());
            }
            final boolean[] ret = new boolean[1];
            final String fname = name;
            final String froot = root;
            final InputStream fsource = source;
            BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                public void run() {
                    ret[0] = DevConfWizard.this.addDevConf(fname, froot, fsource);
                }
            });
            if (!ret[0]) {
                return false;
            }
        }
        catch (Throwable e) {
            Util.logExceptionMessage(this.theTracer, 2, "Import Development Configuration failed", e);
            Util.showException(e, "Error", "Import Development Configuration failed", this.getShell());
            this.getContainer().getShell().close();
        }
        return true;
    }

    private IDevelopmentConfiguration findDevelopmentConfiguration(String name) {
        List configs = DevConfManager.getInstalledDevConfs();
        Iterator it = configs.iterator();
        while (it.hasNext()) {
            IDevelopmentConfiguration config = (IDevelopmentConfiguration)it.next();
            if (!name.equals(config.getConfigurationData().getName())) continue;
            return config;
        }
        return null;
    }

    private String generateNextFolderNumber(String devConfPoolRoot) {
        File poolRoot = new File(devConfPoolRoot);
        if (!poolRoot.exists()) {
            return "0";
        }
        int i = 0;
        File dir;
        while ((dir = new File(poolRoot, String.valueOf(i))).exists()) {
            ++i;
        }
        return String.valueOf(i);
    }

    private void revertLogin(boolean wasOnline) {
        if (wasOnline) {
            return;
        }
        UserValidator.resetDefaultServerData();
    }

    private boolean addDevConf(String name, String root, InputStream source) {
        File file;
        boolean localConfig = this.descDevConf.isLocal();
        boolean wasOnline = UserValidator.isDefaultServerOnline();
        String user = "";
        String password = "";
        UserValidator.Data data = null;
        if (!localConfig) {
            data = UserValidator.getDefaultServerData((int)UserValidator.LAZY_FORCE_LOGIN, (Shell)this.getShell());
            if (data == null) {
                return false;
            }
            user = data.getUser();
            password = data.getPassword();
        }
        if ((file = new File(root)).exists() && Arrays.asList(file.list()).contains(".confdef")) {
            if (MessageDialog.openConfirm((Shell)this.getShell(), (String)ComponentProviderMessages.getString("OverwriteErrorTitle"), (String)ComponentProviderMessages.format("OverwriteErrorMessage", new Object[]{name}))) {
                IDevelopmentConfiguration devConf = DevelopmentConfigurationFactory.getInstance().findConfigInstanceForPath(root);
                Model model = null;
                Model modelLocal = null;
                if (devConf != null) {
                    model = ModelAccess.getModel((UniqueName)ComponentMetaDataUtil.createDevConfName(devConf));
                    modelLocal = ModelAccess.getModel((UniqueName)ComponentMetaDataUtil.createDevConfLocalName(devConf));
                }
                try {
                    DevelopmentConfigurationFactory.getInstance().removeConfiguration(root, user, password);
                }
                catch (Throwable e) {
                    Util.logExceptionMessage(this.theTracer, 2, "Remove Development Configuration failed", null);
                    this.closeConnection(source);
                    Util.showException(e, "Error", "Remove Development Configuration failed", this.getShell());
                    if (!localConfig) {
                        this.revertLogin(wasOnline);
                    }
                    return false;
                }
                if (model != null) {
                    model.delete();
                }
                if (modelLocal != null) {
                    modelLocal.delete();
                }
            } else {
                this.closeConnection(source);
                if (!localConfig) {
                    this.revertLogin(wasOnline);
                }
                return false;
            }
        }
        file.mkdirs();
        try {
            ConnectionContext context = new ConnectionContext(user, password, UserValidator.getKeyStore(), null);
            this.createdDevConf = DevelopmentConfigurationFactory.getInstance().addConfiguration(root, source, null, null, localConfig, (IConnectionContext)context);
        }
        catch (Throwable e) {
            Util.logExceptionMessage(this.theTracer, 2, "Import Development Configuration failed", e);
            this.closeConnection(source);
            this.revertLogin(wasOnline);
            Util.showException(e, "Error", "Import Development Configuration failed", this.getShell());
            return false;
        }
        if (data != null && !data.isUserValid()) {
            data.setUserValid(true);
        }
        this.closeConnection(source);
        if (this.createdDevConf != null) {
            if (!this.createdDevConf.isLocalConfiguration()) {
                ComponentMetaDataUtil.createDevConf(this.createdDevConf);
            }
            ComponentMetaDataUtil.createDevConfLocal(this.createdDevConf);
            Util.saveBuildVariants(this.createdDevConf, this.buildVariantPage.getResults());
            Util.initBuildVariant(this.createdDevConf);
            DevConfValidator.update();
            DevConfWizard.updateDTR(this.createdDevConf);
        }
        return true;
    }

    private void closeConnection(InputStream stream) {
        try {
            stream.close();
        }
        catch (IOException ex) {
            Util.logExceptionMessage(this.theTracer, 3, "Close Stream failed", ex);
        }
    }

    private boolean validateRoot(String root) {
        if (root == null) {
            return true;
        }
        File rootFile = new File(root);
        if (!rootFile.exists()) {
            if (MessageDialog.openConfirm((Shell)this.getShell(), (String)ComponentProviderMessages.getString("noRootDirectoryErrorTitle"), (String)ComponentProviderMessages.format("noRootDirectoryErrorMessage", new Object[]{root}))) {
                rootFile.mkdir();
            } else {
                return false;
            }
        }
        if (!rootFile.isDirectory()) {
            this.loadDevConfPage.setErrorMessage(ComponentProviderMessages.format("isNotDirectoryError", new Object[]{root}));
            return false;
        }
        return false;
    }

    public boolean initDevConf() {
        this._stream = null;
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                DevConfWizard.this.descDevConf = DevConfWizard.this.getDevConfInfo(DevConfWizard.this.getInputStream());
                DevConfWizard.this.buildVariantPage.listCompartments(DevConfWizard.this.descDevConf);
            }
        });
        return this.descDevConf != null;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    private DevelopmentConfiguration getDevConfInfo(InputStream instream) {
        if (instream == null) {
            return null;
        }
        SimpleFileDevConfInputProvider in = new SimpleFileDevConfInputProvider(instream);
        DevelopmentConfiguration conf = null;
        try {
            conf = ConfigurationFactory.initializeDevelopmentConfiguration((ConfigurationInputProvider)in);
        }
        catch (XMLException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)ComponentProviderMessages.getString("configImportFailedTitle"), (String)ComponentProviderMessages.format("invalidConfigFileError", new Object[]{((Object)((Object)e)).getClass(), e.getMessage()}));
        }
        catch (ValidationException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)ComponentProviderMessages.getString("configImportFailedTitle"), (String)ComponentProviderMessages.format("invalidConfigFileError", new Object[]{((Object)((Object)e)).getClass(), e.getMessage()}));
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)ComponentProviderMessages.getString("configImportFailedTitle"), (String)ComponentProviderMessages.format("defaultExceptionError", new Object[]{e.getClass(), e.getMessage()}));
        }
        try {
            instream.close();
        }
        catch (IOException e) {
            Util.logExceptionMessage(this.theTracer, 2, "Close Development Configuration Input Stream failed", e);
        }
        return conf;
    }

    public boolean performCancel() {
        return super.performCancel();
    }

    private static void updateDTR(IDevelopmentConfiguration configuration) {
        if (configuration == null) {
            return;
        }
        String clientName = configuration.getConfigurationData().getName();
        IConfiguration config = Configuration.getConfiguration();
        IClient clt = config.getClient(clientName);
        if (clt != null) {
            config.setActiveClient(clt);
        }
    }

    public static class SimpleFileDevConfInputProvider
    implements ConfigurationInputProvider {
        InputStream stream;

        public SimpleFileDevConfInputProvider(InputStream stream) {
            this.stream = stream;
        }

        public InputStream getStreamForConfiguration() throws ProviderException {
            return this.stream;
        }

        public void releaseStream(InputStream stream) {
        }
    }
}

