/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.component.wizard;

import com.sap.ide.eclipse.component.core.ComponentTypeTreeViewer;
import com.sap.ide.eclipse.component.core.Util;
import com.sap.ide.eclipse.component.provider.ComponentProviderPlugin;
import com.sap.ide.eclipse.component.provider.ComponentUtil;
import com.sap.ide.eclipse.component.provider.DCProjectUtil;
import com.sap.ide.eclipse.component.provider.NamereservationUtil;
import com.sap.ide.eclipse.component.provider.listener.WorkspaceResourceListener;
import com.sap.ide.eclipse.component.provider.objects.ObjectUtil;
import com.sap.ide.eclipse.component.provider.ui.message.ComponentProviderMessages;
import com.sap.ide.eclipse.component.wizard.DevConfWizard;
import com.sap.ide.eclipse.dii.component.IDCExtendedProject;
import com.sap.ide.eclipse.dii.namereservation.NameServerUtil;
import com.sap.lcr.namealloc.NameAllocator;
import com.sap.lcr.namealloc.api.AllocationState;
import com.sap.lcr.namealloc.api.CommunicationFailureException;
import com.sap.tc.complib.Compartment;
import com.sap.tc.complib.Component;
import com.sap.tc.complib.ComponentFactory;
import com.sap.tc.complib.ComponentType;
import com.sap.tc.complib.DCReference;
import com.sap.tc.complib.Dependency;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.Entity;
import com.sap.tc.complib.PPReference;
import com.sap.tc.complib.Property;
import com.sap.tc.complib.PropertyElement;
import com.sap.tc.complib.PublicPart;
import com.sap.tc.complib.namecheck.NameCheckException;
import com.sap.tc.complib.provider.FileOutputProvider;
import com.sap.tc.complib.provider.PPOutputProvider;
import com.sap.tc.complib.provider.ProviderException;
import com.sap.tc.devconf.CheckoutException;
import com.sap.tc.devconf.CreateException;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.IDCProxy;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.devconf.InvalidDefinitionException;
import com.sap.tc.devconf.RepositoryAccessException;
import com.sap.tc.devconf.SyncException;
import com.tssap.dii.component.DCProjectInfo;
import com.tssap.dii.component.IConnectedWizard;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.workspaceMonitor.WorkspaceMonitor;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsFolder;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.ModelUinSupport;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.internal.plugins.PluginDescriptor;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Element;

public class DCWizardUtil {
    private static final String SQLJ_NATURE_ID = "com.sap.dictionary.tools.sqlj.SQLJNature";
    private static TracerI theTracer = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$component$wizard$DCWizardUtil == null ? (class$com$sap$ide$eclipse$component$wizard$DCWizardUtil = DCWizardUtil.class$("com.sap.ide.eclipse.component.wizard.DCWizardUtil")) : class$com$sap$ide$eclipse$component$wizard$DCWizardUtil));
    static /* synthetic */ Class class$com$sap$ide$eclipse$component$wizard$DCWizardUtil;

    private static boolean getBooleanValue(Object object) {
        Boolean value = new Boolean(false);
        if (object instanceof String) {
            return Boolean.getBoolean((String)object);
        }
        if (object instanceof Boolean) {
            value = (Boolean)object;
        }
        return value;
    }

    private static void addPPsAndEntitys(DevelopmentComponent localDC, Properties props, String configPath) {
        Object obj;
        List entityList = null;
        Object entityObj = ((Hashtable)props).get("DCPublicPartEntity");
        if (entityObj instanceof List) {
            entityList = (List)entityObj;
        }
        if ((obj = ((Hashtable)props).get("DCPublicParts")) instanceof List) {
            List ppList = (List)obj;
            Iterator iter = ppList.iterator();
            while (iter.hasNext()) {
                Object[] element = (Object[])iter.next();
                String ppName = null;
                String purpose = null;
                String caption = null;
                String description = null;
                int i = 0;
                while (i < element.length) {
                    if (element[i] instanceof String) {
                        switch (i) {
                            case 0: {
                                ppName = (String)element[i];
                                break;
                            }
                            case 1: {
                                purpose = (String)element[i];
                                break;
                            }
                            case 2: {
                                caption = (String)element[i];
                                break;
                            }
                            case 3: {
                                description = (String)element[i];
                            }
                        }
                    }
                    ++i;
                }
                if (ppName == null) continue;
                PublicPart publicPart = ComponentFactory.createPublicPart(ppName, (DevelopmentComponent)localDC);
                publicPart.setPurpose(PublicPart.Purpose.valueOf(purpose));
                publicPart.setCaption(caption);
                publicPart.setDescription(description);
                if (entityList != null) {
                    Iterator iterator = entityList.iterator();
                    while (iterator.hasNext()) {
                        Object[] array = (Object[])iterator.next();
                        if (array == null || !ppName.equals(array[0])) continue;
                        DCWizardUtil.addEntity(publicPart, array);
                    }
                }
                try {
                    FileOutputProvider outpuProvider = new FileOutputProvider(configPath.replace('\\', '/'), (Component)localDC);
                    outpuProvider.selectPublicPart(publicPart.getName());
                    publicPart.serialize((PPOutputProvider)outpuProvider);
                }
                catch (IOException e) {
                    Util.logExceptionMessage(theTracer, 2, "Public Part Serialisation failed", e);
                }
                catch (ProviderException e) {
                    Util.logExceptionMessage(theTracer, 2, "Public Part Serialisation failed", e);
                }
            }
        }
    }

    private static void addEntity(PublicPart publicPart, Object[] array) {
        String entityName = null;
        String entityType = null;
        String subType = null;
        String packageName = null;
        String entityCaption = null;
        String entityDesc = null;
        int i = 1;
        while (i < array.length) {
            if (array[i] instanceof String) {
                switch (i) {
                    case 1: {
                        entityName = (String)array[i];
                        break;
                    }
                    case 2: {
                        entityType = (String)array[i];
                        break;
                    }
                    case 3: {
                        subType = (String)array[i];
                        break;
                    }
                    case 4: {
                        packageName = (String)array[i];
                        break;
                    }
                    case 5: {
                        entityCaption = (String)array[i];
                        break;
                    }
                    case 6: {
                        entityDesc = (String)array[i];
                    }
                }
            }
            ++i;
        }
        if (entityName != null && entityType != null) {
            Entity entity = ComponentFactory.createEntity(entityName, entityType, (PublicPart)publicPart);
            entity.setSubType(subType);
            entity.setCaption(entityCaption);
            entity.setDescription(entityDesc);
            entity.setPackageName(packageName);
        }
    }

    private static boolean getBooleanValue(Element element, String attrName) {
        String value = element.getAttribute(attrName);
        if (value == null) {
            return false;
        }
        return "true".equals(value.toLowerCase());
    }

    private static void addToList(List list, Properties props, String propName) {
        Object obj;
        if (list == null) {
            return;
        }
        if (((Hashtable)props).containsKey(propName) && (obj = ((Hashtable)props).get(propName)) instanceof Collection) {
            Iterator it = ((Collection)obj).iterator();
            while (it.hasNext()) {
                Object str = it.next();
                if (!(str instanceof String)) continue;
                list.add(str);
            }
        }
    }

    public static DevelopmentComponent preFillDC(DevelopmentComponent localDC, Properties props, String vendor, String language, String domain, String caption, ComponentType type) {
        if (localDC != null) {
            List dependencies;
            localDC.setVendor(vendor);
            if (domain != null || language != null) {
                Property p = ComponentFactory.createProperty((String)"localization", (String)"ns0", (String)"http://xml.sap.com/2003/06/Localization", (DevelopmentComponent)localDC);
                PropertyElement pChild = p.addChild("domain", domain);
                pChild.setNamespace("ns0", null);
                pChild = p.addChild("originalLocale", language);
                pChild.setNamespace("ns0", null);
            }
            localDC.setComponentType(type);
            localDC.setExternal(localDC.getComponentType().getType().toLowerCase().startsWith("external"));
            localDC.setCaption(caption);
            Element buildPlugin = ComponentTypeTreeViewer.getBuildPlugin(type);
            if (buildPlugin != null) {
                PPReference ppReference = new PPReference();
                ppReference.setName(buildPlugin.getAttribute("ppref"));
                DCReference dcReference = new DCReference();
                dcReference.setName(buildPlugin.getAttribute("name"));
                dcReference.setVendor(buildPlugin.getAttribute("vendor"));
                dcReference.setSCAlias(buildPlugin.getAttribute("scalias"));
                ppReference.setComponent(dcReference);
                localDC.setBuildPlugin(ppReference);
            }
            if ((dependencies = ComponentTypeTreeViewer.getDependencies(type)) != null) {
                localDC.emptyDependencies();
                Iterator it = dependencies.iterator();
                while (it.hasNext()) {
                    Element element = (Element)it.next();
                    Dependency dependency = ComponentFactory.createDependency();
                    dependency.setComponent(new DCReference());
                    dependency.getComponent().setName(element.getAttribute("name"));
                    dependency.getComponent().setVendor(element.getAttribute("vendor"));
                    dependency.getComponent().setSCAlias(element.getAttribute("scalias"));
                    dependency.setPublicPart(element.getAttribute("ppref"));
                    element.getAttribute("ppref");
                    dependency.setForChildrenOnly(DCWizardUtil.getBooleanValue(element, "for-children"));
                    dependency.setAtBuildTime(DCWizardUtil.getBooleanValue(element, "at-build-time"));
                    dependency.setAtDeployTime(DCWizardUtil.getBooleanValue(element, "at-deploy-time"));
                    dependency.setAtDesignTime(DCWizardUtil.getBooleanValue(element, "at-design-time"));
                    dependency.setAtRunTime(DCWizardUtil.getBooleanValue(element, "at-runtime"));
                    localDC.getDependencies().add(dependency);
                }
            }
            if (props != null) {
                localDC.emptyPackageFolders();
                DCWizardUtil.addToList(localDC.getPackageFolders(), props, "DCPackageFolder");
                localDC.emptySourceFolders();
                DCWizardUtil.addToList(localDC.getSourceFolders(), props, "DCSourceFolder");
                DCWizardUtil.addReferences(localDC, props);
                DCWizardUtil.addBeReferencedBy(localDC, props);
            }
        }
        return localDC;
    }

    public static DevelopmentComponent postFillDC(DevelopmentComponent localDC, Properties props, IDevelopmentConfiguration config) {
        if (localDC != null) {
            String configPath = config.getConfigurationRootFolder();
            if (props != null) {
                DCWizardUtil.addPPsAndEntitys(localDC, props, configPath);
            }
        }
        return localDC;
    }

    private static void addReferences(DevelopmentComponent localDC, Properties props) {
        Object obj = ((Hashtable)props).get("DCReferences");
        if (obj instanceof List) {
            List referenceList = (List)obj;
            Iterator it = referenceList.iterator();
            while (it.hasNext()) {
                Object[] array = (Object[])it.next();
                String dcName = null;
                String dcVendor = null;
                String scAlias = null;
                String ppName = null;
                boolean atBuildTime = false;
                boolean atDeployTime = false;
                boolean atDesignTime = false;
                boolean atRunTime = false;
                boolean forChildrenOnly = false;
                int i = 0;
                while (i < array.length) {
                    switch (i) {
                        case 0: {
                            dcName = (String)array[i];
                            break;
                        }
                        case 1: {
                            dcVendor = (String)array[i];
                            break;
                        }
                        case 2: {
                            scAlias = (String)array[i];
                            break;
                        }
                        case 3: {
                            ppName = (String)array[i];
                            break;
                        }
                        case 4: {
                            atBuildTime = DCWizardUtil.getBooleanValue(array[i]);
                            break;
                        }
                        case 5: {
                            atDeployTime = DCWizardUtil.getBooleanValue(array[i]);
                            break;
                        }
                        case 6: {
                            atDesignTime = DCWizardUtil.getBooleanValue(array[i]);
                            break;
                        }
                        case 7: {
                            atRunTime = DCWizardUtil.getBooleanValue(array[i]);
                            break;
                        }
                        case 8: {
                            forChildrenOnly = DCWizardUtil.getBooleanValue(array[i]);
                        }
                    }
                    ++i;
                }
                if (dcName == null || dcVendor == null || ppName == null) continue;
                DCReference dcRef = new DCReference(dcName, dcVendor, scAlias);
                PPReference ppRef = new PPReference(ppName, dcRef);
                Dependency dependency = ComponentFactory.createDependency((PPReference)ppRef, (DevelopmentComponent)localDC);
                dependency.setAtBuildTime(atBuildTime);
                dependency.setAtDeployTime(atDeployTime);
                dependency.setAtDesignTime(atDesignTime);
                dependency.setAtRunTime(atRunTime);
                dependency.setForChildrenOnly(forChildrenOnly);
            }
        }
    }

    private static void addBeReferencedBy(DevelopmentComponent localDC, Properties props) {
        Object obj = ((Hashtable)props).get("SelfDCReferences");
        if (obj instanceof List) {
            List referenceList = (List)obj;
            Iterator it = referenceList.iterator();
            while (it.hasNext()) {
                IDevelopmentComponentNode dcNode;
                Object[] array = (Object[])it.next();
                IProject dcProject = null;
                String ppName = null;
                boolean atBuildTime = false;
                boolean atDeployTime = false;
                boolean atDesignTime = false;
                boolean atRunTime = false;
                boolean forChildrenOnly = false;
                int i = 0;
                while (i < array.length) {
                    switch (i) {
                        case 0: {
                            dcProject = (IProject)array[i];
                            break;
                        }
                        case 1: {
                            ppName = (String)array[i];
                            break;
                        }
                        case 2: {
                            atBuildTime = DCWizardUtil.getBooleanValue(array[i]);
                            break;
                        }
                        case 3: {
                            atDeployTime = DCWizardUtil.getBooleanValue(array[i]);
                            break;
                        }
                        case 4: {
                            atDesignTime = DCWizardUtil.getBooleanValue(array[i]);
                            break;
                        }
                        case 5: {
                            atRunTime = DCWizardUtil.getBooleanValue(array[i]);
                            break;
                        }
                        case 6: {
                            forChildrenOnly = DCWizardUtil.getBooleanValue(array[i]);
                        }
                    }
                    ++i;
                }
                if (dcProject == null || localDC == null || (dcNode = com.sap.ide.eclipse.dii.component.ComponentUtil.getDCNode(dcProject)) == null) continue;
                IDCProxy proxy = null;
                try {
                    proxy = dcNode.getDCProxy();
                }
                catch (DevConfigException e1) {
                    Util.logExceptionMessage(theTracer, 2, "Get DCProxy failed.", e1);
                }
                if (proxy == null || proxy.getComponent() == null) continue;
                DCReference dcRef = new DCReference(localDC.getName(), localDC.getVendor(), "");
                PPReference ppRef = new PPReference(ppName, dcRef);
                DevelopmentComponent myDC = proxy.getComponent();
                Dependency dependency = ComponentFactory.createDependency((PPReference)ppRef, (DevelopmentComponent)myDC);
                dependency.setAtBuildTime(atBuildTime);
                dependency.setAtDeployTime(atDeployTime);
                dependency.setAtDesignTime(atDesignTime);
                dependency.setAtRunTime(atRunTime);
                dependency.setForChildrenOnly(forChildrenOnly);
                try {
                    proxy.serializeDefinition();
                }
                catch (DevConfigException e) {
                    Util.logExceptionMessage(theTracer, 2, "DCDEF serialization failed", e);
                }
            }
        }
    }

    public static boolean createComponent(Shell shell, Properties props, NameAllocator allocator, IProject project, IVfsActivity activity, IDevelopmentConfiguration conf, Compartment node, boolean local, boolean syncUsedDCs, String dcName, String dcVendor, String parentName, String parentVendor, String language, String domain, String caption, ComponentType dcType) {
        IDCProxy dcProxy = null;
        String resName = null;
        if (local) {
            try {
                dcProxy = conf.createLocalComponent(node.getName(), dcVendor, dcName, parentVendor, parentName);
            }
            catch (NameCheckException e) {
                Util.logExceptionMessage(theTracer, 2, "Failed to check the name", e);
                Util.showException(e, shell);
            }
            catch (SyncException e) {
                Util.logExceptionMessage(theTracer, 2, "Failed to create dc", e);
                Util.showException(e, shell);
            }
            catch (CreateException e) {
                Util.logExceptionMessage(theTracer, 2, "Failed to create dc", e);
                Util.showException(e, shell);
            }
        } else {
            AllocationState nameState = null;
            if (activity == null) {
                return false;
            }
            resName = NameServerUtil.getDCReservationName((String)dcVendor, (String)dcName);
            if (allocator != null) {
                try {
                    if (NamereservationUtil.isDCReserved(resName, allocator)) {
                        MessageDialog.openError((Shell)shell, (String)ComponentProviderMessages.getString("NameReservationError.title"), (String)ComponentProviderMessages.format("AllreadyReserved.error", new Object[]{resName}));
                        return false;
                    }
                }
                catch (CommunicationFailureException e) {
                    Util.logExceptionMessage(theTracer, 2, "Name Reservation", e);
                    Util.showException(e, shell);
                    return false;
                }
                try {
                    if (allocator != null && resName != null) {
                        nameState = NamereservationUtil.reserveDC(resName, allocator);
                    }
                }
                catch (Throwable e) {
                    Util.logExceptionMessage(theTracer, 2, "Name Reservation", e);
                    Util.showException(e, shell);
                    return false;
                }
            }
            boolean success = false;
            try {
                dcProxy = conf.createComponent(node.getName(), dcVendor, dcName, parentVendor, parentName, activity);
                success = true;
            }
            catch (NameCheckException e) {
                Util.logExceptionMessage(theTracer, 2, "Name Reservation", e);
                Util.showException(e, shell);
            }
            catch (SyncException e) {
                Util.logExceptionMessage(theTracer, 2, "Create DC failed", e);
                Util.showException(e, shell);
            }
            catch (CreateException e) {
                Util.logExceptionMessage(theTracer, 2, "Create DC failed", e);
                Util.showException(e, shell);
            }
            catch (CheckoutException e) {
                Util.logExceptionMessage(theTracer, 2, "Create DC failed", e);
                Util.showException(e, shell);
            }
            boolean nameinDtrReserved = false;
            if (success && allocator != null && nameState != null) {
                try {
                    IVfsFile dcdefFile = dcProxy.getComponentDefinitionVfsFile();
                    if (dcdefFile == null) {
                        success = false;
                    } else {
                        nameinDtrReserved = NamereservationUtil.reserveDCinDTR(dcdefFile, resName, nameState, allocator, activity);
                    }
                }
                catch (Throwable e) {
                    Util.logExceptionMessage(theTracer, 2, "Name Reservation Error", e);
                    Util.showException(e, shell);
                }
            }
            if (!success || !nameinDtrReserved) {
                try {
                    if (allocator != null && resName != null) {
                        NamereservationUtil.revertDCReservation(resName, allocator);
                    }
                }
                catch (Throwable e) {
                    Util.logExceptionMessage(theTracer, 2, "Revert Name Reservation Error", e);
                    Util.showException(e, shell);
                }
                if (!success) {
                    return false;
                }
            }
        }
        if (dcProxy == null || dcProxy.getComponent() == null) {
            MessageDialog.openError((Shell)shell, (String)ComponentProviderMessages.getString("unexpectedError.title"), (String)ComponentProviderMessages.getString("developmentComponentCreation.error"));
            return false;
        }
        DCWizardUtil.preFillDC(dcProxy.getComponent(), props, dcVendor, language, domain, caption, dcType);
        try {
            dcProxy.serializeDefinition();
        }
        catch (DevConfigException e) {
            Util.logExceptionMessage(theTracer, 2, "DCDEF Serialisation failed", e);
            Util.showException(e, shell);
        }
        DCWizardUtil.postFillDC(dcProxy.getComponent(), props, conf);
        if (syncUsedDCs) {
            try {
                dcProxy.syncUsedComponents(DCWizardUtil.getBuildVariant(conf, node), false);
            }
            catch (SyncException e1) {
                Util.logExceptionMessage(theTracer, 2, "Sync used DCs failed", e1);
                Util.showException(e1, shell);
            }
        }
        DCWizardUtil.checkInDefFolder(dcProxy, activity);
        if (activity != null) {
            try {
                String clientDefName = activity.getWorkspace().getContext().getClientName();
                BluebirdPlugin.getDefault().associateProjectWithDTR(project, clientDefName);
            }
            catch (Throwable e) {
                Util.logExceptionMessage(theTracer, 2, "DTR Association failed", e);
            }
        }
        return true;
    }

    public static void checkInDefFolder(IDCProxy dcProxy, IVfsActivity activity) {
        if (activity == null) {
            return;
        }
        try {
            IVfsFile dcdefFile = dcProxy.getComponentDefinitionVfsFile();
            IVfsFolder root = dcdefFile.getParent().asFolder();
            IVfsFolderItem defFolder = null;
            if (root != null && (defFolder = dcProxy.getComponentDefinitionVfsFile().getVersionedFileSystemManager().getFolderItem(root.getLocalPath() + "/def")) != null) {
                defFolder.asFolder().createAndCheckout(activity, 2);
            }
        }
        catch (VfsException e) {
            Util.logExceptionMessage(theTracer, 3, "Def folder check in failed", e);
        }
    }

    public static String getBuildVariant(IDevelopmentConfiguration conf, Compartment comp) {
        if (comp == null) {
            return null;
        }
        String compartmentName = comp.getName();
        if (conf == null || compartmentName == null) {
            return null;
        }
        try {
            return Util.getBuildVariant(conf, compartmentName);
        }
        catch (Exception e) {
            Util.logExceptionMessage(theTracer, 3, "get Build Variant failed", e);
            return null;
        }
    }

    public static void updateModel(IProject project, final IDevelopmentConfiguration configuration) {
        IDCExtendedProject dcPrj = null;
        try {
            if (project == null || !project.exists() || !DCProjectInfo.isDCProject((IProject)project)) {
                return;
            }
            dcPrj = (IDCExtendedProject)project.getNature("com.sap.ide.eclipse.component.provider.dcnature");
        }
        catch (CoreException e) {
            Util.logExceptionMessage(theTracer, 3, "Problem with DC Project " + project, e);
        }
        if (dcPrj == null) {
            return;
        }
        UniqueName modelUName = ModelAccess.createModelUniqueName((String)project.getName());
        Model model = ModelAccess.getModel((UniqueName)modelUName);
        if (model != null) {
            try {
                final DevelopmentComponent dc = dcPrj.getDCNode().getDevelopmentComponent(false);
                ObjectUtil.initLocalModel();
                ModelAccess.runCommandLater((Runnable)new Runnable(){

                    public void run() {
                        if (configuration != null && dc != null) {
                            try {
                                DCProjectUtil.updateProject(configuration, dc);
                            }
                            catch (Throwable e) {
                                Util.logExceptionMessage(theTracer, 2, "Update DC project failed", e);
                            }
                        }
                    }
                });
            }
            catch (RepositoryAccessException e) {
                Util.logExceptionMessage(theTracer, 3, "Get DC from Project failed " + project, e);
            }
            catch (InvalidDefinitionException e) {
                Util.logExceptionMessage(theTracer, 3, "Get DC from Project failed " + project, e);
            }
        }
    }

    public static void createGenfolder(IProject project) {
        IFolder genFolder = project.getFolder("gen");
        if (!genFolder.exists()) {
            try {
                genFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                genFolder.setDerived(true);
            }
            catch (CoreException e) {
                Util.logExceptionMessage(theTracer, 3, "Init of GEN folder failed", e);
            }
        }
        if (genFolder.exists()) {
            WorkspaceMonitor.getInstance().setMonitorResource((IResource)genFolder, false, -1);
        }
    }

    public static IProject createProjectFromDC(IDevelopmentComponentNode dcNode, boolean updateProject, Shell shell, IProgressMonitor progressMonitor) {
        if (progressMonitor == null) {
            progressMonitor = new NullProgressMonitor();
        }
        progressMonitor.setTaskName("Project Creating for DC " + dcNode.getName());
        final IProject project = DCWizardUtil.createDCProject(dcNode, updateProject, shell, progressMonitor);
        if (project == null) {
            return null;
        }
        if (!dcNode.isLocalOnlySource()) {
            progressMonitor.subTask("Associate Project with DTR");
            String clientDefName = ComponentUtil.getDTRClientName(dcNode);
            if (clientDefName != null) {
                BluebirdPlugin.getDefault().associateProjectWithDTR(project, clientDefName);
            }
        }
        progressMonitor.subTask("Creating GEN Folder");
        DCWizardUtil.createGenfolder(project);
        progressMonitor.subTask("Refresh Project");
        try {
            project.refreshLocal(2, null);
        }
        catch (CoreException e) {
            Util.logExceptionMessage(theTracer, 3, "Project refreshing failed", e);
        }
        if (Display.getCurrent() != null) {
            DCWizardUtil.createProjectModel(project);
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    DCWizardUtil.createProjectModel(project);
                }
            });
        }
        progressMonitor.subTask("");
        progressMonitor.setTaskName("");
        return project;
    }

    private static void createProjectModel(IProject project) {
        String projectName = project.getName();
        Model model = DCWizardUtil.findModel(projectName);
        if (model == null) {
            UniqueName modelUin = ModelUinSupport.createModelUin((String)projectName);
            Model model2 = ModelAccess.createModel((UniqueName)modelUin);
        }
    }

    private static Model findModel(String projectId) {
        if (projectId == null) {
            return null;
        }
        Enumeration models = ModelAccess.models();
        while (models.hasMoreElements()) {
            Model model = (Model)models.nextElement();
            if (!projectId.equals(ModelUinSupport.getProjectId((UniqueName)model.getUniqueName()))) continue;
            return model;
        }
        return null;
    }

    private static IProject createDCProject(IDevelopmentComponentNode dcNode, boolean updateProject, final Shell shell, IProgressMonitor progressMonitor) {
        if (dcNode == null) {
            return null;
        }
        progressMonitor.subTask("Reading DC Information ...");
        DevelopmentComponent dComp = null;
        IDCProxy proxy = null;
        try {
            proxy = dcNode.getDCProxy();
        }
        catch (DevConfigException ex) {
            Util.showException(ex, "Warning", "DC is inavlid", shell);
            Util.logExceptionMessage(theTracer, 2, "Get Dc Proxy failed", ex);
        }
        String compartmentName = dcNode.getCompartmentName();
        if (compartmentName == null) {
            return null;
        }
        IProject newProj = null;
        IProjectDescription projDescr = null;
        File directory = new File(dcNode.getComponentRootFolder() + File.separatorChar + ".project");
        if (!directory.exists()) {
            String projName = com.sap.ide.eclipse.dii.component.ComponentUtil.createProjectName((IDevelopmentConfiguration)dcNode.getConfiguration(), (IDevelopmentComponentNode)dcNode);
            newProj = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
            projDescr = ResourcesPlugin.getWorkspace().newProjectDescription(projName);
        } else {
            try {
                projDescr = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)new Path(dcNode.getComponentRootFolder() + File.separatorChar + ".project"));
            }
            catch (CoreException e) {
                Util.logExceptionMessage(theTracer, 3, "Project Desccription Loading failed", e);
                return null;
            }
            newProj = ResourcesPlugin.getWorkspace().getRoot().getProject(projDescr.getName());
        }
        try {
            dComp = dcNode.getDevelopmentComponent(false);
        }
        catch (RepositoryAccessException e) {
            Util.logExceptionMessage(theTracer, 2, "Getting DC failed", e);
        }
        catch (InvalidDefinitionException e) {
            Util.logExceptionMessage(theTracer, 2, "Getting DC failed", e);
        }
        if (dComp != null) {
            progressMonitor.subTask("Setting project Natures");
            List collection = ComponentTypeTreeViewer.getNatures(dComp.getComponentType());
            if (collection != null) {
                collection.add("com.sap.ide.eclipse.component.provider.dcnature");
                projDescr.setNatureIds(collection.toArray(new String[collection.size()]));
            }
        }
        projDescr.setLocation((IPath)new Path(dcNode.getComponentRootFolder()));
        progressMonitor.subTask("Project Creating ...");
        try {
            if (newProj.exists()) {
                IProject oldProject = ResourcesPlugin.getWorkspace().getRoot().getProject(newProj.getName());
                if (oldProject != null && !oldProject.getLocation().equals((Object)projDescr.getLocation())) {
                    final boolean[] confirmed = new boolean[]{false};
                    final String projName = newProj.getName();
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            confirmed[0] = MessageDialog.openConfirm((Shell)shell, (String)ComponentProviderMessages.getString("replaceProject.title"), (String)ComponentProviderMessages.format("replaceProject.question", new Object[]{projName}));
                        }
                    });
                    if (confirmed[0]) {
                        oldProject.delete(false, true, null);
                        newProj.create(projDescr, (IProgressMonitor)new NullProgressMonitor());
                    }
                }
            } else {
                newProj.create(projDescr, (IProgressMonitor)new NullProgressMonitor());
            }
            progressMonitor.subTask("Opening Project");
            if (!newProj.isOpen()) {
                try {
                    WorkspaceResourceListener.getListener().addToIgnoreProject(newProj);
                    newProj.open(null);
                    Object var14_18 = null;
                    WorkspaceResourceListener.getListener().removeToIgnoreProject(newProj);
                }
                catch (Throwable throwable) {
                    Object var14_19 = null;
                    WorkspaceResourceListener.getListener().removeToIgnoreProject(newProj);
                    throw throwable;
                }
            }
            DCWizardUtil.updateModel(newProj);
            if (proxy != null && dComp != null) {
                IWizard wizard = DCWizardUtil.getConnectedWizard(dComp.getComponentType());
                if (wizard != null && wizard instanceof IConnectedWizard) {
                    progressMonitor.subTask("Filling Project with DC Type dependent Data");
                    ((IConnectedWizard)wizard).completeProject(newProj, DCWizardUtil.createProperties(proxy, dcNode.getConfiguration()));
                }
                DCWizardUtil.initializeSpetialSources(newProj);
            }
            if (updateProject) {
                progressMonitor.subTask("Update Project Setings from DC Data");
                DCProjectUtil.updateProject(dcNode.getConfiguration(), dComp);
            }
        }
        catch (Exception e) {
            Util.logExceptionMessage(theTracer, 2, "Project Creation failed", e);
            return null;
        }
        return newProj;
    }

    private static void initializeSpetialSources(IProject prj) {
        if (prj == null) {
            return;
        }
        try {
            IJavaProject project;
            IPackageFragmentRoot[] roots;
            if (prj.hasNature(SQLJ_NATURE_ID)) {
                return;
            }
            if (prj.hasNature("org.eclipse.jdt.core.javanature") && (roots = (project = JavaCore.create((IProject)prj)).getAllPackageFragmentRoots()) != null) {
                int i = 0;
                while (i < roots.length) {
                    if (roots[i].getKind() == 1) {
                        IJavaElement[] jList = roots[i].getChildren();
                        int j = 0;
                        while (j < jList.length) {
                            if (jList[j].getElementType() == 4) {
                                IPackageFragment fragment = (IPackageFragment)jList[j];
                                Object[] objs = fragment.getNonJavaResources();
                                int k = 0;
                                while (k < objs.length) {
                                    IResource res;
                                    if (objs[k] instanceof IResource && (res = (IResource)objs[k]).getName().toLowerCase().endsWith(".sqlj")) {
                                        IProjectDescription description = prj.getDescription();
                                        String[] natures = description.getNatureIds();
                                        String[] newNatures = new String[natures.length + 1];
                                        System.arraycopy(natures, 0, newNatures, 0, natures.length);
                                        newNatures[newNatures.length - 1] = SQLJ_NATURE_ID;
                                        description.setNatureIds(newNatures);
                                        prj.setDescription(description, 1, null);
                                    }
                                    ++k;
                                }
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
        catch (JavaModelException e) {
            Util.logExceptionMessage(theTracer, 2, "SQLJ init failed", e);
        }
        catch (Throwable e) {
            Util.logExceptionMessage(theTracer, 2, "SQLJ init failed", e);
        }
    }

    private static Properties createProperties(IDCProxy proxy, IDevelopmentConfiguration configuration) {
        Map ppMap;
        List dependencies;
        List libs;
        List sourceFolders;
        List list;
        Properties props = new Properties();
        String buildVariant = null;
        try {
            buildVariant = Util.getBuildVariant(configuration, proxy.getCompartment().getName());
        }
        catch (Exception e) {
            Util.logExceptionMessage(theTracer, 3, "Getting Build Variant failed", e);
        }
        DevelopmentComponent dc = proxy.getComponent();
        if (dc == null) {
            return null;
        }
        props.setProperty("DCName", dc.getName());
        props.setProperty("DCVendor", dc.getVendor());
        PropertyElement pe = null;
        Property p = dc.getProperty("localization", "http://xml.sap.com/2003/06/Localization");
        if (p != null) {
            pe = p.getChild("originalLocale");
        }
        props.setProperty("DCBuildVariant", buildVariant);
        if (pe != null) {
            ((Hashtable)props).put("DCLanguage", pe.getValue());
        }
        if ((list = dc.getPackageFolders()) != null) {
            ((Hashtable)props).put("DCPackageFolder", list);
        }
        if ((sourceFolders = dc.getSourceFolders()) != null) {
            ((Hashtable)props).put("DCSourceFolder", sourceFolders);
        }
        if ((libs = proxy.getUsedCompilationPathList(buildVariant)) != null) {
            ((Hashtable)props).put("UsedDCsPaths", libs);
        }
        if ((dependencies = dc.getDependencies()) != null && !dependencies.isEmpty()) {
            ArrayList<Object[]> dependencyList = new ArrayList<Object[]>();
            Iterator it = dependencies.iterator();
            while (it.hasNext()) {
                Dependency dependency = (Dependency)it.next();
                PPReference ppRef = dependency.getPublicPartDependency();
                DCReference dcRef = dependency.getComponent();
                dependencyList.add(new Object[]{dcRef.getName(), dcRef.getVendor(), dcRef.getSCAlias(), ppRef != null ? ppRef.getName() : null, new Boolean(dependency.isAtBuildTime()), new Boolean(dependency.isAtDeployTime()), new Boolean(dependency.isAtDesignTime()), new Boolean(dependency.isAtRunTime()), new Boolean(dependency.isForChildrenOnly())});
            }
            ((Hashtable)props).put("DCReferences", dependencyList);
        }
        if ((ppMap = dc.getPublicParts()) != null && !ppMap.isEmpty()) {
            ArrayList<Object[]> ppList = new ArrayList<Object[]>();
            ArrayList<Object[]> entityList = new ArrayList<Object[]>();
            Iterator it = ppMap.values().iterator();
            while (it.hasNext()) {
                PublicPart pp = (PublicPart)it.next();
                ppList.add(new Object[]{pp.getName(), pp.getPurpose(), pp.getCaption(), pp.getDescription()});
                List entities = pp.getEntities();
                if (entities == null || entities.isEmpty()) continue;
                Iterator iter = entities.iterator();
                while (iter.hasNext()) {
                    Entity entity = (Entity)iter.next();
                    entityList.add(new Object[]{pp.getName(), entity.getName(), entity.getType(), entity.getSubType(), entity.getPackageName(), entity.getCaption(), entity.getDescription()});
                }
            }
            ((Hashtable)props).put("DCPublicParts", ppList);
            ((Hashtable)props).put("DCPublicPartEntity", entityList);
        }
        return props;
    }

    public static void updateModel(final IProject project) {
        ModelAccess.runCommandLater((Runnable)new Runnable(){

            public void run() {
                if (project == null) {
                    return;
                }
                UniqueName modelUName = ModelAccess.createModelUniqueName((String)project.getName());
                Model model = ModelAccess.getModel((UniqueName)modelUName);
                if (model != null) {
                    ObjectUtil.initLocalModel();
                }
            }
        });
    }

    public static IWizard getConnectedWizard(ComponentType type) throws CoreException {
        Element wizardNode = ComponentTypeTreeViewer.getWizard(type);
        if (wizardNode == null) {
            return null;
        }
        String plugin = wizardNode.getAttribute("pluginid");
        String wizardClass = wizardNode.getAttribute("class");
        if (plugin == null || wizardClass == null) {
            return null;
        }
        ComponentProviderPlugin plg = null;
        plg = plugin != null ? Platform.getPlugin((String)plugin) : ComponentProviderPlugin.getPlugin();
        if (plg == null) {
            throw new CoreException((IStatus)new Status(4, "com.sap.ide.eclipse.component.provider", 0, "Couldn't find Plugin " + plugin + " for this DC Type", null));
        }
        if (!plg.getDescriptor().isPluginActivated()) {
            plg.startup();
        }
        return (IWizard)((PluginDescriptor)plg.getDescriptor()).createExecutableExtension(wizardClass, null, null, null);
    }

    public static void addDescription(IProject project, IProjectDescription description) throws CoreException {
        IProjectDescription createdDescription = project.getDescription();
        if (createdDescription == null || description == null || createdDescription.equals(description)) {
            return;
        }
        String comment = description.getComment() != null ? description.getComment() : ("" + createdDescription.getComment() != null ? ":".concat(createdDescription.getComment()) : "");
        createdDescription.setComment(comment);
        ICommand[] commands1 = createdDescription.getBuildSpec();
        ICommand[] commands2 = description.getBuildSpec();
        List list = DCWizardUtil.concatWithRemoveDouble(Arrays.asList(commands1), Arrays.asList(commands2));
        createdDescription.setBuildSpec(list.toArray(new ICommand[0]));
        String[] natures1 = createdDescription.getNatureIds();
        String[] natures2 = description.getNatureIds();
        list = DCWizardUtil.concatWithRemoveDouble(Arrays.asList(natures1), Arrays.asList(natures2));
        createdDescription.setNatureIds(list.toArray(new String[0]));
        project.setDescription(createdDescription, 1, null);
    }

    private static List concatWithRemoveDouble(List ar1, List ar2) {
        ArrayList list = new ArrayList();
        if (ar1 == null) {
            return ar2;
        }
        if (ar2 == null) {
            return ar1;
        }
        list.addAll(ar1);
        Iterator it = ar2.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            if (ar1.contains(element)) continue;
            list.add(element);
        }
        return list;
    }

    public static void startImportConfiguration(Shell parentShell, Point size) {
        if (MessageDialog.openConfirm((Shell)parentShell, (String)ComponentProviderMessages.getString("noConfigurationsInstalled.title"), (String)ComponentProviderMessages.getString("startImportConfiguration.confirm"))) {
            DevConfWizard wizard = new DevConfWizard();
            final WizardDialog dialog = new WizardDialog(ComponentProviderPlugin.getPlugin().getMyShell(), (IWizard)wizard);
            dialog.create();
            if (size != null) {
                dialog.getShell().setLocation(size);
            }
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    dialog.open();
                }
            });
        }
        parentShell.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

